/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.JamEditWindow;
import com.nttdocomo.dojaemu.ktoolbar.JamTableCellRenderer;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

class JamFileWindow
extends TabPanel {
    static final int FRAME_WIDTH = 450;
    static final int FRAME_HEIGHT = 300;
    static final int URL_TABLE_RATE = 70;
    private static final int INITIAL_ROWHEIGHT = 20;
    private JTable tableView = null;
    private Vector jamInfo = new Vector();
    private String jamPath = null;
    JButton editJamButton = null;
    private Properties jamProperties;
    private boolean edited;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JamFileWindow(AbstractWindow abstractWindow, String string) {
        super(abstractWindow);
        this.jamPath = string;
        this.edited = false;
        this.editJamButton = new JButton(Resource.getString("EDIT"));
        JButton jButton = new JButton(Resource.getString("ADD"));
        this.tableView = new JTable();
        FileInputStream fileInputStream = null;
        try {
            this.jamProperties = new Properties();
            fileInputStream = new FileInputStream(string);
            this.jamProperties.load(fileInputStream);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
        this.changeWindowState();
        JScrollPane jScrollPane = new JScrollPane(this.tableView);
        this.editJamButton.setActionCommand("editJam");
        jButton.setActionCommand("newJam");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.editJamButton.addActionListener(actionDispatcher);
        jButton.addActionListener(actionDispatcher);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(jButton);
        jPanel.add(this.editJamButton);
        this.setLayout(new BorderLayout());
        this.add("Center", jScrollPane);
        this.add("South", jPanel);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(450, 300);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean set() {
        boolean bl = true;
        if (this.edited) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.jamPath);
                this.jamProperties.store(fileOutputStream, null);
            }
            catch (Exception exception) {
                this.parent.showDialog(Resource.format("WRITE_ERR", this.jamPath), this.tabwin, 2);
                bl = false;
            }
            finally {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
            this.edited = false;
        }
        return bl;
    }

    void newJam() {
        try {
            JamEditWindow jamEditWindow = new JamEditWindow(this.parent, this.jamPath, null, null, Resource.getString("ADD_JAM_WINDOW_TITLE"), this.jamProperties);
            jamEditWindow.setLocation(this.parent.getShowLocation(jamEditWindow.getWidth(), jamEditWindow.getHeight(), this.tabwin));
            jamEditWindow.setVisible(true);
            this.edited = jamEditWindow.isEdited();
            if (this.edited && this.listener != null) {
                this.listener.tabPanelEvent(this, 1, 0);
            }
            jamEditWindow.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.changeWindowState();
    }

    void editJam() {
        int n = this.tableView.getSelectedRow();
        if (n == -1) {
            return;
        }
        try {
            String string = (String)this.tableView.getModel().getValueAt(n, 0);
            String string2 = (String)this.tableView.getModel().getValueAt(n, 1);
            JamEditWindow jamEditWindow = new JamEditWindow(this.parent, this.jamPath, string, string2, Resource.getString("EDIT_JAM_WINDOW_TITLE"), this.jamProperties);
            jamEditWindow.setLocation(this.parent.getShowLocation(jamEditWindow.getWidth(), jamEditWindow.getHeight(), this.tabwin));
            jamEditWindow.setVisible(true);
            this.edited = jamEditWindow.isEdited();
            if (this.edited && this.listener != null) {
                this.listener.tabPanelEvent(this, 1, 0);
            }
            jamEditWindow.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.changeWindowState();
    }

    @Override
    void cancel() {
    }

    private void setEnabledButtons(boolean bl) {
        this.editJamButton.setEnabled(bl);
    }

    private TableModel getJamListTable() {
        String string;
        int n;
        String string2 = Resource.getString("ADF_URL");
        String string3 = Resource.getString("JAM_FILE");
        Enumeration<Object> enumeration = null;
        final String[] stringArray = new String[]{string2, string3};
        final Object[][] objectArray = new Object[this.jamProperties.size()][stringArray.length];
        enumeration = this.jamProperties.keys();
        int n2 = this.jamProperties.size();
        String[] stringArray2 = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray2[n] = (String)enumeration.nextElement();
            for (int i = n; i > 0; --i) {
                if (stringArray2[i - 1].compareTo(stringArray2[i]) <= 0) continue;
                string = stringArray2[i - 1];
                stringArray2[i - 1] = stringArray2[i];
                stringArray2[i] = string;
            }
        }
        for (n = 0; n < n2; ++n) {
            String string4 = stringArray2[n];
            string = (String)this.jamProperties.get(string4);
            objectArray[n] = new Object[]{string4, string};
        }
        AbstractTableModel abstractTableModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return stringArray.length;
            }

            @Override
            public int getRowCount() {
                return objectArray.length;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return objectArray[n][n2];
            }

            @Override
            public String getColumnName(int n) {
                return stringArray[n];
            }

            public Class getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                objectArray[n][n2] = object;
            }
        };
        return abstractTableModel;
    }

    void changeWindowState() {
        this.tableView.setModel(this.getJamListTable());
        this.tableView.setSelectionMode(0);
        this.tableView.setDefaultRenderer(Object.class, new JamTableCellRenderer());
        this.tableView.setRowHeight(20);
        this.tableView.getColumnModel().getColumn(0).setMinWidth(315);
        this.tableView.getColumnModel().getColumn(0).setMaxWidth(315);
        this.tableView.getTableHeader().setReorderingAllowed(false);
        this.tableView.getTableHeader().setResizingAllowed(false);
        if (this.tableView.getRowCount() != 0) {
            this.setEnabledButtons(true);
        } else {
            this.setEnabledButtons(false);
        }
    }
}

