/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.Environment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

class LocationEntry {
    private int entryId = 0;
    private String timeStampYearPart = null;
    private String timeStampMonthPart = null;
    private String timeStampDayPart = null;
    private String timeStampHourPart = null;
    private String timeStampMinutePart = null;
    private String timeStampSecondPart = null;
    private String timeStampMilliSecondPart = null;
    private String infoLevel = null;
    private String latitudeHeadPart = null;
    private String latitudeDegreePart = null;
    private String latitudeMinutePart = null;
    private String latitudeSecondPart = null;
    private String latitudeCentiSecondPart = null;
    private String longitudeHeadPart = null;
    private String longitudeDegreePart = null;
    private String longitudeMinutePart = null;
    private String longitudeSecondPart = null;
    private String longitudeCentiSecondPart = null;
    private String altitude = null;
    private String datum = null;
    public static final int LOCATION_NO_USE = 0;
    public static final int LOCATION_USE = 1;
    public static final int LATITUDE_PARAM = 0;
    public static final int LONGITUDE_PARAM = 1;
    public static final File locationDir = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "location" + File.separator + "location_information");

    public void setEntryId(int n) {
        this.entryId = n;
    }

    public int getEntryId() {
        return this.entryId;
    }

    public void setTimeStampYearPart(String string) {
        this.timeStampYearPart = string;
    }

    public String getTimeStampYearPart() {
        return this.timeStampYearPart;
    }

    public void setTimeStampDayPart(String string) {
        this.timeStampDayPart = string;
    }

    public String getTimeStampDayPart() {
        return this.timeStampDayPart;
    }

    public void setTimeStampMonthPart(String string) {
        this.timeStampMonthPart = string;
    }

    public String getTimeStampMonthPart() {
        return this.timeStampMonthPart;
    }

    public void setTimeStampHourPart(String string) {
        this.timeStampHourPart = string;
    }

    public String getTimeStampHourPart() {
        return this.timeStampHourPart;
    }

    public void setTimeStampMinutePart(String string) {
        this.timeStampMinutePart = string;
    }

    public String getTimeStampMinutePart() {
        return this.timeStampMinutePart;
    }

    public void setTimeStampSecondPart(String string) {
        this.timeStampSecondPart = string;
    }

    public String getTimeStampSecondPart() {
        return this.timeStampSecondPart;
    }

    public void setTimeStampMilliSecondPart(String string) {
        this.timeStampMilliSecondPart = string;
    }

    public String getTimeStampMilliSecondPart() {
        return this.timeStampMilliSecondPart;
    }

    public void setInfoLevel(String string) {
        this.infoLevel = string;
    }

    public String getInfoLevel() {
        return this.infoLevel;
    }

    public void setLatitudeHeadPart(String string) {
        this.latitudeHeadPart = string;
    }

    public String getLatitudeHeadPart() {
        return this.latitudeHeadPart;
    }

    public void setLatitudeDegreePart(String string) {
        this.latitudeDegreePart = string;
    }

    public String getLatitudeDegreePart() {
        return this.latitudeDegreePart;
    }

    public void setLatitudeMinutePart(String string) {
        this.latitudeMinutePart = string;
    }

    public String getLatitudeMinutePart() {
        return this.latitudeMinutePart;
    }

    public void setLatitudeSecondPart(String string) {
        this.latitudeSecondPart = string;
    }

    public String getLatitudeSecondPart() {
        return this.latitudeSecondPart;
    }

    public void setLatitudeCentiSecondPart(String string) {
        this.latitudeCentiSecondPart = string;
    }

    public String getLatitudeCentiSecondPart() {
        return this.latitudeCentiSecondPart;
    }

    public void setLongitudeHeadPart(String string) {
        this.longitudeHeadPart = string;
    }

    public String getLongitudeHeadPart() {
        return this.longitudeHeadPart;
    }

    public void setLongitudeDegreePart(String string) {
        this.longitudeDegreePart = string;
    }

    public String getLongitudeDegreePart() {
        return this.longitudeDegreePart;
    }

    public void setLongitudeMinutePart(String string) {
        this.longitudeMinutePart = string;
    }

    public String getLongitudeMinutePart() {
        return this.longitudeMinutePart;
    }

    public void setLongitudeSecondPart(String string) {
        this.longitudeSecondPart = string;
    }

    public String getLongitudeSecondPart() {
        return this.longitudeSecondPart;
    }

    public void setLongitudeCentiSecondPart(String string) {
        this.longitudeCentiSecondPart = string;
    }

    public String getLongitudeCentiSecondPart() {
        return this.longitudeCentiSecondPart;
    }

    public void setAltitude(String string) {
        this.altitude = string;
    }

    public String getAltitude() {
        return this.altitude;
    }

    public void setDatum(String string) {
        this.datum = string;
    }

    public String getDatum() {
        return this.datum;
    }

    public void init() {
        long l = System.currentTimeMillis();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Environment.getLocale());
        gregorianCalendar.setTime(new Date(l));
        this.setTimeStampYearPart(Integer.toString(gregorianCalendar.get(1)));
        this.setTimeStampMonthPart(this.fillZero(Integer.toString(gregorianCalendar.get(2) + 1), 2));
        this.setTimeStampDayPart(this.fillZero(Integer.toString(gregorianCalendar.get(5)), 2));
        this.setTimeStampHourPart(this.fillZero(Integer.toString(gregorianCalendar.get(11)), 2));
        this.setTimeStampMinutePart(this.fillZero(Integer.toString(gregorianCalendar.get(12)), 2));
        this.setTimeStampSecondPart(this.fillZero(Integer.toString(gregorianCalendar.get(13)), 2));
        this.setTimeStampMilliSecondPart(this.fillZero(Integer.toString(gregorianCalendar.get(14)), 3));
        this.setInfoLevel("3");
        this.setLatitudeHeadPart(new String("N"));
        this.setLongitudeHeadPart(new String("E"));
        this.setLatitudeDegreePart(new String("00"));
        this.setLongitudeDegreePart(new String("000"));
        this.setLatitudeMinutePart(new String("00"));
        this.setLongitudeMinutePart(new String("00"));
        this.setLatitudeSecondPart(new String("00"));
        this.setLongitudeSecondPart(new String("00"));
        this.setLatitudeCentiSecondPart(new String("000"));
        this.setLongitudeCentiSecondPart(new String("000"));
        this.setAltitude("0");
        this.setDatum("0");
    }

    public boolean load(String string) throws FileNotFoundException, IOException {
        File file = new File(string);
        BufferedReader bufferedReader = null;
        boolean bl = false;
        if (file.exists() && file.isFile()) {
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer;
                    if (string2.startsWith("#") || (stringTokenizer = new StringTokenizer(string2, ",")).countTokens() < 6) continue;
                    try {
                        this.setEntryId(Integer.parseInt(stringTokenizer.nextToken()));
                        TimeZone timeZone = TimeZone.getTimeZone("GMT");
                        GregorianCalendar gregorianCalendar = new GregorianCalendar();
                        gregorianCalendar.setTimeZone(timeZone);
                        long l = Long.parseLong(stringTokenizer.nextToken());
                        gregorianCalendar.setTime(new Date(l));
                        this.setTimeStampYearPart(Integer.toString(gregorianCalendar.get(1)));
                        this.setTimeStampMonthPart(this.fillZero(Integer.toString(gregorianCalendar.get(2) + 1), 2));
                        this.setTimeStampDayPart(this.fillZero(Integer.toString(gregorianCalendar.get(5)), 2));
                        this.setTimeStampHourPart(this.fillZero(Integer.toString(gregorianCalendar.get(11)), 2));
                        this.setTimeStampMinutePart(this.fillZero(Integer.toString(gregorianCalendar.get(12)), 2));
                        this.setTimeStampSecondPart(this.fillZero(Integer.toString(gregorianCalendar.get(13)), 2));
                        this.setTimeStampMilliSecondPart(this.fillZero(Integer.toString(gregorianCalendar.get(14)), 3));
                        this.setInfoLevel(stringTokenizer.nextToken());
                        int n = Integer.parseInt(this.getInfoLevel());
                        if (n < 1 || n > 3) {
                            throw new IllegalArgumentException("Illegal value.");
                        }
                        String string3 = stringTokenizer.nextToken();
                        if (!this.parseDmsString(string3, 0)) {
                            throw new IllegalArgumentException("Illegal value.");
                        }
                        String string4 = stringTokenizer.nextToken();
                        if (!this.parseDmsString(string4, 1)) {
                            throw new IllegalArgumentException("Illegal value.");
                        }
                        this.setAltitude(stringTokenizer.nextToken());
                        this.setDatum(stringTokenizer.nextToken());
                        int n2 = Integer.parseInt(this.getDatum());
                        if (n2 != 0) {
                            throw new IllegalArgumentException("Illegal value.");
                        }
                        bl = true;
                        break;
                    }
                    catch (Exception exception) {
                        this.init();
                    }
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                this.init();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    public void save(String string, String string2) throws IOException {
        BufferedWriter bufferedWriter = null;
        BufferedReader bufferedReader = null;
        String string3 = locationDir.getPath() + File.separator + string2;
        File file = new File(locationDir, string2);
        try {
            String string4 = "";
            if (file.exists() && file.isFile()) {
                bufferedReader = new BufferedReader(new FileReader(string3));
                String string5 = null;
                while ((string5 = bufferedReader.readLine()) != null) {
                    if (!string5.startsWith("#")) continue;
                    string4 = string4 + string5 + '\n';
                }
                bufferedReader.close();
            }
            bufferedWriter = new BufferedWriter(new FileWriter(string3, false));
            if (!string4.equals("")) {
                bufferedWriter.write(string4);
            }
            bufferedWriter.write(string);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean parseDmsString(String string, int n) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = true;
        boolean bl2 = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            bl = false;
        }
        string2 = stringTokenizer.nextToken();
        string3 = stringTokenizer.nextToken();
        string4 = stringTokenizer.nextToken();
        string5 = stringTokenizer.nextToken();
        if (n == 0) {
            if (string2.length() < 1 || string2.length() > 3) {
                bl = false;
            }
        } else if (string2.length() < 1 || string2.length() > 4) {
            bl = false;
        }
        if (string3.length() != 2 || string4.length() != 2 || string5.length() != 3) {
            bl = false;
        }
        try {
            switch (string2.charAt(0)) {
                case '-': 
                case 'E': 
                case 'N': {
                    n2 = Integer.parseInt(string2.substring(1)) * -1;
                    break;
                }
                case '+': 
                case 'S': 
                case 'W': {
                    n2 = Integer.parseInt(string2.substring(1));
                    break;
                }
                default: {
                    n2 = Integer.parseInt(string2);
                    bl2 = false;
                }
            }
            n3 = Integer.parseInt(string3);
            n4 = Integer.parseInt(string4);
            n5 = Integer.parseInt(string5);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (n == 0) {
            if (n2 < -90 || n2 > 90) {
                bl = false;
            }
        } else if (n2 < -180 || n2 >= 180) {
            bl = false;
        }
        if (n3 < 0 || n3 > 59) {
            bl = false;
        }
        if (n4 < 0 || n4 > 59) {
            bl = false;
        }
        if (n5 < 0 || n5 > 999) {
            bl = false;
        }
        if (n == 0) {
            if (Math.abs(n2) == 90 && (n3 != 0 || n4 != 0 || n5 != 0)) {
                bl = false;
            }
        } else if (Math.abs(n2) == -180 && (n3 != 0 || n4 != 0 || n5 != 0)) {
            bl = false;
        }
        if (bl) {
            if (n == 0) {
                if (bl2) {
                    this.setLatitudeHeadPart(string2.substring(0, 1));
                    this.setLatitudeDegreePart(string2.substring(1));
                } else {
                    this.setLatitudeHeadPart("");
                    this.setLatitudeDegreePart(string2);
                }
                this.setLatitudeMinutePart(string3);
                this.setLatitudeSecondPart(string4);
                this.setLatitudeCentiSecondPart(string5);
            } else {
                if (bl2) {
                    this.setLongitudeHeadPart(string2.substring(0, 1));
                    this.setLongitudeDegreePart(string2.substring(1));
                } else {
                    this.setLongitudeHeadPart("");
                    this.setLongitudeDegreePart(string2);
                }
                this.setLongitudeMinutePart(string3);
                this.setLongitudeSecondPart(string4);
                this.setLongitudeCentiSecondPart(string5);
            }
            return true;
        }
        return false;
    }

    public String parseStringTimestamp() {
        String string = null;
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeZone(timeZone);
        gregorianCalendar.set(1, Integer.parseInt(this.getTimeStampYearPart()));
        gregorianCalendar.set(2, Integer.parseInt(this.getTimeStampMonthPart()) - 1);
        gregorianCalendar.set(5, Integer.parseInt(this.getTimeStampDayPart()));
        gregorianCalendar.set(11, Integer.parseInt(this.getTimeStampHourPart()));
        gregorianCalendar.set(12, Integer.parseInt(this.getTimeStampMinutePart()));
        gregorianCalendar.set(13, Integer.parseInt(this.getTimeStampSecondPart()));
        gregorianCalendar.set(14, Integer.parseInt(this.getTimeStampMilliSecondPart()));
        string = Long.toString(gregorianCalendar.getTime().getTime());
        return string;
    }

    public String parseStringDms(int n) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (n == 0) {
            string2 = this.getLatitudeHeadPart();
            string3 = this.getLatitudeDegreePart();
            string4 = this.getLatitudeMinutePart();
            string5 = this.getLatitudeSecondPart();
            string6 = this.getLatitudeCentiSecondPart();
        } else {
            string2 = this.getLongitudeHeadPart();
            string3 = this.getLongitudeDegreePart();
            string4 = this.getLongitudeMinutePart();
            string5 = this.getLongitudeSecondPart();
            string6 = this.getLongitudeCentiSecondPart();
        }
        string = string2 + string3 + "." + string4 + "." + string5 + "." + string6;
        return string;
    }

    public String fillZero(String string, int n) {
        String string2 = new String(string);
        while (string2.length() < n) {
            string2 = "0" + string2;
        }
        return string2;
    }
}

