/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.LocationEntry;
import com.nttdocomo.dojaemu.ktoolbar.LocationInfoWindow;
import com.nttdocomo.dojaemu.ktoolbar.LocationSelectWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class LocationEntryWindow
extends TabPanel {
    private static final int FRAME_WIDTH = 600;
    private static final int FRAME_HEIGHT = 200;
    private static String[] locationFiles;
    private JTable locationTable;
    private Hashtable locationHash;
    private int[] idList = null;
    private int next = 0;
    private JScrollPane scrollpane;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;
    private JButton alldeleteButton;
    private JButton imageSetButton;
    private JButton phoneSetButton;
    private static final File locationDir;

    LocationEntryWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.addButton = new JButton(Resource.getString("ADD"));
        this.editButton = new JButton(Resource.getString("EDIT"));
        this.deleteButton = new JButton(Resource.getString("DELETE"));
        this.alldeleteButton = new JButton(Resource.getString("LOCATION_ALL_DELETE"));
        this.imageSetButton = new JButton(Resource.getString("SET_LOCATION_IMAGE"));
        this.phoneSetButton = new JButton(Resource.getString("SET_LOCATION_PHONEBOOK"));
        this.addButton.setActionCommand("add");
        this.editButton.setActionCommand("edit");
        this.deleteButton.setActionCommand("delete");
        this.alldeleteButton.setActionCommand("alldelete");
        this.imageSetButton.setActionCommand("imageSet");
        this.phoneSetButton.setActionCommand("phoneSet");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.addButton.addActionListener(actionDispatcher);
        this.editButton.addActionListener(actionDispatcher);
        this.deleteButton.addActionListener(actionDispatcher);
        this.alldeleteButton.addActionListener(actionDispatcher);
        this.imageSetButton.addActionListener(actionDispatcher);
        this.phoneSetButton.addActionListener(actionDispatcher);
        jPanel2.add(this.addButton);
        jPanel2.add(this.editButton);
        jPanel2.add(this.deleteButton);
        jPanel2.add(this.alldeleteButton);
        jPanel2.add(this.imageSetButton);
        jPanel2.add(this.phoneSetButton);
        this.locationTable = this.createLocationTable();
        this.scrollpane = new JScrollPane(this.locationTable);
        this.add("Center", this.scrollpane);
        this.add("South", jPanel2);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(600, 200);
    }

    private JTable createLocationTable() {
        String string = "";
        locationFiles = locationDir.list(new LocationFilter());
        String[] stringArray = new String[locationFiles.length];
        this.locationHash = new Hashtable();
        for (int i = 0; i < locationFiles.length; ++i) {
            String string2 = locationDir.getPath() + File.separator + locationFiles[i];
            int n = locationFiles[i].indexOf(46);
            int n2 = 0;
            try {
                n2 = Integer.parseInt(locationFiles[i].substring(0, n));
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            try {
                LocationEntry locationEntry = new LocationEntry();
                boolean bl = locationEntry.load(string2);
                if (!bl) continue;
                this.locationHash.put(new Integer(locationEntry.getEntryId()), locationEntry);
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(Resource.format("NOT_FOUND_ERR", string2));
                continue;
            }
            catch (IOException iOException) {
                System.err.println(Resource.format("READ_ERR", string2));
            }
        }
        this.idList = new int[this.locationHash.size()];
        Enumeration enumeration = this.locationHash.keys();
        for (int i = 0; i < this.idList.length; ++i) {
            this.idList[i] = (Integer)enumeration.nextElement();
        }
        Arrays.sort(this.idList);
        this.next = this.idList.length > 0 ? this.idList[this.idList.length - 1] + 1 : 1;
        String[] stringArray2 = new String[]{Resource.getString("LOCATION_IMAGE_ID"), Resource.getString("LOCATION_INFO_TIMESTAMP")};
        LocationTableModel locationTableModel = new LocationTableModel(stringArray2, 0);
        for (int i = 0; i < this.idList.length; ++i) {
            LocationEntry locationEntry = null;
            Object v = this.locationHash.get(new Integer(this.idList[i]));
            if (v == null || !(v instanceof LocationEntry)) continue;
            locationEntry = (LocationEntry)v;
            String string3 = null;
            string3 = locationEntry.getTimeStampYearPart() + "/" + locationEntry.getTimeStampMonthPart() + "/" + locationEntry.getTimeStampDayPart() + " " + locationEntry.getTimeStampHourPart() + ":" + locationEntry.getTimeStampMinutePart() + ":" + locationEntry.getTimeStampSecondPart() + "." + locationEntry.getTimeStampMilliSecondPart();
            Vector<String> vector = new Vector<String>();
            vector.addElement(Integer.toString(locationEntry.getEntryId()));
            vector.addElement(string3);
            locationTableModel.addRow(vector);
        }
        JTable jTable = new JTable(locationTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.setDefaultRenderer(Object.class, new LocationTableCellRenderer());
        jTable.setSelectionMode(0);
        this.changeButtonEnabled();
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    LocationEntryWindow.this.edit();
                }
            }
        });
        jTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    LocationEntryWindow.this.edit();
                }
            }
        });
        return jTable;
    }

    void add() {
        LocationEntry locationEntry = new LocationEntry();
        locationEntry.setEntryId(this.next);
        locationEntry.init();
        LocationInfoWindow locationInfoWindow = new LocationInfoWindow(this.parent, locationEntry, true);
        locationInfoWindow.setLocation(this.parent.getShowLocation(locationInfoWindow.getWidth(), locationInfoWindow.getHeight(), this.tabwin));
        locationInfoWindow.setVisible(true);
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.locationTable = null;
        this.locationTable = this.createLocationTable();
        this.scrollpane = new JScrollPane(this.locationTable);
        this.add("Center", this.scrollpane);
        this.setVisible(true);
    }

    void edit() {
        int n = this.locationTable.getSelectedRow();
        if (n != -1 && n < this.idList.length) {
            Object v = this.locationHash.get(new Integer(this.idList[n]));
            LocationEntry locationEntry = null;
            if (v instanceof LocationEntry) {
                locationEntry = (LocationEntry)v;
            }
            LocationInfoWindow locationInfoWindow = new LocationInfoWindow(this.parent, locationEntry, false);
            locationInfoWindow.setLocation(this.parent.getShowLocation(locationInfoWindow.getWidth(), locationInfoWindow.getHeight(), this.tabwin));
            locationInfoWindow.setVisible(true);
            this.setVisible(false);
            this.remove(this.scrollpane);
            this.scrollpane = null;
            this.locationTable = null;
            this.locationTable = this.createLocationTable();
            this.scrollpane = new JScrollPane(this.locationTable);
            this.add("Center", this.scrollpane);
            this.setVisible(true);
        }
    }

    void delete() {
        int n = this.locationTable.getSelectedRow();
        if (n != -1) {
            JOptionPane jOptionPane = new JOptionPane(Resource.getString("LOCATION_DELETE_WNG"), 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                String string = Integer.toString(this.idList[n]) + ".loc";
                File file = new File(locationDir, string);
                file.delete();
                this.setVisible(false);
                this.remove(this.scrollpane);
                this.scrollpane = null;
                this.locationTable = null;
                this.locationTable = this.createLocationTable();
                this.scrollpane = new JScrollPane(this.locationTable);
                this.add("Center", this.scrollpane);
                this.setVisible(true);
            }
        }
    }

    void alldelete() {
        JOptionPane jOptionPane = new JOptionPane(Resource.getString("LOCATION_ALL_DELETE_WNG"), 3, 0);
        JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
        jDialog.setResizable(false);
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object instanceof Integer && (Integer)object == 0) {
            locationFiles = locationDir.list(new LocationFilter());
            for (int i = 0; i < locationFiles.length; ++i) {
                String string = locationDir.getPath() + File.separator + locationFiles[i];
                File file = new File(string);
                file.delete();
            }
            this.setVisible(false);
            this.remove(this.scrollpane);
            this.scrollpane = null;
            this.locationTable = null;
            this.locationTable = this.createLocationTable();
            this.scrollpane = new JScrollPane(this.locationTable);
            this.add("Center", this.scrollpane);
            this.setVisible(true);
        }
    }

    void imageSet() {
        int n = this.locationTable.getSelectedRow();
        if (n != -1) {
            Object v = this.locationHash.get(new Integer(this.idList[n]));
            LocationEntry locationEntry = null;
            if (v instanceof LocationEntry) {
                locationEntry = (LocationEntry)v;
            }
            LocationSelectWindow locationSelectWindow = new LocationSelectWindow(this.parent, locationEntry, 14);
            locationSelectWindow.setLocation(this.parent.getShowLocation(locationSelectWindow.getWidth(), locationSelectWindow.getHeight(), this.tabwin));
            locationSelectWindow.setVisible(true);
            this.setVisible(false);
            this.remove(this.scrollpane);
            this.scrollpane = null;
            this.locationTable = null;
            this.locationTable = this.createLocationTable();
            this.scrollpane = new JScrollPane(this.locationTable);
            this.add("Center", this.scrollpane);
            this.setVisible(true);
        }
    }

    void phoneSet() {
        int n = this.locationTable.getSelectedRow();
        if (n != -1) {
            Object v = this.locationHash.get(new Integer(this.idList[n]));
            LocationEntry locationEntry = null;
            if (v instanceof LocationEntry) {
                locationEntry = (LocationEntry)v;
            }
            LocationSelectWindow locationSelectWindow = new LocationSelectWindow(this.parent, locationEntry, 15);
            locationSelectWindow.setLocation(this.parent.getShowLocation(locationSelectWindow.getWidth(), locationSelectWindow.getHeight(), this.tabwin));
            locationSelectWindow.setVisible(true);
            this.setVisible(false);
            this.remove(this.scrollpane);
            this.scrollpane = null;
            this.locationTable = null;
            this.locationTable = this.createLocationTable();
            this.scrollpane = new JScrollPane(this.locationTable);
            this.add("Center", this.scrollpane);
            this.setVisible(true);
        }
    }

    @Override
    void cancel() {
    }

    @Override
    boolean set() {
        return true;
    }

    private void changeButtonEnabled() {
        if (this.idList != null && this.idList.length > 0) {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            this.alldeleteButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.alldeleteButton.setEnabled(false);
        }
    }

    static {
        locationDir = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "location" + File.separator + "location_information");
    }

    class LocationTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LocationTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            switch (n2) {
                case 0: 
                case 1: {
                    this.setHorizontalAlignment(2);
                    break;
                }
                default: {
                    this.setHorizontalAlignment(0);
                }
            }
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class LocationTableModel
    extends DefaultTableModel {
        LocationTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    class LocationFilter
    implements FilenameFilter {
        LocationFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            if (file.equals(locationDir)) {
                return string.endsWith(".loc");
            }
            return false;
        }
    }
}

