/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.DecimalDocument;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.LocationEntry;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.plaf.ComboBoxUI;

class LocationInfoWindow
extends AbstractWindow {
    private MainWindow parent = null;
    private LocationEntry entry = null;
    private JTextField timestampYearField;
    private JTextField timestampMonthField;
    private JTextField timestampDayField;
    private JTextField timestampHourField;
    private JTextField timestampMinuteField;
    private JTextField timestampSecondField;
    private JTextField timestampMilliSecondField;
    private JComboBox latitudeCombo;
    private JComboBox longitudeCombo;
    private String[] latitudePrefixItems = null;
    private String[] longitudePrefixItems = null;
    private JTextField latitudeDegreeField;
    private JTextField latitudeMinuteField;
    private JTextField latitudeSecondField;
    private JTextField latitudeCentiSecondField;
    private JTextField longitudeDegreeField;
    private JTextField longitudeMinuteField;
    private JTextField longitudeSecondField;
    private JTextField longitudeCentiSecondField;
    private JTextField altitudeField;
    private ButtonGroup accuracyLevelButtonGroup;
    private JRadioButton accuracyCoarseRadioButton;
    private JRadioButton accuracyNormalRadioButton;
    private JRadioButton accuracyFineRadioButton;
    private JButton setButton;
    private JButton cancelButton;
    private String locationTitleId = null;
    private long locationInfoTimestamp = 0L;
    private int locationInfoLevel = 0;
    private String locationInfoLatitude = null;
    private String locationInfoLongitude = null;
    private int locationInfoDatum = 0;
    private ButtonGroup datumButtonGroup;
    private JRadioButton datumWGSRadioButton;
    private JRadioButton datumTokyoRadioButton;
    private int TITLE_NUM_MAX = 30;
    private String ILLEGAL_TITLE = "1";
    private String ILLEGAL_TIME = "2";
    private String ILLEGAL_LONGITUDE = "3";
    private String ILLEGAL_LATITUDE = "4";
    private String ILLEGAL_ID = "5";
    private String ILLEGAL_ALTITUDE = "6";
    private int MAX_ENTRY = 50;
    private boolean pFlag = true;

    LocationInfoWindow(MainWindow mainWindow, LocationEntry locationEntry, boolean bl) {
        super(mainWindow, null);
        this.parent = mainWindow;
        this.entry = locationEntry;
        this.addWindowListener();
        this.pFlag = bl;
        this.setTitle(Resource.getString("LOCATION_INFO_WINDOW_TITLE"));
        this.latitudePrefixItems = new String[2];
        this.latitudePrefixItems[0] = new String("N  ");
        this.latitudePrefixItems[1] = new String("S  ");
        this.longitudePrefixItems = new String[2];
        this.longitudePrefixItems[0] = new String("E  ");
        this.longitudePrefixItems[1] = new String("W  ");
        this.latitudeCombo = new JComboBox<String>(this.latitudePrefixItems);
        this.longitudeCombo = new JComboBox<String>(this.longitudePrefixItems);
        this.latitudeCombo.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        this.longitudeCombo.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        if (locationEntry.getLatitudeHeadPart().equals("N") || locationEntry.getLatitudeHeadPart().equals("+") || locationEntry.getLatitudeHeadPart().length() == 0) {
            this.latitudeCombo.setSelectedIndex(0);
        } else {
            this.latitudeCombo.setSelectedIndex(1);
        }
        if (locationEntry.getLongitudeHeadPart().equals("E") || locationEntry.getLongitudeHeadPart().equals("+") || locationEntry.getLongitudeHeadPart().length() == 0) {
            this.latitudeCombo.setSelectedIndex(0);
        } else {
            this.longitudeCombo.setSelectedIndex(1);
        }
        JLabel jLabel = new JLabel(Resource.getString("LOCATION_IMAGE_ID"));
        JLabel jLabel2 = new JLabel(Resource.getString("LOCATION_INFO_TIMESTAMP"));
        JLabel jLabel3 = new JLabel(Resource.getString("GPS_ACCURACY_LEVEL"));
        JLabel jLabel4 = new JLabel(Resource.getString("GPS_LATITUDE"));
        JLabel jLabel5 = new JLabel(Resource.getString("GPS_LONGITUDE"));
        JLabel jLabel6 = new JLabel(Resource.getString("GPS_ALTITUDE"));
        JLabel jLabel7 = new JLabel(Resource.getString("GPS_DATUM_TYPE"));
        JLabel jLabel8 = new JLabel(".");
        JLabel jLabel9 = new JLabel(".");
        JLabel jLabel10 = new JLabel(".");
        JLabel jLabel11 = new JLabel(".");
        JLabel jLabel12 = new JLabel(".");
        JLabel jLabel13 = new JLabel(".");
        JLabel jLabel14 = new JLabel(" " + Resource.getString("GPS_DATUM_WGS84"));
        JLabel jLabel15 = new JLabel("/");
        JLabel jLabel16 = new JLabel("/");
        JLabel jLabel17 = new JLabel(" ");
        JLabel jLabel18 = new JLabel(":");
        JLabel jLabel19 = new JLabel(":");
        JLabel jLabel20 = new JLabel(".");
        this.setButton = new JButton(Resource.getString("SET"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        this.accuracyCoarseRadioButton = new JRadioButton("1");
        this.accuracyNormalRadioButton = new JRadioButton("2");
        this.accuracyFineRadioButton = new JRadioButton("3");
        this.accuracyLevelButtonGroup = new ButtonGroup();
        this.accuracyLevelButtonGroup.add(this.accuracyCoarseRadioButton);
        this.accuracyLevelButtonGroup.add(this.accuracyNormalRadioButton);
        this.accuracyLevelButtonGroup.add(this.accuracyFineRadioButton);
        switch (Integer.parseInt(locationEntry.getInfoLevel())) {
            case 1: {
                this.accuracyCoarseRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.accuracyNormalRadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.accuracyFineRadioButton.setSelected(true);
            }
        }
        JLabel jLabel21 = new JLabel(" " + Integer.toString(locationEntry.getEntryId()));
        this.timestampYearField = new JTextField(4);
        this.timestampMonthField = new JTextField(3);
        this.timestampDayField = new JTextField(3);
        this.timestampHourField = new JTextField(3);
        this.timestampMinuteField = new JTextField(3);
        this.timestampSecondField = new JTextField(3);
        this.timestampMilliSecondField = new JTextField(4);
        this.timestampYearField.setDocument(new HalfNumberDocument(4));
        this.timestampMonthField.setDocument(new HalfNumberDocument(2));
        this.timestampDayField.setDocument(new HalfNumberDocument(2));
        this.timestampHourField.setDocument(new HalfNumberDocument(2));
        this.timestampMinuteField.setDocument(new HalfNumberDocument(2));
        this.timestampSecondField.setDocument(new HalfNumberDocument(2));
        this.timestampMilliSecondField.setDocument(new HalfNumberDocument(3));
        this.timestampYearField.setText(locationEntry.getTimeStampYearPart());
        this.timestampMonthField.setText(locationEntry.getTimeStampMonthPart());
        this.timestampDayField.setText(locationEntry.getTimeStampDayPart());
        this.timestampHourField.setText(locationEntry.getTimeStampHourPart());
        this.timestampMinuteField.setText(locationEntry.getTimeStampMinutePart());
        this.timestampSecondField.setText(locationEntry.getTimeStampSecondPart());
        this.timestampMilliSecondField.setText(locationEntry.getTimeStampMilliSecondPart());
        this.latitudeDegreeField = new JTextField(4);
        this.latitudeMinuteField = new JTextField(3);
        this.latitudeSecondField = new JTextField(3);
        this.latitudeCentiSecondField = new JTextField(4);
        this.latitudeDegreeField.setDocument(new HalfNumberDocument(2));
        this.latitudeMinuteField.setDocument(new HalfNumberDocument(2));
        this.latitudeSecondField.setDocument(new HalfNumberDocument(2));
        this.latitudeCentiSecondField.setDocument(new HalfNumberDocument(3));
        this.latitudeDegreeField.setHorizontalAlignment(4);
        this.latitudeMinuteField.setHorizontalAlignment(4);
        this.latitudeSecondField.setHorizontalAlignment(4);
        this.latitudeCentiSecondField.setHorizontalAlignment(4);
        this.latitudeDegreeField.setText(locationEntry.getLatitudeDegreePart());
        this.latitudeMinuteField.setText(locationEntry.getLatitudeMinutePart());
        this.latitudeSecondField.setText(locationEntry.getLatitudeSecondPart());
        this.latitudeCentiSecondField.setText(locationEntry.getLatitudeCentiSecondPart());
        this.longitudeDegreeField = new JTextField(4);
        this.longitudeMinuteField = new JTextField(3);
        this.longitudeSecondField = new JTextField(3);
        this.longitudeCentiSecondField = new JTextField(4);
        this.longitudeDegreeField.setDocument(new HalfNumberDocument(3));
        this.longitudeMinuteField.setDocument(new HalfNumberDocument(2));
        this.longitudeSecondField.setDocument(new HalfNumberDocument(2));
        this.longitudeCentiSecondField.setDocument(new HalfNumberDocument(3));
        this.longitudeDegreeField.setHorizontalAlignment(4);
        this.longitudeMinuteField.setHorizontalAlignment(4);
        this.longitudeSecondField.setHorizontalAlignment(4);
        this.longitudeCentiSecondField.setHorizontalAlignment(4);
        this.longitudeDegreeField.setText(locationEntry.getLongitudeDegreePart());
        this.longitudeMinuteField.setText(locationEntry.getLongitudeMinutePart());
        this.longitudeSecondField.setText(locationEntry.getLongitudeSecondPart());
        this.longitudeCentiSecondField.setText(locationEntry.getLongitudeCentiSecondPart());
        this.altitudeField = new JTextField(20);
        this.altitudeField.setDocument(new DecimalDocument(11));
        this.altitudeField.setHorizontalAlignment(4);
        this.altitudeField.setText(locationEntry.getAltitude());
        Container container = this.getContentPane();
        container.setLayout(new FlowLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new GridLayout(7, 1));
        jPanel4.setLayout(new GridLayout(7, 1));
        jPanel6.setLayout(new FlowLayout(0));
        jPanel7.setLayout(new FlowLayout(0));
        jPanel8.setLayout(new FlowLayout(0));
        jPanel9.setLayout(new FlowLayout(0));
        jPanel10.setLayout(new FlowLayout(0));
        jPanel6.add(this.timestampYearField);
        jPanel6.add(jLabel15);
        jPanel6.add(this.timestampMonthField);
        jPanel6.add(jLabel16);
        jPanel6.add(this.timestampDayField);
        jPanel6.add(jLabel17);
        jPanel6.add(this.timestampHourField);
        jPanel6.add(jLabel18);
        jPanel6.add(this.timestampMinuteField);
        jPanel6.add(jLabel19);
        jPanel6.add(this.timestampSecondField);
        jPanel6.add(jLabel20);
        jPanel6.add(this.timestampMilliSecondField);
        jPanel7.add(this.accuracyCoarseRadioButton);
        jPanel7.add(this.accuracyNormalRadioButton);
        jPanel7.add(this.accuracyFineRadioButton);
        jPanel8.add(this.latitudeCombo);
        jPanel8.add(this.latitudeDegreeField);
        jPanel8.add(jLabel8);
        jPanel8.add(this.latitudeMinuteField);
        jPanel8.add(jLabel9);
        jPanel8.add(this.latitudeSecondField);
        jPanel8.add(jLabel10);
        jPanel8.add(this.latitudeCentiSecondField);
        jPanel9.add(this.longitudeCombo);
        jPanel9.add(this.longitudeDegreeField);
        jPanel9.add(jLabel11);
        jPanel9.add(this.longitudeMinuteField);
        jPanel9.add(jLabel12);
        jPanel9.add(this.longitudeSecondField);
        jPanel9.add(jLabel13);
        jPanel9.add(this.longitudeCentiSecondField);
        jPanel10.add(this.altitudeField);
        jPanel3.add(this.getFlowPanel(jLabel, 2));
        jPanel3.add(this.getFlowPanel(jLabel2, 2));
        jPanel3.add(this.getFlowPanel(jLabel3, 2));
        jPanel3.add(this.getFlowPanel(jLabel4, 2));
        jPanel3.add(this.getFlowPanel(jLabel5, 2));
        jPanel3.add(this.getFlowPanel(jLabel6, 2));
        jPanel3.add(this.getFlowPanel(jLabel7, 2));
        jPanel4.add(this.getFlowPanel(jLabel21, 0));
        jPanel4.add(jPanel6);
        jPanel4.add(jPanel7);
        jPanel4.add(jPanel8);
        jPanel4.add(jPanel9);
        jPanel4.add(jPanel10);
        jPanel4.add(this.getFlowPanel(jLabel14, 0));
        jPanel5.add(this.setButton);
        jPanel5.add(this.cancelButton);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel.add("North", jPanel2);
        jPanel.add("South", jPanel5);
        container.add(jPanel);
        this.setButton.setActionCommand("set");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.setButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.pack();
        this.setResizable(false);
    }

    private long parseTimestamp() {
        String string = this.timestampYearField.getText();
        String string2 = this.timestampMonthField.getText();
        String string3 = this.timestampDayField.getText();
        String string4 = this.timestampHourField.getText();
        String string5 = this.timestampMinuteField.getText();
        String string6 = this.timestampSecondField.getText();
        String string7 = this.timestampMilliSecondField.getText();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        try {
            n = Integer.parseInt(string);
            n2 = Integer.parseInt(string2);
            n3 = Integer.parseInt(string3);
            n4 = Integer.parseInt(string4);
            n5 = Integer.parseInt(string5);
            n6 = Integer.parseInt(string6);
            n7 = Integer.parseInt(string7);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n < 1 || n > 9999) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n3 < 1 || n3 > 31) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n4 < 0 || n4 > 23) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n5 < 0 || n5 > 59) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n6 < 0 || n6 > 59) {
            throw new IllegalArgumentException("Illegal params.");
        }
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeZone(timeZone);
        gregorianCalendar.set(1, n);
        gregorianCalendar.set(2, n2 - 1);
        if (n3 > gregorianCalendar.getActualMaximum(5)) {
            throw new IllegalArgumentException("Illegal params.");
        }
        gregorianCalendar.set(5, n3);
        gregorianCalendar.set(11, n4);
        gregorianCalendar.set(12, n5);
        gregorianCalendar.set(13, n6);
        gregorianCalendar.set(14, n7);
        long l = gregorianCalendar.getTime().getTime();
        if (l < 0L) {
            throw new IllegalArgumentException("Illegal params.");
        }
        return l;
    }

    private String parseDmsLatitude() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.latitudeCombo.getSelectedIndex();
        String string = ((String)this.latitudeCombo.getSelectedItem()).trim();
        String string2 = this.latitudeDegreeField.getText();
        String string3 = this.latitudeMinuteField.getText();
        String string4 = this.latitudeSecondField.getText();
        String string5 = this.latitudeCentiSecondField.getText();
        String string6 = null;
        try {
            n = Integer.parseInt(string2);
            if (n5 != 0) {
                n = -n;
            }
            n2 = Integer.parseInt(string3);
            n3 = Integer.parseInt(string4);
            n4 = Integer.parseInt(string5);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl) {
            if (n < -90 || n > 90) {
                bl = true;
            } else if (n2 < 0 || n2 > 59) {
                bl = true;
            } else if (n3 < 0 || n3 > 59) {
                bl = true;
            } else if (n4 < 0 || n4 > 999) {
                bl = true;
            } else if (Math.abs(n) == 90 && (n2 != 0 || n3 != 0 || n4 != 0)) {
                bl = true;
            } else {
                if (string2.length() == 1) {
                    string2 = "0" + string2;
                }
                if (string3.length() == 1) {
                    string3 = "0" + string3;
                }
                if (string4.length() == 1) {
                    string4 = "0" + string4;
                }
                if (string5.length() == 1) {
                    string5 = "00" + string5;
                } else if (string5.length() == 2) {
                    string5 = "0" + string5;
                }
                string6 = string + string2 + "." + string3 + "." + string4 + "." + string5;
            }
        }
        return string6;
    }

    private String parseDmsLongitude() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.longitudeCombo.getSelectedIndex();
        String string = ((String)this.longitudeCombo.getSelectedItem()).trim();
        String string2 = this.longitudeDegreeField.getText();
        String string3 = this.longitudeMinuteField.getText();
        String string4 = this.longitudeSecondField.getText();
        String string5 = this.longitudeCentiSecondField.getText();
        String string6 = null;
        try {
            n = Integer.parseInt(string2);
            if (n5 != 0) {
                n = -n;
            }
            n2 = Integer.parseInt(string3);
            n3 = Integer.parseInt(string4);
            n4 = Integer.parseInt(string5);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl) {
            if (n < -180 || n >= 180) {
                bl = true;
            } else if (n2 < 0 || n2 > 59) {
                bl = true;
            } else if (n3 < 0 || n3 > 59) {
                bl = true;
            } else if (n4 < 0 || n4 > 999) {
                bl = true;
            } else if (n == -180 && (n2 != 0 || n3 != 0 || n4 != 0)) {
                bl = true;
            } else {
                if (string2.length() == 1) {
                    string2 = "00" + string2;
                } else if (string2.length() == 2) {
                    string2 = "0" + string2;
                }
                if (string3.length() == 1) {
                    string3 = "0" + string3;
                }
                if (string4.length() == 1) {
                    string4 = "0" + string4;
                }
                if (string5.length() == 1) {
                    string5 = "00" + string5;
                } else if (string5.length() == 2) {
                    string5 = "0" + string5;
                }
                string6 = string + string2 + "." + string3 + "." + string4 + "." + string5;
            }
        }
        return string6;
    }

    private String parseAltitude() {
        String string = this.altitudeField.getText();
        String string2 = null;
        int n = 0;
        try {
            n = Integer.parseInt(string);
            string2 = Integer.toString(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    void set() {
        int n = 1;
        long l = 0L;
        String string = this.parseDmsLatitude();
        String string2 = this.parseDmsLongitude();
        String string3 = this.parseAltitude();
        String string4 = null;
        String string5 = null;
        String string6 = "";
        int n2 = this.latitudeCombo.getSelectedIndex();
        if (n2 < 0) {
            return;
        }
        n2 = this.longitudeCombo.getSelectedIndex();
        if (n2 < 0) {
            return;
        }
        try {
            try {
                l = this.parseTimestamp();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(this.ILLEGAL_TIME);
            }
            if (string == null) {
                throw new IllegalArgumentException(this.ILLEGAL_LATITUDE);
            }
            if (string2 == null) {
                throw new IllegalArgumentException(this.ILLEGAL_LONGITUDE);
            }
            if (string3 == null) {
                throw new IllegalArgumentException(this.ILLEGAL_ALTITUDE);
            }
            if (this.accuracyCoarseRadioButton.isSelected()) {
                n = 1;
            } else if (this.accuracyNormalRadioButton.isSelected()) {
                n = 2;
            } else if (this.accuracyFineRadioButton.isSelected()) {
                n = 3;
            }
            String[] stringArray = LocationEntry.locationDir.list(new LocationFilter());
            if (this.pFlag && stringArray.length >= this.MAX_ENTRY) {
                JOptionPane jOptionPane = new JOptionPane(Resource.getString("LOCATION_OVER_ELEMENT_WNG"), 3, 0);
                JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
                jDialog.setResizable(false);
                jDialog.setVisible(true);
                Object object = jOptionPane.getValue();
                if (object instanceof Integer) {
                    if ((Integer)object == 0) {
                        Object[] objectArray = new String[stringArray.length];
                        String string7 = null;
                        for (int i = 0; i < objectArray.length; ++i) {
                            string7 = stringArray[i].substring(0, stringArray[i].length() - 4);
                            int n3 = string7.length();
                            for (int j = 0; j < 5 - n3; ++j) {
                                string7 = "0" + string7;
                            }
                            objectArray[i] = string7;
                        }
                        Arrays.sort(objectArray);
                        String string8 = LocationEntry.locationDir.getPath() + File.separator + Integer.parseInt((String)objectArray[0]) + ".loc";
                        File file = new File(string8);
                        file.delete();
                    }
                } else {
                    return;
                }
            }
            string4 = this.entry.getEntryId() + "," + l + "," + n + "," + string + "," + string2 + "," + string3 + "," + "0";
            string5 = this.entry.getEntryId() + ".loc";
            this.entry.save(string4, string5);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage().equals(this.ILLEGAL_ID)) {
                this.parent.showDialog(Resource.format("WRNG_VAL_WNG", Resource.getString("LOCATION_IMAGE_ID")), this, 2);
                return;
            }
            if (illegalArgumentException.getMessage().equals(this.ILLEGAL_LATITUDE)) {
                string6 = Resource.getString("GPS_LATITUDE");
            } else if (illegalArgumentException.getMessage().equals(this.ILLEGAL_LONGITUDE)) {
                string6 = Resource.getString("GPS_LONGITUDE");
            } else if (illegalArgumentException.getMessage().equals(this.ILLEGAL_TIME)) {
                string6 = Resource.getString("LOCATION_INFO_TIMESTAMP");
            } else if (illegalArgumentException.getMessage().equals(this.ILLEGAL_ALTITUDE)) {
                string6 = Resource.getString("GPS_ALTITUDE");
            }
            this.parent.showDialog(Resource.format("WRNG_VAL_WNG", string6), this, 2);
            return;
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("WRITE_ERR", string5));
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private JPanel getFlowPanel(JComponent jComponent, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(n));
        jPanel.add(jComponent);
        return jPanel;
    }

    class LocationFilter
    implements FilenameFilter {
        LocationFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            if (file.equals(LocationEntry.locationDir)) {
                return string.endsWith(".loc");
            }
            return false;
        }
    }
}

