/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.MailAddressEditLog;
import com.nttdocomo.dojaemu.ktoolbar.MailEditWindow;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

class MailAddressEditWindow
extends AbstractWindow {
    private MainWindow parent;
    private JTextField addressField;
    private String oldAddress;
    private boolean selected = false;
    private Vector vLog;
    private Vector vAdd;

    MailAddressEditWindow(MainWindow mainWindow, String string, boolean bl, Vector vector, Vector vector2) {
        super(mainWindow, null, true);
        this.parent = mainWindow;
        this.oldAddress = string;
        this.selected = bl;
        this.vLog = vector;
        this.vAdd = vector2;
        this.addWindowListener();
        JButton jButton = new JButton(Resource.getString("SET"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        this.addressField = new JTextField(40);
        if (string != null) {
            this.setTitle(Resource.getString("ADDRESS_EDIT_TITLE"));
            this.addressField.setText(string);
        } else {
            this.setTitle(Resource.getString("ADDRESS_ADD_TITLE"));
            this.addressField.setText("");
        }
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        container.add("Center", this.addressField);
        container.add("South", jPanel);
        this.pack();
        this.setResizable(false);
        jButton2.setActionCommand("cancel");
        jButton.setActionCommand("save");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton2.addActionListener(actionDispatcher);
        jButton.addActionListener(actionDispatcher);
    }

    void save() {
        String string = this.addressField.getText();
        boolean bl = false;
        if (string == null || string.trim().length() == 0) {
            try {
                this.parent.showDialog(Resource.format("EMP_VAL_WNG", Resource.getString("MY_ADDRESS")), this, 2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        if ((string = string.trim()).length() > 50) {
            try {
                Object[] objectArray = new String[]{Resource.getString("MY_ADDRESS"), "50"};
                this.parent.showDialog(Resource.format("OVER_VAL_WNG", objectArray), this, 2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        if (!MailEditWindow.checkASCIICharacters(string) || string.indexOf(32) != -1 || string.indexOf(44) != -1) {
            this.parent.showDialog(Resource.format("WRNG_VAL_WNG", Resource.getString("MY_ADDRESS")), this, 2);
            return;
        }
        if (this.oldAddress != null && string.equals(this.oldAddress)) {
            this.setVisible(false);
            return;
        }
        if (this.isInvalidCharacter(string)) {
            this.parent.showDialog(Resource.format("EMP_VAL_WNG", Resource.getString("MY_ADDRESS")), this, 2);
            return;
        }
        if (this.vAdd.indexOf(string) != -1) {
            this.parent.showDialog(Resource.getString("SAME_ADDRESS_ERR"), this, 2);
            return;
        }
        if (this.oldAddress == null) {
            if (!this.isAbleToAdd(string)) {
                this.parent.showDialog(Resource.format("EMP_VAL_WNG", Resource.getString("MY_ADDRESS")), this, 2);
            } else {
                this.vLog.addElement(new MailAddressEditLog(1, null, string));
                this.vAdd.addElement(string);
                this.setVisible(false);
            }
        } else if (!this.isAbleToRename(this.oldAddress, string)) {
            this.parent.showDialog(Resource.format("EMP_VAL_WNG", Resource.getString("MY_ADDRESS")), this, 2);
        } else {
            this.vLog.addElement(new MailAddressEditLog(2, this.oldAddress, string));
            int n = this.vAdd.indexOf(this.oldAddress);
            if (n != -1) {
                this.vAdd.set(n, string);
            }
            this.setVisible(false);
        }
    }

    private boolean isAbleToAdd(String string) {
        if (string == null) {
            return false;
        }
        if (this.isInvalidCharacter(string)) {
            return false;
        }
        return this.vAdd.indexOf(string) == -1;
    }

    private boolean isAbleToRename(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (this.isInvalidCharacter(string) || this.isInvalidCharacter(string2)) {
            return false;
        }
        return this.vAdd.indexOf(string) != -1 && this.vAdd.indexOf(string2) == -1;
    }

    private boolean isInvalidCharacter(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\\' && cArray[i] != '/' && cArray[i] != ':' && cArray[i] != '*' && cArray[i] != '?' && cArray[i] != '\"' && cArray[i] != '<' && cArray[i] != '>' && cArray[i] != '|') continue;
            return true;
        }
        return false;
    }

    void cancel() {
        this.setVisible(false);
    }
}

