/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.MailAddressEditLog;
import com.nttdocomo.dojaemu.ktoolbar.MailAddressEditWindow;
import com.nttdocomo.dojaemu.ktoolbar.MailFileManager;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class MailAddressWindow
extends TabPanel {
    private JList addressList = null;
    static final String DEFAULT_ADDRESS = "message_app_usr0@docomo.ne.jp";
    private JButton editAddressButton = null;
    private JButton newAddressButton = null;
    private Vector vLog = new Vector();
    private Vector vAdd = new Vector();

    MailAddressWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.editAddressButton = new JButton(Resource.getString("EDIT_MAIL"));
        this.newAddressButton = new JButton(Resource.getString("ADD"));
        this.addressList = new JList();
        this.addressList.setSelectionMode(0);
        this.addressList.setCellRenderer(new MailaddressTableCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.addressList);
        this.addressList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    MailAddressWindow.this.editAddress();
                }
            }
        });
        this.addressList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    MailAddressWindow.this.editAddress();
                }
            }
        });
        this.addressList.addListSelectionListener(new WindowListSelectionListener(this));
        this.changeWindowState(true);
        this.editAddressButton.setActionCommand("editAddress");
        this.newAddressButton.setActionCommand("newAddress");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.editAddressButton.addActionListener(actionDispatcher);
        this.newAddressButton.addActionListener(actionDispatcher);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(this.newAddressButton);
        jPanel.add(this.editAddressButton);
        this.setLayout(new BorderLayout());
        this.add("Center", jScrollPane);
        this.add("South", jPanel);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(300, 400);
    }

    void newAddress() {
        MailAddressEditWindow mailAddressEditWindow = new MailAddressEditWindow(this.parent, null, false, this.vLog, this.vAdd);
        mailAddressEditWindow.setLocation(this.parent.getShowLocation(mailAddressEditWindow.getWidth(), mailAddressEditWindow.getHeight(), this.tabwin));
        mailAddressEditWindow.setVisible(true);
        mailAddressEditWindow.dispose();
        this.changeWindowState(false);
        if (this.vLog.size() > 0 && this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    void editAddress() {
        String string = (String)this.addressList.getSelectedValue();
        String string2 = MailFileManager.getMyAddress();
        boolean bl = false;
        if (string == null) {
            return;
        }
        if (JAMManager.getState() != 4) {
            this.parent.showDialog(Resource.getString("NOT_ADDRESS_WNG"), this.tabwin, 2);
            return;
        }
        if (string2 != null && string2.trim().equals(string.trim())) {
            bl = true;
        }
        MailAddressEditWindow mailAddressEditWindow = new MailAddressEditWindow(this.parent, string, bl, this.vLog, this.vAdd);
        mailAddressEditWindow.setLocation(this.parent.getShowLocation(mailAddressEditWindow.getWidth(), mailAddressEditWindow.getHeight(), this.tabwin));
        mailAddressEditWindow.setVisible(true);
        mailAddressEditWindow.dispose();
        this.changeWindowState(false);
        if (this.vLog.size() > 0 && this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    boolean set() {
        if (this.vLog.size() > 0) {
            for (int i = 0; i < this.vLog.size(); ++i) {
                String string;
                boolean bl;
                String string2;
                MailAddressEditLog mailAddressEditLog = (MailAddressEditLog)this.vLog.elementAt(i);
                int n = mailAddressEditLog.getType();
                if (n == 1) {
                    string2 = mailAddressEditLog.getNewAddress();
                    boolean bl2 = MailFileManager.addAddress(string2);
                    if (bl2) continue;
                    this.parent.showDialog(Resource.format("WRITE_ERR", Resource.getString("MY_ADDRESS")), this.tabwin, 2);
                    return false;
                }
                if (n != 2 || (bl = MailFileManager.renameAddress(string2 = mailAddressEditLog.getOldAddress(), string = mailAddressEditLog.getNewAddress()))) continue;
                this.parent.showDialog(Resource.getString("RENAME_ADDRESS_ERR"), this.tabwin, 2);
                return false;
            }
            this.vLog.removeAllElements();
        }
        String string = (String)this.addressList.getSelectedValue();
        boolean bl = false;
        if (string == null) {
            return false;
        }
        if (JAMManager.getState() != 4) {
            this.parent.showDialog(Resource.getString("NOT_ADDRESS_WNG"), this.tabwin, 2);
            return false;
        }
        bl = MailFileManager.setMyAddress(string);
        if (!bl) {
            this.parent.showDialog(Resource.format("WRITE_ERR", Resource.getString("MY_ADDRESS")), this.tabwin, 2);
            return false;
        }
        return true;
    }

    @Override
    void cancel() {
    }

    void changeWindowState(boolean bl) {
        String[] stringArray = null;
        String string = null;
        boolean bl2 = false;
        int n = 0;
        string = MailFileManager.getMyAddress();
        this.addressList.removeAll();
        if (bl) {
            stringArray = MailFileManager.getMailAddresses();
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (string != null && stringArray[i].equals(string)) {
                    n = i;
                    bl2 = true;
                }
                this.vAdd.addElement(stringArray[i]);
            }
        } else {
            stringArray = this.vAdd.size() == 0 ? new String[]{} : new String[this.vAdd.size()];
            if (!this.addressList.isSelectionEmpty()) {
                string = (String)this.addressList.getSelectedValue();
            }
            for (int i = 0; i < this.vAdd.size(); ++i) {
                stringArray[i] = (String)this.vAdd.elementAt(i);
                if (stringArray[i] == null || !stringArray[i].equals(string)) continue;
                n = i;
                bl2 = true;
            }
        }
        if (stringArray.length != 0) {
            if (!bl2) {
                n = 0;
            }
            this.editAddressButton.setEnabled(true);
            this.addressList.setListData(stringArray);
            this.addressList.setSelectedIndex(n);
            this.addressList.ensureIndexIsVisible(n);
        } else {
            this.editAddressButton.setEnabled(false);
        }
    }

    class WindowListSelectionListener
    implements ListSelectionListener {
        TabPanel parentTab;

        WindowListSelectionListener(TabPanel tabPanel) {
            this.parentTab = tabPanel;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting() && MailAddressWindow.this.listener != null) {
                MailAddressWindow.this.listener.tabPanelEvent(this.parentTab, 1, 0);
            }
        }
    }

    class MailaddressTableCellRenderer
    extends JLabel
    implements ListCellRenderer {
        MailaddressTableCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }
}

