/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.MailEditWindow;
import com.nttdocomo.dojaemu.ktoolbar.MailFileManager;
import com.nttdocomo.dojaemu.ktoolbar.MailInfo;
import com.nttdocomo.dojaemu.ktoolbar.MailTableCellRenderer;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

class MailSettingWindow
extends TabPanel
implements ItemListener {
    static final int FRAME_WIDTH = 600;
    static final int FRAME_HEIGHT = 300;
    private final int TEXT_AREA_WIDTH = 580;
    private final int TEXT_AREA_HEIGHT = 240;
    private final int COLUMN_NUM = 4;
    private final int INITIAL_ROWHEIGHT = 20;
    private final int STATE_COLUMN_WIDTH = 40;
    private final int DATE_COLUMN_WIDTH = 110;
    private final int TABLE_COLUMN_MARGIN = 18;
    private JComboBox mailBoxList = null;
    private JTable tableView = null;
    private String mailAddress = null;
    private Vector mailBox = new Vector();
    private JButton editMailButton = null;
    private JButton deleteButton = null;
    private int mailBoxState = 0;
    private String messageCode = null;
    private int receivedNum = 0;
    private int sentNum = 0;

    MailSettingWindow(AbstractWindow abstractWindow, String string, String string2, int n, int n2) {
        super(abstractWindow);
        this.mailAddress = string;
        this.messageCode = string2;
        this.receivedNum = n;
        this.sentNum = n2;
        if (this.receivedNum == 0) {
            this.receivedNum = 200;
        }
        if (this.sentNum == 0) {
            this.sentNum = 50;
        }
        this.mailBoxList = this.getMailBoxes();
        this.mailBoxList.addItemListener(this);
        this.editMailButton = new JButton(Resource.getString("EDIT_MAIL"));
        JButton jButton = new JButton(Resource.getString("ADD"));
        this.deleteButton = new JButton(Resource.getString("DELETE"));
        this.tableView = new JTable();
        this.tableView.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    MailSettingWindow.this.editMail();
                }
            }
        });
        this.tableView.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    MailSettingWindow.this.editMail();
                }
            }
        });
        this.changeWindowState();
        JScrollPane jScrollPane = new JScrollPane(this.tableView);
        this.editMailButton.setActionCommand("editMail");
        jButton.setActionCommand("newMail");
        this.deleteButton.setActionCommand("deleteMail");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.editMailButton.addActionListener(actionDispatcher);
        jButton.addActionListener(actionDispatcher);
        this.deleteButton.addActionListener(actionDispatcher);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(this.mailBoxList);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        jPanel2.add(jButton);
        jPanel2.add(this.editMailButton);
        jPanel2.add(this.deleteButton);
        this.setLayout(new BorderLayout());
        this.add("North", jPanel);
        this.add("Center", jScrollPane);
        this.add("South", jPanel2);
    }

    MailSettingWindow(AbstractWindow abstractWindow, String string) {
        JLabel jLabel = new JLabel(string);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(jLabel);
        this.setLayout(new GridLayout(3, 1));
        this.add(new JPanel());
        this.add(jPanel);
        this.add(new JPanel());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(600, 300);
    }

    @Override
    boolean set() {
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent != null) {
            this.mailBoxState = this.mailBoxList.getSelectedIndex();
        }
        if (this.mailBoxState == -1) {
            this.mailBoxState = 0;
        }
        this.changeWindowState();
    }

    void newMail() {
        boolean bl = true;
        MailFileManager mailFileManager = new MailFileManager(this.mailAddress, this.messageCode);
        if (this.mailBoxState == 0) {
            if (mailFileManager.getMailNum(0) >= this.receivedNum) {
                bl = false;
            }
        } else if (mailFileManager.getMailNum(1) + mailFileManager.getMailNum(2) >= this.sentNum) {
            bl = false;
        }
        if (!bl) {
            this.parent.showDialog(Resource.getString("ADD_MAIL_ERR"), this, 2);
            return;
        }
        try {
            MailEditWindow mailEditWindow = new MailEditWindow(this.parent, this.mailAddress, this.mailBoxState, this.messageCode, this.receivedNum, this.sentNum, this.getWindowTitle());
            mailEditWindow.setLocation(this.parent.getShowLocation(mailEditWindow.getWidth(), mailEditWindow.getHeight(), this.tabwin));
            mailEditWindow.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.changeWindowState();
    }

    void editMail() {
        int[] nArray = this.tableView.getSelectedRows();
        if (this.tableView.getSelectedRowCount() != 1) {
            return;
        }
        try {
            MailInfo mailInfo = (MailInfo)this.mailBox.elementAt(nArray[0]);
            MailEditWindow mailEditWindow = new MailEditWindow(this.parent, mailInfo, this.mailAddress, this.mailBoxState, this.messageCode, this.receivedNum, this.sentNum, this.getWindowTitle());
            mailEditWindow.setLocation(this.parent.getShowLocation(mailEditWindow.getWidth(), mailEditWindow.getHeight(), this.tabwin));
            mailEditWindow.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.changeWindowState();
    }

    void deleteMail() {
        BufferedWriter bufferedWriter = null;
        BufferedReader bufferedReader = null;
        int[] nArray = this.tableView.getSelectedRows();
        if (this.tableView.getSelectedRowCount() == 0) {
            return;
        }
        JOptionPane jOptionPane = new JOptionPane(Resource.format("MAIL_DELETE_WNG", String.valueOf(this.tableView.getSelectedRowCount())), 3, 0);
        JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
        jDialog.setResizable(false);
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object instanceof Integer && (Integer)object == 0) {
            MailFileManager mailFileManager = new MailFileManager(this.mailAddress, this.messageCode);
            File file = mailFileManager.getStateFilePath(this.mailBoxState);
            String string = null;
            for (int i = 0; i < this.tableView.getSelectedRowCount(); ++i) {
                try {
                    MailInfo mailInfo = (MailInfo)this.mailBox.elementAt(nArray[i]);
                    string = mailInfo.getMailPath().getName();
                    bufferedReader = new BufferedReader(new FileReader(file));
                    String string2 = null;
                    String string3 = "";
                    while ((string2 = bufferedReader.readLine()) != null) {
                        string2 = string2.indexOf(string) != -1 ? "" : string2 + "\n";
                        string3 = string3 + string2;
                    }
                    bufferedWriter = new BufferedWriter(new FileWriter(file, false));
                    bufferedWriter.write(string3);
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    mailInfo.getMailPath().delete();
                    continue;
                }
                catch (Exception exception) {
                    System.err.println(Resource.format("MAIL_DELETE_ERR", string));
                    return;
                }
            }
            this.changeWindowState();
        }
    }

    @Override
    void cancel() {
    }

    private JComboBox getMailBoxes() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        jComboBox.addItem(Resource.getString("RECEIVED_BOX"));
        jComboBox.addItem(Resource.getString("SENT_BOX"));
        jComboBox.addItem(Resource.getString("UNSENT_BOX"));
        jComboBox.setSelectedIndex(0);
        return jComboBox;
    }

    private void setEnabledButtons(boolean bl) {
        this.editMailButton.setEnabled(bl);
        this.deleteButton.setEnabled(bl);
    }

    private TableModel getMailListTable() {
        String string = Resource.getString("TO");
        String string2 = Resource.getString("SEND_DATE");
        MailFileManager mailFileManager = new MailFileManager(this.mailAddress, this.messageCode);
        if (this.mailBoxState == 0) {
            string = Resource.getString("FROM");
            string2 = Resource.getString("RECEIVE_DATE");
        }
        final String[] stringArray = new String[]{Resource.getString("MAIL_STATE"), string2, string, Resource.getString("SUBJECT")};
        this.mailBox = mailFileManager.getMails(this.mailBoxState);
        final Object[][] objectArray = new Object[this.mailBox.size()][4];
        for (int i = 0; i < this.mailBox.size(); ++i) {
            String string3 = null;
            String string4 = "";
            if (this.mailBoxState == 0) {
                string3 = ((MailInfo)this.mailBox.elementAt(i)).getFromHeader();
                string4 = this.getStateString(((MailInfo)this.mailBox.elementAt(i)).getState());
            } else {
                string3 = MailEditWindow.getAddressString(((MailInfo)this.mailBox.elementAt(i)).getToHeader());
            }
            objectArray[i] = new Object[]{string4, ((MailInfo)this.mailBox.elementAt(i)).getDate(), string3, ((MailInfo)this.mailBox.elementAt(i)).getSubjectHeader()};
        }
        AbstractTableModel abstractTableModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return stringArray.length;
            }

            @Override
            public int getRowCount() {
                return objectArray.length;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return objectArray[n][n2];
            }

            @Override
            public String getColumnName(int n) {
                return stringArray[n];
            }

            public Class getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                objectArray[n][n2] = object;
            }
        };
        return abstractTableModel;
    }

    void changeWindowState() {
        int n = 0;
        int n2 = 0;
        this.tableView.setModel(this.getMailListTable());
        this.tableView.setSelectionMode(2);
        this.tableView.setDefaultRenderer(Object.class, new MailTableCellRenderer());
        this.tableView.setRowHeight(20);
        n = 40;
        n2 = this.getFontMetrics(this.getFont()).stringWidth(Resource.getString("MAIL_STATE")) + 18;
        if (n2 > n) {
            n = n2;
        }
        this.tableView.getColumnModel().getColumn(0).setMinWidth(n);
        this.tableView.getColumnModel().getColumn(0).setMaxWidth(n);
        n = 110;
        n2 = this.getFontMetrics(this.getFont()).stringWidth(Resource.getString("RECEIVE_DATE")) + 18;
        if (n2 > n) {
            n = n2;
        }
        this.tableView.getColumnModel().getColumn(1).setMinWidth(n);
        this.tableView.getColumnModel().getColumn(1).setMaxWidth(n);
        this.tableView.getTableHeader().setReorderingAllowed(false);
        this.tableView.getTableHeader().setResizingAllowed(false);
        if (this.tableView.getRowCount() != 0) {
            this.setEnabledButtons(true);
        } else {
            this.setEnabledButtons(false);
        }
    }

    private String getWindowTitle() {
        String string = null;
        switch (this.mailBoxState) {
            case 0: {
                string = Resource.getString("MAIL_EDIT") + "(" + Resource.getString("RECEIVED_BOX") + ")";
                break;
            }
            case 1: {
                string = Resource.getString("MAIL_EDIT") + "(" + Resource.getString("SENT_BOX") + ")";
                break;
            }
            case 2: {
                string = Resource.getString("MAIL_EDIT") + "(" + Resource.getString("UNSENT_BOX") + ")";
                break;
            }
        }
        return string;
    }

    private String getStateString(int n) {
        String string = "";
        if (n == 1) {
            string = Resource.getString("ALREADY_READ_SHORT");
        } else if (n == 0) {
            string = Resource.getString("NOT_READ_YET_SHORT");
        }
        return string;
    }
}

