/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.MakeSourceFile;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.StringDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.ComboBoxUI;

class MakeSourceWindow
extends AbstractWindow {
    private static final int CLASS_TYPE_IAPP = 0;
    private static final int CLASS_TYPE_MAPP = 1;
    private static final int CLASS_TYPE_NOME = 2;
    private static final int FRAME_TYPE_PANEL = 0;
    private static final int FRAME_TYPE_CANVAS = 1;
    private static final int TEXT_WIDTH = 25;
    private static final int TEXT_NUM = 64;
    private static final int COMP_HGAP = 3;
    private static final int COMP_VGAP = 2;
    private static final int SRC_LABEL_WIDTH = 310;
    private JTextField sourceNameField;
    private JLabel sourcePathLabel;
    private JCheckBox templateCheckBox;
    private JCheckBox lSoftKeyChkBox;
    private JCheckBox lKeyChkBox;
    private JCheckBox lComponentChkBox;
    private JCheckBox lMediaChkBox;
    private JCheckBox lTimerChkBox;
    private JCheckBox lMesFolderChkBox;
    private JCheckBox lAudio3DChkBox;
    private JComboBox superClassBox;
    private JComboBox orderFrameBox;
    private static String sourcePath;
    private MakeSourceFile makeSource;
    private static int MAKE_OK;
    private static int MAKE_NG;
    private static int NO_TEMP_FILE;
    private String errString = "";

    MakeSourceWindow(MainWindow mainWindow, String string) {
        super(mainWindow, Resource.getString("SOURCE_WINDOW_TITLE"));
        this.addWindowListener();
        sourcePath = mainWindow.getSourcePath(mainWindow.getProjectName());
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel.setLayout(new BorderLayout(3, 0));
        jPanel2.setLayout(new BorderLayout(3, 0));
        jPanel3.setLayout(new FlowLayout(1));
        String string2 = " ";
        String string3 = "        ";
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        JLabel jLabel = new JLabel(Resource.getString("SOURCE_PATH"));
        JButton jButton = new JButton(Resource.getString("FILE_SELECT"));
        jButton.setMnemonic(82);
        this.sourcePathLabel = new JLabel(sourcePath);
        Dimension dimension = this.sourcePathLabel.getPreferredSize();
        dimension.width = 310;
        this.sourcePathLabel.setPreferredSize(dimension);
        JSeparator jSeparator = new JSeparator(0);
        jPanel4.add(jLabel);
        jPanel4.add(jButton);
        jPanel.add("North", jPanel4);
        jPanel.add("West", new JLabel(string2));
        jPanel.add("Center", this.sourcePathLabel);
        jPanel.add("South", jSeparator);
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JPanel jPanel11 = new JPanel();
        JPanel jPanel12 = new JPanel();
        JPanel jPanel13 = new JPanel();
        JPanel jPanel14 = new JPanel();
        JPanel jPanel15 = new JPanel();
        JPanel jPanel16 = new JPanel();
        JPanel jPanel17 = new JPanel();
        JPanel jPanel18 = new JPanel();
        JPanel jPanel19 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0));
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel7.setLayout(new FlowLayout(0, 3, 2));
        jPanel8.setLayout(new BorderLayout());
        jPanel8.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("KIND_OF_TEMPLATE")));
        jPanel12.setLayout(new BoxLayout(jPanel12, 1));
        jPanel9.setLayout(new BoxLayout(jPanel9, 1));
        jPanel10.setLayout(new BoxLayout(jPanel10, 1));
        jPanel11.setLayout(new BoxLayout(jPanel11, 1));
        jPanel11.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("USE_LISTENER")));
        jPanel13.setLayout(new FlowLayout(0, 3, 2));
        jPanel14.setLayout(new FlowLayout(0, 3, 2));
        jPanel15.setLayout(new FlowLayout(0, 3, 2));
        jPanel16.setLayout(new FlowLayout(0, 3, 2));
        jPanel17.setLayout(new FlowLayout(0, 3, 2));
        jPanel18.setLayout(new FlowLayout(0, 3, 2));
        jPanel19.setLayout(new FlowLayout(0, 3, 2));
        JLabel jLabel2 = new JLabel(Resource.getString("SOURCE_NAME"));
        this.sourceNameField = new JTextField(25);
        this.sourceNameField.setDocument(new StringDocument(64));
        if (string.length() != 0) {
            this.sourceNameField.setText(string + ".java");
        }
        this.templateCheckBox = new JCheckBox(Resource.getString("CREATE_TEMPLATE"));
        JLabel jLabel3 = new JLabel(Resource.getString("TYPE_OF_IAPPLI"));
        jLabel3.setAlignmentX(0.0f);
        this.superClassBox = new JComboBox();
        this.superClassBox.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        this.superClassBox.addItem(Resource.getString("IAPPLICATION"));
        this.superClassBox.addItem(Resource.getString("MAPPLICATION"));
        this.superClassBox.addItem(Resource.getString("EXTENDS_NONE"));
        this.superClassBox.setAlignmentX(0.0f);
        this.superClassBox.setSelectedIndex(0);
        JLabel jLabel4 = new JLabel(Resource.getString("TYPE_OF_FRAME"));
        jLabel4.setAlignmentX(0.0f);
        this.orderFrameBox = new JComboBox();
        this.orderFrameBox.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        this.orderFrameBox.addItem(Resource.getString("FRAME_PANEL"));
        this.orderFrameBox.addItem(Resource.getString("FRAME_CANVAS"));
        this.orderFrameBox.setAlignmentX(0.0f);
        this.orderFrameBox.setSelectedIndex(0);
        this.lSoftKeyChkBox = new JCheckBox(Resource.getString("LISTENER_SOFTKEY"));
        this.lKeyChkBox = new JCheckBox(Resource.getString("LISTENER_KEY"));
        this.lComponentChkBox = new JCheckBox(Resource.getString("LISTENER_COMP"));
        this.lMediaChkBox = new JCheckBox(Resource.getString("LISTENER_MEDIA"));
        this.lTimerChkBox = new JCheckBox(Resource.getString("LISTENER_TIMER"));
        this.lMesFolderChkBox = new JCheckBox(Resource.getString("LISTENER_MESSFOL"));
        this.lAudio3DChkBox = new JCheckBox(Resource.getString("LISTENER_AUDIO3D"));
        jPanel5.add(jLabel2);
        jPanel5.add(this.sourceNameField);
        jPanel7.add(this.templateCheckBox);
        jPanel9.add(jLabel3);
        jPanel9.add(this.superClassBox);
        jPanel10.add(jLabel4);
        jPanel10.add(this.orderFrameBox);
        jPanel12.add(jPanel9);
        jPanel12.add(Box.createRigidArea(new Dimension(3, 4)));
        jPanel12.add(jPanel10);
        jPanel12.add(Box.createRigidArea(new Dimension(3, 4)));
        jPanel8.add("Center", jPanel12);
        jPanel8.add("East", new JLabel(string3));
        jPanel8.add("West", new JLabel(string2));
        jPanel13.add(this.lSoftKeyChkBox);
        jPanel14.add(this.lKeyChkBox);
        jPanel15.add(this.lComponentChkBox);
        jPanel16.add(this.lMediaChkBox);
        jPanel17.add(this.lTimerChkBox);
        jPanel18.add(this.lMesFolderChkBox);
        jPanel19.add(this.lAudio3DChkBox);
        jPanel11.add(jPanel13);
        jPanel11.add(jPanel14);
        jPanel11.add(jPanel15);
        jPanel11.add(jPanel16);
        jPanel11.add(jPanel17);
        jPanel11.add(jPanel18);
        jPanel11.add(jPanel19);
        jPanel6.add(jPanel7);
        jPanel6.add(jPanel8);
        jPanel6.add(Box.createRigidArea(new Dimension(3, 4)));
        jPanel6.add(jPanel11);
        jPanel6.add(Box.createRigidArea(new Dimension(3, 4)));
        jPanel2.add("North", jPanel5);
        jPanel2.add("West", new JLabel(string3));
        jPanel2.add("Center", jPanel6);
        jPanel2.add("East", new JLabel(string3));
        JButton jButton2 = new JButton(Resource.getString("MAKE"));
        JButton jButton3 = new JButton(Resource.getString("CANCEL"));
        jPanel3.add(jButton2);
        jPanel3.add(jButton3);
        container.add("North", jPanel);
        container.add("Center", jPanel2);
        container.add("South", jPanel3);
        jButton.setActionCommand("select");
        jButton2.setActionCommand("make");
        jButton3.setActionCommand("cancel");
        this.orderFrameBox.setActionCommand("changeFrameType");
        this.templateCheckBox.setActionCommand("useChange");
        this.sourceNameField.setActionCommand("make");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jButton3.addActionListener(actionDispatcher);
        this.orderFrameBox.addActionListener(actionDispatcher);
        this.templateCheckBox.addActionListener(actionDispatcher);
        this.sourceNameField.addActionListener(actionDispatcher);
        this.templateCheckBox.setSelected(true);
        this.setResizable(false);
        this.pack();
        this.sourceNameField.requestFocus();
    }

    void make() {
        String string;
        String string2 = string = this.sourceNameField.getText().trim();
        if (string.length() == 0) {
            this.parent.showDialog(Resource.format("EMP_VAL_WNG", Resource.getString("SOURCE_NAME")), this, 2);
            return;
        }
        if (!string.toLowerCase().endsWith(".java")) {
            string = string + ".java";
        } else {
            string2 = string2.substring(0, string2.length() - 5);
        }
        String string3 = sourcePath + File.separator + string;
        File file = new File(string3);
        if (file.exists()) {
            this.parent.showDialog(Resource.format("SOURCE_EXISTS_WNG", string), this, 2);
            return;
        }
        if (this.templateCheckBox.isSelected()) {
            int n = this.makeTemplate(file, string2);
            if (n != MAKE_OK) {
                if (file.exists()) {
                    file.delete();
                }
                if (n == NO_TEMP_FILE) {
                    this.parent.showDialog(Resource.format("NOT_FOUND_TEP_WNG", this.errString), this, 2);
                } else {
                    this.parent.showDialog(Resource.format("CANNOT_SOURCE_WNG", file.getPath()), this, 2);
                }
                return;
            }
        } else {
            this.createEmptyFile(file);
        }
        this.parent.closeWindow(this);
        this.openFile(file);
    }

    private void createEmptyFile(File file) {
        try {
            file.createNewFile();
        }
        catch (Exception exception) {
            this.parent.showDialog(Resource.format("CANNOT_SOURCE_WNG", file.getPath()), this, 2);
        }
    }

    private void openFile(File file) {
        if (!file.exists()) {
            return;
        }
        String[] stringArray = new String[]{this.parent.getEditor(), file.getPath()};
        Runtime runtime = Runtime.getRuntime();
        try {
            runtime.exec(stringArray);
        }
        catch (Exception exception) {
            System.out.println(Resource.format("MAKE_FILE", file.getPath()));
            this.parent.showDialog(Resource.getString("NOT_EXEC_WNG"), this, 2);
        }
    }

    void select() {
        JFileChooser jFileChooser = new JFileChooser(sourcePath);
        jFileChooser.setDialogTitle(Resource.getString("SOURCE_MAKE_DIALOG"));
        jFileChooser.setDialogType(2);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            sourcePath = jFileChooser.getSelectedFile().getAbsolutePath();
            this.sourcePathLabel.setText(sourcePath);
        }
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    void changeFrameType() {
        int n = this.orderFrameBox.getSelectedIndex();
        Component[] componentArray = new Component[]{this.lSoftKeyChkBox, this.lKeyChkBox, this.lComponentChkBox};
        if (n == 0) {
            this.setEnabledComp(componentArray, true);
        } else {
            this.setEnabledComp(componentArray, false);
        }
    }

    void useChange() {
        boolean bl = this.templateCheckBox.isSelected();
        Component[] componentArray = new Component[]{this.superClassBox, this.orderFrameBox, this.lSoftKeyChkBox, this.lKeyChkBox, this.lComponentChkBox, this.lMediaChkBox, this.lTimerChkBox, this.lMesFolderChkBox, this.lAudio3DChkBox};
        if (bl) {
            this.setEnabledComp(componentArray, true);
            this.changeFrameType();
        } else {
            this.setEnabledComp(componentArray, false);
        }
    }

    private void setEnabledComp(Component[] componentArray, boolean bl) {
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(bl);
        }
    }

    private int makeTemplate(File file, String string) {
        int n = this.superClassBox.getSelectedIndex();
        int n2 = this.orderFrameBox.getSelectedIndex();
        try {
            File file2 = null;
            file2 = n == 0 ? (n2 == 0 ? new File(MakeSourceFile.IAPP_PANEL) : new File(MakeSourceFile.IAPP_CANVAS)) : (n == 1 ? (n2 == 0 ? new File(MakeSourceFile.MAPP_PANEL) : new File(MakeSourceFile.MAPP_CANVAS)) : (n2 == 0 ? new File(MakeSourceFile.NONE_PANEL) : new File(MakeSourceFile.NONE_CANVAS)));
            if (!file2.exists()) {
                this.errString = file2.getPath();
                return NO_TEMP_FILE;
            }
            int n3 = n2 == 1 ? 2 : 1;
            this.makeSource = new MakeSourceFile(string, file2, file, n3);
            if (this.lSoftKeyChkBox.isSelected() && this.lSoftKeyChkBox.isEnabled()) {
                this.makeSource.setUseListener(0, true);
            }
            if (this.lKeyChkBox.isSelected() && this.lKeyChkBox.isEnabled()) {
                this.makeSource.setUseListener(1, true);
            }
            if (this.lComponentChkBox.isSelected() && this.lComponentChkBox.isEnabled()) {
                this.makeSource.setUseListener(2, true);
            }
            if (this.lMediaChkBox.isSelected() && this.lMediaChkBox.isEnabled()) {
                this.makeSource.setUseListener(3, true);
            }
            if (this.lTimerChkBox.isSelected() && this.lTimerChkBox.isEnabled()) {
                this.makeSource.setUseListener(4, true);
            }
            if (this.lMesFolderChkBox.isSelected() && this.lMesFolderChkBox.isEnabled()) {
                this.makeSource.setUseListener(5, true);
            }
            if (this.lAudio3DChkBox.isSelected() && this.lAudio3DChkBox.isEnabled()) {
                this.makeSource.setUseListener(6, true);
            }
            this.makeSource.makeFile();
        }
        catch (Exception exception) {
            return MAKE_NG;
        }
        return MAKE_OK;
    }

    static {
        MAKE_OK = 0;
        MAKE_NG = -1;
        NO_TEMP_FILE = -2;
    }
}

