/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.PedometerEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

class PedometerData {
    public static final String PATH = ".ped";
    private File PEDOM_BASE_DIR = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "pedom");
    private PedometerEntry[] pEntry = null;

    public PedometerEntry[] loadMasterEntry() throws Exception {
        int n;
        if (!this.PEDOM_BASE_DIR.exists()) {
            this.pEntry = null;
            return null;
        }
        String[] stringArray = this.PEDOM_BASE_DIR.list();
        int n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].endsWith(PATH)) continue;
            ++n2;
        }
        this.pEntry = new PedometerEntry[n2];
        n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].endsWith(PATH)) continue;
            this.pEntry[n2] = this.loadEntryData(stringArray[n]);
            ++n2;
        }
        Arrays.sort(this.pEntry, new DataComparator());
        return this.pEntry;
    }

    public void setEntryData(PedometerEntry pedometerEntry) throws Exception {
        if (pedometerEntry == null) {
            return;
        }
        File file = new File(this.PEDOM_BASE_DIR.getPath() + File.separator + pedometerEntry.getFileName());
        if (file.exists()) {
            file.delete();
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("aerobicsTime", pedometerEntry.getAerobicsTime());
        hashtable.put("amountOfCombustionFat", pedometerEntry.getAmountOfCombustionFat());
        hashtable.put("consumptionCalorie", pedometerEntry.getConsumptionCalorie());
        hashtable.put("date", pedometerEntry.getDate());
        hashtable.put("distance", pedometerEntry.getDistance());
        hashtable.put("numberOfAerobicsSteps", pedometerEntry.getNumberOfAerobicsSteps());
        hashtable.put("numberOfSteps", pedometerEntry.getNumberOfSteps());
        boolean bl = this.save(hashtable, file);
        if (!bl) {
            file.delete();
            throw new Exception();
        }
    }

    public void delete(String string) {
        File file = new File(this.PEDOM_BASE_DIR.getPath() + File.separator + string);
        if (file.exists()) {
            file.delete();
        }
    }

    public boolean checkDate(Date date) {
        boolean bl = false;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        String string = simpleDateFormat.format(date);
        if (this.pEntry != null) {
            for (int i = 0; i < this.pEntry.length; ++i) {
                if (!string.equals(this.pEntry[i].getDate())) continue;
                bl = true;
            }
        }
        return bl;
    }

    public boolean checkExists(String string) {
        File file = new File(this.PEDOM_BASE_DIR.getPath() + File.separator + string);
        return file.exists();
    }

    private PedometerEntry loadEntryData(String string) throws Exception {
        File file = new File(this.PEDOM_BASE_DIR.getPath() + File.separator + string);
        PedometerEntry pedometerEntry = new PedometerEntry();
        Hashtable hashtable = new Hashtable();
        boolean bl = this.load(hashtable, file);
        if (!bl) {
            System.out.println("load--error");
            return null;
        }
        pedometerEntry.setFileName(string);
        pedometerEntry.setDate((String)hashtable.get("date"));
        pedometerEntry.setAerobicsTime((String)hashtable.get("aerobicsTime"));
        pedometerEntry.setAmountOfCombustionFat((String)hashtable.get("amountOfCombustionFat"));
        pedometerEntry.setDistance((String)hashtable.get("distance"));
        pedometerEntry.setNumberOfAerobicsSteps((String)hashtable.get("numberOfAerobicsSteps"));
        pedometerEntry.setNumberOfSteps((String)hashtable.get("numberOfSteps"));
        pedometerEntry.setConsumptionCalorie((String)hashtable.get("consumptionCalorie"));
        return pedometerEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean load(Hashtable hashtable, File file) {
        boolean bl = true;
        BufferedReader bufferedReader = null;
        InputStreamReader inputStreamReader = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            String string = null;
            int n = 0;
            String string2 = null;
            String string3 = null;
            while ((string = bufferedReader.readLine()) != null) {
                n = string.indexOf("=");
                if (n <= 0) continue;
                string2 = string.substring(0, n).trim();
                string3 = string.substring(n + 1).trim();
                if (string2.length() <= 0) continue;
                hashtable.put(string2, string3);
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean save(Hashtable hashtable, File file) {
        boolean bl = true;
        PrintStream printStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            printStream = new PrintStream(fileOutputStream);
            String string = null;
            String string2 = null;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                string2 = (String)hashtable.get(string);
                printStream.println(string + "=" + string2);
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            try {
                if (printStream != null) {
                    printStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    class DataComparator
    implements Comparator {
        DataComparator() {
        }

        public int compare(Object object, Object object2) {
            Date date;
            Date date2;
            if (!(object instanceof PedometerEntry) || !(object2 instanceof PedometerEntry)) {
                return 0;
            }
            PedometerEntry pedometerEntry = (PedometerEntry)object;
            PedometerEntry pedometerEntry2 = (PedometerEntry)object2;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
            try {
                date2 = simpleDateFormat.parse(pedometerEntry.getDate());
                date = simpleDateFormat.parse(pedometerEntry2.getDate());
            }
            catch (ParseException parseException) {
                return 0;
            }
            return date2.compareTo(date);
        }
    }
}

