/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.PedometerData;
import com.nttdocomo.dojaemu.ktoolbar.PedometerEntry;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class PedometerEditWindow
extends AbstractWindow {
    private PedometerEntry entry = null;
    private JTextField txtDateYear;
    private JTextField txtDateMonth;
    private JTextField txtDateDay;
    private JTextField txtSteps;
    private JTextField txtDistance;
    private JTextField txtAeroSteps;
    private JTextField txtAeroTime;
    private JTextField txtFat;
    private JTextField txtCalorie;
    private JButton setButton;
    private JButton cancelButton;
    private PedometerData masData;

    PedometerEditWindow(MainWindow mainWindow, PedometerEntry pedometerEntry, PedometerData pedometerData, boolean bl) {
        super(mainWindow, Resource.getString("PEDO_EDIT_WINDOW_TITLE"));
        this.parent = mainWindow;
        this.addWindowListener();
        this.entry = pedometerEntry;
        this.masData = pedometerData;
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        JPanel jPanel8 = new JPanel(new FlowLayout(0));
        JPanel jPanel9 = new JPanel(new FlowLayout(0));
        JPanel jPanel10 = new JPanel(new FlowLayout(0));
        JPanel jPanel11 = new JPanel(new FlowLayout(0));
        JPanel jPanel12 = new JPanel(new FlowLayout(0));
        JPanel jPanel13 = new JPanel(new FlowLayout(0));
        JPanel jPanel14 = new JPanel(new FlowLayout(0));
        JPanel jPanel15 = new JPanel(new GridLayout(7, 1));
        JPanel jPanel16 = new JPanel(new GridLayout(7, 1));
        JPanel jPanel17 = new JPanel();
        JPanel jPanel18 = new JPanel();
        JLabel jLabel = new JLabel(Resource.getString("PEDOMETER_LBL_DATE"));
        JLabel jLabel2 = new JLabel(Resource.getString("PEDOMETER_LBL_STEPS"));
        JLabel jLabel3 = new JLabel(Resource.getString("PEDOMETER_LBL_DISTANCE"));
        JLabel jLabel4 = new JLabel(Resource.getString("PEDOMETER_LBL_AERO_STEPS"));
        JLabel jLabel5 = new JLabel(Resource.getString("PEDOMETER_LBL_AERO_TIME"));
        JLabel jLabel6 = new JLabel(Resource.getString("PEDOMETER_LBL_FAT"));
        JLabel jLabel7 = new JLabel(Resource.getString("PEDOMETER_LBL_CALORIE"));
        JLabel jLabel8 = new JLabel(Resource.getString("YEAR"));
        JLabel jLabel9 = new JLabel(Resource.getString("MONTH"));
        JLabel jLabel10 = new JLabel(Resource.getString("DAY"));
        JLabel jLabel11 = new JLabel(Resource.getString("PEDOMETER_LBL_DIS_UNIT"));
        JLabel jLabel12 = new JLabel(Resource.getString("PEDOMETER_LBL_TIME_UNIT"));
        JLabel jLabel13 = new JLabel(Resource.getString("PEDOMETER_LBL_FAT_UNIT"));
        JLabel jLabel14 = new JLabel(Resource.getString("PEDOMETER_LBL_CAL_UNIT"));
        this.txtDateYear = new JTextField(6);
        this.txtDateMonth = new JTextField(4);
        this.txtDateDay = new JTextField(4);
        this.txtSteps = new JTextField(12);
        this.txtDistance = new JTextField(12);
        this.txtAeroSteps = new JTextField(12);
        this.txtAeroTime = new JTextField(12);
        this.txtFat = new JTextField(12);
        this.txtCalorie = new JTextField(12);
        this.txtDateYear.setDocument(new HalfNumberDocument(4));
        this.txtDateMonth.setDocument(new HalfNumberDocument(2));
        this.txtDateDay.setDocument(new HalfNumberDocument(2));
        this.txtSteps.setDocument(new HalfNumberDocument(10));
        this.txtDistance.setDocument(new HalfNumberDocument(10));
        this.txtAeroSteps.setDocument(new HalfNumberDocument(10));
        this.txtAeroTime.setDocument(new HalfNumberDocument(10));
        this.txtFat.setDocument(new HalfNumberDocument(10));
        this.txtCalorie.setDocument(new HalfNumberDocument(10));
        this.txtDateYear.setHorizontalAlignment(2);
        this.txtDateMonth.setHorizontalAlignment(2);
        this.txtDateDay.setHorizontalAlignment(2);
        this.txtSteps.setHorizontalAlignment(2);
        this.txtDistance.setHorizontalAlignment(2);
        this.txtAeroSteps.setHorizontalAlignment(2);
        this.txtAeroTime.setHorizontalAlignment(2);
        this.txtFat.setHorizontalAlignment(2);
        this.txtCalorie.setHorizontalAlignment(2);
        this.setButton = new JButton(Resource.getString("SET"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        this.setEntryText();
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        jPanel17.setLayout(new BoxLayout(jPanel17, 0));
        jPanel.add(jLabel);
        jPanel2.add(jLabel2);
        jPanel3.add(jLabel3);
        jPanel4.add(jLabel4);
        jPanel5.add(jLabel5);
        jPanel6.add(jLabel6);
        jPanel7.add(jLabel7);
        jPanel8.add(this.txtDateYear);
        jPanel8.add(jLabel8);
        jPanel8.add(this.txtDateMonth);
        jPanel8.add(jLabel9);
        jPanel8.add(this.txtDateDay);
        jPanel8.add(jLabel10);
        jPanel9.add(this.txtSteps);
        jPanel10.add(this.txtDistance);
        jPanel10.add(jLabel11);
        jPanel11.add(this.txtAeroSteps);
        jPanel12.add(this.txtAeroTime);
        jPanel12.add(jLabel12);
        jPanel13.add(this.txtFat);
        jPanel13.add(jLabel13);
        jPanel14.add(this.txtCalorie);
        jPanel14.add(jLabel14);
        jPanel15.add(jPanel);
        jPanel15.add(jPanel2);
        jPanel15.add(jPanel3);
        jPanel15.add(jPanel4);
        jPanel15.add(jPanel5);
        jPanel15.add(jPanel6);
        jPanel15.add(jPanel7);
        jPanel16.add(jPanel8);
        jPanel16.add(jPanel9);
        jPanel16.add(jPanel10);
        jPanel16.add(jPanel11);
        jPanel16.add(jPanel12);
        jPanel16.add(jPanel13);
        jPanel16.add(jPanel14);
        jPanel17.add(jPanel15);
        jPanel17.add(jPanel16);
        jPanel18.add(this.setButton);
        jPanel18.add(this.cancelButton);
        container.add(jPanel17);
        container.add(jPanel18);
        this.setButton.setActionCommand("set");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.setButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.pack();
        this.setResizable(false);
    }

    private void setEntryText() {
        String string = this.entry.getDate();
        String[] stringArray = string.split("/");
        if (stringArray.length != 3) {
            return;
        }
        this.txtDateYear.setText(stringArray[0]);
        this.txtDateMonth.setText(stringArray[1]);
        this.txtDateDay.setText(stringArray[2]);
        this.txtSteps.setText(this.entry.getNumberOfSteps());
        this.txtDistance.setText(this.entry.getDistance());
        this.txtAeroSteps.setText(this.entry.getNumberOfAerobicsSteps());
        this.txtAeroTime.setText(this.entry.getAerobicsTime());
        this.txtFat.setText(this.entry.getAmountOfCombustionFat());
        this.txtCalorie.setText(this.entry.getConsumptionCalorie());
    }

    void set() {
        if (!this.inputCheaker()) {
            return;
        }
        try {
            this.masData.setEntryData(this.entry);
        }
        catch (Exception exception) {
            this.parent.showDialog(Resource.format("WRITE_ERR", this.entry.getFileName()), this, 2);
        }
        this.setVisible(false);
        this.dispose();
    }

    void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private boolean inputCheaker() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        String string = this.txtDateYear.getText();
        String string2 = this.txtDateMonth.getText();
        String string3 = this.txtDateDay.getText();
        String string4 = this.txtDistance.getText();
        String string5 = this.txtSteps.getText();
        String string6 = this.txtAeroSteps.getText();
        String string7 = this.txtAeroTime.getText();
        String string8 = this.txtFat.getText();
        String string9 = this.txtCalorie.getText();
        if (string.equals("") || string2.equals("") || string3.equals("")) {
            this.parent.showDialog(Resource.format("INPUT_EMPTY_ERR", Resource.getString("PEDOMETER_LBL_DATE")), this, 2);
            return false;
        }
        if (string4.equals("")) {
            this.parent.showDialog(Resource.format("INPUT_EMPTY_ERR", Resource.getString("PEDOMETER_LBL_DISTANCE")), this, 2);
            return false;
        }
        if (string5.equals("")) {
            this.parent.showDialog(Resource.format("INPUT_EMPTY_ERR", Resource.getString("PEDOMETER_LBL_STEPS")), this, 2);
            return false;
        }
        if (string6.equals("")) {
            this.parent.showDialog(Resource.format("INPUT_EMPTY_ERR", Resource.getString("PEDOMETER_LBL_AERO_STEPS")), this, 2);
            return false;
        }
        if (string7.equals("")) {
            this.parent.showDialog(Resource.format("INPUT_EMPTY_ERR", Resource.getString("PEDOMETER_LBL_AERO_TIME")), this, 2);
            return false;
        }
        if (string8.equals("")) {
            this.parent.showDialog(Resource.format("INPUT_EMPTY_ERR", Resource.getString("PEDOMETER_LBL_FAT")), this, 2);
            return false;
        }
        if (string9.equals("")) {
            this.parent.showDialog(Resource.format("INPUT_EMPTY_ERR", Resource.getString("PEDOMETER_LBL_CALORIE")), this, 2);
            return false;
        }
        Date date = null;
        try {
            date = this.parse(string, string2, string3);
        }
        catch (Exception exception) {
            this.parent.showDialog(Resource.getString("PEDOMETER_DATE_INVALID_FORMAT"), this, 2);
            return false;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        String string10 = simpleDateFormat.format(date);
        simpleDateFormat.applyPattern("yyyyMMdd");
        String string11 = simpleDateFormat.format(date) + ".ped";
        if (!string10.equals(this.entry.getDate()) && this.masData.checkDate(date)) {
            this.parent.showDialog(Resource.getString("PEDOMETER_DATE_DUPLICATION"), this, 2);
            return false;
        }
        int n7 = 0;
        try {
            n = Integer.parseInt(string5);
            ++n7;
            n2 = Integer.parseInt(string4);
            ++n7;
            n3 = Integer.parseInt(string6);
            ++n7;
            n4 = Integer.parseInt(string7);
            ++n7;
            n5 = Integer.parseInt(string8);
            ++n7;
            n6 = Integer.parseInt(string9);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{Resource.getString("PEDOMETER_LBL_STEPS"), Resource.getString("PEDOMETER_LBL_DISTANCE"), Resource.getString("PEDOMETER_LBL_AERO_STEPS"), Resource.getString("PEDOMETER_LBL_AERO_TIME"), Resource.getString("PEDOMETER_LBL_FAT"), Resource.getString("PEDOMETER_LBL_CALORIE")};
            this.parent.showDialog(Resource.format("PEDOMETER_VAL_OUTSIDE_WNG", stringArray[n7]), this, 2);
            return false;
        }
        if (!this.entry.getFileName().equals("")) {
            this.masData.delete(this.entry.getFileName());
        }
        this.entry.setFileName(string11);
        this.entry.setDate(string10);
        this.entry.setNumberOfSteps(Integer.toString(n));
        this.entry.setDistance(Integer.toString(n2));
        this.entry.setNumberOfAerobicsSteps(Integer.toString(n3));
        this.entry.setAerobicsTime(Integer.toString(n4));
        this.entry.setAmountOfCombustionFat(Integer.toString(n5));
        this.entry.setConsumptionCalorie(Integer.toString(n6));
        return true;
    }

    private Date parse(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = Integer.parseInt(string);
            n2 = Integer.parseInt(string2);
            n3 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n < 1 || n > 9999) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n3 < 1 || n3 > 31) {
            throw new IllegalArgumentException("Illegal params.");
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, n);
        gregorianCalendar.set(2, n2 - 1);
        if (n3 > gregorianCalendar.getActualMaximum(5)) {
            throw new IllegalArgumentException("Illegal params.");
        }
        gregorianCalendar.set(5, n3);
        return gregorianCalendar.getTime();
    }
}

