/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class PedometerSettingsEditWindow
extends AbstractWindow {
    private static final File pedometerSettingsPath = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "pedom" + File.separator + "PedometerSettings.dat");
    private static final File pedometerSettingsRangePath = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "pedom" + File.separator + "PedometerSettingsRange.properties");
    private int height = 0;
    private int weight = 0;
    private String PROP_KEY_HEIGHT_MIN = "heightMin";
    private String PROP_KEY_HEIGHT_MAX = "heightMax";
    private String PROP_KEY_WEIGHT_MIN = "weightMin";
    private String PROP_KEY_WEIGHT_MAX = "weightMax";
    private JTextField txtHeight = null;
    private JTextField txtWeight = null;
    private JButton setButton;
    private JButton cancelButton;

    PedometerSettingsEditWindow(MainWindow mainWindow, int n, int n2) {
        super(mainWindow, Resource.getString("PEDO_SETTING_EDIT_WINDOW_TITLE"));
        this.parent = mainWindow;
        this.addWindowListener();
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.setPreferredSize(new Dimension(165, 40));
        JPanel jPanel5 = new JPanel(new GridLayout(2, 1));
        JPanel jPanel6 = new JPanel(new GridLayout(2, 1));
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        jPanel8.setPreferredSize(new Dimension(165, 35));
        JLabel jLabel = new JLabel(Resource.getString("PEDOMETER_LBL_HEIGHT"));
        JLabel jLabel2 = new JLabel(Resource.getString("PEDOMETER_LBL_WEIGHT"));
        JLabel jLabel3 = new JLabel(Resource.getString("PEDOMETER_LBL_HEIGHT_UNIT"));
        JLabel jLabel4 = new JLabel(Resource.getString("PEDOMETER_LBL_WEIGHT_UNIT"));
        this.txtHeight = new JTextField(12);
        this.txtWeight = new JTextField(12);
        this.txtHeight.setDocument(new HalfNumberDocument(10));
        this.txtWeight.setDocument(new HalfNumberDocument(10));
        this.setButton = new JButton(Resource.getString("SET"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        this.setEntryText(n, n2);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        jPanel.add(jLabel);
        jPanel2.add(jLabel2);
        jPanel3.add(this.txtHeight);
        jPanel3.add(jLabel3);
        jPanel4.add(this.txtWeight);
        jPanel4.add(jLabel4);
        jPanel5.add(jPanel);
        jPanel5.add(jPanel2);
        jPanel6.add(jPanel3);
        jPanel6.add(jPanel4);
        jPanel7.add(jPanel5);
        jPanel7.add(jPanel6);
        jPanel8.add(this.setButton);
        jPanel8.add(this.cancelButton);
        container.add(jPanel7);
        container.add(jPanel8);
        this.setButton.setActionCommand("set");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.setButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.setSize(250, 150);
        this.setResizable(false);
    }

    private void setEntryText(int n, int n2) {
        String string = String.valueOf(n);
        String string2 = String.valueOf(n2);
        this.txtHeight.setText(string);
        this.txtWeight.setText(string2);
    }

    public boolean set() {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        long l5 = 0L;
        long l6 = 0L;
        String string5 = this.txtHeight.getText();
        String string6 = this.txtWeight.getText();
        if (string5 == null || string5.equals("")) {
            this.parent.showDialog(Resource.getString("PEDOMETER_NO_EDIT_WNG"), this.parent, 2);
            return false;
        }
        if (string6 == null || string6.equals("")) {
            this.parent.showDialog(Resource.getString("PEDOMETER_NO_EDIT_WNG"), this.parent, 2);
            return false;
        }
        l5 = Long.parseLong(string5);
        l6 = Long.parseLong(string6);
        Hashtable hashtable = new Hashtable();
        boolean bl = this.load(hashtable);
        if (!bl) {
            this.parent.showDialog(Resource.format("READ_ERR", Resource.getString("PEDO_DWFINITION_FILE")), this.parent, 2);
            return false;
        }
        string = (String)hashtable.get(this.PROP_KEY_HEIGHT_MIN);
        string2 = (String)hashtable.get(this.PROP_KEY_HEIGHT_MAX);
        string3 = (String)hashtable.get(this.PROP_KEY_WEIGHT_MIN);
        string4 = (String)hashtable.get(this.PROP_KEY_WEIGHT_MAX);
        l = Long.parseLong(string);
        l2 = Long.parseLong(string2);
        l3 = Long.parseLong(string3);
        l4 = Long.parseLong(string4);
        Object[] objectArray = new String[]{string, string2};
        Object[] objectArray2 = new String[]{string3, string4};
        if (l5 < l || l5 > l2) {
            this.parent.showDialog(Resource.format("PEDOMETER_WNG_HEIGHT_EDIT", objectArray), this.parent, 2);
            return false;
        }
        if (l6 < l3 || l6 > l4) {
            this.parent.showDialog(Resource.format("PEDOMETER_WNG_WEIGHT_EDIT", objectArray2), this.parent, 2);
            return false;
        }
        if (!this.save(l5, l6)) {
            this.parent.showDialog(Resource.format("WRITE_ERR", Resource.getString("PEDO_DWFINITION_FILE")), this.parent, 2);
            return false;
        }
        this.setVisible(false);
        this.dispose();
        return true;
    }

    void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean load(Hashtable hashtable) {
        boolean bl = true;
        BufferedReader bufferedReader = null;
        String string = null;
        int n = 0;
        String string2 = null;
        String string3 = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(pedometerSettingsRangePath)));
            if (pedometerSettingsRangePath.exists()) {
                while ((string = bufferedReader.readLine()) != null) {
                    n = string.indexOf("=");
                    if (n <= 0) continue;
                    string2 = string.substring(0, n).trim();
                    string3 = string.substring(n + 1).trim();
                    if (string2.length() <= 0) continue;
                    hashtable.put(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    private boolean save(long l, long l2) {
        boolean bl = false;
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(pedometerSettingsPath)));
            bufferedWriter.write(String.valueOf(l) + "\n");
            bufferedWriter.write(String.valueOf(l2) + "\n");
            bufferedWriter.close();
        }
        catch (Exception exception) {
            return bl;
        }
        bl = true;
        return bl;
    }
}

