/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.ImportException;
import com.nttdocomo.dojaemu.ktoolbar.PedometerData;
import com.nttdocomo.dojaemu.ktoolbar.PedometerEditWindow;
import com.nttdocomo.dojaemu.ktoolbar.PedometerEntry;
import com.nttdocomo.dojaemu.ktoolbar.PedometerSettingsEditWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class PedometerWindow
extends TabPanel {
    private static final String pedometerSettingsPath = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "pedom" + File.separator + "PedometerSettings.dat";
    private static Vector pedomRates = new Vector();
    private JTable pedometerTable;
    private JScrollPane scrollpane;
    private JPanel northPanel;
    private JPanel southPanel;
    private int height = 0;
    private int weight = 0;
    private int attrHeightMin = 0;
    private int attrHeightMax = 0;
    private int attrWeightMin = 0;
    private int attrWeightMax = 0;
    private PedometerEntry[] entry = null;
    private PedometerData data = null;
    private JLabel lblHeight = null;
    private JLabel lblWeight = null;
    private JButton settingButton;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;
    private final int ENABLED_WIDTH = 100;

    PedometerWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.makePedometerWindow();
    }

    private void makePedometerWindow() {
        this.setLayout(new BorderLayout());
        this.northPanel = new JPanel();
        this.southPanel = new JPanel();
        JLabel jLabel = new JLabel(Resource.getString("PEDOMETER_LBL_HEIGHT"));
        JLabel jLabel2 = new JLabel(Resource.getString("PEDOMETER_LBL_HEIGHT_UNIT"));
        JLabel jLabel3 = new JLabel(Resource.getString("PEDOMETER_LBL_WEIGHT"));
        JLabel jLabel4 = new JLabel(Resource.getString("PEDOMETER_LBL_WEIGHT_UNIT"));
        this.load();
        this.lblHeight = this.height == 0 ? new JLabel("") : new JLabel(String.valueOf(this.height));
        this.lblWeight = this.weight == 0 ? new JLabel("") : new JLabel(String.valueOf(this.weight));
        this.settingButton = new JButton(Resource.getString("PEDO_SETTING_EDIT"));
        this.addButton = new JButton(Resource.getString("ADD"));
        this.editButton = new JButton(Resource.getString("EDIT"));
        this.deleteButton = new JButton(Resource.getString("DELETE"));
        this.settingButton.setActionCommand("settingEdit");
        this.addButton.setActionCommand("add");
        this.editButton.setActionCommand("edit");
        this.deleteButton.setActionCommand("delete");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.settingButton.addActionListener(actionDispatcher);
        this.addButton.addActionListener(actionDispatcher);
        this.editButton.addActionListener(actionDispatcher);
        this.deleteButton.addActionListener(actionDispatcher);
        this.northPanel.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("PEDOMETER_LBL_SETTING_INFO")));
        this.northPanel.setLayout(new GridLayout(1, 12));
        this.northPanel.add(new JLabel(""));
        this.northPanel.add(new JLabel(""));
        this.northPanel.add(jLabel);
        this.northPanel.add(this.lblHeight);
        this.northPanel.add(jLabel2);
        this.northPanel.add(new JLabel(""));
        this.northPanel.add(jLabel3);
        this.northPanel.add(this.lblWeight);
        this.northPanel.add(jLabel4);
        this.northPanel.add(new JLabel(""));
        this.northPanel.add(this.settingButton);
        this.northPanel.add(new JLabel(""));
        this.southPanel.add(this.addButton);
        this.southPanel.add(this.editButton);
        this.southPanel.add(this.deleteButton);
        this.pedometerTable = this.createPedometerTable();
        this.scrollpane = new JScrollPane(this.pedometerTable);
        this.add("North", this.northPanel);
        this.add("Center", this.scrollpane);
        this.add("South", this.southPanel);
    }

    private JTable createPedometerTable() {
        JTable jTable = null;
        pedomEmuTableModel pedomEmuTableModel2 = null;
        String[] stringArray = new String[]{Resource.getString("PEDOMETER_LBL_DATE"), Resource.getString("PEDOMETER_LBL_STEPS"), Resource.getString("PEDOMETER_LBL_DISTANCE"), Resource.getString("PEDOMETER_LBL_FAT"), Resource.getString("PEDOMETER_LBL_CALORIE")};
        pedomEmuTableModel2 = new pedomEmuTableModel(stringArray, 0);
        this.data = new PedometerData();
        this.entry = null;
        try {
            this.entry = this.data.loadMasterEntry();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.entry != null) {
            for (int i = 0; i < this.entry.length; ++i) {
                Vector<String> vector = new Vector<String>();
                vector.addElement(this.entry[i].getDate());
                vector.addElement(this.entry[i].getNumberOfSteps());
                vector.addElement(this.entry[i].getDistance());
                vector.addElement(this.entry[i].getAmountOfCombustionFat());
                vector.addElement(this.entry[i].getConsumptionCalorie());
                pedomEmuTableModel2.addRow(vector);
            }
        }
        jTable = new JTable(pedomEmuTableModel2);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(100);
        tableColumn.setPreferredWidth(100);
        jTable.setDefaultRenderer(Object.class, new pedomEmuTableCellRenderer());
        jTable.setSelectionMode(0);
        this.changeButtonEnabled();
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    PedometerWindow.this.edit();
                }
            }
        });
        jTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    PedometerWindow.this.edit();
                }
            }
        });
        return jTable;
    }

    private void load() {
        this.height = 0;
        this.weight = 0;
        BufferedReader bufferedReader = null;
        try {
            File file = new File(pedometerSettingsPath);
            if (file.exists()) {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(pedometerSettingsPath)));
                String string = null;
                for (int i = 0; i != 2; ++i) {
                    string = bufferedReader.readLine();
                    if (i == 0) {
                        if (string.equals("") || string.length() == 0) {
                            this.height = 0;
                            continue;
                        }
                        this.height = Integer.parseInt(string);
                        continue;
                    }
                    if (i != 1) continue;
                    this.weight = string.equals("") || string.length() == 0 ? 0 : Integer.parseInt(string);
                }
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void settingEdit() {
        PedometerSettingsEditWindow pedometerSettingsEditWindow = new PedometerSettingsEditWindow(this.parent, this.height, this.weight);
        pedometerSettingsEditWindow.setLocation(this.parent.getShowLocation(pedometerSettingsEditWindow.getWidth(), pedometerSettingsEditWindow.getHeight(), this.tabwin));
        pedometerSettingsEditWindow.setVisible(true);
        this.setVisible(false);
        this.remove(this.northPanel);
        this.remove(this.scrollpane);
        this.remove(this.southPanel);
        this.makePedometerWindow();
        this.setVisible(true);
    }

    void add() {
        PedometerEntry pedometerEntry = new PedometerEntry();
        PedometerEditWindow pedometerEditWindow = new PedometerEditWindow(this.parent, pedometerEntry, this.data, true);
        pedometerEditWindow.setLocation(this.parent.getShowLocation(pedometerEditWindow.getWidth(), pedometerEditWindow.getHeight(), this.tabwin));
        pedometerEditWindow.setVisible(true);
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.pedometerTable = null;
        this.pedometerTable = this.createPedometerTable();
        this.scrollpane = new JScrollPane(this.pedometerTable);
        this.add("Center", this.scrollpane);
        this.setVisible(true);
    }

    void edit() {
        if (this.pedometerTable.getSelectedRowCount() == 1) {
            int n = this.pedometerTable.getSelectedRow();
            PedometerEntry pedometerEntry = this.entry[n];
            PedometerEditWindow pedometerEditWindow = new PedometerEditWindow(this.parent, pedometerEntry, this.data, true);
            pedometerEditWindow.setLocation(this.parent.getShowLocation(pedometerEditWindow.getWidth(), pedometerEditWindow.getHeight(), this.tabwin));
            pedometerEditWindow.setVisible(true);
            this.setVisible(false);
            this.remove(this.scrollpane);
            this.scrollpane = null;
            this.pedometerTable = null;
            this.pedometerTable = this.createPedometerTable();
            this.scrollpane = new JScrollPane(this.pedometerTable);
            this.add("Center", this.scrollpane);
            this.setVisible(true);
        }
    }

    void delete() {
        if (this.pedometerTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.pedometerTable.getSelectedRow();
        int n2 = JOptionPane.showConfirmDialog(this, Resource.getString("PEDOMETER_DELETE_WNG"), Resource.getString("CONFIRM"), 0);
        if (n2 == 0) {
            PedometerEntry pedometerEntry = this.entry[n];
            this.data.delete(pedometerEntry.getFileName());
            this.setVisible(false);
            this.remove(this.scrollpane);
            this.scrollpane = null;
            this.pedometerTable = null;
            this.pedometerTable = this.createPedometerTable();
            this.scrollpane = new JScrollPane(this.pedometerTable);
            this.add("Center", this.scrollpane);
            this.setVisible(true);
        }
    }

    @Override
    void cancel() {
    }

    @Override
    boolean set() {
        return true;
    }

    private void changeButtonEnabled() {
        if (this.entry == null || this.entry.length == 0) {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
        }
    }

    public void addRow(final JTable jTable, final Object[] objectArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (jTable != null && PedometerWindow.this.pedometerTable != null && jTable.equals(PedometerWindow.this.pedometerTable)) {
                    DefaultTableModel defaultTableModel = (DefaultTableModel)jTable.getModel();
                    defaultTableModel.addRow(objectArray);
                }
            }
        });
    }

    public int delete(int n) throws ImportException {
        return n;
    }

    class pedomEmuTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        pedomEmuTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class pedomEmuTableModel
    extends DefaultTableModel {
        pedomEmuTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

