/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.PhoneGroupEntry;
import com.nttdocomo.dojaemu.ktoolbar.PhoneGroupEntryWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class PhoneGroupWindow
extends TabPanel {
    private static final int FRAME_WIDTH = 480;
    private static final int FRAME_HEIGHT = 200;
    private static String[] phoneGroupFiles;
    private JTable phoneGroupTable;
    private Hashtable phoneGroupHash;
    private int[] idList;
    private int next;
    private JScrollPane scrollpane;
    private JButton addButton;
    private JButton deleteButton;
    private static final File phoneGroupDir;

    PhoneGroupWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.addButton = new JButton(Resource.getString("ADD"));
        this.deleteButton = new JButton(Resource.getString("DELETE"));
        this.addButton.setActionCommand("add");
        this.deleteButton.setActionCommand("delete");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.addButton.addActionListener(actionDispatcher);
        this.deleteButton.addActionListener(actionDispatcher);
        jPanel2.add(this.addButton);
        jPanel2.add(this.deleteButton);
        this.phoneGroupTable = this.createPhoneGroupTable();
        this.scrollpane = new JScrollPane(this.phoneGroupTable);
        this.add("Center", this.scrollpane);
        this.add("South", jPanel2);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(480, 200);
    }

    @Override
    boolean set() {
        return true;
    }

    private JTable createPhoneGroupTable() {
        String string = "";
        phoneGroupFiles = phoneGroupDir.list(new PhoneGroupFilter());
        String[] stringArray = new String[phoneGroupFiles.length];
        this.phoneGroupHash = new Hashtable();
        for (int i = 0; i < phoneGroupFiles.length; ++i) {
            String string2 = phoneGroupDir.getPath() + File.separator + phoneGroupFiles[i];
            int n = phoneGroupFiles[i].indexOf(95);
            try {
                int n2 = Integer.parseInt(phoneGroupFiles[i].substring(0, n));
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            try {
                PhoneGroupEntry phoneGroupEntry = new PhoneGroupEntry();
                phoneGroupEntry.load(string2);
                this.phoneGroupHash.put(new Integer(phoneGroupEntry.getGroupID()), phoneGroupEntry);
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(Resource.format("NOT_FOUND_ERR", string2));
                continue;
            }
            catch (IOException iOException) {
                System.err.println(Resource.format("READ_ERR", string2));
            }
        }
        this.idList = new int[this.phoneGroupHash.size()];
        Enumeration enumeration = this.phoneGroupHash.keys();
        for (int i = 0; i < this.idList.length; ++i) {
            this.idList[i] = (Integer)enumeration.nextElement();
        }
        Arrays.sort(this.idList);
        this.next = this.idList.length > 0 ? this.idList[this.idList.length - 1] + 1 : 1;
        String[] stringArray2 = new String[]{Resource.getString("PHONEGROUP_GROUP_ID"), Resource.getString("PHONEGROUP_GROUP_NAME")};
        PhoneGroupTableModel phoneGroupTableModel = new PhoneGroupTableModel(stringArray2, 0);
        for (int i = 0; i < this.idList.length; ++i) {
            PhoneGroupEntry phoneGroupEntry = null;
            Object v = this.phoneGroupHash.get(new Integer(this.idList[i]));
            if (v == null || !(v instanceof PhoneGroupEntry)) continue;
            phoneGroupEntry = (PhoneGroupEntry)v;
            Vector<String> vector = new Vector<String>();
            vector.addElement(phoneGroupEntry.getGroupID());
            vector.addElement(phoneGroupEntry.getGroupName());
            phoneGroupTableModel.addRow(vector);
        }
        JTable jTable = new JTable(phoneGroupTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.setDefaultRenderer(Object.class, new PhoneGroupTableCellRenderer());
        jTable.setSelectionMode(0);
        this.changeButtonEnabled();
        return jTable;
    }

    void add() {
        PhoneGroupEntry phoneGroupEntry = new PhoneGroupEntry();
        phoneGroupEntry.setNo(this.next);
        PhoneGroupEntryWindow phoneGroupEntryWindow = new PhoneGroupEntryWindow(this.parent, phoneGroupEntry);
        phoneGroupEntryWindow.setLocation(this.parent.getShowLocation(phoneGroupEntryWindow.getWidth(), phoneGroupEntryWindow.getHeight(), this.tabwin));
        phoneGroupEntryWindow.setVisible(true);
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.phoneGroupTable = null;
        this.phoneGroupTable = this.createPhoneGroupTable();
        this.scrollpane = new JScrollPane(this.phoneGroupTable);
        this.add("Center", this.scrollpane);
        this.setVisible(true);
    }

    void delete() {
        int n = this.phoneGroupTable.getSelectedRow();
        if (n != -1) {
            JOptionPane jOptionPane = new JOptionPane(Resource.getString("PHONEBOOKGROUP_DELETE_WNG"), 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                String string = String.valueOf(this.idList[n]) + "_" + ((PhoneGroupEntry)this.phoneGroupHash.get(new Integer(this.idList[n]))).getGroupName() + ".grp";
                File file = new File(phoneGroupDir, string);
                file.delete();
                this.setVisible(false);
                this.remove(this.scrollpane);
                this.scrollpane = null;
                this.phoneGroupTable = null;
                this.phoneGroupTable = this.createPhoneGroupTable();
                this.scrollpane = new JScrollPane(this.phoneGroupTable);
                this.add("Center", this.scrollpane);
                this.setVisible(true);
            }
        }
    }

    @Override
    void cancel() {
    }

    private void changeButtonEnabled() {
        if (this.idList != null && this.idList.length > 0) {
            this.deleteButton.setEnabled(true);
        } else {
            this.deleteButton.setEnabled(false);
        }
    }

    static {
        phoneGroupDir = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "group");
    }

    class PhoneGroupTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        PhoneGroupTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class PhoneGroupFilter
    implements FilenameFilter {
        PhoneGroupFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            if (file.equals(phoneGroupDir)) {
                return string.endsWith(".grp");
            }
            return false;
        }
    }

    class PhoneGroupTableModel
    extends DefaultTableModel {
        PhoneGroupTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

