/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;

class ProjectExplorerFiles {
    public static final String EXT_JAVA = ".java";
    public static final String EXT_TEXT = ".txt";
    public static final String EXT_JAM = ".jam";
    public static final String EXT_SP = ".sp";
    public static final String EXT_PROP = ".properties";
    public static final String EXT_FC = ".fc";
    public static final String EXT_LIST = ".list";
    private static final String IAPPLIB_LIST_FILE = "component.list";
    static final int RENAME_OK = 0;
    static final int RENAME_ERR_ARG = -1;
    static final int RENAME_ERR_NOEXISTS = -2;
    static final int RENAME_ERR_SAME = -3;
    static final int RENAME_ERR_OTHER = -4;
    static final int RENAME_FAILE_NAME = -5;
    private static final char[] NA_CHARS = new char[]{'\\', '/', ':', '?', '*', '\"', '>', '<', '|'};
    private static String[] NA_STRS = new String[]{"aux", "com0", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "con", "lpt0", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "nul", "prn"};
    private static final String[] EDIT_EXT = new String[]{".java", ".txt"};
    private static final String[] EMU_EXT = new String[]{".jam", ".sp", ".properties", ".fc", ".list"};

    ProjectExplorerFiles() {
    }

    static String getExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        String string2 = string.substring(n).toLowerCase();
        return string2;
    }

    static boolean isKToolBarExtension(String string) {
        String string2 = ProjectExplorerFiles.getExtension(new File(string));
        if (string2.length() == 0) {
            return false;
        }
        for (int i = 0; i < EMU_EXT.length; ++i) {
            if (!string2.equals(EMU_EXT[i])) continue;
            return true;
        }
        return false;
    }

    static boolean isTextExtension(String string) {
        String string2 = ProjectExplorerFiles.getExtension(new File(string));
        if (string2.length() == 0) {
            return false;
        }
        for (int i = 0; i < EDIT_EXT.length; ++i) {
            if (!string2.equals(EDIT_EXT[i])) continue;
            return true;
        }
        return false;
    }

    static boolean isSDF(String string) {
        String string2 = ProjectExplorerFiles.cutOffParentPath(string);
        if (string2 == null) {
            return false;
        }
        String[] stringArray = ProjectExplorerFiles.splitPath(string2);
        if (stringArray.length != 2) {
            return false;
        }
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        return ProjectExplorerFiles.isFileSameAsProject(string3, string4);
    }

    static boolean isADF(String string) {
        if (!ProjectExplorerFiles.checkExtension(string, EXT_JAM)) {
            return false;
        }
        String string2 = ProjectExplorerFiles.cutOffParentPath(string);
        if (string2 == null) {
            return false;
        }
        String[] stringArray = ProjectExplorerFiles.splitPath(string2);
        if (stringArray.length != 3) {
            return false;
        }
        if (!stringArray[1].equals("bin")) {
            return false;
        }
        String string3 = stringArray[0];
        String string4 = stringArray[2];
        return ProjectExplorerFiles.isFileSameAsProject(string3, string4);
    }

    static boolean isProp(String string) {
        if (!ProjectExplorerFiles.checkExtension(string, EXT_PROP)) {
            return false;
        }
        String string2 = ProjectExplorerFiles.cutOffParentPath(string);
        if (string2 == null) {
            return false;
        }
        String[] stringArray = ProjectExplorerFiles.splitPath(string2);
        if (stringArray.length != 2) {
            return false;
        }
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        return ProjectExplorerFiles.isFileSameAsProject(string3, string4);
    }

    static boolean isScratch(String string) {
        if (!ProjectExplorerFiles.checkExtension(string, EXT_SP)) {
            return false;
        }
        String string2 = ProjectExplorerFiles.cutOffParentPath(string);
        if (string2 == null) {
            return false;
        }
        String[] stringArray = ProjectExplorerFiles.splitPath(string2);
        if (stringArray.length != 3) {
            return false;
        }
        if (!stringArray[1].equals("sp")) {
            return false;
        }
        String string3 = stringArray[0];
        String string4 = stringArray[2];
        return ProjectExplorerFiles.isFileSameAsProject(string3, string4);
    }

    static boolean isFeliCaChip(String string) {
        if (!ProjectExplorerFiles.checkExtension(string, EXT_FC)) {
            return false;
        }
        String string2 = ProjectExplorerFiles.cutOffParentPath(string);
        if (string2 == null) {
            return false;
        }
        String[] stringArray = ProjectExplorerFiles.splitPath(string2);
        if (stringArray.length != 2) {
            return false;
        }
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        return ProjectExplorerFiles.isFileSameAsProject(string3, string4);
    }

    static boolean isIAppliLib(String string) {
        if (!ProjectExplorerFiles.checkExtension(string, EXT_LIST)) {
            return false;
        }
        String string2 = ProjectExplorerFiles.cutOffParentPath(string);
        if (string2 == null) {
            return false;
        }
        String[] stringArray = ProjectExplorerFiles.splitPath(string2);
        if (stringArray.length != 2) {
            return false;
        }
        String string3 = stringArray[1].toLowerCase();
        return string3.equals(IAPPLIB_LIST_FILE);
    }

    private static boolean isFileSameAsProject(String string, String string2) {
        int n = string2.lastIndexOf(".");
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        return (string = string.toLowerCase()).equals(string2 = string2.toLowerCase());
    }

    static boolean isSrcDir(String string) {
        String string2 = ProjectExplorerFiles.cutOffParentPath(string);
        if (string2 == null) {
            return false;
        }
        String[] stringArray = ProjectExplorerFiles.splitPath(string2);
        if (stringArray.length < 2) {
            return false;
        }
        String string3 = stringArray[1];
        return (string3 = string3.toLowerCase()).equals("src");
    }

    static String cutOffParentPath(String string) {
        byte[] byArray = JAMManager.getProject();
        String string2 = new String(byArray);
        if (string.indexOf(string2) == -1) {
            return null;
        }
        if (string.length() <= string2.length()) {
            return null;
        }
        string2 = string.substring(string2.length() + 1);
        return string2;
    }

    private static String[] splitPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return vector.toArray(new String[0]);
    }

    private static boolean checkExtension(String string, String string2) {
        return (string = string.toLowerCase()).endsWith(string2 = string2.toLowerCase());
    }

    static void copyFile(File file, File file2) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        if (!file2.exists()) {
            throw new FileNotFoundException();
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = fileInputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    static int renameFile(File file, String string) {
        int n;
        if (string == null || string.length() == 0) {
            return -1;
        }
        string = string.trim();
        if (!file.exists()) {
            return -2;
        }
        if (ProjectExplorerFiles.compareSpell(file, string)) {
            return 0;
        }
        String string2 = file.getParent();
        if (string2 == null) {
            return -4;
        }
        int n2 = string.lastIndexOf(46);
        String string3 = string;
        if (n2 != -1) {
            string3 = string.substring(0, n2);
        }
        if ((n = Arrays.binarySearch(NA_STRS, string3.toLowerCase())) >= 0) {
            return -5;
        }
        for (int i = 0; i < NA_CHARS.length; ++i) {
            if (string.indexOf(NA_CHARS[i]) == -1) continue;
            return -5;
        }
        if (string.endsWith(".")) {
            return -5;
        }
        String string4 = string2 + File.separator + string;
        File file2 = new File(string4);
        if (file2.exists()) {
            return -3;
        }
        if (!file.renameTo(file2)) {
            return -4;
        }
        return 0;
    }

    static boolean compareSpell(File file, String string) {
        String string2 = file.getName().toLowerCase();
        return string2.equals(string.toLowerCase());
    }
}

