/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.ProjectExplorerTree;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ProjectExplorerTreeAction
implements ActionListener {
    static final int TYPE_OPEN = 0;
    static final String STR_OPEN = Resource.getString("EXPLORER_OPEN_FOLDER");
    static final String ACTCMD_OPEN = "Open";
    static final int TYPE_RELOAD = 1;
    static final String STR_RELOAD = Resource.getString("RELOAD");
    static final String ACTCMD_RELOAD = "Reload";
    private static final byte[] JNICMD_OPEN = new byte[]{111, 112, 101, 110, 0};
    static final int FOLDER_CLOSE = 0;
    static final int FOLDER_OPEN = 1;
    private static final byte[] CMD_FOLDER_CLOSE = new byte[]{102, 111, 108, 100, 101, 114, 95, 99, 108, 111, 115, 101, 0};
    private static final byte[] CMD_FOLDER_OPEN = new byte[]{102, 111, 108, 100, 101, 114, 95, 111, 112, 101, 110, 0};
    private static final int ICON_SIZE = 16;
    ProjectExplorerTree tree;

    ProjectExplorerTreeAction(ProjectExplorerTree projectExplorerTree) {
        this.tree = projectExplorerTree;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACTCMD_OPEN)) {
            this.tree.openSelectedDir();
        } else if (string.equals(ACTCMD_RELOAD)) {
            this.tree.reloadProjectTree();
        }
    }

    void actOpenFolder(String string) {
        byte[] byArray = (string = string + '\u0000').getBytes();
        int n = JAMManager.openFile(byArray, JNICMD_OPEN);
        if (n != 0) {
            System.out.println(Resource.getString("EXPLORER_ERR_FOLDER_OPEN"));
        }
    }

    static Icon getFolderIcon(int n) {
        int[] nArray = null;
        int n2 = -1;
        BufferedImage bufferedImage = null;
        byte[] byArray = n == 0 ? CMD_FOLDER_CLOSE : CMD_FOLDER_OPEN;
        nArray = JAMManager.getFileIcon(byArray, 16);
        if (nArray.length == 0) {
            return null;
        }
        n2 = JAMManager.getBitsPixel();
        switch (n2) {
            case 32: {
                bufferedImage = new BufferedImage(16, 16, 2);
                break;
            }
            case 24: {
                bufferedImage = new BufferedImage(16, 16, 1);
                break;
            }
            case 16: {
                bufferedImage = new BufferedImage(16, 16, 9);
                break;
            }
            case 8: {
                bufferedImage = new BufferedImage(16, 16, 5);
                break;
            }
            default: {
                return null;
            }
        }
        bufferedImage.setRGB(0, 0, 16, 16, nArray, 0, 16);
        return new ImageIcon(bufferedImage);
    }
}

