/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ADF;
import com.nttdocomo.dojaemu.ktoolbar.AppIcon;
import com.nttdocomo.dojaemu.ktoolbar.ProjectFilesPath;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.Setting;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class ReadWindowTable
extends JTable {
    private final int ORDER_ICON = 0;
    private final int ORDER_NAME = 1;
    private final int ORDER_DATE = 2;
    private final int ORDER_SIZE = 3;
    private final int ORDER_INFO = 4;
    private final int ICON_WIDTH = 34;
    private final int NAME_WIDTH = 143;
    private final int DATE_WIDTH = 97;
    private final int SIZE_WIDTH = 84;
    private final int INFO_WIDTH = 248;
    private final int[] COLUMN_MAX = new int[]{34, 286, 97, 84, 248};
    private final int ICON_COLUMN_MARGIN = 18;
    private final int WEIGHT_NAME = 0;
    private final int WEIGHT_DATE = 2;
    private final int WEIGHT_SIZE = 4;
    private final int WEIGHT_INFO = 6;
    private final int SORT_UP = -1;
    private final int SORT_DOWN = 1;
    private String projectHome;
    private int orderNo;
    private int sortFlag;
    private ArrayList files;
    private String projectName;
    private int[] columnWidth;
    private String filterStr = "";

    public ReadWindowTable(String string) {
        this.projectHome = string;
        this.orderNo = 1;
        this.sortFlag = -1;
        this.files = new ArrayList();
        this.projectName = null;
        this.columnWidth = (int[])this.COLUMN_MAX.clone();
        this.setModel(new DirectoryModel(string));
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        this.setRowHeight(28);
        this.setAutoResizeMode(3);
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ReadWindowListSelectionListener());
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.addMouseListener(new SelectionHeader());
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(true);
        this.setDefaultRenderer(Object.class, new ReadWindowCellRenderer());
        this.setSelectionMode(0);
        int n = this.getFontMetrics(this.getFont()).stringWidth(Resource.getString("ICONORDER")) + 18;
        if (n > this.columnWidth[0]) {
            this.columnWidth[0] = n;
        }
        this.columnWidth[1] = this.columnWidth[1] / 2;
        this.loadColumnWidth();
    }

    public void setSortStatus(int n) {
        if (n > 6) {
            this.orderNo = 4;
            n -= 6;
        } else if (n > 4) {
            this.orderNo = 3;
            n -= 4;
        } else if (n > 2) {
            this.orderNo = 2;
            n -= 2;
        } else {
            this.orderNo = 1;
            n += 0;
        }
        n = n == 1 ? -1 : 1;
    }

    public int getSortStatus() {
        int n = this.sortFlag == -1 ? 1 : 2;
        n = this.orderNo == 2 ? (n += 2) : (this.orderNo == 3 ? (n += 4) : (this.orderNo == 4 ? (n += 6) : (n += 0)));
        return n;
    }

    public int getProjectIndex(String string) {
        int n = -1;
        for (int i = 0; i < this.files.size(); ++i) {
            Object[] objectArray = (Object[])this.files.get(i);
            if ((String)objectArray[1] == null || !((String)objectArray[1]).equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public void setProjectIndex(int n) {
        try {
            if (n > this.getRowCount()) {
                return;
            }
            this.setRowSelectionInterval(n, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    void saveColumnWidth() {
        for (int i = 0; i < this.columnWidth.length; ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            this.columnWidth[i] = tableColumn.getWidth();
        }
    }

    void loadColumnWidth() {
        for (int i = 0; i < this.columnWidth.length - 1; ++i) {
            int n;
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            int n2 = this.COLUMN_MAX[i];
            if (i == 0 && (n = this.getFontMetrics(this.getFont()).stringWidth(Resource.getString("ICONORDER")) + 18) > n2) {
                n2 = n;
            }
            tableColumn.setMaxWidth(n2);
            tableColumn.setPreferredWidth(this.columnWidth[i]);
        }
    }

    public String getSelectedProject() {
        return this.projectName;
    }

    public void resetModel(String string) {
        this.projectHome = string;
        this.setModel(new DirectoryModel(string));
    }

    public void setFilterText(String string) {
        this.filterStr = string;
    }

    public String getFilterText() {
        return this.filterStr;
    }

    class ReadWindowListSelectionListener
    implements ListSelectionListener {
        ReadWindowListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            if (!listSelectionEvent.getValueIsAdjusting() && (n = ReadWindowTable.this.getSelectedRow()) != -1) {
                ReadWindowTable.this.projectName = (String)ReadWindowTable.this.getValueAt(n, 1);
            }
        }
    }

    class ReadWindowCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ReadWindowCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 3) {
                this.setHorizontalAlignment(4);
            } else if (n2 == 0) {
                this.setHorizontalAlignment(0);
            } else {
                this.setHorizontalAlignment(2);
            }
            this.setOpaque(true);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            if (n2 == 0) {
                this.setText(null);
                if (object != null) {
                    this.setIcon((ImageIcon)object);
                }
            } else {
                this.setIcon(null);
                if (object != null) {
                    this.setText((String)object);
                }
            }
            return this;
        }
    }

    class SelectionHeader
    extends MouseAdapter {
        SelectionHeader() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
            if (n >= 0 && n < ReadWindowTable.this.columnWidth.length) {
                if (ReadWindowTable.this.orderNo == n) {
                    if (ReadWindowTable.this.sortFlag == -1) {
                        ReadWindowTable.this.sortFlag = 1;
                    } else {
                        ReadWindowTable.this.sortFlag = -1;
                    }
                } else {
                    ReadWindowTable.this.orderNo = n;
                    ReadWindowTable.this.sortFlag = -1;
                }
                ReadWindowTable.this.saveColumnWidth();
                ReadWindowTable.this.setModel(new DirectoryModel());
                ReadWindowTable.this.loadColumnWidth();
                for (int i = 0; i < ReadWindowTable.this.getRowCount(); ++i) {
                    if (!((String)ReadWindowTable.this.getValueAt(i, 1)).equals(ReadWindowTable.this.projectName)) continue;
                    ReadWindowTable.this.setRowSelectionInterval(i, i);
                }
            }
        }
    }

    class MyConparator
    implements Comparator {
        MyConparator() {
        }

        public int compare(Object object, Object object2) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            if (ReadWindowTable.this.orderNo == 1) {
                if (ReadWindowTable.this.sortFlag == -1) {
                    return ((String)objectArray[ReadWindowTable.this.orderNo]).compareToIgnoreCase((String)objectArray2[ReadWindowTable.this.orderNo]);
                }
                return ((String)objectArray2[ReadWindowTable.this.orderNo]).compareToIgnoreCase((String)objectArray[ReadWindowTable.this.orderNo]);
            }
            if (ReadWindowTable.this.orderNo == 2) {
                return Long.valueOf((String)objectArray[ReadWindowTable.this.orderNo]).compareTo(Long.valueOf((String)objectArray2[ReadWindowTable.this.orderNo])) * ReadWindowTable.this.sortFlag;
            }
            if (ReadWindowTable.this.orderNo == 3) {
                return Long.valueOf((String)objectArray[ReadWindowTable.this.orderNo]).compareTo(Long.valueOf((String)objectArray2[ReadWindowTable.this.orderNo])) * ReadWindowTable.this.sortFlag;
            }
            if (ReadWindowTable.this.orderNo == 0) {
                int n;
                int n2 = objectArray[ReadWindowTable.this.orderNo].hashCode();
                if (n2 == (n = objectArray2[ReadWindowTable.this.orderNo].hashCode())) {
                    return 0;
                }
                if (n2 > n) {
                    return ReadWindowTable.this.sortFlag == -1 ? 1 : -1;
                }
                return ReadWindowTable.this.sortFlag == -1 ? -1 : 1;
            }
            if (ReadWindowTable.this.sortFlag == -1) {
                return ((String)objectArray[ReadWindowTable.this.orderNo]).compareToIgnoreCase((String)objectArray2[ReadWindowTable.this.orderNo]);
            }
            return ((String)objectArray2[ReadWindowTable.this.orderNo]).compareToIgnoreCase((String)objectArray[ReadWindowTable.this.orderNo]);
        }
    }

    class DirectoryModel
    extends AbstractTableModel
    implements ActionListener {
        private ProjectFilesPath pfl;
        private AppIcon appIcon;

        public DirectoryModel(String string) {
            this.pfl = new ProjectFilesPath(ReadWindowTable.this.projectHome);
            this.appIcon = new AppIcon(ReadWindowTable.this.projectHome);
            if (string != null) {
                this.readProjectElements(string);
            }
            Object[] objectArray = ReadWindowTable.this.files.toArray();
            MyConparator myConparator = new MyConparator();
            Arrays.sort(objectArray, myConparator);
            ReadWindowTable.this.files.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                ReadWindowTable.this.files.add(objectArray[i]);
            }
        }

        public DirectoryModel() {
            this(null);
        }

        private String getJarSize(String string) {
            String string2 = "0";
            File file = new File(this.pfl.getJarPath(string));
            if (file.exists()) {
                string2 = String.valueOf(file.length());
            }
            return string2;
        }

        private String getProjectInfo(String string) {
            String string2 = null;
            File file = new File(this.pfl.getPrpPath(string));
            try {
                Setting setting = new Setting(file);
                string2 = setting.getProperty("projectInfo");
                if (string2 == null) {
                    ADF aDF = new ADF(new File(this.pfl.getJamPath(string)));
                    string2 = aDF.getProperty("AppName");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string2 == null ? "" : "   " + string2;
        }

        private ImageIcon getAppIcon(String string) {
            return this.appIcon.getImageIcon(string);
        }

        public void readProjectElements(String string) {
            String[] stringArray = new File(string).list();
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            ReadWindowTable.this.files.clear();
            String string2 = ReadWindowTable.this.getFilterText().toLowerCase();
            for (int i = 0; i < stringArray.length; ++i) {
                String string3;
                File file = new File(this.pfl.getJamPath(stringArray[i]));
                if (!file.exists() || (string3 = stringArray[i].toLowerCase()).indexOf(string2) < 0) continue;
                Object[] objectArray = new Object[ReadWindowTable.this.columnWidth.length];
                objectArray[0] = this.getAppIcon(stringArray[i]);
                objectArray[1] = stringArray[i];
                objectArray[2] = new Long(file.lastModified()).toString();
                objectArray[3] = this.getJarSize(stringArray[i]);
                objectArray[4] = this.getProjectInfo(stringArray[i]);
                ReadWindowTable.this.files.add(objectArray);
            }
        }

        @Override
        public int getRowCount() {
            return ReadWindowTable.this.files != null ? ReadWindowTable.this.files.size() : 0;
        }

        @Override
        public int getColumnCount() {
            return ReadWindowTable.this.files != null ? ReadWindowTable.this.columnWidth.length : 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (ReadWindowTable.this.files == null || ReadWindowTable.this.files.size() == 0) {
                return null;
            }
            Object[] objectArray = (Object[])ReadWindowTable.this.files.get(n);
            switch (n2) {
                case 0: {
                    return objectArray[0];
                }
                case 1: {
                    return (String)objectArray[1];
                }
                case 2: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                    return simpleDateFormat.format(new Date(Long.parseLong((String)objectArray[2])));
                }
                case 3: {
                    return NumberFormat.getNumberInstance().format(Long.parseLong((String)objectArray[3]));
                }
                case 4: {
                    return (String)objectArray[4];
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            String string = "";
            String string2 = "";
            if (n == 0) {
                return Resource.getString("ICONORDER");
            }
            if (n == 1) {
                string = "NAMEORDER";
            } else if (n == 2) {
                string = "DATEORDER";
            } else if (n == 3) {
                string = "SIZEORDER";
            } else if (n == 4) {
                string = "INFOORDER";
            }
            if (ReadWindowTable.this.orderNo == n) {
                string2 = ReadWindowTable.this.sortFlag == -1 ? "_UP" : "_DOWN";
            }
            return Resource.getString(string + string2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DirectoryModel directoryModel = new DirectoryModel(ReadWindowTable.this.projectHome);
            ReadWindowTable.this.setModel(directoryModel);
        }
    }
}

