/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.ScheduleEntry;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class ScheduleWindow
extends TabPanel {
    private static final int FRAME_WIDTH = 540;
    private static final int FRAME_HEIGHT = 200;
    private static String[] scheduleFiles;
    private JTable scheduleTable;
    private Hashtable scheduleHash;
    private int[] idList;
    private int next;
    private JScrollPane scrollpane;
    private JButton deleteButton;
    private static final File scheduleDir;
    private static final String EXTENSION_SCHEDULE = ".sdl";

    ScheduleWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.deleteButton = new JButton(Resource.getString("DELETE"));
        this.deleteButton.setActionCommand("delete");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.deleteButton.addActionListener(actionDispatcher);
        jPanel2.add(this.deleteButton);
        this.scheduleTable = this.createScheduleTable();
        this.scrollpane = new JScrollPane(this.scheduleTable);
        this.add("Center", this.scrollpane);
        this.add("South", jPanel2);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(540, 200);
    }

    private JTable createScheduleTable() {
        String string = "";
        scheduleFiles = scheduleDir.list(new ScheduleFilter());
        String[] stringArray = new String[scheduleFiles.length];
        this.scheduleHash = new Hashtable();
        int n = 0;
        while (true) {
            block8: {
                int n2;
                if (n >= scheduleFiles.length) break;
                String string2 = scheduleDir.getPath() + File.separator + scheduleFiles[n];
                int n3 = scheduleFiles[n].indexOf(46);
                try {
                    n2 = Integer.parseInt(scheduleFiles[n].substring(0, n3));
                }
                catch (NumberFormatException numberFormatException) {
                    break block8;
                }
                try {
                    ScheduleEntry scheduleEntry = new ScheduleEntry();
                    scheduleEntry.setId(n2);
                    if (scheduleEntry.load(string2) == 0) {
                        this.scheduleHash.put(new Integer(n2), scheduleEntry);
                    }
                }
                catch (Exception exception) {
                    System.err.println(Resource.format("NOT_FOUND_ERR", string2));
                }
            }
            ++n;
        }
        this.idList = new int[this.scheduleHash.size()];
        Enumeration enumeration = this.scheduleHash.keys();
        for (int i = 0; i < this.idList.length; ++i) {
            this.idList[i] = (Integer)enumeration.nextElement();
        }
        Arrays.sort(this.idList);
        this.next = this.idList.length > 0 ? this.idList[this.idList.length - 1] + 1 : 1;
        String[] stringArray2 = new String[]{Resource.getString("SCHEDULE_TYPE"), Resource.getString("SCHEDULE_DATE"), Resource.getString("SCHEDULE_DESCRIPTION"), Resource.getString("SCHEDULE_ALARM")};
        ScheduleTableModel scheduleTableModel = new ScheduleTableModel(stringArray2, 0);
        for (int i = 0; i < this.idList.length; ++i) {
            ScheduleEntry scheduleEntry = null;
            Object v = this.scheduleHash.get(new Integer(this.idList[i]));
            if (v == null || !(v instanceof ScheduleEntry)) continue;
            scheduleEntry = (ScheduleEntry)v;
            Vector<String> vector = new Vector<String>();
            vector.addElement(scheduleEntry.getTypeStringForDisplay());
            vector.addElement(scheduleEntry.getDateStringForDisplay());
            vector.addElement(scheduleEntry.getDescription());
            vector.addElement(scheduleEntry.getAlarmStateStringForDisplay());
            scheduleTableModel.addRow(vector);
        }
        JTable jTable = new JTable(scheduleTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.setDefaultRenderer(Object.class, new ScheduleTableCellRenderer());
        jTable.setSelectionMode(0);
        jTable.getColumnModel().getColumn(0).setMinWidth(60);
        jTable.getColumnModel().getColumn(0).setMaxWidth(60);
        jTable.getColumnModel().getColumn(1).setMinWidth(155);
        jTable.getColumnModel().getColumn(1).setMaxWidth(155);
        jTable.getColumnModel().getColumn(3).setMinWidth(60);
        jTable.getColumnModel().getColumn(3).setMaxWidth(60);
        this.changeButtonEnabled();
        return jTable;
    }

    void delete() {
        int n = this.scheduleTable.getSelectedRow();
        if (n != -1) {
            JOptionPane jOptionPane = new JOptionPane(Resource.getString("SCHEDULE_DELETE_WNG"), 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                File file = new File(scheduleDir, String.valueOf(this.idList[n]) + EXTENSION_SCHEDULE);
                file.delete();
                this.setVisible(false);
                this.remove(this.scrollpane);
                this.scrollpane = null;
                this.scheduleTable = null;
                this.scheduleTable = this.createScheduleTable();
                this.scrollpane = new JScrollPane(this.scheduleTable);
                this.add("Center", this.scrollpane);
                this.setVisible(true);
            }
        }
    }

    @Override
    void cancel() {
    }

    @Override
    boolean set() {
        return true;
    }

    private void changeButtonEnabled() {
        if (this.idList != null && this.idList.length > 0) {
            this.deleteButton.setEnabled(true);
        } else {
            this.deleteButton.setEnabled(false);
        }
    }

    static {
        scheduleDir = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "schedule");
    }

    class ScheduleTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ScheduleTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class ScheduleFilter
    implements FilenameFilter {
        ScheduleFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            if (file.equals(scheduleDir)) {
                return string.endsWith(ScheduleWindow.EXTENSION_SCHEDULE);
            }
            return false;
        }
    }

    class ScheduleTableModel
    extends DefaultTableModel {
        ScheduleTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

