/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.ComponentListManager;
import com.nttdocomo.dojaemu.ktoolbar.JarAccess;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.Setting;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class SelectComponentWindow
extends AbstractWindow {
    private final int DEFAULT_FRAME_WIDTH = 550;
    private final int DEFAULT_FRAME_HEIGHT = 300;
    private final int BUTTON_WIDTH = 100;
    private final int BUTTON_HEIGHT = 25;
    private final int TABLE_COLUMN_MARGIN = 18;
    private JTable componentJTable;
    private MainWindow parent;
    private JScrollPane scrollpane;
    private Container cp;
    private final int[] CEL_WIDTH = new int[]{30, 150, 70, 120, 90, 90};
    private JCheckBox requiredTakeInCheck;
    private JTable scwTable;
    SelectCompTblModel tableModel;
    private int currentFrameWidth = 550;
    private final String entryListName = "component.list";
    private final File compEntryDir = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "component");
    private File componentPath;
    ComponentListManager compList = null;
    private final String[] columnNames = new String[]{Resource.getString("SELCT_COMP_COL_USE"), Resource.getString("SELCT_COMP_COL_NAME"), Resource.getString("SELCT_COMP_COL_VERSION"), Resource.getString("SELCT_COMP_COL_AUTHOR"), Resource.getString("SELCT_COMP_COL_DOJAPROF"), Resource.getString("SELCT_COMP_COL_LASTMODI")};

    SelectComponentWindow(MainWindow mainWindow) {
        super(mainWindow, Resource.getString("SELCT_COMP_WINDOW_TITLE"));
        this.parent = mainWindow;
        this.addWindowListener();
        this.cp = this.getContentPane();
        this.cp.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.requiredTakeInCheck = new JCheckBox(Resource.getString("SELCT_COMP_CHK_REQ_CLS"));
        this.requiredTakeInCheck.setActionCommand("switchInclude");
        this.requiredTakeInCheck.addActionListener(actionDispatcher);
        jPanel.add((Component)this.requiredTakeInCheck, "West");
        JButton jButton = new JButton(Resource.getString("SELCT_COMP_BTN_REGIST"));
        JButton jButton2 = new JButton(Resource.getString("SELCT_COMP_BTN_CANCEL"));
        JButton jButton3 = new JButton(Resource.getString("CLOSE"));
        Dimension dimension = new Dimension(100, 25);
        jButton.setPreferredSize(dimension);
        jButton2.setPreferredSize(dimension);
        jButton3.setPreferredSize(dimension);
        jButton.setActionCommand("registration");
        jButton2.setActionCommand("cancel");
        jButton3.setActionCommand("close");
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jButton3.addActionListener(actionDispatcher);
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel3.add(jButton3);
        File file = new File(mainWindow.getProjectPath(mainWindow.getProjectName()));
        if (!file.exists()) {
            System.out.println(Resource.getString("STARTUP_ERR"));
        }
        this.componentPath = new File(file, "component.list");
        if (!this.componentPath.exists()) {
            try {
                this.componentPath.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.compList = new ComponentListManager(this.componentPath);
        ArrayList arrayList = this.getCompEntryDir();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.compList.addItem((String)iterator.next(), false);
        }
        this.componentJTable = this.createComponetTable();
        this.requiredTakeInCheck.setSelected(this.compList.isAllInclude());
        this.scrollpane = new JScrollPane(this.componentJTable);
        this.cp.add("North", jPanel);
        this.cp.add("South", jPanel3);
        this.cp.add("Center", this.scrollpane);
        this.setResizable(false);
        this.setSize(this.currentFrameWidth, 300);
    }

    private ArrayList getCompEntryDir() {
        File[] fileArray = this.getJarInDir(this.compEntryDir);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getPath();
                try {
                    if (!ComponentListManager.checkCompJar(string)) continue;
                    arrayList.add(fileArray[i].getPath());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return arrayList;
    }

    private File[] getJarInDir(File file) {
        Vector<File> vector = new Vector<File>();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return null;
        }
        if (fileArray.length == 0) {
            return null;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                File[] fileArray2 = this.getJarInDir(fileArray[i]);
                if (fileArray2 == null) continue;
                for (int j = 0; j < fileArray2.length; ++j) {
                    vector.addElement(fileArray2[j]);
                }
                continue;
            }
            vector.addElement(fileArray[i]);
        }
        vector.trimToSize();
        if (vector.size() == 0) {
            return null;
        }
        return vector.toArray(new File[0]);
    }

    private JTable createComponetTable() {
        int n = this.compList.size();
        int n2 = 0;
        this.tableModel = new SelectCompTblModel();
        this.scwTable = new JTable(this.tableModel);
        this.scwTable.getTableHeader().setReorderingAllowed(false);
        this.scwTable.getTableHeader().setResizingAllowed(false);
        this.scwTable.setDefaultRenderer(Object.class, new SelectCompTblRenderer());
        this.scwTable.setSelectionMode(0);
        for (int i = 0; i < this.columnNames.length; ++i) {
            int n3 = this.CEL_WIDTH[i];
            int n4 = this.getFontMetrics(this.getFont()).stringWidth(this.columnNames[i]) + 18;
            if (n4 > n3) {
                n3 = n4;
            }
            n2 += n3;
            TableColumn tableColumn = this.scwTable.getColumnModel().getColumn(i);
            tableColumn.setMinWidth(n3);
            tableColumn.setMaxWidth(n3);
            tableColumn.setResizable(false);
        }
        if (n2 > 550) {
            this.currentFrameWidth = n2;
        }
        this.scwTable.setShowGrid(false);
        return this.scwTable;
    }

    public void switchInclude() {
        this.compList.setAllInclude(this.requiredTakeInCheck.isSelected());
        this.setList();
    }

    public void registration() {
        JFileChooser jFileChooser = new JFileChooser(new File(this.parent.getSelectCompPath()));
        jFileChooser.setDialogTitle(Resource.getString("SELCT_COMP_DLG_SEL_JAR"));
        jFileChooser.setDialogType(0);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new CompJarFilter());
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().toString();
            if (!this.componentPath.canWrite()) {
                this.showWngMessage(Resource.getString("SELCT_COMP_LIST_SV_ERR"), Resource.getString("WNG"));
                return;
            }
            this.parent.setSelectCompPath(jFileChooser.getCurrentDirectory().getPath());
            if (this.parent.getBuildSwitch() == 1 && this.isCreatingComp(string)) {
                this.showInfoMessage(Resource.getString("SELCT_COMP_EDLG_M_SAME"), Resource.getString("SELCT_COMP_EDLG_T_NO_LJ"));
                return;
            }
            if (this.compList.contains(string)) {
                this.showInfoMessage(Resource.getString("SELCT_COMP_EDLG_M_OL"), Resource.getString("SELCT_COMP_EDLG_T_OL"));
                return;
            }
            JarAccess jarAccess = new JarAccess(string);
            if (!jarAccess.isManifest()) {
                this.showInfoMessage(Resource.getString("SELCT_COMP_EDLG_M_NO_LJ"), Resource.getString("SELCT_COMP_EDLG_T_NO_LJ"));
                return;
            }
            try {
                if (!ComponentListManager.checkCompJar(jarAccess)) {
                    this.showInfoMessage(Resource.getString("SELCT_COMP_EDLG_M_NO_NV"), Resource.getString("SELCT_COMP_EDLG_T_NO_NV"));
                    return;
                }
                this.compList.pushItem(string, false);
                this.setList();
                this.tableModel.fireTableRowsInserted(0, this.compList.size());
                this.scwTable.repaint();
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public void cancel() {
        if (!this.componentPath.canWrite()) {
            this.showWngMessage(Resource.getString("SELCT_COMP_LIST_SV_ERR"), Resource.getString("WNG"));
            return;
        }
        int n = this.scwTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        this.compList.remove(n);
        this.tableModel.fireTableRowsDeleted(0, this.compList.size());
        this.scwTable.repaint();
        this.setList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setList() {
        BufferedWriter bufferedWriter = null;
        try {
            if (!this.componentPath.canWrite()) {
                throw new Exception();
            }
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.componentPath)));
            String string = "false";
            if (this.compList.size() != 0) {
                if (this.requiredTakeInCheck.isSelected()) {
                    string = "true";
                }
                bufferedWriter.write(string);
                bufferedWriter.newLine();
                for (int i = 0; i < this.compList.size(); ++i) {
                    String string2 = this.compList.getJarPath(i);
                    String string3 = this.compList.getUse(i);
                    if (string2 == null || string3 == null) continue;
                    String string4 = string2 + " " + string3;
                    bufferedWriter.write(string4);
                    bufferedWriter.newLine();
                }
            }
        }
        catch (Exception exception) {
            this.showWngMessage(Resource.getString("SELCT_COMP_LIST_SV_ERR"), Resource.getString("WNG"));
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    public void close() {
        try {
            if (this.componentPath.length() == 0L) {
                this.componentPath.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.parent.closeWindow(this);
    }

    boolean isCreatingComp(String string) {
        try {
            File file = new File(this.parent.getProjectSettingPath(this.parent.getProjectName()));
            Setting setting = new Setting(file);
            String string2 = setting.getProperty("componentName");
            if (string2 == null || string2.length() == 0) {
                return false;
            }
            String string3 = this.parent.getProjectPath(this.parent.getProjectName());
            String string4 = string3 + File.separator + "bin" + File.separator + string2 + ".jar";
            if (!string.equals(string4)) {
                return false;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void showWngMessage(String string, String string2) {
        JOptionPane.showMessageDialog(this, string, string2, 2);
    }

    private void showInfoMessage(String string, String string2) {
        JOptionPane.showMessageDialog(this, string, string2, 1);
    }

    class CompJarFilter
    extends FileFilter {
        CompJarFilter() {
        }

        @Override
        public boolean accept(File file) {
            String string;
            if (file.isDirectory()) {
                return true;
            }
            return file.isFile() && (string = file.getPath().toLowerCase()).endsWith(".jar");
        }

        @Override
        public String getDescription() {
            return Resource.getString("SELCT_COMP_FILTER_DESC");
        }
    }

    class SelectCompTblRenderer
    extends JLabel
    implements TableCellRenderer {
        SelectCompTblRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            if (n2 != 0) {
                this.setText((String)object);
                this.setToolTipText((String)object);
            }
            return this;
        }
    }

    class SelectCompTblModel
    extends AbstractTableModel
    implements TableModelListener {
        SelectCompTblModel() {
            this.addTableModelListener(this);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public int getRowCount() {
            return SelectComponentWindow.this.compList != null ? SelectComponentWindow.this.compList.size() : 0;
        }

        @Override
        public int getColumnCount() {
            return SelectComponentWindow.this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            if (n < SelectComponentWindow.this.columnNames.length) {
                return SelectComponentWindow.this.columnNames[n];
            }
            return null;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String[] stringArray = SelectComponentWindow.this.compList.getItem(n);
            if (n < SelectComponentWindow.this.compList.size()) {
                Object object;
                switch (n2) {
                    case 0: {
                        object = new Boolean(SelectComponentWindow.this.compList.isUse(n));
                        break;
                    }
                    case 1: {
                        ComponentListManager cfr_ignored_0 = SelectComponentWindow.this.compList;
                        object = stringArray[0];
                        break;
                    }
                    case 2: {
                        ComponentListManager cfr_ignored_1 = SelectComponentWindow.this.compList;
                        object = stringArray[1];
                        break;
                    }
                    case 3: {
                        ComponentListManager cfr_ignored_2 = SelectComponentWindow.this.compList;
                        object = stringArray[2];
                        break;
                    }
                    case 4: {
                        ComponentListManager cfr_ignored_3 = SelectComponentWindow.this.compList;
                        object = stringArray[3];
                        break;
                    }
                    case 5: {
                        ComponentListManager cfr_ignored_4 = SelectComponentWindow.this.compList;
                        object = stringArray[4];
                        break;
                    }
                    default: {
                        object = new Object();
                    }
                }
                return object;
            }
            return new Object();
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0 && object instanceof Boolean) {
                if (new Boolean(true).equals(object)) {
                    SelectComponentWindow.this.compList.setUse(n, "0");
                } else {
                    SelectComponentWindow.this.compList.setUse(n, "1");
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = tableModelEvent.getColumn();
            int n2 = tableModelEvent.getLastRow();
            if (n2 < SelectComponentWindow.this.compList.size() && n == 0) {
                if (!SelectComponentWindow.this.componentPath.canWrite()) {
                    SelectComponentWindow.this.showWngMessage(Resource.getString("SELCT_COMP_LIST_SV_ERR"), Resource.getString("WNG"));
                    return;
                }
                String string = SelectComponentWindow.this.compList.getUse(n2);
                String string2 = string.equals("0") ? "1" : "0";
                SelectComponentWindow.this.compList.setUse(n2, string2);
            }
            SelectComponentWindow.this.setList();
        }
    }
}

