/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.plaf.ComboBoxUI;

public class SelectFreeareaWindow
extends JDialog
implements ActionListener {
    public static final int TYPE_REMOVE = 0;
    public static final int TYPE_ADD_RELATION = 1;
    private JPanel jContentPane = null;
    private JPanel listContainer = null;
    private JPanel labelContainer = null;
    private JPanel buttonContainer = null;
    private JButton setButton = null;
    private JButton cancelButton = null;
    private JLabel areaLabel = null;
    private JComboBox areaListBox = null;
    private JLabel cpidTitleLabel = null;
    private JLabel cpidLabel = null;
    private JLabel pinTitleLabel = null;
    private JLabel pinLabel = null;
    private int selectedIndex = -2;
    private String cpid;
    private String pin;
    private int dialogType;

    public SelectFreeareaWindow(JDialog jDialog, String string, String string2, int n) {
        super((Dialog)jDialog, true);
        this.cpid = string;
        this.pin = string2;
        this.dialogType = n;
        this.initialize();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    private void initialize() {
        if (this.dialogType == 0) {
            this.setSize(380, 160);
            this.setTitle(Resource.getString("FELICA_CPID_PIN_REMOVE_TITLE"));
        } else {
            this.setSize(340, 160);
            this.setTitle(Resource.getString("FELICA_CPID_PIN_RELATION_TITLE"));
        }
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getListContainer(), "North");
            this.jContentPane.add((Component)this.getLabelContainer(), "Center");
            this.jContentPane.add((Component)this.getButtonContainer(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getListContainer() {
        if (this.listContainer == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 7, 0, 0);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(5, 12, 5, 40);
            gridBagConstraints2.weightx = 1.0;
            this.areaLabel = new JLabel();
            this.areaLabel.setText(Resource.getString("FELICA_DATAFILE_FREEAREA_SELECT_LABEL"));
            this.listContainer = new JPanel();
            this.listContainer.setLayout(new GridBagLayout());
            this.listContainer.add((Component)this.areaLabel, gridBagConstraints);
            this.listContainer.add((Component)this.getAreaListBox(), gridBagConstraints2);
        }
        return this.listContainer;
    }

    private JPanel getLabelContainer() {
        if (this.labelContainer == null) {
            this.labelContainer = new JPanel();
            this.labelContainer.setLayout(new GridBagLayout());
            this.labelContainer.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(102, 102, 102), 1), Resource.getString("FELICA_CPID_PIN_PANEL_BORDER_TITLE"), 0, 0, new Font("MS UI Gothic", 0, 12), Color.black));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 10;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 10, 20);
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.gridheight = 1;
            gridBagConstraints2.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 3;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.insets = new Insets(0, 0, 0, 27);
            gridBagConstraints4.gridy = 1;
            this.cpidTitleLabel = new JLabel();
            this.cpidTitleLabel.setText(Resource.getString("FELICA_CPID_TITLE"));
            this.cpidLabel = new JLabel();
            if (this.dialogType == 0) {
                this.cpidLabel.setText(Resource.getString("FELICA_CPID_PIN_DELETE_VALUE"));
            } else {
                this.cpidLabel.setText(this.cpid);
            }
            this.pinLabel = new JLabel();
            if (this.dialogType == 0) {
                this.pinLabel.setText(Resource.getString("FELICA_CPID_PIN_DELETE_VALUE"));
            } else {
                this.pinLabel.setText(this.pin + "(0x" + Integer.toHexString(Integer.parseInt(this.pin)) + ")");
            }
            this.pinTitleLabel = new JLabel();
            this.pinTitleLabel.setText(Resource.getString("FELICA_PIN_TITLE"));
            this.labelContainer.add((Component)this.cpidTitleLabel, gridBagConstraints2);
            this.labelContainer.add((Component)this.cpidLabel, gridBagConstraints);
            this.labelContainer.add((Component)this.pinTitleLabel, gridBagConstraints4);
            this.labelContainer.add((Component)this.pinLabel, gridBagConstraints3);
        }
        return this.labelContainer;
    }

    private JPanel getButtonContainer() {
        if (this.buttonContainer == null) {
            this.buttonContainer = new JPanel();
            this.buttonContainer.add((Component)this.getSetButton(), null);
            this.buttonContainer.add((Component)this.getCancelButton(), null);
        }
        return this.buttonContainer;
    }

    private JButton getSetButton() {
        if (this.setButton == null) {
            this.setButton = new JButton();
            this.setButton.setText(Resource.getString("SET"));
            this.setButton.addActionListener(this);
            this.setButton.setActionCommand("set");
        }
        return this.setButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText(Resource.getString("CANCEL"));
            this.cancelButton.addActionListener(this);
            this.cancelButton.setActionCommand("cancel");
        }
        return this.cancelButton;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    private JComboBox getAreaListBox() {
        String[] stringArray = new String[]{Resource.format("FELICA_DATAFILE_FREEAREA", "1"), Resource.format("FELICA_DATAFILE_FREEAREA", "2"), Resource.format("FELICA_DATAFILE_FREEAREA", "3")};
        if (this.areaListBox == null) {
            this.areaListBox = new JComboBox();
            this.areaListBox.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
            for (int i = 0; i < stringArray.length; ++i) {
                this.areaListBox.addItem(stringArray[i]);
            }
        }
        return this.areaListBox;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("set")) {
            int n = -1;
            switch (this.dialogType) {
                case 0: {
                    n = JOptionPane.showConfirmDialog(this, Resource.format("FELICA_CPID_PIN_REMOVE_MSG", Resource.format("FELICA_DATAFILE_FREEAREA", String.valueOf(this.areaListBox.getSelectedIndex() + 1))), Resource.getString("FELICA_CPID_PIN_REMOVE"), 0);
                    break;
                }
                case 1: {
                    n = JOptionPane.showConfirmDialog(this, Resource.format("FELICA_CPID_PIN_OVERWRITE_MSG", Resource.format("FELICA_DATAFILE_FREEAREA", String.valueOf(this.areaListBox.getSelectedIndex() + 1))), Resource.getString("FELICA_CPID_PIN_OVERWRITE"), 0);
                }
            }
            if (n == 0) {
                this.selectedIndex = this.areaListBox.getSelectedIndex();
                this.dispose();
            }
        }
        if (string.equals("cancel")) {
            this.selectedIndex = -1;
            this.dispose();
        }
    }
}

