/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.ShortcutKeyEditWindow;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class ShortcutKeyWindow
extends TabPanel {
    private static final int FRAME_WIDTH = 480;
    private static final int FRAME_HEIGHT = 200;
    private static final int BUTTON_WIDTH = 10;
    private static final int BUTTON_HEIGHT = 10;
    private static final int BUTTON_INTERVAL = 5;
    private JTable shortcutKeyTable;
    private Hashtable shortcutKeyHash;
    private Vector commandTable;
    private JScrollPane scrollpane;

    ShortcutKeyWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        JButton jButton = new JButton(Resource.getString("ADD"));
        JButton jButton2 = new JButton(Resource.getString("EDIT"));
        JButton jButton3 = new JButton(Resource.getString("REMOVE"));
        jButton.setActionCommand("add");
        jButton2.setActionCommand("edit");
        jButton3.setActionCommand("remove");
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jButton3.addActionListener(actionDispatcher);
        jButton.setSize(10, 10);
        jButton2.setSize(10, 10);
        jButton3.setSize(10, 10);
        jPanel3.add(Box.createVerticalStrut(5));
        jPanel3.add(jButton);
        jPanel3.add(Box.createVerticalStrut(5));
        jPanel3.add(jButton2);
        jPanel3.add(Box.createVerticalStrut(5));
        jPanel3.add(jButton3);
        jPanel3.add(Box.createHorizontalStrut(10));
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createHorizontalStrut(5));
        this.refreshShortcutKeyHash();
        this.shortcutKeyTable = this.createShortcutKeyTable();
        this.scrollpane = new JScrollPane(this.shortcutKeyTable);
        this.add("East", jPanel2);
        this.add("Center", this.scrollpane);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(480, 200);
    }

    private JTable createShortcutKeyTable() {
        String[] stringArray = new String[]{Resource.getString("OPERATION"), Resource.getString("KEY_STROKE")};
        ShortcutKeyTableModel shortcutKeyTableModel = new ShortcutKeyTableModel(stringArray, 0);
        KeyStroke keyStroke = null;
        String string = null;
        this.commandTable = new Vector();
        Enumeration enumeration = this.shortcutKeyHash.elements();
        while (enumeration.hasMoreElements()) {
            JMenuItem jMenuItem = null;
            Object v = enumeration.nextElement();
            if (v == null || !(v instanceof JMenuItem)) continue;
            jMenuItem = (JMenuItem)v;
            keyStroke = jMenuItem.getAccelerator();
            Vector<String> vector = new Vector<String>();
            vector.addElement(jMenuItem.getText());
            string = (keyStroke.getModifiers() & 2) == 2 ? KeyEvent.getKeyModifiersText(keyStroke.getModifiers()) + " + " + KeyEvent.getKeyText(keyStroke.getKeyCode()) : KeyEvent.getKeyText(keyStroke.getKeyCode());
            vector.addElement(string);
            shortcutKeyTableModel.addRow(vector);
            this.commandTable.add(jMenuItem.getActionCommand());
        }
        JTable jTable = new JTable(shortcutKeyTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.setDefaultRenderer(Object.class, new ShortcutKeyTableCellRenderer());
        jTable.setSelectionMode(0);
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    ShortcutKeyWindow.this.edit();
                }
            }
        });
        jTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    ShortcutKeyWindow.this.edit();
                }
            }
        });
        return jTable;
    }

    private void refreshShortcutKeyHash() {
        JMenuBar jMenuBar = this.parent.getJMenuBar();
        this.shortcutKeyHash = new Hashtable();
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            for (int j = 0; j < jMenu.getItemCount(); ++j) {
                JMenuItem jMenuItem = jMenu.getItem(j);
                if (jMenuItem == null || jMenuItem.getAccelerator() == null) continue;
                String string = jMenuItem.getActionCommand();
                this.shortcutKeyHash.put(jMenuItem.getActionCommand(), jMenuItem);
            }
        }
    }

    void add() {
        ShortcutKeyEditWindow shortcutKeyEditWindow = new ShortcutKeyEditWindow(this.parent, null, this.shortcutKeyHash);
        shortcutKeyEditWindow.setLocation(this.parent.getShowLocation(shortcutKeyEditWindow.getWidth(), shortcutKeyEditWindow.getHeight(), this.tabwin));
        shortcutKeyEditWindow.setVisible(true);
        if (shortcutKeyEditWindow.isEdited() && this.listener != null) {
            this.listener.tabPanelEvent(this, 2, 0);
        }
        shortcutKeyEditWindow.dispose();
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.shortcutKeyTable = null;
        this.shortcutKeyTable = this.createShortcutKeyTable();
        this.scrollpane = new JScrollPane(this.shortcutKeyTable);
        this.add("Center", this.scrollpane);
        this.setVisible(true);
    }

    void edit() {
        int n = this.shortcutKeyTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        String string = (String)this.commandTable.get(n);
        JMenuItem jMenuItem = null;
        Object v = this.shortcutKeyHash.get(string);
        if (v == null || !(v instanceof JMenuItem)) {
            return;
        }
        jMenuItem = (JMenuItem)v;
        ShortcutKeyEditWindow shortcutKeyEditWindow = new ShortcutKeyEditWindow(this.parent, jMenuItem, this.shortcutKeyHash);
        shortcutKeyEditWindow.setLocation(this.parent.getShowLocation(shortcutKeyEditWindow.getWidth(), shortcutKeyEditWindow.getHeight(), this.tabwin));
        shortcutKeyEditWindow.setVisible(true);
        if (shortcutKeyEditWindow.isEdited() && this.listener != null) {
            this.listener.tabPanelEvent(this, 2, 0);
        }
        shortcutKeyEditWindow.dispose();
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.shortcutKeyTable = null;
        this.shortcutKeyTable = this.createShortcutKeyTable();
        this.scrollpane = new JScrollPane(this.shortcutKeyTable);
        this.add("Center", this.scrollpane);
        this.setVisible(true);
    }

    void remove() {
        int n = this.shortcutKeyTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        String string = (String)this.commandTable.get(n);
        JMenuItem jMenuItem = null;
        Object v = this.shortcutKeyHash.remove(string);
        if (v == null || !(v instanceof JMenuItem)) {
            return;
        }
        jMenuItem = (JMenuItem)v;
        jMenuItem.setAccelerator(null);
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.shortcutKeyTable = null;
        this.shortcutKeyTable = this.createShortcutKeyTable();
        this.scrollpane = new JScrollPane(this.shortcutKeyTable);
        this.add("Center", this.scrollpane);
        this.setVisible(true);
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 2, 0);
        }
    }

    @Override
    void cancel() {
        this.parent.setAccelerator();
    }

    @Override
    boolean set() {
        this.saveSetting();
        return true;
    }

    void saveSetting() {
        JMenuBar jMenuBar = this.parent.getJMenuBar();
        JMenu jMenu = null;
        JMenuItem jMenuItem = null;
        KeyStroke keyStroke = null;
        int n = 0;
        Object var7_6 = null;
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            jMenu = jMenuBar.getMenu(i);
            for (int j = 0; j < jMenu.getItemCount(); ++j) {
                jMenuItem = jMenu.getItem(j);
                if (jMenuItem == null) continue;
                String string = jMenuItem.getActionCommand();
                keyStroke = jMenuItem.getAccelerator();
                if (keyStroke != null) {
                    n = (keyStroke.getModifiers() & 2) == 2 ? keyStroke.getKeyCode() | 0x80 : keyStroke.getKeyCode();
                    JAMManager.setShortcutSetting((string + '\u0000').getBytes(), n);
                    continue;
                }
                JAMManager.delShortcutSetting((string + '\u0000').getBytes());
            }
        }
    }

    class ShortcutKeyTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ShortcutKeyTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class ShortcutKeyTableModel
    extends DefaultTableModel {
        ShortcutKeyTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

