/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.util.Locale;
import java.util.ResourceBundle;

class SoundDefinition {
    public static final int MAX_SOUND_GROUP = 16;
    public static final int MAX_PERCUSSION_GROUP = 1;
    public static final int MAX_SOUND_INSTRUMENT = 128;
    public static final int MAX_PERCUSSION_INSTRUMENT = 47;
    public static final int MAX_CHANNEL = 16;
    public static final int SOUND_PER_GROUP = 8;
    public static final int GROUP_INDEX_UNSETTING = -1;
    public static final int GROUP_INDEX_PERCUSSION = 16;
    public static final String KEY_MODE = "MODE";
    public static final String KEY_SOUND_LIBRARY = "SOUNDLIB";
    public static final String KEY_DEVICE = "DEVICE";
    public static final String PREFIX_CHANNEL = "CH_";
    public static final String PREFIX_SOUND_GROUP = "SMG_";
    public static final String PREFIX_SOUND = "SM_";
    public static final String PREFIX_PERCUSSION_GROUP = "PMG_";
    public static final String PREFIX_PERCUSSION = "PM_";
    private String[] soundGroupInfo;
    private String[] instrumentInfo;
    private String[] percussionInfo;
    private String[][] soundDeviceInfo;
    private int soundDeviceNum;
    private String[][] soundLibInfo;
    private int soundLibNum;
    private final String NOT_SET = Resource.getString("SOUND_SETTING_UNSETTING");
    private final String NOT_DEFFINE = Resource.getString("SOUND_SETTING_UNDEFINED");

    public SoundDefinition() throws Exception {
        Locale locale = Locale.getDefault();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("sound", locale);
        this.soundGroupInfo = this.getSoundGroupAll(resourceBundle);
        this.instrumentInfo = this.getInstrumentAll(resourceBundle);
        this.percussionInfo = this.getPercussionAll(resourceBundle);
        this.setSoundDeviceInfo();
        this.setSoundLibInfo();
    }

    private String[] getSoundGroupAll(ResourceBundle resourceBundle) throws Exception {
        int n = 0;
        String[] stringArray = new String[18];
        stringArray[n++] = this.NOT_SET;
        int n2 = 0;
        while (n2 < 16) {
            try {
                stringArray[n] = resourceBundle.getString(PREFIX_SOUND_GROUP + n2);
                if (stringArray[n] == null || stringArray[n].equals("")) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                stringArray[n] = this.NOT_DEFFINE;
                throw exception;
            }
            ++n2;
            ++n;
        }
        n2 = 0;
        while (n2 < 1) {
            try {
                stringArray[n] = resourceBundle.getString(PREFIX_PERCUSSION_GROUP + n2);
                if (stringArray[n] == null || stringArray[n].equals("")) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                stringArray[n] = this.NOT_DEFFINE;
                throw exception;
            }
            ++n2;
            ++n;
        }
        return stringArray;
    }

    private String[] getInstrumentAll(ResourceBundle resourceBundle) throws Exception {
        String[] stringArray = new String[128];
        for (int i = 0; i < 128; ++i) {
            try {
                stringArray[i] = resourceBundle.getString(PREFIX_SOUND + i);
                if (stringArray[i] != null && !stringArray[i].equals("")) continue;
                throw new Exception();
            }
            catch (Exception exception) {
                stringArray[i] = this.NOT_DEFFINE;
                throw exception;
            }
        }
        return stringArray;
    }

    private String[] getPercussionAll(ResourceBundle resourceBundle) throws Exception {
        String[] stringArray = new String[47];
        for (int i = 0; i < 47; ++i) {
            try {
                stringArray[i] = resourceBundle.getString(PREFIX_PERCUSSION + i);
                if (stringArray[i] != null && !stringArray[i].equals("")) continue;
                throw new Exception();
            }
            catch (Exception exception) {
                stringArray[i] = this.NOT_DEFFINE;
                throw exception;
            }
        }
        return stringArray;
    }

    private void setSoundDeviceInfo() {
        this.soundDeviceNum = JAMManager.getSoundDeviceNum();
        if (this.soundDeviceNum > 0) {
            this.soundDeviceInfo = new String[this.soundDeviceNum][2];
            for (int i = 0; i < this.soundDeviceNum; ++i) {
                this.soundDeviceInfo[i][1] = new String(JAMManager.getSoundDeviceInfo(i, 1));
                this.soundDeviceInfo[i][0] = this.soundDeviceInfo[i][1] == null || this.soundDeviceInfo[i][1].equals("") ? Resource.getString("SOUND_SETTING_PRIMARY_DRIVER") : new String(JAMManager.getSoundDeviceInfo(i, 0));
            }
        } else {
            this.soundDeviceInfo = null;
        }
    }

    private void setSoundLibInfo() {
        this.soundLibNum = JAMManager.getSoundLibNum();
        if (this.soundLibNum > 0) {
            this.soundLibInfo = new String[this.soundLibNum][3];
            for (int i = 0; i < this.soundLibNum; ++i) {
                boolean bl = false;
                String string = new String(JAMManager.getSoundLibInfo(i, 0));
                if (string == null || string.equals("")) continue;
                this.soundLibInfo[i][0] = string;
                this.soundLibInfo[i][1] = new String(JAMManager.getSoundLibInfo(i, 1));
                if (this.soundLibInfo[i][1] == null || this.soundLibInfo[i][1].equals("")) {
                    this.soundLibInfo[i][1] = Resource.getString("SOUND_SETTING_SOUND_LIBRARY") + " " + this.soundLibInfo[i][0];
                }
                this.soundLibInfo[i][2] = new String(JAMManager.getSoundLibInfo(i, 2));
                if (this.soundLibInfo[i][2] != null && !this.soundLibInfo[i][2].equals("")) continue;
                this.soundLibInfo[i][2] = "0";
            }
        } else {
            this.soundLibInfo = null;
        }
    }

    public String[] getSoundDeviceName() {
        String[] stringArray = null;
        if (this.soundDeviceNum > 0) {
            stringArray = new String[this.soundDeviceNum];
            for (int i = 0; i < this.soundDeviceNum; ++i) {
                stringArray[i] = this.soundDeviceInfo[i][0];
            }
        }
        return stringArray;
    }

    public String[] getSoundDeviceGUID() {
        String[] stringArray = null;
        if (this.soundDeviceNum > 0) {
            stringArray = new String[this.soundDeviceNum];
            for (int i = 0; i < this.soundDeviceNum; ++i) {
                stringArray[i] = this.soundDeviceInfo[i][1];
            }
        }
        return stringArray;
    }

    public String[] getSoundLibName() {
        String[] stringArray = null;
        if (this.soundLibNum > 0 && this.soundLibInfo != null) {
            stringArray = new String[this.soundLibNum];
            for (int i = 0; i < this.soundLibNum; ++i) {
                stringArray[i] = this.soundLibInfo[i][1];
            }
        }
        return stringArray;
    }

    public String[] getSoundLibIndexString() {
        String[] stringArray = null;
        if (this.soundLibNum > 0 && this.soundLibInfo != null) {
            stringArray = new String[this.soundLibNum];
            for (int i = 0; i < this.soundLibNum; ++i) {
                stringArray[i] = this.soundLibInfo[i][0];
            }
        }
        return stringArray;
    }

    public int getSoundLibIndex(String string) {
        if (this.soundLibInfo != null) {
            for (int i = 0; i < this.soundLibNum; ++i) {
                if (!string.equals(this.soundLibInfo[i][0])) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean isUcsEnabled(int n) {
        boolean bl = false;
        if (this.soundLibNum > 0 && this.soundLibInfo != null && this.soundLibInfo[n][2].equals("1")) {
            bl = true;
        }
        return bl;
    }

    public String[] getInstrumentGropuInfo(int n) {
        String[] stringArray;
        if (n == -1) {
            stringArray = new String[this.instrumentInfo.length + this.percussionInfo.length + 1];
            stringArray[0] = this.NOT_SET;
            System.arraycopy(this.instrumentInfo, 0, stringArray, 1, this.instrumentInfo.length);
            System.arraycopy(this.percussionInfo, 0, stringArray, this.instrumentInfo.length + 1, this.percussionInfo.length);
        } else if (n == 16) {
            int n2 = n * 8;
            int n3 = n2 + 8;
            stringArray = new String[this.percussionInfo.length];
            System.arraycopy(this.percussionInfo, 0, stringArray, 0, stringArray.length);
        } else {
            int n4 = n * 8;
            int n5 = n4 + 8;
            stringArray = new String[8];
            System.arraycopy(this.instrumentInfo, n4, stringArray, 0, stringArray.length);
        }
        return stringArray;
    }

    public String getSoundGroupInfo(int n) {
        if (n == -1) {
            return this.NOT_SET;
        }
        return this.soundGroupInfo[n + 1];
    }

    public String[] getSoundGroupAll() {
        return this.soundGroupInfo;
    }

    public String getInstrumentInfo(int n, int n2) {
        String string = null;
        string = n == -1 ? this.NOT_SET : (n == 16 ? this.percussionInfo[n2] : this.instrumentInfo[n2]);
        return string;
    }
}

