/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.FeliCaFileFilter;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.HostInfoDocument;
import com.nttdocomo.dojaemu.ktoolbar.IniFileEntity;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import com.nttdocomo.dojaemu.ktoolbar.VirtualFeliCaEditWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class VirtualFeliCaSettingWindow
extends TabPanel
implements DocumentListener {
    private JPanel mainContainer = null;
    private JPanel serverSettingPanel = null;
    private JPanel listenSettingPanel = null;
    private JPanel chipSettingPanel = null;
    private JLabel felicaFilePathLabel = null;
    private JTextField felicaFilePathInfo = null;
    private JButton fileChooserButton = null;
    private JLabel chipVersionLabel = null;
    private JComboBox chipVersionList = null;
    private JPanel portPanel = null;
    private JLabel listenPortLabel = null;
    private JTextField listenPortInfo = null;
    private JPanel connectHostPanel = null;
    private JPanel connectPortPanel = null;
    private JLabel hostLabel = null;
    private JTextField hostInfo = null;
    private JLabel portLabel = null;
    private JTextField portInfo = null;
    private String fcFilePath;
    private final String[] VERSION_ITEMS = new String[2];
    private final int TAB_WIDTH = 350;
    private static final int TYPE_NOT_INPUT = 0;
    private static final int TYPE_INVALID_FORMAT = 1;
    private AbstractWindow tabwin;
    private static final String DEFAULT_PATH = "external.fc";
    private int emuFelicaDiv;
    private final int EXTERNAL_PORT = 28080;
    private JPanel nodeSettingPanel = null;
    private JPanel listPanel = null;
    private JButton addButton = null;
    private JButton editButton = null;
    private JButton delButton = null;
    private final int NODE_SETTING_PANEL_HEIGHT = 260;
    private final int LIST_SCROLL_PANE_WIDTH = 400;
    private final int LIST_SCROLL_PANE_HEIGHT = 150;
    private final int[] COLUMN_WIDTH = new int[]{85, 135, 1340};
    private final int NODE_CODE_COLUMN_MIN_WIDTH = 177;
    private final String SEC_NAME = "Entry ";
    private final String[] ITEM_KEY = new String[]{"system_code", "service_id", "node_code"};
    private final int MAX_NODE_CODE_COUNT = 100;
    private final int SYSTEM_CODE_LENGTH = 4;
    private final int SYSTEM_CODE_NUM = 1;
    private final int SERVIVE_ID_LENGTH = 8;
    private final int SERVIVE_ID_NUM = 2;
    private final int NODE_CODE_LENGTH = 8;
    private final int NODE_CODE_NUM = 20;
    private final String NODE_SETTING_FILE_PATH = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "locked_node_list.properties";
    private Vector compItemVector;
    private JTable scwTable;
    private SelectCompTblModel tableModel;
    private JScrollPane listScrollPane;
    private final String[] columnNames = new String[]{Resource.getString("SET_FELICA_SYSTEM_CODE"), Resource.getString("SET_FELICA_SERVICE_ID"), Resource.getString("SET_FELICA_NODE_CODE")};

    public VirtualFeliCaSettingWindow(AbstractWindow abstractWindow, int n) {
        super(abstractWindow);
        this.tabwin = abstractWindow;
        this.emuFelicaDiv = n;
        this.VERSION_ITEMS[0] = Resource.getString("SET_FELICA_CHIP_VER1");
        this.VERSION_ITEMS[1] = Resource.getString("SET_FELICA_CHIP_VER2");
        this.initialize();
        this.loadValue();
    }

    private void loadValue() {
        String string = "";
        this.hostInfo.setText(JAMManager.getFeliCaServerHost());
        int n = JAMManager.getFeliCaServerPort();
        if (n != -1) {
            string = "" + n;
        }
        this.portInfo.setText(string);
        n = JAMManager.getFeliCaListenPort();
        string = n != -1 ? "" + n : "";
        this.listenPortInfo.setText(string);
        if (this.emuFelicaDiv != 4) {
            this.fcFilePath = new String(JAMManager.getFeliCaDataFilePath());
            if (this.fcFilePath == null || "".equals(this.fcFilePath)) {
                this.fcFilePath = System.getProperty("emu.home") + File.separator + "lib" + File.separator + DEFAULT_PATH;
                String string2 = this.fcFilePath + '\u0000';
                JAMManager.setFeliCaDataFilePath(string2.getBytes());
            }
            this.felicaFilePathInfo.setText(this.fcFilePath);
            this.felicaFilePathInfo.getDocument().addDocumentListener(this);
        }
        if ((n = JAMManager.getFeliCaChipVersion()) == -1) {
            n = 0;
        }
        this.chipVersionList.setSelectedIndex(n);
        this.listenPortInfo.getDocument().addDocumentListener(this);
        this.hostInfo.getDocument().addDocumentListener(this);
        this.portInfo.getDocument().addDocumentListener(this);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    boolean set() {
        int n;
        int n2;
        Object object;
        int n3 = 0;
        boolean bl = true;
        if (JAMManager.getState() != 4) {
            this.parent.showDialog(Resource.getString("SET_FELICA_WNG_APP_RUNNING"), this.tabwin, 2);
            return false;
        }
        if (!this.doValidate()) {
            return false;
        }
        try {
            object = this.hostInfo.getText();
            n2 = Integer.parseInt(this.portInfo.getText());
            if (n2 == 28080) {
                this.parent.showDialog(Resource.format("PORT_ERR", this.portInfo.getText()), this, 2);
                return false;
            }
            n3 = JAMManager.setFeliCaServerInfo((String)object, n2);
            int n4 = Integer.parseInt(this.listenPortInfo.getText());
            if (this.emuFelicaDiv != 4) {
                String string = this.felicaFilePathInfo.getText() + '\u0000';
                n3 = JAMManager.setFeliCaDataFilePath(string.getBytes());
            }
            if (n4 == 28080) {
                this.parent.showDialog(Resource.format("PORT_ERR", this.listenPortInfo.getText()), this, 2);
                return false;
            }
            n3 = JAMManager.setFeliCaListenPort(n4);
            n = this.chipVersionList.getSelectedIndex();
            n3 = JAMManager.setFeliCaChipVersion(n);
            if (n3 != 0) {
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            this.parent.showDialog(Resource.getString("REGISTRY_ERR"), this, 0);
        }
        if (this.emuFelicaDiv != 4) {
            try {
                object = new IniFileEntity(this.NODE_SETTING_FILE_PATH);
                for (n2 = 0; n2 < this.compItemVector.size(); ++n2) {
                    String[] stringArray = (String[])this.compItemVector.get(n2);
                    for (n = 0; n < 3; ++n) {
                        ((IniFileEntity)object).setSectionAttribute("Entry " + (n2 + 1), this.ITEM_KEY[n], stringArray[n]);
                    }
                }
                ((IniFileEntity)object).save();
            }
            catch (Exception exception) {
                this.parent.showDialog(Resource.getString("SET_FELICA_NODE_WNG_WRITE_ERR"), this, 2);
                return false;
            }
        }
        return true;
    }

    private boolean doValidate() {
        String string = null;
        string = this.hostInfo.getText();
        if (!this.checkInput(string)) {
            this.showDialog(0);
            return false;
        }
        if (!VirtualFeliCaSettingWindow.checkHalf(string)) {
            this.showDialog(1);
            return false;
        }
        string = this.portInfo.getText();
        if (!this.checkInput(string)) {
            this.showDialog(0);
            return false;
        }
        if (!VirtualFeliCaSettingWindow.checkNumber(string)) {
            this.showDialog(1);
            return false;
        }
        string = this.listenPortInfo.getText();
        if (!this.checkInput(string)) {
            this.showDialog(0);
            return false;
        }
        if (!VirtualFeliCaSettingWindow.checkNumber(string)) {
            this.showDialog(1);
            return false;
        }
        if (this.emuFelicaDiv != 4 && !this.checkInput(string = this.felicaFilePathInfo.getText())) {
            this.showDialog(0);
            return false;
        }
        return true;
    }

    private void showDialog(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = Resource.getString("SET_FELICA_WNG_NOT_INPUT");
                break;
            }
            case 1: {
                string = Resource.getString("SET_FELICA_WNG_INVALID_INPUT");
                break;
            }
            default: {
                string = "";
            }
        }
        JOptionPane.showMessageDialog(this.tabwin, string, Resource.getString("WNG"), 2);
    }

    @Override
    void cancel() {
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainContainer(), "North");
    }

    private JPanel getMainContainer() {
        if (this.mainContainer == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.ipadx = 0;
            gridBagConstraints2.ipady = 0;
            gridBagConstraints2.gridheight = 1;
            gridBagConstraints2.anchor = 10;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.ipadx = 0;
            gridBagConstraints3.ipady = 0;
            gridBagConstraints3.anchor = 11;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.weightx = 0.5;
            gridBagConstraints3.gridwidth = 1;
            gridBagConstraints3.gridheight = 1;
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.ipadx = 0;
            gridBagConstraints4.ipady = 0;
            gridBagConstraints4.gridheight = 1;
            gridBagConstraints4.anchor = 10;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.weighty = 2.0;
            gridBagConstraints4.gridy = 3;
            this.mainContainer = new JPanel();
            this.mainContainer.setLayout(new GridBagLayout());
            this.mainContainer.add((Component)this.getServerSettingPanel(), gridBagConstraints3);
            this.mainContainer.add((Component)this.getListenSettingPanel(), gridBagConstraints2);
            this.mainContainer.add((Component)this.getChipSettingPanel(), gridBagConstraints);
            if (this.emuFelicaDiv != 4) {
                this.mainContainer.add((Component)this.getNodeSettingPanel(), gridBagConstraints4);
            }
        }
        return this.mainContainer;
    }

    private JPanel getServerSettingPanel() {
        if (this.serverSettingPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints.fill = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.gridwidth = 4;
            gridBagConstraints2.ipadx = 0;
            gridBagConstraints2.weightx = 0.1;
            gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints2.anchor = 17;
            this.serverSettingPanel = new JPanel();
            this.serverSettingPanel.setLayout(new GridBagLayout());
            if (this.emuFelicaDiv == 4) {
                this.serverSettingPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getString("SET_FELICA_ADHOC_CLIENT_TITLE"), 0, 0, null, null));
            } else {
                this.serverSettingPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getString("SET_FELICA_EXT_ADHOC_CLIENT_TITLE"), 0, 0, null, null));
                this.serverSettingPanel.setPreferredSize(new Dimension(350, 100));
            }
            this.serverSettingPanel.add((Component)this.getConnectHostPanel(), gridBagConstraints2);
            this.serverSettingPanel.add((Component)this.getConnectPortPanel(), gridBagConstraints);
        }
        return this.serverSettingPanel;
    }

    private JPanel getListenSettingPanel() {
        if (this.listenSettingPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints.anchor = 17;
            if (this.emuFelicaDiv == 4) {
                gridBagConstraints.ipadx = 350;
            }
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.insets = new Insets(0, 2, 2, 2);
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridwidth = 3;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 2;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints4.weightx = 1.0;
            this.felicaFilePathLabel = new JLabel();
            this.felicaFilePathLabel.setText(Resource.getString("SET_FELICA_EXT_ADHOC_SERVER_FILEPATH"));
            this.listenSettingPanel = new JPanel();
            this.listenSettingPanel.setLayout(new GridBagLayout());
            if (this.emuFelicaDiv == 4) {
                this.listenSettingPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getString("SET_FELICA_ADHOC_SERVER_TITLE"), 0, 0, null, null));
            } else {
                this.listenSettingPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getString("SET_FELICA_EXT_ADHOC_SERVER_TITLE"), 0, 0, null, null));
                this.listenSettingPanel.setPreferredSize(new Dimension(350, 100));
            }
            if (this.emuFelicaDiv != 4) {
                this.listenSettingPanel.add((Component)this.felicaFilePathLabel, gridBagConstraints3);
                this.listenSettingPanel.add((Component)this.getFelicaFilePathInfo(), gridBagConstraints4);
                this.listenSettingPanel.add((Component)this.getFileChooserButton(), gridBagConstraints2);
            }
            this.listenSettingPanel.add((Component)this.getPortPanel(), gridBagConstraints);
        }
        return this.listenSettingPanel;
    }

    private JPanel getChipSettingPanel() {
        if (this.chipSettingPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 3, 5, 56);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(0, 5, 0, 2);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.anchor = 10;
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.gridx = 0;
            this.chipVersionLabel = new JLabel();
            this.chipVersionLabel.setText(Resource.getString("SET_FELICA_CHIP_VERSION"));
            this.chipSettingPanel = new JPanel();
            this.chipSettingPanel.setLayout(new GridBagLayout());
            this.chipSettingPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getString("SET_FELICA_CHIPSET_TITLE"), 0, 0, null, null));
            this.chipSettingPanel.setPreferredSize(new Dimension(350, 61));
            this.chipSettingPanel.add((Component)this.chipVersionLabel, gridBagConstraints2);
            this.chipSettingPanel.add((Component)this.getChipVersionList(), gridBagConstraints);
        }
        return this.chipSettingPanel;
    }

    private JTextField getFelicaFilePathInfo() {
        if (this.felicaFilePathInfo == null) {
            this.felicaFilePathInfo = new JTextField();
            this.felicaFilePathInfo.setColumns(22);
        }
        return this.felicaFilePathInfo;
    }

    private JButton getFileChooserButton() {
        if (this.fileChooserButton == null) {
            this.fileChooserButton = new JButton();
            this.fileChooserButton.setText(Resource.getString("SET_FELICA_EXT_ADHOC_SERVER_REF_BUTTON"));
            this.fileChooserButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser(new File(VirtualFeliCaSettingWindow.this.fcFilePath).getParent());
                    jFileChooser.setDialogTitle(Resource.getString("FELICA_DATAFILE_DIALOG"));
                    jFileChooser.setDialogType(0);
                    jFileChooser.setFileSelectionMode(2);
                    jFileChooser.setFileFilter(new FeliCaFileFilter());
                    jFileChooser.setMultiSelectionEnabled(false);
                    int n = jFileChooser.showOpenDialog(VirtualFeliCaSettingWindow.this);
                    if (n == 0) {
                        VirtualFeliCaSettingWindow.this.felicaFilePathInfo.setText(jFileChooser.getSelectedFile().toString());
                    }
                }
            });
        }
        return this.fileChooserButton;
    }

    private JPanel getNodeSettingPanel() {
        if (this.nodeSettingPanel == null) {
            this.nodeSettingPanel = new JPanel();
            this.nodeSettingPanel.setLayout(new BoxLayout(this.nodeSettingPanel, 1));
            this.nodeSettingPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getString("SET_FELICA_NODE_LIST_TITLE"), 0, 0, null, null));
            this.nodeSettingPanel.setPreferredSize(new Dimension(350, 260));
            this.nodeSettingPanel.add("Center", this.getListPanel());
            this.nodeSettingPanel.add("South", this.getButtonPanel());
        }
        return this.nodeSettingPanel;
    }

    private JPanel getListPanel() {
        if (this.listPanel == null) {
            this.listPanel = new JPanel();
            this.listPanel.setLayout(new FlowLayout(1));
            this.compItemVector = this.getNodeSetting();
            this.setList();
        }
        return this.listPanel;
    }

    private JTable createComponetTable() {
        this.tableModel = new SelectCompTblModel();
        this.scwTable = new JTable(this.tableModel);
        this.scwTable.getTableHeader().setReorderingAllowed(false);
        this.scwTable.getTableHeader().setResizingAllowed(false);
        this.scwTable.setDefaultRenderer(Object.class, new SelectCompTblRenderer());
        this.scwTable.setSelectionMode(0);
        this.scwTable.getTableHeader().setDefaultRenderer(new HeaderRenderer(this.scwTable.getTableHeader().getDefaultRenderer()));
        for (int i = 0; i < this.columnNames.length; ++i) {
            TableColumn tableColumn = this.scwTable.getColumnModel().getColumn(i);
            tableColumn.setPreferredWidth(this.COLUMN_WIDTH[i]);
            tableColumn.setResizable(false);
        }
        this.scwTable.setShowGrid(false);
        this.scwTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    VirtualFeliCaSettingWindow.this.edit();
                }
            }
        });
        this.scwTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    VirtualFeliCaSettingWindow.this.edit();
                }
            }
        });
        return this.scwTable;
    }

    private Vector getNodeSetting() {
        IniFileEntity iniFileEntity = new IniFileEntity(this.NODE_SETTING_FILE_PATH);
        try {
            iniFileEntity.read();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                System.err.println(Resource.format("READ_ERR", iniFileEntity.getName()));
            }
            if (exception instanceof FileNotFoundException) {
                IniFileEntity iniFileEntity2 = new IniFileEntity(this.NODE_SETTING_FILE_PATH);
                try {
                    iniFileEntity2.save();
                    iniFileEntity = iniFileEntity2;
                }
                catch (IOException iOException) {
                    System.err.println(Resource.format("WRITE_ERR", iniFileEntity.getName()));
                }
            }
            return new Vector();
        }
        Vector<String[]> vector = new Vector<String[]>();
        for (int i = 0; i < 100; ++i) {
            String string = "Entry " + (i + 1);
            if (iniFileEntity.getSection(string) == null) continue;
            String[] stringArray = new String[this.columnNames.length];
            stringArray[0] = iniFileEntity.getSectionAttribute(string, this.ITEM_KEY[0]);
            stringArray[1] = iniFileEntity.getSectionAttribute(string, this.ITEM_KEY[1]);
            stringArray[2] = iniFileEntity.getSectionAttribute(string, this.ITEM_KEY[2]);
            if (!this.valueCheck(stringArray[0], 4, 1) || !this.valueCheck(stringArray[1], 8, 2) || !this.valueCheck(stringArray[2], 8, 20)) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                String string2 = "";
                String[] stringArray2 = stringArray[j].split(",");
                for (int k = 0; k < stringArray2.length; ++k) {
                    string2 = string2 + stringArray2[k].trim();
                    if (k >= stringArray2.length - 1) continue;
                    string2 = string2 + ",";
                }
                stringArray[j] = string2;
            }
            vector.addElement(stringArray);
        }
        return vector;
    }

    private boolean valueCheck(String string, int n, int n2) {
        int n3 = (n + ",".length()) * n2 - ",".length();
        if (string == null || string.equals("")) {
            return false;
        }
        String[] stringArray = string.split(",");
        if (stringArray.length > n2) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
            if (stringArray[i].length() != n) {
                return false;
            }
            try {
                Long.parseLong(stringArray[i], 16);
                continue;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    private JPanel getButtonPanel() {
        JButton jButton = new JButton(Resource.getString("ADD"));
        JButton jButton2 = new JButton(Resource.getString("EDIT"));
        JButton jButton3 = new JButton(Resource.getString("DELETE"));
        jButton.setActionCommand("add");
        jButton2.setActionCommand("edit");
        jButton3.setActionCommand("del");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jButton3.addActionListener(actionDispatcher);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        return jPanel;
    }

    private void setList() {
        this.scwTable = this.createComponetTable();
        this.scwTable.setAutoResizeMode(0);
        this.listScrollPane = new JScrollPane(this.scwTable);
        this.listScrollPane.setVerticalScrollBarPolicy(20);
        this.listScrollPane.setHorizontalScrollBarPolicy(30);
        if (this.compItemVector.size() > 0) {
            this.scwTable.getColumnModel().getColumn(2).setMinWidth(this.COLUMN_WIDTH[2]);
            this.scwTable.getColumnModel().getColumn(2).setMaxWidth(this.COLUMN_WIDTH[2]);
        } else {
            this.scwTable.getColumnModel().getColumn(2).setMinWidth(177);
            this.scwTable.getColumnModel().getColumn(2).setMaxWidth(177);
        }
        this.listScrollPane.setPreferredSize(new Dimension(400, 150));
        this.listPanel.add(this.listScrollPane);
        this.listPanel.updateUI();
    }

    void add() {
        if (this.compItemVector.size() >= 100) {
            return;
        }
        String[] stringArray = new String[this.columnNames.length];
        stringArray[0] = "";
        stringArray[1] = "";
        stringArray[2] = "";
        VirtualFeliCaEditWindow virtualFeliCaEditWindow = new VirtualFeliCaEditWindow(Resource.getString("SET_FELICA_NODE_LIST_ADD_TITLE"), this.parent, stringArray);
        virtualFeliCaEditWindow.setLocation(this.parent.getShowLocation(virtualFeliCaEditWindow.getWidth(), virtualFeliCaEditWindow.getHeight(), this.tabwin));
        if (!virtualFeliCaEditWindow.showWindow()) {
            return;
        }
        this.compItemVector.addElement(stringArray);
        int n = this.compItemVector.size() - 1;
        this.listPanel.remove(this.listScrollPane);
        this.listScrollPane = null;
        this.scwTable = null;
        this.setList();
        this.scwTable.setRowSelectionInterval(n, n);
        JScrollBar jScrollBar = this.listScrollPane.getVerticalScrollBar();
        JViewport jViewport = this.listScrollPane.getViewport();
        Point point = new Point(0, this.compItemVector.size() * this.scwTable.getRowHeight());
        jViewport.setViewPosition(point);
        this.listener.tabPanelEvent(this, 1, 0);
    }

    void edit() {
        int n = this.scwTable.getSelectedRow();
        if (n == -1 || n > this.compItemVector.size()) {
            return;
        }
        String[] stringArray = (String[])this.compItemVector.get(n);
        String[] stringArray2 = new String[this.columnNames.length];
        stringArray2[0] = "" + stringArray[0];
        stringArray2[1] = "" + stringArray[1];
        stringArray2[2] = "" + stringArray[2];
        VirtualFeliCaEditWindow virtualFeliCaEditWindow = new VirtualFeliCaEditWindow(Resource.getString("SET_FELICA_NODE_LIST_EDIT_TITLE"), this.parent, stringArray2);
        virtualFeliCaEditWindow.setLocation(this.parent.getShowLocation(virtualFeliCaEditWindow.getWidth(), virtualFeliCaEditWindow.getHeight(), this.tabwin));
        if (!virtualFeliCaEditWindow.showWindow()) {
            return;
        }
        String[] stringArray3 = (String[])this.compItemVector.get(n);
        stringArray3[0] = stringArray2[0];
        stringArray3[1] = stringArray2[1];
        stringArray3[2] = stringArray2[2];
        this.listPanel.remove(this.listScrollPane);
        this.listScrollPane = null;
        this.scwTable = null;
        this.setList();
        this.scwTable.setRowSelectionInterval(n, n);
        JViewport jViewport = this.listScrollPane.getViewport();
        Point point = new Point(0, n * this.scwTable.getRowHeight());
        jViewport.setViewPosition(point);
        this.listener.tabPanelEvent(this, 1, 0);
    }

    void del() {
        int n = this.scwTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        this.compItemVector.removeElementAt(n);
        this.listPanel.remove(this.listScrollPane);
        this.listScrollPane = null;
        this.scwTable = null;
        this.setList();
        if (this.compItemVector.size() > 0) {
            if (this.compItemVector.size() < n + 1) {
                n = this.compItemVector.size() - 1;
            }
            this.scwTable.setRowSelectionInterval(n, n);
            JViewport jViewport = this.listScrollPane.getViewport();
            Point point = new Point(0, n * this.scwTable.getRowHeight());
            jViewport.setViewPosition(point);
        }
        this.listener.tabPanelEvent(this, 1, 0);
    }

    private JComboBox getChipVersionList() {
        if (this.chipVersionList == null) {
            this.chipVersionList = new JComboBox<String>(this.VERSION_ITEMS);
            this.chipVersionList.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
            this.chipVersionList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (VirtualFeliCaSettingWindow.this.listener != null) {
                        VirtualFeliCaSettingWindow.this.listener.tabPanelEvent(VirtualFeliCaSettingWindow.this, 1, 0);
                    }
                }
            });
        }
        return this.chipVersionList;
    }

    private JPanel getPortPanel() {
        if (this.portPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.listenPortLabel = new JLabel();
            this.listenPortLabel.setText(Resource.getString("SET_FELICA_EXT_ADHOC_SERVER_PORT"));
            this.portPanel = new JPanel();
            this.portPanel.setLayout(flowLayout);
            this.portPanel.add((Component)this.listenPortLabel, null);
            this.portPanel.add((Component)this.getListenPortInfo(), null);
        }
        return this.portPanel;
    }

    private JTextField getListenPortInfo() {
        if (this.listenPortInfo == null) {
            this.listenPortInfo = new JTextField();
            this.listenPortInfo.setColumns(5);
            this.listenPortInfo.setDocument(new HalfNumberDocument(5));
        }
        return this.listenPortInfo;
    }

    private JPanel getConnectHostPanel() {
        if (this.connectHostPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.hostLabel = new JLabel();
            this.hostLabel.setText(Resource.getString("SET_FELICA_EXT_ADHOC_CLIENT_HOST"));
            this.connectHostPanel = new JPanel();
            this.connectHostPanel.setLayout(flowLayout);
            this.connectHostPanel.setPreferredSize(new Dimension(200, 30));
            this.connectHostPanel.add((Component)this.hostLabel, null);
            this.connectHostPanel.add((Component)this.getHostInfo(), null);
        }
        return this.connectHostPanel;
    }

    private JPanel getConnectPortPanel() {
        if (this.connectPortPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.portLabel = new JLabel();
            this.portLabel.setText(Resource.getString("SET_FELICA_EXT_ADHOC_CLIENT_PORT"));
            this.connectPortPanel = new JPanel();
            this.connectPortPanel.setLayout(flowLayout);
            this.connectPortPanel.setPreferredSize(new Dimension(200, 30));
            this.connectPortPanel.add((Component)this.portLabel, null);
            this.connectPortPanel.add((Component)this.getPortInfo(), null);
        }
        return this.connectPortPanel;
    }

    private JTextField getHostInfo() {
        if (this.hostInfo == null) {
            this.hostInfo = new JTextField();
            this.hostInfo.setDocument(new HostInfoDocument(255));
            this.hostInfo.setColumns(15);
        }
        return this.hostInfo;
    }

    private JTextField getPortInfo() {
        if (this.portInfo == null) {
            this.portInfo = new JTextField();
            this.portInfo.setColumns(5);
            this.portInfo.setDocument(new HalfNumberDocument(5));
        }
        return this.portInfo;
    }

    private static boolean checkNumber(String string) {
        boolean bl = false;
        try {
            int n = Integer.parseInt(string);
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bl;
    }

    private static boolean checkHalf(String string) {
        byte[] byArray = string.getBytes();
        int n = string.length();
        return n == byArray.length;
    }

    public boolean checkInput(String string) {
        String string2;
        boolean bl = false;
        if (!(string == null && "".equals(string) || (string2 = string.trim()).equals(""))) {
            bl = true;
        }
        return bl;
    }

    public class LimitedDocument
    extends PlainDocument {
        int limit;

        LimitedDocument(int n) {
            this.limit = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) {
            if (this.getLength() >= this.limit) {
                return;
            }
            try {
                super.insertString(n, string, attributeSet);
            }
            catch (BadLocationException badLocationException) {
                System.out.println(badLocationException);
            }
        }
    }

    class SelectCompTblRenderer
    extends JLabel
    implements TableCellRenderer {
        SelectCompTblRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            this.setToolTipText((String)object);
            return this;
        }
    }

    class HeaderRenderer
    implements TableCellRenderer {
        private final TableCellRenderer tcr;

        public HeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tcr = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)this.tcr.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setHorizontalAlignment(2);
            return jLabel;
        }
    }

    class SelectCompTblModel
    extends AbstractTableModel
    implements TableModelListener {
        SelectCompTblModel() {
            this.addTableModelListener(this);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public int getRowCount() {
            return VirtualFeliCaSettingWindow.this.compItemVector != null ? VirtualFeliCaSettingWindow.this.compItemVector.size() : 0;
        }

        @Override
        public int getColumnCount() {
            return VirtualFeliCaSettingWindow.this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            if (n < VirtualFeliCaSettingWindow.this.columnNames.length) {
                return VirtualFeliCaSettingWindow.this.columnNames[n];
            }
            return null;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < VirtualFeliCaSettingWindow.this.compItemVector.size()) {
                String[] stringArray = (String[])VirtualFeliCaSettingWindow.this.compItemVector.get(n);
                return stringArray[n2];
            }
            return new Object();
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            String[] stringArray = (String[])VirtualFeliCaSettingWindow.this.compItemVector.get(n);
            stringArray[n2] = (String)object;
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = tableModelEvent.getColumn();
            int n2 = tableModelEvent.getLastRow();
            if (n2 < VirtualFeliCaSettingWindow.this.compItemVector.size()) {
                String[] stringArray = (String[])VirtualFeliCaSettingWindow.this.compItemVector.get(n2);
            }
        }
    }
}

