/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.classFileStructure;

import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.Attribute;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.Code;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.JavaClass;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.LocalVariableTable;
import java.util.Vector;

public class Method {
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_PRIVATE = 2;
    private static final int ACC_PROTECTED = 4;
    private static final int ACC_STATIC = 8;
    private static final int ACC_FINAL = 16;
    private static final int ACC_SYNCHRONIZED = 32;
    private static final int ACC_NATIVE = 256;
    private static final int ACC_ABSTRACT = 1024;
    private static final int ACC_STRICT = 2048;
    private int accessFlag = 0;
    private int nameIndex = 0;
    private int descriptorIndex = 0;
    private int attributeCount = 0;
    private Attribute[] attributes = null;
    private JavaClass jc = null;

    private Method() {
    }

    Method(JavaClass javaClass) {
        this.jc = javaClass;
        this.accessFlag = this.jc.getInt(2);
        this.nameIndex = this.jc.getInt(2);
        this.descriptorIndex = this.jc.getInt(2);
        this.attributeCount = this.jc.getInt(2);
        this.attributes = new Attribute[this.attributeCount];
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i] = new Attribute(this.jc);
        }
    }

    public Code getCodes() {
        if (0 >= this.attributeCount) {
            return null;
        }
        for (int i = 0; i < this.attributeCount; ++i) {
            if (!this.attributes[i].isCodeAttribute()) continue;
            return this.attributes[i].getCodeAttribute();
        }
        return null;
    }

    public String getMethodName(boolean bl) {
        String string = this.jc.getConstantPoolInfo(this.nameIndex);
        if (bl) {
            return string;
        }
        if (0 <= string.indexOf("<init>")) {
            String string2 = this.jc.getClassName();
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.replace(string.indexOf("<init>"), string.indexOf("<init>") + 6, string2.substring(string2.lastIndexOf("/") + 1));
            string = stringBuffer.toString();
        } else if (0 <= string.indexOf("<clinit>")) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.delete(string.indexOf("<clinit>"), string.indexOf("<clinit>") + 8);
            string = stringBuffer.toString();
        }
        return string;
    }

    public String getDescriptor(boolean bl) {
        String string = this.jc.getConstantPoolInfo(this.descriptorIndex);
        if (bl) {
            return string;
        }
        return this.jc.getDescriptorSourceCode(string);
    }

    public String getMethodSignature() {
        String string = this.getMethodName(true);
        String string2 = this.getMethodName(false);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getAccessLevel());
        if (string.equals(string2)) {
            if (0 < stringBuffer.length()) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.getReturnType());
            if (0 < stringBuffer.length()) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string2);
            stringBuffer.append("(" + this.getParameter() + ")");
        } else {
            if (0 < stringBuffer.length()) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string2);
            if (0 < string2.length()) {
                stringBuffer.append("(" + this.getParameter() + ")");
            }
        }
        return stringBuffer.toString();
    }

    private String getAccessLevel() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.checkPermissions(1)) {
            stringBuffer.append("public");
        }
        if (this.checkPermissions(2)) {
            if (0 < stringBuffer.length()) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("private");
        }
        if (this.checkPermissions(4)) {
            if (0 < stringBuffer.length()) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("protected");
        }
        if (this.checkPermissions(8)) {
            if (0 < stringBuffer.length()) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("static");
        }
        if (this.checkPermissions(16)) {
            if (0 < stringBuffer.length()) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("final");
        }
        if (this.checkPermissions(32)) {
            if (0 < stringBuffer.length()) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("synchronized");
        }
        if (this.checkPermissions(256)) {
            if (0 < stringBuffer.length()) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("native");
        }
        if (this.checkPermissions(1024)) {
            if (0 < stringBuffer.length()) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("abstract");
        }
        if (this.checkPermissions(2048)) {
            if (0 < stringBuffer.length()) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("strictfp");
        }
        return stringBuffer.toString();
    }

    private boolean checkPermissions(int n) {
        return (this.accessFlag & n) == n;
    }

    public boolean isAbstract() {
        return this.checkPermissions(1024);
    }

    public boolean isNative() {
        return this.checkPermissions(256);
    }

    private String getReturnType() {
        String string = this.getDescriptor(true);
        int n = string.lastIndexOf(")");
        string = string.substring(++n);
        return this.jc.getDescriptorSourceCode(string);
    }

    private String getParameter() {
        String[] stringArray = this.getParameterList();
        if (0 == stringArray.length) {
            String string = this.getDescriptor(false);
            int n = string.lastIndexOf(41);
            return string.substring(1, n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (0 != stringBuffer.length()) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[n++]);
            stringBuffer.append(" ");
            stringBuffer.append(stringArray[n++]);
        }
        return stringBuffer.toString();
    }

    private String[] getParameterList() {
        Vector<String> vector = new Vector<String>();
        Attribute attribute = null;
        LocalVariableTable[] localVariableTableArray = null;
        Code code = null;
        String string = null;
        for (int i = 0; i < this.attributeCount; ++i) {
            attribute = this.attributes[i];
            if (!attribute.isCodeAttribute()) continue;
            code = attribute.getCodeAttribute();
            for (int j = 0; j < code.getAttributeCount(); ++j) {
                attribute = code.getAttributes()[j];
                if (!attribute.isLocalVariableTable()) continue;
                localVariableTableArray = attribute.getLocalVariableTable();
                for (int k = 0; k < attribute.getLocalVariableTableLength(); ++k) {
                    if (0 != localVariableTableArray[k].getStartPc() || 0 == localVariableTableArray[k].getIndex()) continue;
                    string = this.jc.getConstantPoolInfo(localVariableTableArray[k].getDescriptorIndex());
                    vector.add(this.jc.getDescriptorSourceCode(string));
                    string = this.jc.getConstantPoolInfo(localVariableTableArray[k].getNameIndex());
                    vector.add(string);
                }
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public boolean isSynthetic() {
        for (int i = 0; i < this.attributeCount; ++i) {
            if (!this.attributes[i].isSynthetic()) continue;
            return true;
        }
        return false;
    }
}

