/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica;

import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipFactory;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipNode;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipNodeException;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewBase;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewBlockInfoArea;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewButtonListener;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewNodeCodeTree;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewWindowAdapter;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewerWindow;
import com.nttdocomo.dojaemu.ktoolbar.felica.NodeCode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FaverChipViewHierarchy
extends FaverChipViewBase {
    private MainWindow parent;
    private FaverChipViewNodeCodeTree nodeList;
    private FaverChipViewBlockInfoArea blockInfo;
    private FaverChipNode fcd;
    private int felicaEmuDiv;
    private String chipVersion;
    private File fcFile = null;
    private JButton updateButton;
    private JButton reloadButton;
    private JButton closeButton;
    private JButton changeButton;

    public FaverChipViewHierarchy(MainWindow mainWindow, File file, int n, int n2, int n3) throws FileNotFoundException, IOException {
        this.parent = mainWindow;
        this.fcFile = file;
        this.felicaEmuDiv = n;
        this.chipVersion = n2 == 1 ? "ver20" : "ver10";
        this.nodeList = FaverChipFactory.createTree(this.chipVersion, this);
        this.blockInfo = FaverChipFactory.createInfoArea(this.chipVersion, this);
        this.addWindowListener(new FaverChipViewWindowAdapter(this));
        this.fcd = FaverChipFactory.create(file, this.chipVersion, n, 1);
        this.createPane();
        this.updateTree();
        this.nodeList.expandAll();
        NodeCode nodeCode = this.fcd.getInitialNode(n3);
        this.selectTreeNode(nodeCode);
    }

    private void createPane() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.nodeList);
        JScrollPane jScrollPane2 = new JScrollPane(this.blockInfo);
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setTopComponent(jScrollPane);
        jSplitPane.setBottomComponent(jScrollPane2);
        jSplitPane.setDividerLocation(0.3);
        jSplitPane.setResizeWeight(0.3);
        this.setTitle(Resource.getString("FC_WINDOW_TITLE") + " - " + this.fcFile.getName());
        this.changeButton = new JButton(Resource.getString("SWITCH_VIEWER"));
        this.updateButton = new JButton(Resource.getString("UPDATE"));
        this.reloadButton = new JButton(Resource.getString("RELOAD"));
        this.closeButton = new JButton(Resource.getString("CLOSE"));
        this.changeButton.setActionCommand("change");
        this.updateButton.setActionCommand("update");
        this.reloadButton.setActionCommand("reload");
        this.closeButton.setActionCommand("close");
        JPanel jPanel = new JPanel();
        jPanel.add(this.changeButton);
        jPanel.add(this.updateButton);
        jPanel.add(this.reloadButton);
        jPanel.add(this.closeButton);
        container.add("Center", jSplitPane);
        container.add("South", jPanel);
        FaverChipViewButtonListener faverChipViewButtonListener = new FaverChipViewButtonListener(this);
        this.updateButton.addActionListener(faverChipViewButtonListener);
        this.reloadButton.addActionListener(faverChipViewButtonListener);
        this.closeButton.addActionListener(faverChipViewButtonListener);
        this.changeButton.addActionListener(faverChipViewButtonListener);
        this.pack();
        this.setSize(600, 400);
    }

    private DefaultMutableTreeNode serchNode(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!defaultMutableTreeNode2.getUserObject().toString().equals(string)) continue;
            return defaultMutableTreeNode2;
        }
        return null;
    }

    public void selectTreeNode(NodeCode nodeCode) {
        Object[] objectArray;
        if (nodeCode.getNodeCodeType() == 1) {
            this.nodeList.setSelectionRow(0);
            return;
        }
        NodeCode nodeCode2 = nodeCode;
        Vector<Object> vector = new Vector<Object>();
        vector.add(nodeCode.getNodeCodeString());
        while ((nodeCode2 = (NodeCode)nodeCode2.getParent()) != null && !(objectArray = nodeCode2.getNodeCodeString()).equals("card")) {
            vector.add(objectArray);
        }
        objectArray = new Object[vector.size()];
        int n = objectArray.length - 1;
        int n2 = 0;
        while (n >= 0) {
            objectArray[n2] = vector.elementAt(n);
            --n;
            ++n2;
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.nodeList.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = 0; i < objectArray.length; ++i) {
            defaultMutableTreeNode = defaultMutableTreeNode2 = this.serchNode(defaultMutableTreeNode, objectArray[i].toString().toUpperCase());
        }
        this.nodeList.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
    }

    public void updateTree() {
        this.nodeList.saveExpand();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.nodeList.getModel();
        String string = this.fcd.getRootNodeCode().getNodeCodeString();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        this.nodeList.createNodes(defaultMutableTreeNode, this.fcd);
        defaultTreeModel.setRoot(defaultMutableTreeNode);
        this.nodeList.expand();
    }

    public boolean isNewNode() {
        return this.nodeList.isNewNode();
    }

    public boolean updateTreeNode(NodeCode nodeCode) {
        try {
            this.blockInfo.update(this.fcd);
        }
        catch (FaverChipNodeException faverChipNodeException) {
            this.showDialog(this, faverChipNodeException.getMessage());
            return false;
        }
        catch (Exception exception) {
            this.showDialog(this, Resource.getString("FC_ERR_DATA_BREAKS"));
            return false;
        }
        this.blockInfo.changeInfo(nodeCode);
        return true;
    }

    public boolean checkTreeNode() {
        try {
            this.blockInfo.check(this.fcd);
        }
        catch (FaverChipNodeException faverChipNodeException) {
            this.showDialog(this, faverChipNodeException.getMessage());
            return false;
        }
        catch (Exception exception) {
            this.showDialog(this, Resource.getString("FC_ERR_DATA_BREAKS"));
            return false;
        }
        return true;
    }

    public boolean isEmulatorGen() {
        return this.felicaEmuDiv == 4;
    }

    public void showDialog(Component component, String string) {
        JOptionPane jOptionPane = new JOptionPane(string, 2);
        if (component == null) {
            component = this;
        }
        JDialog jDialog = jOptionPane.createDialog(component, Resource.getString("WNG"));
        jDialog.setResizable(false);
        jDialog.setVisible(true);
    }

    int showQuestionDialog(Component component, String string) {
        Object[] objectArray = new Object[]{Resource.getString("OK"), Resource.getString("CANCEL")};
        JOptionPane jOptionPane = new JOptionPane(string, 3, 2, null, objectArray);
        if (component == null) {
            component = this;
        }
        JDialog jDialog = jOptionPane.createDialog(component, Resource.getString("CONFIRM"));
        jDialog.setResizable(false);
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object != null) {
            if (object.toString().equals(objectArray[0].toString())) {
                return 0;
            }
            return 2;
        }
        return 2;
    }

    @Override
    public void close() {
        this.parent.closeWindow(this);
    }

    @Override
    public void reload() {
        this.nodeList.enabledSelectionListener(false);
        try {
            this.fcd = FaverChipFactory.create(this.fcFile, this.chipVersion, this.felicaEmuDiv, 1);
        }
        catch (Exception exception) {
            this.showDialog(this, Resource.getString("FC_READ_ERR"));
            this.nodeList.enabledSelectionListener(true);
            return;
        }
        this.updateTree();
        this.nodeList.reset();
        NodeCode nodeCode = this.fcd.getRootNodeCode();
        this.selectTreeNode(nodeCode);
        this.blockInfo.changeInfo(nodeCode);
        this.nodeList.enabledSelectionListener(true);
    }

    @Override
    public void update() {
        int[] nArray = this.nodeList.getSelectionRows();
        if (this.isNewNode()) {
            if (!this.checkTreeNode()) {
                return;
            }
            this.updateTree();
            this.nodeList.reset();
        } else {
            try {
                this.blockInfo.update(this.fcd);
            }
            catch (FaverChipNodeException faverChipNodeException) {
                this.showDialog(this, faverChipNodeException.getMessage());
                return;
            }
            catch (Exception exception) {
                this.showDialog(this, Resource.getString("FCH_MSG_FAILED_UPDATE"));
                return;
            }
            this.updateTree();
        }
        try {
            this.fcd.save();
            this.showDialog(this, Resource.getString("FCH_MSG_SUCCESS_UPDATE"));
        }
        catch (Exception exception) {
            this.showDialog(this, Resource.getString("FCH_MSG_FAILED_UPDATE"));
        }
        int[] nArray2 = this.nodeList.getSelectionRows();
        if (nArray2 == null || nArray2.length == 0) {
            if (nArray == null || nArray.length == 0) {
                this.nodeList.setSelectionRow(0);
            } else {
                this.nodeList.setSelectionRow(nArray[0]);
            }
            return;
        }
        this.nodeList.setSelectionRow(nArray2[0]);
        this.nodeList.scrollRowToVisible(nArray2[0]);
    }

    @Override
    public void change() {
        try {
            FaverChipViewerWindow.changeWindow(this, this.nodeList.currentNodeBlockPos());
        }
        catch (Exception exception) {
            this.showDialog(this, Resource.getString("FCH_MSG_FAILED_CHANGE_VIEW"));
        }
    }
}

