/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica.ver10;

import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipData;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewerBlock;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewerLabelInfo;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver10.FaverChipCheck;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver10.ViewerBlock;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class FaverChipDataCon
extends FaverChipData {
    final int REAL_DATA_SIZE = 5120;
    final int MANAGEMENT_SIZE = 1280;
    final int BEGIN_EDIT_AREA = 64;
    final int END_EDIT_AREA = 4575;
    final boolean ENABLE_RIGTH_CLICK = true;
    FaverChipCheck fcc;
    private String[] blockName = new String[]{"IDm (Shared area)", "PMm (Shared area)", "IDi (Shared area)", "PMi (Shared area)", "System define block (Shared area)", "Area define block (Shared area)", "Shared area", "IDm (Free area)", "PMm (Free area)", "IDi (Free area)", "PMi (Free area)", "System define block (Free area)", "Area define block (Free area)", "Area define block (Free area 0001)", "Service block 1 (Free area 0001)", "CPID data block (Free area 0001)", "Service block 2 (Free area 0001)", "Data block 0 (Free area 0001)", "Data block 1 (Free area 0001)", "Data block 2 (Free area 0001)", "Data block 3 (Free area 0001)", "PIN service block (Free area 0001)", "PIN data block (Free area 0001)", "Area define block (Free area 0002)", "Service block 1 (Free area 0002)", "CPID data block (Free area 0002)", "Service block 2 (Free area 0002)", "Data block 0 (Free area 0002)", "Data block 1 (Free area 0002)", "Data block 2 (Free area 0002)", "Data block 3 (Free area 0002)", "PIN service block (Free area 0002)", "PIN data block (Free area 0002)", "Area define block (Free area 0003)", "Service block 1 (Free area 0003)", "CPID data block (Free area 0003)", "Service block 2 (Free area 0003)", "Data block 0 (Free area 0003)", "Data block 1 (Free area 0003)", "Data block 2 (Free area 0003)", "Data block 3 (Free area 0003)", "PIN service block (Free area 0003)", "PIN data block (Free area 0003)"};

    @Override
    public void createSaveData() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = this.hexStrToByteArray(this.editData.toString());
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            byteArrayOutputStream.write(this.editManagementInfo, 0, this.editManagementInfo.length);
            this.savedata = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String[] getBlockName() {
        return this.blockName;
    }

    @Override
    public FaverChipViewerLabelInfo[] getLabelInfo() {
        ArrayList<FaverChipViewerLabelInfo> arrayList = new ArrayList<FaverChipViewerLabelInfo>();
        arrayList.add(new FaverChipViewerLabelInfo(0, 0, 8));
        arrayList.add(new FaverChipViewerLabelInfo(1, 8, 8));
        arrayList.add(new FaverChipViewerLabelInfo(2, 16, 8));
        arrayList.add(new FaverChipViewerLabelInfo(3, 24, 8));
        arrayList.add(new FaverChipViewerLabelInfo(4, 32, 16));
        arrayList.add(new FaverChipViewerLabelInfo(5, 48, 16));
        for (int i = 64; i <= 4575; i += 16) {
            arrayList.add(new FaverChipViewerLabelInfo(6, i, 16));
        }
        arrayList.add(new FaverChipViewerLabelInfo(7, 4576, 8));
        arrayList.add(new FaverChipViewerLabelInfo(8, 4584, 8));
        arrayList.add(new FaverChipViewerLabelInfo(9, 4592, 8));
        arrayList.add(new FaverChipViewerLabelInfo(10, 4600, 8));
        arrayList.add(new FaverChipViewerLabelInfo(11, 4608, 16));
        arrayList.add(new FaverChipViewerLabelInfo(12, 4624, 16));
        arrayList.add(new FaverChipViewerLabelInfo(13, 4640, 16));
        arrayList.add(new FaverChipViewerLabelInfo(14, 4656, 16));
        arrayList.add(new FaverChipViewerLabelInfo(15, 4672, 16));
        arrayList.add(new FaverChipViewerLabelInfo(16, 4688, 16));
        arrayList.add(new FaverChipViewerLabelInfo(17, 4704, 16));
        arrayList.add(new FaverChipViewerLabelInfo(18, 4720, 16));
        arrayList.add(new FaverChipViewerLabelInfo(19, 4736, 16));
        arrayList.add(new FaverChipViewerLabelInfo(20, 4752, 16));
        arrayList.add(new FaverChipViewerLabelInfo(21, 4768, 16));
        arrayList.add(new FaverChipViewerLabelInfo(22, 4784, 16));
        arrayList.add(new FaverChipViewerLabelInfo(23, 4800, 16));
        arrayList.add(new FaverChipViewerLabelInfo(24, 4816, 16));
        arrayList.add(new FaverChipViewerLabelInfo(25, 4832, 16));
        arrayList.add(new FaverChipViewerLabelInfo(26, 4848, 16));
        arrayList.add(new FaverChipViewerLabelInfo(27, 4864, 16));
        arrayList.add(new FaverChipViewerLabelInfo(28, 4880, 16));
        arrayList.add(new FaverChipViewerLabelInfo(29, 4896, 16));
        arrayList.add(new FaverChipViewerLabelInfo(30, 4912, 16));
        arrayList.add(new FaverChipViewerLabelInfo(31, 4928, 16));
        arrayList.add(new FaverChipViewerLabelInfo(32, 4944, 16));
        arrayList.add(new FaverChipViewerLabelInfo(33, 4960, 16));
        arrayList.add(new FaverChipViewerLabelInfo(34, 4976, 16));
        arrayList.add(new FaverChipViewerLabelInfo(35, 4992, 16));
        arrayList.add(new FaverChipViewerLabelInfo(36, 5008, 16));
        arrayList.add(new FaverChipViewerLabelInfo(37, 5024, 16));
        arrayList.add(new FaverChipViewerLabelInfo(38, 5040, 16));
        arrayList.add(new FaverChipViewerLabelInfo(39, 5056, 16));
        arrayList.add(new FaverChipViewerLabelInfo(40, 5072, 16));
        arrayList.add(new FaverChipViewerLabelInfo(41, 5088, 16));
        arrayList.add(new FaverChipViewerLabelInfo(42, 5104, 16));
        return arrayList.toArray(new FaverChipViewerLabelInfo[0]);
    }

    @Override
    public boolean isEnabledRightClick() {
        return true;
    }

    @Override
    public void create(File file) throws IOException {
        this.realDataSize = 5120;
        this.managementSize = 1280;
        this.beginEditArea = 64;
        this.endEditArea = 4575;
        if (!file.canRead()) {
            throw new IOException(Resource.getString("FC_READ_ERR"));
        }
        int n = (int)file.length();
        if (n < this.realDataSize + this.managementSize) {
            throw new IOException(Resource.getString("FC_FILE_BREAKS"));
        }
        if (n > this.realDataSize + this.managementSize) {
            throw new IOException(Resource.getString("FC_DIFFERENT_VERSION"));
        }
        this.originData = new byte[5120];
        this.originManagementInfo = new byte[1280];
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(this.originData, 0, 5120);
        fileInputStream.read(this.originManagementInfo, 0, 1280);
        fileInputStream.close();
        this.fcFile = file;
        this.editflag = false;
        this.init();
    }

    @Override
    public boolean verification() {
        this.fcc = new FaverChipCheck(this.savedata);
        boolean bl = this.fcc.verification();
        if (!bl) {
            System.out.println("\u3010NG EDITING\u3011" + this.fcc.getErrorMessage());
        } else {
            System.out.println("\u3010OK EDITING\u3011");
        }
        return bl;
    }

    @Override
    public void setSaveData() {
        this.savedata = this.fcc.getUpdatedData();
    }

    @Override
    public FaverChipViewerBlock[] getBlockInfo() {
        FaverChipViewerBlock[] faverChipViewerBlockArray = null;
        ArrayList<ViewerBlock> arrayList = new ArrayList<ViewerBlock>();
        if (this.originManagementInfo != null) {
            for (int i = 0; i < this.originManagementInfo.length; i += 4) {
                byte[] byArray = new byte[4];
                byte[] byArray2 = new byte[2];
                System.arraycopy(this.originManagementInfo, i, byArray, 0, byArray.length);
                System.arraycopy(this.originData, i * 4, byArray2, 0, byArray2.length);
                ViewerBlock viewerBlock = new ViewerBlock(arrayList.size() * 16, byArray, byArray2);
                arrayList.add(viewerBlock);
            }
            faverChipViewerBlockArray = arrayList.toArray(new ViewerBlock[0]);
        }
        return faverChipViewerBlockArray;
    }

    @Override
    public void resetBlockInfo(FaverChipViewerBlock[] faverChipViewerBlockArray) {
        int n = 0;
        if (this.originManagementInfo != null) {
            for (int i = 0; i < faverChipViewerBlockArray.length; ++i) {
                n = i * 4;
                byte[] byArray = new byte[4];
                byte[] byArray2 = new byte[2];
                System.arraycopy(this.originManagementInfo, n, byArray, 0, byArray.length);
                System.arraycopy(this.originData, n * 4, byArray2, 0, byArray2.length);
                faverChipViewerBlockArray[i].set(byArray, byArray2);
            }
        }
    }
}

