/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica.ver20;

import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipData;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewerBlock;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewerLabelInfo;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20.FaverChipCheck;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20.ViewerBlock;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class FaverChipDataGen
extends FaverChipData {
    final int FULL_DATA_SIZE = 22528;
    final int REAL_DATA_SIZE = 736;
    int MANAGEMENT_SIZE = 276;
    final int OFFSET_REAL_DATA = 15648;
    final int OFFSET_MANAGEMENT = 22252;
    final int BEGIN_EDIT_AREA = -1;
    final int END_EDIT_AREA = -1;
    byte[] allDataByte = null;
    final boolean ENABLE_RIGTH_CLICK = false;
    private final int SAVE_OFFSET = 64;
    private final int BLOCK_SIZE = 16;
    FaverChipCheck fcc;
    private String[] blockName = new String[]{"System define block (Free area)", "Area define block (Free area)", "PIN service block", "PIN data block", "Area define block (Free area 0001)", "PIN service block", "PIN data block", "Service block 1 (Free area 0001)", "PIN service block", "PIN data block", "CPID data block (Free area 0001)", "Service block 2 (Free area 0001)", "PIN service block (Free area 0001)", "PIN data block (Free area 0001)", "Data block 0 (Free area 0001)", "Data block 1 (Free area 0001)", "Data block 2 (Free area 0001)", "Data block 3 (Free area 0001)", "Area define block (Free area 0002)", "PIN service block", "PIN data block", "Service block 1 (Free area 0002)", "PIN service block", "PIN data block", "CPID data block (Free area 0002)", "Service block 2 (Free area 0002)", "PIN service block (Free area 0002)", "PIN data block (Free area 0002)", "Data block 0 (Free area 0002)", "Data block 1 (Free area 0002)", "Data block 2 (Free area 0002)", "Data block 3 (Free area 0002)", "Area define block (Free area 0003)", "PIN service block", "PIN data block", "Service block 1 (Free area 0003)", "PIN service block", "PIN data block", "CPID data block (Free area 0003)", "Service block 2 (Free area 0003)", "PIN service block (Free area 0003)", "PIN data block (Free area 0003)", "Data block 0 (Free area 0003)", "Data block 1 (Free area 0003)", "Data block 2 (Free area 0003)", "Data block 3 (Free area 0003)"};

    @Override
    public void create(File file) throws IOException {
        FileInputStream fileInputStream = null;
        this.realDataSize = 736;
        this.managementSize = this.MANAGEMENT_SIZE;
        this.beginEditArea = -1;
        this.endEditArea = -1;
        if (!file.canRead()) {
            throw new IOException(Resource.getString("FC_READ_ERR"));
        }
        int n = (int)file.length();
        if (n < 22528) {
            throw new IOException(Resource.getString("FC_DIFFERENT_VERSION"));
        }
        if (n > 22528) {
            throw new IOException(Resource.getString("FC_FILE_BREAKS"));
        }
        this.allDataByte = new byte[22528];
        this.originData = new byte[736];
        this.originManagementInfo = new byte[this.MANAGEMENT_SIZE];
        fileInputStream = new FileInputStream(file);
        fileInputStream.read(this.allDataByte);
        fileInputStream.close();
        System.arraycopy(this.allDataByte, 15648, this.originData, 0, 736);
        System.arraycopy(this.allDataByte, 22252, this.originManagementInfo, 0, this.MANAGEMENT_SIZE);
        this.fcFile = file;
        this.editflag = false;
        this.init();
    }

    @Override
    public void createSaveData() {
        try {
            byte[] byArray = this.hexStrToByteArray(this.editData.toString());
            for (int i = 0; i < 3; ++i) {
                int n = 64 + i * 14 * 16;
                int n2 = n + 96;
                System.arraycopy(byArray, n2, this.allDataByte, 15648 + n2, 16);
                int n3 = n + 144;
                System.arraycopy(byArray, n3, this.allDataByte, 15648 + n3, 4);
                int n4 = n + 160;
                System.arraycopy(byArray, n4, this.allDataByte, 15648 + n4, 64);
            }
            System.arraycopy(this.editManagementInfo, 0, this.allDataByte, 22252, this.MANAGEMENT_SIZE);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.allDataByte);
            this.savedata = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String[] getBlockName() {
        return this.blockName;
    }

    @Override
    public FaverChipViewerLabelInfo[] getLabelInfo() {
        ArrayList<FaverChipViewerLabelInfo> arrayList = new ArrayList<FaverChipViewerLabelInfo>();
        for (int i = 0; i < this.blockName.length; ++i) {
            arrayList.add(new FaverChipViewerLabelInfo(i, i * 16, 16));
        }
        return arrayList.toArray(new FaverChipViewerLabelInfo[0]);
    }

    @Override
    public boolean isEnabledRightClick() {
        return false;
    }

    @Override
    public boolean verification() {
        this.fcc = new FaverChipCheck(this.savedata);
        boolean bl = this.fcc.verification();
        if (!bl) {
            System.out.println("\u3010NG EDITING\u3011" + this.fcc.getErrorMessage());
        } else {
            System.out.println("\u3010OK EDITING\u3011");
        }
        return bl;
    }

    @Override
    public void setSaveData() {
        this.savedata = this.fcc.getUpdatedData();
    }

    @Override
    public FaverChipViewerBlock[] getBlockInfo() {
        FaverChipViewerBlock[] faverChipViewerBlockArray = null;
        ArrayList<ViewerBlock> arrayList = new ArrayList<ViewerBlock>();
        if (this.originManagementInfo != null) {
            int n = 0;
            int n2 = 0;
            while (n < this.originManagementInfo.length) {
                byte[] byArray = new byte[6];
                byte[] byArray2 = new byte[4];
                System.arraycopy(this.originManagementInfo, n, byArray, 0, byArray.length);
                System.arraycopy(this.originData, n + 10 * n2, byArray2, 0, byArray2.length);
                ViewerBlock viewerBlock = new ViewerBlock(arrayList.size() * 16, byArray, byArray2);
                arrayList.add(viewerBlock);
                n += 6;
                ++n2;
            }
            faverChipViewerBlockArray = arrayList.toArray(new ViewerBlock[0]);
        }
        return faverChipViewerBlockArray;
    }

    @Override
    public void resetBlockInfo(FaverChipViewerBlock[] faverChipViewerBlockArray) {
        int n = 0;
        if (this.originManagementInfo != null) {
            for (int i = 0; i < faverChipViewerBlockArray.length; ++i) {
                n = i * 6;
                byte[] byArray = new byte[6];
                byte[] byArray2 = new byte[4];
                System.arraycopy(this.originManagementInfo, n, byArray, 0, byArray.length);
                System.arraycopy(this.originData, n + 10 * i, byArray2, 0, byArray2.length);
                faverChipViewerBlockArray[i].set(byArray, byArray2);
            }
        }
    }
}

