/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica.ver20h;

import com.nttdocomo.dojaemu.ktoolbar.HexDocument;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipNode;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipNodeException;
import com.nttdocomo.dojaemu.ktoolbar.felica.NodeCode;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.BlockInfoAreaNode;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.DefaultNodeCodeCheck;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeArea;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BlockInfoAreaArea
extends BlockInfoAreaNode
implements DocumentListener {
    private JTextField tbxNodeCode;
    private JTextField tbxKeyVersion;
    private JTextField tbxEndService;
    private JLabel dspCertification;
    private JLabel dspComparison;
    private Color anActivatColor;
    private final String[] NECESSITY = new String[]{Resource.getString("FCH_LBL_NASHI"), Resource.getString("FCH_LBL_ARI")};
    private final String[] CREATABLE = new String[]{Resource.getString("FCH_LBL_CREATABLE"), Resource.getString("FCH_LBL_UNCREATABLE")};
    private NodeCodeArea node;
    private String preNodeCode;

    public BlockInfoAreaArea(NodeCode nodeCode, boolean bl) {
        this.node = (NodeCodeArea)nodeCode;
        this.emuType = bl;
        this.setLayout(new BorderLayout());
        this.preNodeCode = nodeCode.getNodeCodeString();
        JLabel jLabel = new JLabel(Resource.getString("FCH_LBL_NODE_CODE"));
        JLabel jLabel2 = new JLabel(Resource.getString("FCH_LBL_KEY_VERSION"));
        JLabel jLabel3 = new JLabel(Resource.getString("FCH_LBL_END_SERVICE"));
        JLabel jLabel4 = new JLabel(Resource.getString("FCH_LBL_CHILD_AREA"));
        JLabel jLabel5 = new JLabel(Resource.getString("FCH_LBL_COMPARISON"));
        this.tbxNodeCode = new JTextField(16);
        this.tbxKeyVersion = new JTextField(16);
        this.tbxEndService = new JTextField(16);
        this.dspCertification = new JLabel();
        this.dspComparison = new JLabel();
        this.tbxNodeCode.setDocument(new HexDocument(8));
        this.tbxKeyVersion.setDocument(new HexDocument(4));
        this.tbxEndService.setDocument(new HexDocument(8));
        this.tbxNodeCode.setText(this.node.getNodeCodeString());
        this.tbxKeyVersion.setText(this.node.getKeyVersion());
        this.tbxEndService.setText(this.node.getEndService());
        this.tbxNodeCode.getDocument().addDocumentListener(this);
        this.tbxKeyVersion.getDocument().addDocumentListener(this);
        this.tbxEndService.getDocument().addDocumentListener(this);
        this.dspCertification.setText(this.node.canCreateArea() ? this.CREATABLE[0] : this.CREATABLE[1]);
        this.dspComparison.setText(this.node.getComparison() ? this.NECESSITY[1] : this.NECESSITY[0]);
        Dimension dimension = new Dimension(this.tbxNodeCode.getPreferredSize().width, this.tbxNodeCode.getPreferredSize().height);
        this.dspCertification.setPreferredSize(dimension);
        this.dspComparison.setPreferredSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        jPanel.add(jLabel);
        jPanel.add(this.tbxNodeCode);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        jPanel2.add(jLabel2);
        jPanel2.add(this.tbxKeyVersion);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        jPanel3.add(jLabel3);
        jPanel3.add(this.tbxEndService);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        jPanel4.add(jLabel4);
        jPanel4.add(this.dspCertification);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(2));
        jPanel5.add(jLabel5);
        jPanel5.add(this.dspComparison);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("FCH_LBL_AREA_BLOCK")));
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.add(jPanel);
        jPanel6.add(jPanel2);
        jPanel6.add(jPanel3);
        jPanel6.add(jPanel4);
        jPanel6.add(jPanel5);
        this.enabled();
        this.add("Center", jPanel6);
        this.anActivatColor = jPanel6.getBackground();
        this.editFlag = false;
    }

    public void enabled() {
        if (this.node.getAreaType() == 2) {
            this.tbxNodeCode.setEnabled(false);
            this.tbxNodeCode.setBackground(this.anActivatColor);
            this.tbxEndService.setEnabled(false);
            this.tbxEndService.setBackground(this.anActivatColor);
        }
        if (this.node.getNodeCodeString().equals("00000000") && this.node.getParent() instanceof NodeCodeSystem) {
            this.tbxNodeCode.setEnabled(false);
            this.tbxNodeCode.setBackground(this.anActivatColor);
            this.tbxEndService.setEnabled(false);
            this.tbxEndService.setBackground(this.anActivatColor);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.editFlag = true;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.editFlag = true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public NodeCode check(FaverChipNode faverChipNode, boolean bl) throws FaverChipNodeException {
        String string = this.tbxNodeCode.getText();
        String string2 = this.tbxKeyVersion.getText();
        String string3 = this.tbxEndService.getText();
        this.node.setNodeCode(this.addZero(string, 8));
        this.node.setKeyVersion(this.addZero(string2, 4));
        this.node.setEndService(this.addZero(string3, 8));
        DefaultNodeCodeCheck defaultNodeCodeCheck = (DefaultNodeCodeCheck)faverChipNode.getNodeCodeCheck();
        defaultNodeCodeCheck.checkAreaNode(this.node);
        if (bl) {
            faverChipNode.changeNodeCode(this.node, Resource.getString("FCH_NODE_NEW_AREA"));
            faverChipNode.addPINNodeCode(this.node, 0);
            faverChipNode.reorganization(this.node);
        } else if (!this.node.getNodeCodeString().equals(this.preNodeCode) && !this.preNodeCode.equals("00000000") && this.editFlag) {
            faverChipNode.changeNodeCode(this.node, this.preNodeCode);
            faverChipNode.changePINNode(this.node);
            faverChipNode.reorganization(this.node);
        } else {
            faverChipNode.reorganization(this.node);
        }
        this.editFlag = false;
        return this.node;
    }
}

