/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica.ver20h;

import com.nttdocomo.dojaemu.ktoolbar.HexDocument;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipNode;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipNodeException;
import com.nttdocomo.dojaemu.ktoolbar.felica.NodeCode;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.BlockInfoAreaNode;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.DefaultNodeCodeCheck;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipUserData;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BlockInfoAreaService
extends BlockInfoAreaNode
implements DocumentListener {
    private final int DEFAULT_USER_DATA_NUM = 8;
    private final int LIMIT_USER_DATA_NUM = 965;
    private JTextField tbxNodeCode;
    private JTextField tbxKeyVersion;
    private JTextField tbxDataNum;
    private JLabel dspCertification;
    private JLabel dspComparison;
    private final String[] NECESSITY = new String[]{Resource.getString("FCH_LBL_NASHI"), Resource.getString("FCH_LBL_ARI")};
    private Vector vTbxData;
    private Vector vLblData;
    private Vector vPnlData;
    private JPanel pnlAllData;
    private JTextField tbxPIN;
    private JTextField tbxTryCount;
    private JTextField tbxTryCountMax;
    private JTextField tbxPINAttrB8;
    private JTextField tbxPINAttrBc;
    private NodeCodeService node;
    private String preNodeCode;
    private Color anActivatColor;
    private Color activatColor;

    public BlockInfoAreaService(NodeCode nodeCode, boolean bl) {
        this.node = (NodeCodeService)nodeCode;
        this.emuType = bl;
        this.setLayout(new BorderLayout());
        this.preNodeCode = nodeCode.getNodeCodeString();
        this.add("North", this.getServicePanel());
        if (this.node.isPINService()) {
            this.add("Center", this.getPINDataPanel());
        } else {
            this.add("Center", this.getDataPanel());
        }
        this.enabled();
        this.editFlag = false;
    }

    private JPanel getServicePanel() {
        JLabel jLabel = new JLabel(Resource.getString("FCH_LBL_NODE_CODE"));
        JLabel jLabel2 = new JLabel(Resource.getString("FCH_LBL_KEY_VERSION"));
        JLabel jLabel3 = new JLabel(Resource.getString("FCH_LBL_ASSIGN_DATA"));
        JLabel jLabel4 = new JLabel(Resource.getString("FCH_LBL_CERTIFICATION"));
        JLabel jLabel5 = new JLabel(Resource.getString("FCH_LBL_COMPARISON"));
        this.tbxNodeCode = new JTextField(16);
        this.tbxKeyVersion = new JTextField(16);
        this.tbxDataNum = new JTextField(16);
        this.dspCertification = new JLabel();
        this.dspComparison = new JLabel();
        this.tbxNodeCode.setDocument(new HexDocument(8));
        this.tbxKeyVersion.setDocument(new HexDocument(4));
        this.tbxDataNum.setDocument(new HexDocument(4));
        this.tbxNodeCode.setText(this.node.getNodeCodeString());
        this.tbxKeyVersion.setText(this.node.getKeyVersion());
        this.tbxDataNum.setText(this.node.getDataNum());
        this.tbxNodeCode.getDocument().addDocumentListener(this);
        this.tbxKeyVersion.getDocument().addDocumentListener(this);
        this.tbxDataNum.getDocument().addDocumentListener(this);
        this.dspCertification.setText(this.node.getCertification() ? this.NECESSITY[1] : this.NECESSITY[0]);
        this.dspComparison.setText(this.node.getComparison() ? this.NECESSITY[1] : this.NECESSITY[0]);
        Dimension dimension = new Dimension(this.tbxNodeCode.getPreferredSize().width, this.tbxNodeCode.getPreferredSize().height);
        this.dspCertification.setPreferredSize(dimension);
        this.dspComparison.setPreferredSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        jPanel.add(jLabel);
        jPanel.add(this.tbxNodeCode);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        jPanel2.add(jLabel2);
        jPanel2.add(this.tbxKeyVersion);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        jPanel3.add(jLabel3);
        jPanel3.add(this.tbxDataNum);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        jPanel4.add(jLabel4);
        jPanel4.add(this.dspCertification);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(2));
        jPanel5.add(jLabel5);
        jPanel5.add(this.dspComparison);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("FCH_LBL_SERVICE_BLOCK")));
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.add(jPanel);
        jPanel6.add(jPanel2);
        if (!this.node.isPINService()) {
            jPanel6.add(jPanel3);
            jPanel6.add(jPanel4);
            jPanel6.add(jPanel5);
        }
        this.anActivatColor = jPanel6.getBackground();
        this.activatColor = this.tbxNodeCode.getBackground();
        return jPanel6;
    }

    private JPanel getDataPanel() {
        int n;
        this.vTbxData = new Vector();
        this.vLblData = new Vector();
        this.vPnlData = new Vector();
        int n2 = 0;
        int n3 = 0;
        try {
            n2 = Integer.parseInt(this.node.getDataNum(), 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 < 8) {
            n3 = 8;
        } else if (n2 > 965) {
            n3 = 965;
            n2 = 965;
            this.tbxDataNum.setText(Integer.toHexString(n3 & 0xFFFF));
        } else {
            n3 = n2;
        }
        Vector vector = this.node.getChildren();
        for (n = 0; n < n3; ++n) {
            Object object;
            JLabel jLabel = new JLabel(new Integer(n).toString() + ":");
            this.vLblData.addElement(jLabel);
            JTextField jTextField = new JTextField(32);
            jTextField.setDocument(new HexDocument(32));
            jTextField.getDocument().addDocumentListener(this);
            if (n < vector.size()) {
                object = (FaverChipUserData)vector.elementAt(n);
                String string = this.node.getHexString(((FaverChipUserData)object).getDataBytes(), 0, 16);
                jTextField.setText(string);
            }
            this.vTbxData.addElement(jTextField);
            object = new JPanel();
            ((Container)object).setLayout(new FlowLayout(2));
            ((Container)object).add(jLabel);
            ((Container)object).add(jTextField);
            this.vPnlData.addElement(object);
        }
        this.pnlAllData = new JPanel();
        this.pnlAllData.setLayout(new BoxLayout(this.pnlAllData, 1));
        for (n = 0; n < this.vPnlData.size(); ++n) {
            this.pnlAllData.add((JPanel)this.vPnlData.elementAt(n));
        }
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("FCH_LBL_USER_BLOCK")));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.pnlAllData);
        for (int i = n2; i < n3; ++i) {
            ((JTextField)this.vTbxData.elementAt(i)).setEnabled(false);
            ((JTextField)this.vTbxData.elementAt(i)).setBackground(this.anActivatColor);
        }
        return jPanel;
    }

    private JPanel getPINDataPanel() {
        JLabel jLabel = new JLabel(Resource.getString("FCH_LBL_PIN"));
        JLabel jLabel2 = new JLabel(Resource.getString("FCH_LBL_TRY_COUNT"));
        JLabel jLabel3 = new JLabel(Resource.getString("FCH_LBL_TRY_COUNT_MAX"));
        JLabel jLabel4 = new JLabel(Resource.getString("FCH_LBL_PIN_ATTR_B8"));
        JLabel jLabel5 = new JLabel(Resource.getString("FCH_LBL_PIN_ATTR_BC"));
        this.tbxPIN = new JTextField(12);
        this.tbxTryCount = new JTextField(12);
        this.tbxTryCountMax = new JTextField(12);
        this.tbxPINAttrB8 = new JTextField(12);
        this.tbxPINAttrBc = new JTextField(12);
        this.tbxPIN.setDocument(new HexDocument(8));
        this.tbxTryCount.setDocument(new HexDocument(2));
        this.tbxTryCountMax.setDocument(new HexDocument(2));
        this.tbxPINAttrB8.setDocument(new HexDocument(2));
        this.tbxPINAttrBc.setDocument(new HexDocument(2));
        Vector vector = this.node.getChildren();
        if (vector.size() != 1) {
            return new JPanel();
        }
        FaverChipUserData faverChipUserData = (FaverChipUserData)vector.elementAt(0);
        byte[] byArray = faverChipUserData.getDataBytes();
        this.tbxPIN.setText(this.node.getHexString(byArray, 0, 4));
        this.tbxTryCount.setText(this.node.getHexString(byArray, 6, 1));
        this.tbxTryCountMax.setText(this.node.getHexString(byArray, 7, 1));
        this.tbxPINAttrB8.setText(this.node.getHexString(byArray, 8, 1));
        this.tbxPINAttrBc.setText(this.node.getHexString(byArray, 12, 1));
        this.tbxPIN.getDocument().addDocumentListener(this);
        this.tbxTryCount.getDocument().addDocumentListener(this);
        this.tbxTryCountMax.getDocument().addDocumentListener(this);
        this.tbxPINAttrB8.getDocument().addDocumentListener(this);
        this.tbxPINAttrBc.getDocument().addDocumentListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        jPanel.add(jLabel);
        jPanel.add(this.tbxPIN);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        jPanel2.add(jLabel2);
        jPanel2.add(this.tbxTryCount);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        jPanel3.add(jLabel3);
        jPanel3.add(this.tbxTryCountMax);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        jPanel4.add(jLabel4);
        jPanel4.add(this.tbxPINAttrB8);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(2));
        jPanel5.add(jLabel5);
        jPanel5.add(this.tbxPINAttrBc);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("FCH_LBL_USER_BLOCK")));
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.add(jPanel);
        jPanel6.add(jPanel2);
        jPanel6.add(jPanel3);
        jPanel6.add(jPanel4);
        jPanel6.add(jPanel5);
        if (this.emuType) {
            this.tbxTryCount.setEnabled(false);
            this.tbxTryCountMax.setEnabled(false);
            this.tbxPINAttrB8.setEnabled(false);
            this.tbxPINAttrBc.setEnabled(false);
            this.tbxTryCount.setBackground(this.anActivatColor);
            this.tbxTryCountMax.setBackground(this.anActivatColor);
            this.tbxPINAttrB8.setBackground(this.anActivatColor);
            this.tbxPINAttrBc.setBackground(this.anActivatColor);
        }
        return jPanel6;
    }

    public void enabled() {
        if (this.node.isPINService()) {
            this.tbxNodeCode.setEnabled(false);
            this.tbxNodeCode.setBackground(this.anActivatColor);
        }
        if (this.node.getAreaType() == 2) {
            this.tbxNodeCode.setEnabled(false);
            this.tbxNodeCode.setBackground(this.anActivatColor);
            this.tbxDataNum.setEnabled(false);
            this.tbxDataNum.setBackground(this.anActivatColor);
        }
    }

    @Override
    public NodeCode check(FaverChipNode faverChipNode, boolean bl) throws FaverChipNodeException {
        Object object;
        String string = this.tbxNodeCode.getText();
        String string2 = this.tbxKeyVersion.getText();
        String[] stringArray = null;
        this.node.setNodeCode(this.addZero(string, 8));
        this.node.setKeyVersion(this.addZero(string2, 4));
        if (this.node.isPINService()) {
            object = this.addZero(this.tbxPIN.getText().trim(), 8);
            String string3 = this.addZero(this.tbxTryCount.getText().trim(), 2);
            String string4 = this.addZero(this.tbxTryCountMax.getText().trim(), 2);
            String string5 = this.addZero(this.tbxPINAttrB8.getText().trim(), 2);
            String string6 = this.addZero(this.tbxPINAttrBc.getText().trim(), 2);
            Vector vector = this.node.getChildren();
            FaverChipUserData faverChipUserData = (FaverChipUserData)vector.elementAt(0);
            byte[] byArray = this.node.getBytes((String)object);
            faverChipUserData.setDataBytes(byArray, 0, 0, byArray.length);
            byArray = this.node.getBytes(string3);
            faverChipUserData.setDataBytes(byArray, 0, 6, byArray.length);
            byArray = this.node.getBytes(string4);
            faverChipUserData.setDataBytes(byArray, 0, 7, byArray.length);
            byArray = this.node.getBytes(string5);
            faverChipUserData.setDataBytes(byArray, 0, 8, byArray.length);
            byArray = this.node.getBytes(string6);
            faverChipUserData.setDataBytes(byArray, 0, 12, byArray.length);
        } else {
            object = this.tbxDataNum.getText();
            this.node.setDataNum(this.addZero((String)object, 4));
            int n = 0;
            try {
                n = Integer.parseInt((String)object, 16);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n > 965) {
                throw new FaverChipNodeException(Resource.getString("FC_ERR_OVER_LIM_BLOCK"));
            }
            if (0 < n) {
                stringArray = new String[n];
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i < this.vTbxData.size()) {
                        JTextField jTextField = (JTextField)this.vTbxData.elementAt(i);
                        stringArray[i] = this.addZero(jTextField.getText(), 32);
                        continue;
                    }
                    stringArray[i] = this.addZero("0", 32);
                }
            }
        }
        object = (DefaultNodeCodeCheck)faverChipNode.getNodeCodeCheck();
        ((DefaultNodeCodeCheck)object).checkServiceNode(this.node);
        if (!this.node.isPINService()) {
            if (bl) {
                faverChipNode.checkFreeBlock(2 + stringArray.length);
                faverChipNode.changeNodeCode(this.node, Resource.getString("FCH_NODE_NEW_SERVICE"));
                faverChipNode.addPINNodeCode(this.node, 1);
                faverChipNode.removeNode(this.node, null);
                faverChipNode.changeUserData(this.node, stringArray);
                faverChipNode.reorganization(this.node);
            } else if (!this.node.getNodeCodeString().equals(this.preNodeCode) && !this.preNodeCode.equals("00000000") && this.editFlag) {
                faverChipNode.changeNodeCode(this.node, this.preNodeCode);
                faverChipNode.changePINNode(this.node);
                try {
                    faverChipNode.removeNode(this.node, this.preNodeCode);
                    faverChipNode.changeUserData(this.node, stringArray);
                    faverChipNode.reorganization(this.node);
                }
                catch (FaverChipNodeException faverChipNodeException) {
                    String string7 = this.node.getNodeCodeString();
                    this.node.setNodeCode(this.preNodeCode);
                    faverChipNode.changeNodeCode(this.node, string7);
                    faverChipNode.changePINNode(this.node);
                    throw faverChipNodeException;
                }
            } else {
                faverChipNode.changeUserData(this.node, stringArray);
                faverChipNode.reorganization(this.node);
            }
        }
        this.editFlag = false;
        return this.node;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.editFlag = true;
        if (documentEvent.getDocument().equals(this.tbxDataNum.getDocument())) {
            this.updateTBXDataNum();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.editFlag = true;
        if (documentEvent.getDocument().equals(this.tbxDataNum.getDocument())) {
            this.updateTBXDataNum();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private void updateTBXDataNum() {
        JComponent jComponent;
        JTextField jTextField;
        JComponent jComponent2;
        int n;
        String string = this.tbxDataNum.getText();
        int n2 = 0;
        if (string.length() != 4) {
            return;
        }
        try {
            n2 = Integer.parseInt(string, 16);
        }
        catch (Exception exception) {
            return;
        }
        if (n2 > 965) {
            return;
        }
        int n3 = this.vTbxData.size();
        if (n3 < n2) {
            for (n = n3; n < n2; ++n) {
                jComponent2 = new JLabel(new Integer(n).toString() + ":");
                this.vLblData.addElement(jComponent2);
                jTextField = new JTextField(32);
                jTextField.setDocument(new HexDocument(32));
                jTextField.getDocument().addDocumentListener(this);
                this.vTbxData.addElement(jTextField);
                jComponent = new JPanel();
                jComponent.setLayout(new FlowLayout(2));
                jComponent.add(jComponent2);
                jComponent.add(jTextField);
                this.vPnlData.addElement(jComponent);
                this.pnlAllData.add(jComponent);
                this.pnlAllData.repaint();
            }
            this.updateUI();
        } else if (n3 > n2) {
            for (n = n3; n > n2 && n > 8; --n) {
                jComponent2 = (JPanel)this.vPnlData.lastElement();
                jTextField = (JTextField)this.vTbxData.lastElement();
                jComponent = (JLabel)this.vLblData.lastElement();
                this.vTbxData.remove(jTextField);
                this.vLblData.remove(jComponent);
                this.vPnlData.remove(jComponent2);
                this.pnlAllData.remove(jComponent2);
                this.pnlAllData.repaint();
            }
            this.updateUI();
        }
        n = 0;
        for (n = 0; n < this.vTbxData.size() && n < n2; ++n) {
            jComponent2 = (JTextField)this.vTbxData.elementAt(n);
            jComponent2.setEnabled(true);
            jComponent2.setBackground(this.activatColor);
        }
        while (n < this.vTbxData.size()) {
            jComponent2 = (JTextField)this.vTbxData.elementAt(n);
            jComponent2.setEnabled(false);
            jComponent2.setBackground(this.anActivatColor);
            ++n;
        }
    }
}

