/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica.ver20h;

import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipArea;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipBlock;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipBlockContainerID;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipBlockContainerIssue;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipIssue;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipManufacture;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipService;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipSystem;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipUnuse;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipUserData;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeManager;
import java.util.Vector;

class BlockManager {
    static final int BLOCK_SIZE = 16;
    static final int INFO_SIZE = 6;
    static final int TOTAL_BLOCK = 1024;
    static final int BLOCK_TOTAL_SIZE = 16384;
    static final int INFO_TOTAL_SIZE = 6144;
    static final int TOTAL_SIZE = 22528;
    static final int COMMON_DATA_BLOCK = 976;
    static final int FREE_DATA_BLOCK = 48;
    byte[][] faverData = new byte[1024][16];
    byte[][] faverInfo = new byte[1024][6];
    private NodeCodeManager manager;

    BlockManager(byte[] byArray, byte[] byArray2, int n) {
        if (n == 0) {
            for (int i = 0; i < 1024; ++i) {
                System.arraycopy(byArray, i * 16, this.faverData[i], 0, 16);
                System.arraycopy(byArray2, i * 6, this.faverInfo[i], 0, 6);
            }
        } else {
            int n2 = 978;
            int n3 = 0;
            while (n2 < 1024) {
                System.arraycopy(byArray, n3 * 16, this.faverData[n2], 0, 16);
                System.arraycopy(byArray2, n3 * 6, this.faverInfo[n2], 0, 6);
                ++n2;
                ++n3;
            }
        }
        this.makeNodeList(n);
    }

    void makeNodeList(int n) {
        this.manager = new NodeCodeManager();
        if (n == 0) {
            Vector vector = this.makeBlocks(0, 976);
            this.manager.makeNodeCode(vector, 1);
            Vector vector2 = this.makeBlocks(976, 1024);
            this.manager.makeNodeCode(vector2, 2);
        } else {
            Vector vector = this.makeBlocks(978, 1024);
            this.manager.makeNodeCode(vector, 2);
        }
    }

    Vector makeBlocks(int n, int n2) {
        Vector<FaverChipBlock> vector = new Vector<FaverChipBlock>();
        for (int i = n; i < n2; ++i) {
            if (this.faverInfo[i][0] == 4) {
                vector.add(new FaverChipArea(i, this.faverData[i], this.faverInfo[i]));
                continue;
            }
            if (this.faverInfo[i][0] == 5) {
                vector.add(new FaverChipService(i, this.faverData[i], this.faverInfo[i]));
                continue;
            }
            if (this.faverInfo[i][0] == 6) {
                vector.add(new FaverChipUserData(i, this.faverData[i], this.faverInfo[i]));
                continue;
            }
            if (this.faverInfo[i][0] == 1) {
                vector.add(new FaverChipManufacture(i, this.faverData[i], this.faverInfo[i]));
                continue;
            }
            if (this.faverInfo[i][0] == 2) {
                vector.add(new FaverChipIssue(i, this.faverData[i], this.faverInfo[i]));
                continue;
            }
            if (this.faverInfo[i][0] == 3) {
                vector.add(new FaverChipSystem(i, this.faverData[i], this.faverInfo[i]));
                continue;
            }
            if (this.faverInfo[i][0] == 7) {
                vector.add(new FaverChipBlockContainerID(i, this.faverData[i], this.faverInfo[i]));
                continue;
            }
            if (this.faverInfo[i][0] == 8) {
                vector.add(new FaverChipBlockContainerIssue(i, this.faverData[i], this.faverInfo[i]));
                continue;
            }
            vector.add(new FaverChipUnuse(i, this.faverData[i], this.faverInfo[i]));
        }
        return vector;
    }

    NodeCodeManager getNodeCodeManager() {
        return this.manager;
    }
}

