/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica.ver20h;

import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipNodeException;
import com.nttdocomo.dojaemu.ktoolbar.felica.NodeCodeCheck;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipArea;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipService;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeArea;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeCard;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeService;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeSystem;
import java.util.Hashtable;
import java.util.Vector;

class DefaultNodeCodeCheck
extends NodeCodeCheck {
    private final String ERR_NOT_FIND_PARENT = "FC_ERR_NOT_FIND_PARENT";
    private final String ERR_INVALID_ATTR = "FC_ERR_INVALID_ATTR";
    private final String ERR_OVERLAP_CODE = "FC_ERR_OVERLAP_CODE";
    private final String ERR_INVALID_ENDCODE = "FC_ERR_INVALID_ENDCODE";
    private final String ERR_INVALID_BLOCK_NUM = "FC_ERR_INVALID_BLOCK_NUM";
    private final String ERR_INVALID_PIN_ATTR = "FC_ERR_INVALID_PIN_ATTR";
    private final String ERR_NO_SERVICE = "FC_ERR_NO_SERVICE";
    private final String ERR_NO_BELONG = "FC_ERR_NO_BELONG";
    private final String ERR_NO_USER_DATA = "FC_ERR_NO_USER_DATA";
    private final String ERR_DATA_BREAKS = "FC_ERR_DATA_BREAKS";
    private final String ERR_NO_PIN_SERVICE = "FC_ERR_NO_PIN_SERVICE";
    private final String E_SV = "_SV";
    private final String E_AR = "_AR";
    private Hashtable hash;
    private NodeCodeCard root;

    public DefaultNodeCodeCheck(Hashtable hashtable, NodeCodeCard nodeCodeCard) {
        this.hash = hashtable;
        this.root = nodeCodeCard;
    }

    public boolean checkAreaNode(NodeCodeArea nodeCodeArea) throws FaverChipNodeException {
        if (nodeCodeArea.getParent() instanceof NodeCodeSystem) {
            return this.checkArea0000(nodeCodeArea);
        }
        return this.checkAreaOther(nodeCodeArea);
    }

    public boolean checkArea0000(NodeCodeArea nodeCodeArea) throws FaverChipNodeException {
        String string = null;
        FaverChipArea faverChipArea = nodeCodeArea.getAreaBlock();
        Vector vector = nodeCodeArea.getChildren();
        int n = (int)(0x1FL & faverChipArea.code);
        int n2 = (int)(0x20L & faverChipArea.code);
        if (n2 == 32 || n != 0 && n != 1) {
            string = this.getErrorMessage("FC_ERR_INVALID_ATTR_AR", nodeCodeArea.getNodeCodeString());
            throw new FaverChipNodeException(string);
        }
        if (faverChipArea.code + 2L > faverChipArea.endService) {
            string = this.getErrorMessage("FC_ERR_INVALID_ENDCODE", nodeCodeArea.getNodeCodeString());
            throw new FaverChipNodeException(string);
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof NodeCodeArea)) continue;
            NodeCodeArea nodeCodeArea2 = (NodeCodeArea)e;
            FaverChipArea faverChipArea2 = nodeCodeArea2.getAreaBlock();
            if (faverChipArea2.code != faverChipArea.code) continue;
            string = this.getErrorMessage("FC_ERR_OVERLAP_CODE_SV", nodeCodeArea.getNodeCodeString());
            throw new FaverChipNodeException(string);
        }
        return true;
    }

    public boolean checkAreaOther(NodeCodeArea nodeCodeArea) throws FaverChipNodeException {
        String string = null;
        NodeCodeArea nodeCodeArea2 = (NodeCodeArea)nodeCodeArea.getParent();
        FaverChipArea faverChipArea = nodeCodeArea.getAreaBlock();
        FaverChipArea faverChipArea2 = nodeCodeArea2.getAreaBlock();
        Vector vector = nodeCodeArea2.getChildren();
        int n = (int)(0x1FL & faverChipArea.code);
        int n2 = (int)(0x20L & faverChipArea.code);
        if (n2 == 32 || n != 0 && n != 1) {
            string = this.getErrorMessage("FC_ERR_INVALID_ATTR_AR", nodeCodeArea.getNodeCodeString());
            throw new FaverChipNodeException(string);
        }
        if (faverChipArea.code <= faverChipArea2.code || faverChipArea2.endService <= faverChipArea.code + 2L) {
            string = this.getErrorMessage("FC_ERR_NOT_FIND_PARENT_AR", nodeCodeArea.getNodeCodeString());
            throw new FaverChipNodeException(string);
        }
        int n3 = (int)(0xFFFF0000L & faverChipArea.code);
        int n4 = (int)(0xFFFF0000L & faverChipArea.endService);
        if (n3 != n4) {
            string = this.getErrorMessage("FC_ERR_INVALID_ENDCODE", nodeCodeArea.getNodeCodeString());
            throw new FaverChipNodeException(string);
        }
        long l = faverChipArea.endService | 0x3FL;
        Object object = Long.toHexString(l).toUpperCase();
        for (int i = 8 - ((String)object).length(); i > 0; --i) {
            object = "0" + (String)object;
        }
        nodeCodeArea.setEndService((String)object);
        if (faverChipArea.code + 2L > faverChipArea.endService) {
            string = this.getErrorMessage("FC_ERR_INVALID_ENDCODE", nodeCodeArea.getNodeCodeString());
            throw new FaverChipNodeException(string);
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof NodeCodeArea) || (object = (NodeCodeArea)e).equals(nodeCodeArea)) continue;
            FaverChipArea faverChipArea3 = ((NodeCodeArea)object).getAreaBlock();
            if (faverChipArea3.code == faverChipArea.code) {
                string = this.getErrorMessage("FC_ERR_OVERLAP_CODE_AR", nodeCodeArea.getNodeCodeString());
                throw new FaverChipNodeException(string);
            }
            if (((NodeCodeArea)object).canCreateArea() && faverChipArea3.code <= faverChipArea.code && faverChipArea.code + 2L <= faverChipArea3.endService) {
                string = this.getErrorMessage("FC_ERR_NOT_FIND_PARENT_AR", nodeCodeArea.getNodeCodeString());
                throw new FaverChipNodeException(string);
            }
            if (!((NodeCodeArea)object).canCreateArea() || faverChipArea3.code > faverChipArea.endService || faverChipArea.endService > faverChipArea3.endService) continue;
            string = this.getErrorMessage("FC_ERR_INVALID_ENDCODE", nodeCodeArea.getNodeCodeString());
            throw new FaverChipNodeException(string);
        }
        return true;
    }

    public boolean checkServiceNode(NodeCodeService nodeCodeService) throws FaverChipNodeException {
        String string = null;
        NodeCodeArea nodeCodeArea = (NodeCodeArea)nodeCodeService.getParent();
        FaverChipService faverChipService = nodeCodeService.getServiceBlock();
        FaverChipArea faverChipArea = nodeCodeArea.getAreaBlock();
        Vector vector = nodeCodeArea.getChildren();
        int n = 0;
        try {
            n = Integer.parseInt(nodeCodeService.getDataNum(), 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = (int)(0x1FL & faverChipService.code);
        int n3 = (int)(0x20L & faverChipService.code);
        if (!(nodeCodeService.isPINService() || n3 != 32 && n2 >= 8 && 23 >= n2)) {
            string = this.getErrorMessage("FC_ERR_INVALID_ATTR_SV", nodeCodeService.getNodeCodeString());
            throw new FaverChipNodeException(string);
        }
        if (faverChipService.code <= faverChipArea.code || faverChipArea.endService <= faverChipService.code + (long)n) {
            string = this.getErrorMessage("FC_ERR_NOT_FIND_PARENT_SV", nodeCodeService.getNodeCodeString());
            throw new FaverChipNodeException(string);
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof NodeCodeService)) continue;
            NodeCodeService nodeCodeService2 = (NodeCodeService)e;
            FaverChipService faverChipService2 = nodeCodeService2.getServiceBlock();
            if (nodeCodeService2.equals(nodeCodeService) || faverChipService2.code != faverChipService.code) continue;
            string = this.getErrorMessage("FC_ERR_OVERLAP_CODE_SV", nodeCodeService.getNodeCodeString());
            throw new FaverChipNodeException(string);
        }
        if (n < 1) {
            string = this.getErrorMessage("FC_ERR_NO_USER_DATA", nodeCodeService.getNodeCodeString());
            throw new FaverChipNodeException(string);
        }
        return true;
    }

    public boolean checkSystemNode(NodeCodeSystem nodeCodeSystem) {
        Object var2_2 = null;
        Vector vector = this.root.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            String string;
            String string2;
            NodeCodeSystem nodeCodeSystem2 = (NodeCodeSystem)vector.elementAt(i);
            if (nodeCodeSystem.equals(nodeCodeSystem2) || !(string2 = nodeCodeSystem.getNodeCodeString().toUpperCase()).equals(string = nodeCodeSystem2.getNodeCodeString().toUpperCase())) continue;
            return false;
        }
        return true;
    }

    String getErrorMessage(String string, String string2) {
        String string3 = "";
        string3 = string2 == null ? Resource.getString(string) : Resource.format(string, string2);
        return string3;
    }
}

