/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica.ver20h;

abstract class FaverChipBlock {
    static final int BLOCK_DIV_UNUSE = 0;
    static final int BLOCK_DIV_MANUFAC = 1;
    static final int BLOCK_DIV_ISSUE = 2;
    static final int BLOCK_DIV_SYSTEM = 3;
    static final int BLOCK_DIV_AREA = 4;
    static final int BLOCK_DIV_SERVICE = 5;
    static final int BLOCK_DIV_USER_DATA = 6;
    static final int BLOCK_DIV_CONTAINER_ID = 7;
    static final int BLOCK_DIV_CONTAINER_ISSUE = 8;
    int division;
    long parentCode;
    int position;
    byte[] data;
    byte[] info;

    FaverChipBlock(int n, byte[] byArray, byte[] byArray2) {
        this.division = n;
        this.data = byArray;
        this.info = byArray2;
    }

    int byte2int(int n, byte[] byArray) {
        return this.byte2int(n, byArray, 2);
    }

    long byte2long(int n, byte[] byArray) {
        return this.byte2long(n, byArray, 4);
    }

    int byte2int(int n, byte[] byArray, int n2) {
        if (n2 < 0 || byArray.length < n + n2 || 4 < n2) {
            return -1;
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = 0xFF & byArray[n + i];
            n3 |= (n4 <<= 8 * (n2 - 1 - i));
        }
        return n3;
    }

    long byte2long(int n, byte[] byArray, int n2) {
        if (n2 < 0 || byArray.length < n + n2 || 4 < n2) {
            return -1L;
        }
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            long l2 = 0xFFL & (long)byArray[n + i];
            l |= (l2 <<= 8 * (n2 - 1 - i));
        }
        return l;
    }

    void setData(int n, int n2) {
        this.setBytes(n, n2, this.data);
    }

    void setData(long l, int n) {
        this.setBytes(l, n, this.data);
    }

    void setInfo(int n, int n2) {
        this.setBytes(n, n2, this.info);
    }

    void setInfo(long l, int n) {
        this.setBytes(l, n, this.info);
    }

    void setInfo(int n, int n2, int n3) {
        this.setBytes(n, n2, this.info, n3);
    }

    void setInfo(long l, int n, int n2) {
        this.setBytes(l, n, this.info, n2);
    }

    private void setBytes(int n, int n2, byte[] byArray) {
        this.setBytes(n, n2, byArray, 2);
    }

    private void setBytes(long l, int n, byte[] byArray) {
        this.setBytes(l, n, byArray, 4);
    }

    private void setBytes(int n, int n2, byte[] byArray, int n3) {
        if (n3 < 0 || byArray.length < n2 + n3 || 4 < n3) {
            return;
        }
        byte[] byArray2 = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            int n4 = 255 << 8 * (n3 - 1 - i);
            byArray2[i] = (byte)((n4 & n) >> 8 * (n3 - 1 - i));
        }
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
    }

    private void setBytes(long l, int n, byte[] byArray, int n2) {
        if (n2 < 0 || byArray.length < n + n2 || 4 < n2) {
            return;
        }
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            long l2 = 255L << 8 * (n2 - 1 - i);
            byArray2[i] = (byte)((l2 & l) >> 8 * (n2 - 1 - i));
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public void setDataBytes(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(byArray, n, this.data, n2, n3);
    }

    public void setInfoBytes(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(byArray, n, this.info, n2, n3);
    }

    abstract byte[] getDataBytes();

    abstract byte[] getInfoBytes();
}

