/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica.ver20h;

import com.nttdocomo.dojaemu.ktoolbar.felica.NodeCode;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipArea;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipBlock;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipUserData;
import java.util.Vector;

class NodeCodeArea
extends NodeCode {
    private String keyVer;
    private String endService;
    private String assignNum;
    private String freeNum;
    private boolean creatable;
    private boolean comparison;
    private FaverChipArea fcvArea;
    private NodeCode pinNode;

    NodeCodeArea() {
        this.nodeType = 3;
        this.nodeCode = "00000000";
        this.keyVer = "0";
        this.endService = "0";
        this.assignNum = "0";
        this.freeNum = "0";
        this.creatable = false;
        this.comparison = false;
        this.pinNode = null;
    }

    NodeCodeArea(int n) {
        this();
        this.areaType = n;
    }

    public void setArea(FaverChipBlock faverChipBlock) {
        this.fcvArea = (FaverChipArea)faverChipBlock;
        this.nodeCode = this.getHexString(faverChipBlock.getDataBytes(), 0, 4);
        this.keyVer = this.getHexString(faverChipBlock.getDataBytes(), 4, 2);
        this.endService = this.getHexString(faverChipBlock.getDataBytes(), 6, 4);
        this.assignNum = this.getHexString(faverChipBlock.getDataBytes(), 10, 2);
        this.freeNum = this.getHexString(faverChipBlock.getDataBytes(), 12, 2);
        this.creatable = (((FaverChipArea)faverChipBlock).code & 1L) == 0L;
        this.comparison = (((FaverChipArea)faverChipBlock).code & 0x20L) != 0L;
    }

    public void setPinNode(NodeCode nodeCode) {
        this.pinNode = nodeCode;
    }

    public NodeCode getPinNode() {
        return this.pinNode;
    }

    public FaverChipArea getAreaBlock() {
        return this.fcvArea;
    }

    public String getKeyVersion() {
        return this.keyVer;
    }

    public String getEndService() {
        return this.endService;
    }

    public boolean canCreateArea() {
        return (this.fcvArea.code & 1L) == 0L;
    }

    public boolean getComparison() {
        this.comparison = false;
        if (this.pinNode != null) {
            Vector vector = this.pinNode.getChildren();
            if (vector.size() != 1) {
                return false;
            }
            FaverChipUserData faverChipUserData = (FaverChipUserData)vector.elementAt(0);
            byte by = faverChipUserData.getDataBytes()[8];
            this.comparison = (by & 0x80) != 0;
        }
        return this.comparison;
    }

    public void setKeyVersion(String string) {
        this.keyVer = string.trim();
        byte[] byArray = this.getBytes(this.keyVer);
        this.fcvArea.setDataBytes(byArray, 0, 4, byArray.length);
    }

    public void setNodeCode(String string) {
        this.nodeCode = string.trim();
        byte[] byArray = this.getBytes(this.nodeCode);
        this.fcvArea.setDataBytes(byArray, 0, 0, byArray.length);
        this.creatable = (this.fcvArea.code & 1L) == 0L;
    }

    public void setEndService(String string) {
        this.endService = string.trim();
        byte[] byArray = this.getBytes(this.endService);
        this.fcvArea.setDataBytes(byArray, 0, 6, byArray.length);
    }
}

