/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica.ver20h;

import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipNode;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipNodeException;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewHierarchy;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewNodeCodeTree;
import com.nttdocomo.dojaemu.ktoolbar.felica.NodeCode;
import com.nttdocomo.dojaemu.ktoolbar.felica.NodeCodeInterface;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipArea;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipBlock;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipService;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeArea;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeService;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeSystem;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeTreeAction;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeTreeMouseAdapter;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeTreePopup;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class NodeCodeTree
extends FaverChipViewNodeCodeTree
implements TreeSelectionListener {
    private NodeCodeTreePopup popup = null;
    private FaverChipViewHierarchy parent;
    private NodeCode currentNode;
    NodeCodeTreeAction treeAction = null;
    private FaverChipNode faverChipNode;
    private boolean selectionEnabled;
    private DefaultMutableTreeNode target;
    private TreePath oldSelectPath = null;
    private int oldSelectRow;
    private boolean[] memmem = new boolean[384];

    @Override
    public void create(FaverChipViewHierarchy faverChipViewHierarchy) {
        this.parent = faverChipViewHierarchy;
        this.target = null;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode, true);
        this.setModel(defaultTreeModel);
        this.setCellRenderer(new NodeCodeTreeCellRenderer());
        this.selectionEnabled = true;
        this.getSelectionModel().setSelectionMode(1);
        NodeCodeTreeMouseAdapter nodeCodeTreeMouseAdapter = new NodeCodeTreeMouseAdapter(this);
        this.addMouseListener(nodeCodeTreeMouseAdapter);
        this.popup = new NodeCodeTreePopup(this);
        this.addTreeSelectionListener(this);
    }

    @Override
    public void saveExpand() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.memmem[i] = this.isExpanded(i);
        }
    }

    @Override
    public void expand() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.memmem[i]) continue;
            this.expandRow(i);
        }
    }

    @Override
    public void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    @Override
    public void collapseAll() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            this.collapseRow(i);
        }
    }

    @Override
    public void reset() {
        this.selectionEnabled = true;
        this.target = null;
        this.oldSelectPath = null;
        this.currentNode = null;
        this.oldSelectRow = 0;
    }

    public void setTargetNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.target = defaultMutableTreeNode;
    }

    @Override
    public TreePath getOldSelectPath() {
        return this.oldSelectPath;
    }

    @Override
    public int getOldSelectRow() {
        return this.oldSelectRow;
    }

    @Override
    public boolean isNewNode() {
        return this.target != null && (this.target.toString().equals(Resource.getString("FCH_NODE_NEW_AREA")) || this.target.toString().equals(Resource.getString("FCH_NODE_NEW_SERVICE")));
    }

    public void setDelNode(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        Object[] objectArray = defaultMutableTreeNode.getUserObjectPath();
        NodeCode nodeCode = null;
        try {
            nodeCode = this.faverChipNode.getNodeCodeByPath(objectArray);
        }
        catch (FaverChipNodeException faverChipNodeException) {
            return;
        }
        this.faverChipNode.deleteNodeCode(nodeCode);
    }

    @Override
    public void createNodes(DefaultMutableTreeNode defaultMutableTreeNode, FaverChipNode faverChipNode) {
        this.target = null;
        this.faverChipNode = faverChipNode;
        NodeCode nodeCode = faverChipNode.getRootNodeCode();
        this.createNode(defaultMutableTreeNode, nodeCode);
    }

    private void createNode(DefaultMutableTreeNode defaultMutableTreeNode, NodeCode nodeCode) {
        Vector vector = nodeCode.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof NodeCodeInterface)) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(((NodeCode)e).getNodeCodeString());
            if (((NodeCode)e).getNodeCodeType() < 4) {
                this.createNode(defaultMutableTreeNode2, (NodeCode)e);
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    @Override
    public void enabledSelectionListener(boolean bl) {
        if (bl) {
            this.addTreeSelectionListener(this);
        } else {
            this.removeTreeSelectionListener(this);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        String string;
        this.removeTreeSelectionListener(this);
        if (!this.selectionEnabled) {
            if (this.target == null) {
                this.addTreeSelectionListener(this);
                return;
            }
            if (this.parent.checkTreeNode()) {
                this.selectionEnabled = true;
                this.parent.updateTree();
                this.addTreeSelectionListener(this);
                return;
            }
            if (this.oldSelectRow != -1) {
                this.setSelectionRow(this.oldSelectRow);
                this.scrollRowToVisible(this.oldSelectRow);
            }
            this.addTreeSelectionListener(this);
            return;
        }
        Object[] objectArray = treeSelectionEvent.getPath().getPath();
        try {
            this.currentNode = this.faverChipNode.getNodeCodeByPath(objectArray);
        }
        catch (FaverChipNodeException faverChipNodeException) {
            this.parent.showDialog(this.parent, faverChipNodeException.getMessage());
            this.parent.updateTree();
            this.addTreeSelectionListener(this);
            return;
        }
        if (objectArray.length > 1 && ((string = objectArray[objectArray.length - 1].toString()).equals(Resource.getString("FCH_NODE_NEW_AREA")) || string.equals(Resource.getString("FCH_NODE_NEW_SERVICE")))) {
            this.selectionEnabled = false;
        }
        if (!this.parent.updateTreeNode(this.currentNode)) {
            if (this.oldSelectRow != -1) {
                this.setSelectionRow(this.oldSelectRow);
                this.scrollRowToVisible(this.oldSelectRow);
            }
            this.addTreeSelectionListener(this);
            return;
        }
        this.oldSelectPath = treeSelectionEvent.getPath();
        this.oldSelectRow = this.getSelectionRow();
        if (this.oldSelectRow != -1) {
            this.parent.updateTree();
            this.setSelectionRow(this.oldSelectRow);
            this.scrollRowToVisible(this.oldSelectRow);
        }
        this.addTreeSelectionListener(this);
    }

    @Override
    public int currentNodeBlockPos() {
        int n = 0;
        if (this.currentNode == null || this.isNewNode()) {
            return 0;
        }
        int n2 = this.currentNode.getNodeCodeType();
        if (n2 == 1) {
            n = 0;
        } else if (n2 == 2) {
            FaverChipBlock faverChipBlock = ((NodeCodeSystem)this.currentNode).getSystemBlock();
            n = faverChipBlock.position;
        } else if (n2 == 3) {
            FaverChipArea faverChipArea = ((NodeCodeArea)this.currentNode).getAreaBlock();
            n = faverChipArea.position;
        } else if (n2 == 4) {
            FaverChipService faverChipService = ((NodeCodeService)this.currentNode).getServiceBlock();
            n = faverChipService.position;
        }
        return n;
    }

    public void showPopupMenu(MouseEvent mouseEvent, boolean bl) {
        if (bl && this.selectionEnabled) {
            if (this.currentNode == null) {
                return;
            }
            int n = this.currentNode.getNodeCodeType();
            int n2 = this.currentNode.getAreaType();
            if (n2 == 1) {
                this.popup.setMenuEnabled(100, true);
                if (n == 3) {
                    NodeCodeArea nodeCodeArea = (NodeCodeArea)this.currentNode;
                    FaverChipArea faverChipArea = nodeCodeArea.getAreaBlock();
                    if ((faverChipArea.code & 1L) == 1L) {
                        this.popup.setMenuEnabled(10, false);
                        this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                } else if (n == 4 && !((NodeCodeService)this.currentNode).isPINService()) {
                    this.popup.setMenuEnabled(0, false);
                    this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c != '\uffff') {
            keyEvent.consume();
        }
        super.processKeyEvent(keyEvent);
    }

    private int getSelectionRow() {
        int[] nArray = this.getSelectionRows();
        if (nArray == null || nArray.length == 0) {
            return -1;
        }
        return nArray[0];
    }

    public void reload() {
        this.removeTreeSelectionListener(this);
        this.parent.updateTree();
        this.addTreeSelectionListener(this);
    }

    class NodeCodeTreeCellRenderer
    implements TreeCellRenderer {
        private final String ICON_DIR = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "images" + File.separator;
        private final String[] iconFile = new String[]{"card.gif", "system.gif", "area.gif", "service.gif", "pin.gif"};
        private ImageIcon[] icon = new ImageIcon[this.iconFile.length];

        public NodeCodeTreeCellRenderer() {
            for (int i = 0; i < this.icon.length; ++i) {
                this.icon[i] = new ImageIcon(this.ICON_DIR + this.iconFile[i]);
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            String string = object.toString();
            JLabel jLabel = new JLabel(string);
            ImageIcon imageIcon = this.icon[0];
            if (string == null || string.equals("")) {
                return jLabel;
            }
            if ((string = string.trim()).equals("card")) {
                imageIcon = this.icon[0];
            } else if (string.length() == 4) {
                imageIcon = this.icon[1];
            } else if (string.equals(Resource.getString("FCH_NODE_NEW_AREA"))) {
                imageIcon = this.icon[2];
            } else if (string.equals(Resource.getString("FCH_NODE_NEW_SERVICE"))) {
                imageIcon = this.icon[3];
            } else {
                long l = 0L;
                try {
                    l = Long.parseLong(string, 16);
                }
                catch (Exception exception) {
                    return jLabel;
                }
                imageIcon = (l & 0x20L) != 0L ? this.icon[4] : ((l & 0x1FL) >= 8L ? this.icon[3] : this.icon[2]);
            }
            jLabel.setIcon(imageIcon);
            if (!NodeCodeTree.this.selectionEnabled) {
                if (string.equals(Resource.getString("FCH_NODE_NEW_AREA")) || string.equals(Resource.getString("FCH_NODE_NEW_SERVICE"))) {
                    jLabel.setForeground(Color.RED);
                }
            } else if (bl) {
                jLabel.setForeground(Color.RED);
            }
            return jLabel;
        }
    }
}

