/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl.swt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.cocoa.NSNotificationCenter;
import org.eclipse.swt.internal.cocoa.NSOpenGLContext;
import org.eclipse.swt.internal.cocoa.NSOpenGLPixelFormat;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Listener;
import org.lwjgl.opengl.swt.AbstractPlatformGLCanvas;
import org.lwjgl.opengl.swt.GLCanvas;
import org.lwjgl.opengl.swt.GLData;

class PlatformMacOSXGLCanvas
extends AbstractPlatformGLCanvas {
    private NSOpenGLContext context;
    private NSOpenGLPixelFormat pixelFormat;
    private static final int MAX_ATTRIB = 32;
    private static final String GLCONTEXT_KEY = "org.eclipse.swt.internal.cocoa.glcontext";
    private NSView view;
    static final int NSOpenGLPFAOpenGLProfile = 99;
    static final int NSOpenGLProfileVersion3_2Core = 12800;
    static final int NSOpenGLProfileVersionLegacy = 4096;
    static final int NSOpenGLProfileVersion4_1Core = 16640;

    PlatformMacOSXGLCanvas() {
    }

    public long create(GLCanvas canvas, GLData data, GLData effective) {
        if (data == null) {
            SWT.error((int)4);
        }
        this.view = canvas.view;
        int[] attrib = new int[32];
        int pos = 0;
        if (data.doubleBuffer) {
            attrib[pos++] = 5;
        }
        if (data.stereo) {
            attrib[pos++] = 6;
        }
        if (data.redSize + data.blueSize + data.greenSize > 0) {
            attrib[pos++] = 8;
            attrib[pos++] = data.redSize + data.greenSize + data.blueSize;
        }
        if (data.alphaSize > 0) {
            attrib[pos++] = 11;
            attrib[pos++] = data.alphaSize;
        }
        if (data.depthSize > 0) {
            attrib[pos++] = 12;
            attrib[pos++] = data.depthSize;
        }
        if (data.stencilSize > 0) {
            attrib[pos++] = 13;
            attrib[pos++] = data.stencilSize;
        }
        if (data.profile == GLData.Profile.CORE) {
            attrib[pos++] = 99;
            attrib[pos++] = 12800;
        }
        if (data.profile == GLData.Profile.COMPATIBILITY) {
            attrib[pos++] = 99;
            attrib[pos++] = 4096;
        } else if (data.majorVersion >= 4) {
            attrib[pos++] = 99;
            attrib[pos++] = 16640;
        } else if (data.majorVersion >= 3) {
            attrib[pos++] = 99;
            attrib[pos++] = 12800;
        } else {
            attrib[pos++] = 99;
            attrib[pos++] = 4096;
        }
        if (data.accumRedSize + data.accumBlueSize + data.accumGreenSize > 0) {
            attrib[pos++] = 14;
            attrib[pos++] = data.accumRedSize + data.accumGreenSize + data.accumBlueSize + data.accumAlphaSize;
        }
        if (data.sampleBuffers > 0) {
            attrib[pos++] = 55;
            attrib[pos++] = data.sampleBuffers;
        }
        if (data.samples > 0) {
            attrib[pos++] = 56;
            attrib[pos++] = data.samples;
        }
        attrib[pos++] = 0;
        this.pixelFormat = (NSOpenGLPixelFormat)new NSOpenGLPixelFormat().alloc();
        if (this.pixelFormat == null) {
            canvas.dispose();
            SWT.error((int)38);
        }
        this.pixelFormat.initWithAttributes(attrib);
        NSOpenGLContext ctx = data.shareContext != null ? new NSOpenGLContext(data.shareContext.context) : null;
        this.context = (NSOpenGLContext)new NSOpenGLContext().alloc();
        if (this.context == null) {
            canvas.dispose();
            SWT.error((int)38);
        }
        this.context = this.context.initWithFormat(this.pixelFormat, ctx);
        if (data.swapInterval != null && data.swapInterval > 0) {
            this.context.setValues(new int[]{data.swapInterval}, 222L);
        }
        this.context.setValues(new int[]{-1}, 235L);
        canvas.setData(GLCONTEXT_KEY, (Object)this.context);
        NSNotificationCenter.defaultCenter().addObserver((id)this.view, OS.sel_updateOpenGLContext_, OS.NSViewGlobalFrameDidChangeNotification, (id)this.view);
        Listener listener = event -> {
            switch (event.type) {
                case 12: {
                    canvas.setData(GLCONTEXT_KEY, null);
                    NSNotificationCenter.defaultCenter().removeObserver((id)this.view);
                    if (this.context != null) {
                        this.context.clearDrawable();
                        this.context.release();
                    }
                    this.context = null;
                    if (this.pixelFormat != null) {
                        this.pixelFormat.release();
                    }
                    this.pixelFormat = null;
                }
            }
        };
        canvas.addListener(12, listener);
        long[] longptr = new long[1];
        this.pixelFormat.getValues(longptr, 11, 0);
        effective.alphaSize = (int)longptr[0];
        this.pixelFormat.getValues(longptr, 12, 0);
        effective.depthSize = (int)longptr[0];
        this.pixelFormat.getValues(longptr, 13, 0);
        effective.stencilSize = (int)longptr[0];
        this.pixelFormat.getValues(longptr, 5, 0);
        effective.doubleBuffer = longptr[0] == 1L;
        this.pixelFormat.getValues(longptr, 6, 0);
        effective.stereo = longptr[0] == 1L;
        this.pixelFormat.getValues(longptr, 99, 0);
        if (longptr[0] == 12800L) {
            effective.majorVersion = 3;
            effective.minorVersion = 2;
            effective.profile = GLData.Profile.CORE;
        } else if (longptr[0] == 4096L) {
            effective.profile = GLData.Profile.COMPATIBILITY;
        } else if (longptr[0] == 16640L) {
            effective.majorVersion = 4;
            effective.minorVersion = 1;
            effective.profile = GLData.Profile.CORE;
        }
        this.pixelFormat.getValues(longptr, 55, 0);
        data.sampleBuffers = (int)longptr[0];
        this.pixelFormat.getValues(longptr, 56, 0);
        data.samples = (int)longptr[0];
        return this.context.id;
    }

    public boolean isCurrent(long context) {
        NSOpenGLContext current = NSOpenGLContext.currentContext();
        return current != null && current.id == context;
    }

    public boolean makeCurrent(GLCanvas canvas, long context) {
        new NSOpenGLContext(context).makeCurrentContext();
        return true;
    }

    public boolean deleteContext(GLCanvas canvas, long context) {
        canvas.setData(GLCONTEXT_KEY, null);
        NSNotificationCenter.defaultCenter().removeObserver((id)this.view);
        NSOpenGLContext ctx = new NSOpenGLContext(context);
        if (ctx != null) {
            ctx.clearDrawable();
            ctx.release();
        }
        ctx = null;
        if (this.pixelFormat != null) {
            this.pixelFormat.release();
        }
        this.pixelFormat = null;
        return true;
    }

    public boolean swapBuffers(GLCanvas canvas) {
        new NSOpenGLContext(canvas.context).flushBuffer();
        return true;
    }

    public boolean delayBeforeSwapNV(GLCanvas canvas, float seconds) {
        return false;
    }
}

