/*
 * Decompiled with CFR 0.152.
 */
package com.jblend.kdwp;

import com.jblend.kdwp.JkHSocket;
import java.io.IOException;
import java.io.InputStream;

class InputJkHStream
extends InputStream {
    private int handle;
    private boolean isClosed;
    private JkHSocket soc;

    InputJkHStream(JkHSocket jkHSocket) {
        this.handle = jkHSocket.handle;
        this.soc = jkHSocket;
    }

    private static native int JkHReadByteDebugStream(int var0, byte[] var1);

    public int read() throws IOException {
        if (this.isClosed || this.soc.isClosed) {
            throw new IOException("try to read closed stream");
        }
        byte[] byArray = new byte[1];
        int n = InputJkHStream.JkHReadByteDebugStream(this.handle, byArray);
        if (n != 0) {
            throw new IOException("JkHReadByteDebugStream()->" + n);
        }
        return byArray[0] & 0xFF;
    }

    private static native int JkHReadDebugStream(int var0, byte[] var1, int var2, int var3, Integer var4);

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed || this.soc.isClosed) {
            throw new IOException("try to read closed stream");
        }
        if (n < 0 || n2 < 0 || byArray.length < n + n2) {
            throw new IndexOutOfBoundsException("illegal off=" + n + " or len=" + n2);
        }
        Integer n3 = new Integer(0);
        int n4 = InputJkHStream.JkHReadDebugStream(this.handle, byArray, n, n2, n3);
        if (n4 != 0) {
            throw new IOException("JkHReadDebugStream(" + n2 + ")->" + n4);
        }
        return n3;
    }

    public void close() {
        this.isClosed = true;
    }
}

