/*
 * Decompiled with CFR 0.152.
 */
package com.jblend.kdwp;

import com.jblend.kdwp.JkHSocket;
import java.io.IOException;
import java.io.OutputStream;

class OutputJkHStream
extends OutputStream {
    private int handle;
    private boolean isClosed;
    private JkHSocket soc;

    OutputJkHStream(JkHSocket jkHSocket) {
        this.handle = jkHSocket.handle;
        this.soc = jkHSocket;
    }

    private static native int JkHWriteByteDebugStream(int var0, int var1);

    public void write(int n) throws IOException {
        if (this.isClosed || this.soc.isClosed) {
            throw new IOException("try to write closed stream");
        }
        int n2 = OutputJkHStream.JkHWriteByteDebugStream(this.handle, n);
        if (n2 != 0) {
            throw new IOException("JkHWriteByteDebugStream()->" + n2);
        }
    }

    private static native int JkHWriteDebugStream(int var0, byte[] var1, int var2, int var3, Integer var4);

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed || this.soc.isClosed) {
            throw new IOException("try to write closed stream");
        }
        if (n < 0 || n2 < 0 || byArray.length < n + n2) {
            throw new IndexOutOfBoundsException("illegal off=" + n + " or len=" + n2);
        }
        Integer n3 = new Integer(0);
        while (true) {
            int n4;
            if ((n4 = OutputJkHStream.JkHWriteDebugStream(this.handle, byArray, n, n2, n3)) != 0) {
                throw new IOException("JkHWriteDebugStream()->" + n4);
            }
            if ((n2 -= n3.intValue()) <= 0) break;
            n += n3.intValue();
        }
    }

    public void close() throws IOException {
        this.isClosed = true;
    }
}

