/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import com.jblend.kdwp.KVMSocketInterface;
import com.jblend.kdwp.MemoryMapFrame;
import com.jblend.kdwp.QuitFrame;
import com.jblend.kdwp.UncompressKdwpData;
import java.io.IOException;
import java.util.Map;
import kdp.Flag;
import kdp.Options;
import kdp.Packet;
import kdp.PacketStream;
import kdp.ProxyListener;
import kdp.SocketConnection;
import kdp.VMConstants;
import kdp.classparser.ClassFile;
import kdp.classparser.ClassManager;
import kdp.classparser.MethodInfo;
import kdp.classparser.attributes.CodeAttribute;
import kdp.classparser.attributes.LineNumberTableAttribute;

class KVMListener
extends ProxyListener
implements VMConstants,
Flag {
    SocketConnection connKvm;
    ProxyListener debuggerListener = null;
    ClassManager manager;
    Options options;
    boolean Ready = false;
    boolean useClassParser = false;
    KVMSocketInterface remoteSocket = null;
    MemoryMapFrame memoryMapFrame = null;
    UncompressKdwpData uncompressKdwp;
    int wait_times = 5;
    QuitFrame quitFrame = null;

    public KVMListener(Options options) {
        this.options = options;
        this.useClassParser = options.getUseClassParser();
    }

    public void set(ProxyListener proxyListener, ClassManager classManager, UncompressKdwpData uncompressKdwpData) {
        this.debuggerListener = proxyListener;
        this.manager = classManager;
        this.uncompressKdwp = uncompressKdwpData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(Packet packet) throws IOException {
        Object object = this;
        synchronized (object) {
            while (!this.Ready) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        object = String.valueOf(packet.id);
        Map map = this.waitingQueue;
        synchronized (map) {
            if ((packet.flags & 0x80) == 0 && packet.id < 0) {
                this.waitingQueue.put(object, packet);
            }
        }
        this.connKvm.send(packet);
    }

    public void quit() {
        boolean bl = this.timeToQuit;
        this.timeToQuit = true;
        if (bl != this.timeToQuit) {
            try {
                if (this.remoteSocket != null) {
                    this.remoteSocket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.debuggerListener.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        ClassFile classFile;
        int n;
        String string;
        int n2;
        byte by;
        int n3;
        int n4;
        try {
            while (this.remoteSocket == null) {
                try {
                    this.remoteSocket = (KVMSocketInterface)Class.forName(this.options.getSocketClassName()).newInstance();
                    this.remoteSocket.connect(this.options.getRemoteHost(), this.options.getRemotePort());
                }
                catch (IOException iOException) {
                    if (this.remoteSocket != null) {
                        this.remoteSocket.close();
                        this.remoteSocket = null;
                    }
                    System.err.println("KVM not ready: " + iOException.getMessage());
                    if (this.wait_times > 0 && --this.wait_times == 0) {
                        System.err.println("Failed to connect to KVM.");
                        Runtime.getRuntime().exit(1);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.connKvm = new SocketConnection(this, this.remoteSocket);
        }
        catch (IOException iOException) {
            System.out.println("KVMListener: " + iOException.getMessage());
        }
        catch (SecurityException securityException) {
            System.out.println("KVMListener: " + securityException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("KVMListener: " + classNotFoundException.toString());
            Runtime.getRuntime().exit(1);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("KVMListener: " + instantiationException.toString());
            Runtime.getRuntime().exit(1);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("KVMListener: " + illegalAccessException.toString());
            Runtime.getRuntime().exit(1);
        }
        Object object = this;
        // MONITORENTER : object
        this.Ready = true;
        this.notify();
        // MONITOREXIT : object
        if (!this.useClassParser) {
            object = new String("JDWP-Handshake").getBytes();
            try {
                int n5;
                for (n5 = 0; n5 < ((Object)object).length; ++n5) {
                    this.connKvm.sendByte((byte)object[n5]);
                }
                for (n5 = 0; n5 < ((Object)object).length; ++n5) {
                    this.connKvm.receiveByte();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        new Thread(this.connKvm).start();
        if (this.options.getMemoryMap()) {
            this.memoryMapFrame.start();
            if (this.quitFrame != null) {
                this.quitFrame.dispose();
                this.quitFrame = null;
            }
        }
        if (this.useClassParser) {
            PacketStream packetStream = new PacketStream(this, 128, 1);
            packetStream.writeString("KVM Reference Debugger Agent");
            packetStream.writeByte((byte)1);
            packetStream.writeByte((byte)2);
            packetStream.send();
            try {
                packetStream.waitForReply();
            }
            catch (Exception exception) {
                System.out.println("Exception during handshake: " + exception + " exiting...");
                Runtime.getRuntime().exit(1);
            }
            object = packetStream.readString();
            int n6 = packetStream.readInt();
            if (this.uncompressKdwp != null) {
                packetStream = new PacketStream(this, 201, 4);
                packetStream.writeInt(this.uncompressKdwp.getCodeLength() | this.uncompressKdwp.getParam() << 16);
                packetStream.send();
            }
            if ((n6 & 0x18000) >> 15 == 2) {
                method_index_base = 1;
            }
            packetStream = new PacketStream(this, 1, 3);
            packetStream.send();
            try {
                packetStream.waitForReply();
            }
            catch (Exception exception) {
                System.out.println("Couldn't get list of classes from KVM");
            }
            n4 = packetStream.readInt();
            for (n3 = 0; n3 < n4; ++n3) {
                by = packetStream.readByte();
                n2 = packetStream.readInt();
                string = this.getUncompressKdwpClassName(packetStream, by, true);
                if (this.options.getHideClasses() && string == null) {
                    packetStream.readInt();
                    continue;
                }
                if (by != 3) {
                    string = new String(string.substring(1, string.length() - 1));
                }
                n = packetStream.readInt();
                classFile = (ClassFile)ClassManager.classMap.get(new Integer(n2));
                if (classFile != null || (classFile = this.manager.findClass(by, string)) == null) continue;
                classFile.setClassID(n2);
                classFile.setClassStatus(n);
                ClassManager.classMap.put(new Integer(n2), classFile);
            }
        }
        try {
            while (!this.timeToQuit) {
                boolean bl = false;
                Packet packet = this.waitForPacket();
                if (packet == null) {
                    System.exit(0);
                }
                if (this.useClassParser && (packet.flags & 0x80) == 0) {
                    switch (packet.cmdSet) {
                        case 200: {
                            object = new PacketStream(this, packet);
                            switch (packet.cmd) {
                                case 1: {
                                    System.out.print((char)((PacketStream)object).readInt());
                                    break;
                                }
                                case 2: {
                                    n4 = ((PacketStream)object).readInt();
                                    n3 = ((PacketStream)object).readInt();
                                    String string2 = ((PacketStream)object).readString();
                                    String string3 = ((PacketStream)object).readString();
                                    String string4 = ((PacketStream)object).readString();
                                    long l = ((PacketStream)object).readLong();
                                    if (this.memoryMapFrame == null) break;
                                    this.memoryMapFrame.add(n4, n3, string2, string3, string4, l);
                                    break;
                                }
                                case 3: {
                                    if (this.memoryMapFrame == null) break;
                                    this.memoryMapFrame.removeAll();
                                    break;
                                }
                                case 4: {
                                    n4 = ((PacketStream)object).readInt();
                                    n3 = ((PacketStream)object).readInt();
                                    if (this.memoryMapFrame == null) break;
                                    this.memoryMapFrame.initMap(n4, n3);
                                    break;
                                }
                            }
                            bl = true;
                            break;
                        }
                        case 64: {
                            block20 : switch (packet.cmd) {
                                case 100: {
                                    object = new PacketStream(this, packet);
                                    n4 = ((PacketStream)object).readByte();
                                    int n7 = n3 = ((PacketStream)object).readInt();
                                    while (n7-- > 0) {
                                        byte by2 = ((PacketStream)object).readByte();
                                        if (by2 != 8) break block20;
                                        int n8 = ((PacketStream)object).readInt();
                                        int n9 = ((PacketStream)object).readInt();
                                        by = ((PacketStream)object).readByte();
                                        n2 = ((PacketStream)object).readInt();
                                        string = this.getUncompressKdwpClassName((PacketStream)object, by, n3 == 1);
                                        if (this.options.getHideClasses() && string == null) {
                                            string = by != 3 ? "Ldo;" : "[Ldo;";
                                        }
                                        n = ((PacketStream)object).readInt();
                                        if (n3 == 1 && this.uncompressKdwp != null && by != 3) {
                                            byte[] byArray = string.getBytes("UTF8");
                                            int n10 = byArray.length;
                                            byte[] byArray2 = new byte[27 + n10];
                                            System.arraycopy(packet.data, 0, byArray2, 0, 19);
                                            byArray2[19] = (byte)(n10 >>> 24);
                                            byArray2[20] = (byte)(n10 >>> 16);
                                            byArray2[21] = (byte)(n10 >>> 8);
                                            byArray2[22] = (byte)n10;
                                            System.arraycopy(byArray, 0, byArray2, 23, n10);
                                            n10 += 23;
                                            byArray2[n10++] = (byte)(n >>> 24);
                                            byArray2[n10++] = (byte)(n >>> 16);
                                            byArray2[n10++] = (byte)(n >>> 8);
                                            byArray2[n10] = (byte)n;
                                            packet.data = byArray2;
                                        }
                                        if (by != 3) {
                                            string = new String(string.substring(1, string.length() - 1));
                                        }
                                        if ((classFile = (ClassFile)ClassManager.classMap.get(new Integer(n2))) == null) {
                                            classFile = this.manager.findClass(by, string);
                                            if (classFile == null) continue;
                                            ClassManager.classMap.put(new Integer(n2), classFile);
                                            classFile.setClassID(n2);
                                            classFile.setClassStatus(n);
                                            continue;
                                        }
                                        classFile.setClassStatus(n);
                                    }
                                    break block20;
                                }
                            }
                            break;
                        }
                        case 128: {
                            switch (packet.cmd) {
                                case 3: {
                                    object = new PacketStream(this, packet);
                                    this.handleSteppingInfo((PacketStream)object);
                                    bl = true;
                                }
                            }
                            break;
                        }
                    }
                }
                if (bl) continue;
                this.disp(packet);
                if (packet.cmdSet != 64 || packet.cmd == 100) {
                    // empty if block
                }
                this.debuggerListener.send(packet);
            }
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void handleSteppingInfo(PacketStream packetStream) {
        long l;
        long l2;
        long l3;
        MethodInfo methodInfo;
        int n = packetStream.readInt();
        int n2 = packetStream.readInt();
        int n3 = packetStream.readInt() - method_index_base;
        long l4 = packetStream.readLong();
        PacketStream packetStream2 = new PacketStream(this, 128, 2);
        packetStream2.writeInt(n);
        ClassFile classFile = (ClassFile)ClassManager.classMap.get(new Integer(n2));
        if (classFile == null || (methodInfo = classFile.getMethodInfoByIndex(n3)) == null) {
            if (this.options.getHideClasses()) {
                packetStream2.writeLong(-1L);
                packetStream2.writeLong(-1L);
                packetStream2.writeLong(-1L);
            } else {
                packetStream2.writeLong(0L);
                packetStream2.writeLong(0L);
            }
            packetStream2.send();
            try {
                packetStream2.waitForReply();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        LineNumberTableAttribute lineNumberTableAttribute = null;
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute != null) {
            lineNumberTableAttribute = codeAttribute.getLineNumberTable();
        }
        if (codeAttribute == null || lineNumberTableAttribute == null) {
            l3 = -1L;
            l2 = -1L;
            l = -1L;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
        } else {
            int n7 = lineNumberTableAttribute.getCurrentLineCodeIndex(l4);
            int n8 = lineNumberTableAttribute.getNextExecutableLineCodeIndex(l4);
            int n9 = lineNumberTableAttribute.getDupCurrentExecutableLineCodeIndex(l4);
            l = lineNumberTableAttribute.getStartPCFromIndex(n8);
            l2 = lineNumberTableAttribute.getStartPCFromIndex(n9);
            l3 = lineNumberTableAttribute.getOffsetofDupNextLine(n9);
        }
        if (lineNumberTableAttribute != null) {
            // empty if block
        }
        packetStream2.writeLong(l);
        packetStream2.writeLong(l2);
        packetStream2.writeLong(l3);
        packetStream2.send();
        try {
            packetStream2.waitForReply();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return new String("KVMListener: ");
    }

    void startMemoryMap() {
        this.sendCommandToKvm(1);
    }

    void stopMemoryMap() {
        this.sendCommandToKvm(2);
    }

    void refreshMemoryMap() {
        this.sendCommandToKvm(3);
    }

    private void sendCommandToKvm(int n) {
        PacketStream packetStream = new PacketStream(this, 201, n);
        packetStream.send();
    }

    String getUncompressKdwpClassName(PacketStream packetStream, byte by, boolean bl) {
        if (this.uncompressKdwp != null && by != 3 && bl) {
            int n = 0;
            int n2 = this.uncompressKdwp.getCodeLength();
            for (int i = 0; i < n2; ++i) {
                n <<= 8;
                n |= packetStream.readByte() & 0xFF;
            }
            return this.uncompressKdwp.get(n);
        }
        return packetStream.readString();
    }
}

