/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import kdp.Flag;
import kdp.classparser.FileReference;

public class SearchPath
implements Flag {
    private String pathString;
    private String[] pathArray;

    public SearchPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        this.pathString = string;
        this.pathArray = arrayList.toArray(new String[arrayList.size()]);
        for (int i = 0; i < this.pathArray.length; ++i) {
        }
    }

    public boolean isEmpty() {
        return this.pathArray.length == 0;
    }

    public String asString() {
        return this.pathString;
    }

    public String[] asArray() {
        return (String[])this.pathArray.clone();
    }

    public int path_array_length() {
        return this.pathArray.length;
    }

    public FileReference resolve(String string) {
        if (!string.endsWith(".class")) {
            string = string + ".class";
        }
        for (int i = 0; i < this.pathArray.length; ++i) {
            FileReference fileReference = FileReference.create(this.pathArray[i], string);
            if (!fileReference.exists()) continue;
            return fileReference;
        }
        return null;
    }

    public String[] children(String string, FilenameFilter filenameFilter) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < this.pathArray.length; ++i) {
            String[] stringArray;
            FileReference fileReference = FileReference.create(this.pathArray[i], string);
            if (!fileReference.exists() || (stringArray = fileReference.list(filenameFilter)) == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (treeSet.contains(stringArray[j])) continue;
                treeSet.add(stringArray[j]);
            }
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }
}

