/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import kdp.classparser.attributes.Attribute;
import kdp.classparser.constantpoolclasses.ConstantDoubleInfo;
import kdp.classparser.constantpoolclasses.ConstantFloatInfo;
import kdp.classparser.constantpoolclasses.ConstantIntegerInfo;
import kdp.classparser.constantpoolclasses.ConstantLongInfo;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantStringInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class ConstantValueAttribute
extends Attribute {
    private int attributeNameIndex;
    private int attributeLength;
    private int constantValueIndex;

    public ConstantValueAttribute(DataInputStream dataInputStream, int n, int n2) throws IOException {
        this.attributeNameIndex = n;
        this.attributeLength = n2;
        this.constantValueIndex = dataInputStream.readUnsignedShort();
    }

    public String toString(ConstantPoolInfo[] constantPoolInfoArray) {
        String string = new String("");
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)constantPoolInfoArray[this.attributeNameIndex];
        string = string + constantUtf8Info.toString() + "\n\t\t\t";
        ConstantPoolInfo constantPoolInfo = constantPoolInfoArray[this.constantValueIndex];
        switch (constantPoolInfo.getTag()) {
            case 5: {
                ConstantLongInfo constantLongInfo = (ConstantLongInfo)constantPoolInfo;
                string = string + constantLongInfo.toString();
                break;
            }
            case 4: {
                ConstantFloatInfo constantFloatInfo = (ConstantFloatInfo)constantPoolInfo;
                string = string + constantFloatInfo.toString();
                break;
            }
            case 6: {
                ConstantDoubleInfo constantDoubleInfo = (ConstantDoubleInfo)constantPoolInfo;
                string = string + constantDoubleInfo.toString();
                break;
            }
            case 3: {
                ConstantIntegerInfo constantIntegerInfo = (ConstantIntegerInfo)constantPoolInfo;
                string = string + constantIntegerInfo.toString();
                break;
            }
            case 8: {
                ConstantStringInfo constantStringInfo = (ConstantStringInfo)constantPoolInfo;
                string = string + constantStringInfo.toString(constantPoolInfoArray);
            }
        }
        return string;
    }
}

