/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.spec.KeySpec;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Locale;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.net.ssl.SSLHandshakeException;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.DHKeyExchange;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.JsseJce;
import sun.security.ssl.Record;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLKeyExchange;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLTrafficKeyDerivation;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SupportedGroupsExtension;
import sun.security.ssl.Utilities;

final class DHClientKeyExchange {
    static final DHClientKeyExchangeConsumer dhHandshakeConsumer = new DHClientKeyExchangeConsumer();
    static final DHClientKeyExchangeProducer dhHandshakeProducer = new DHClientKeyExchangeProducer();

    DHClientKeyExchange() {
    }

    private static final class DHClientKeyExchangeConsumer
    implements SSLConsumer {
        private DHClientKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            Object object;
            Object object2;
            Object object3;
            Object object42;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            DHKeyExchange.DHEPossession dHEPossession = null;
            for (Object object42 : serverHandshakeContext.handshakePossessions) {
                if (!(object42 instanceof DHKeyExchange.DHEPossession)) continue;
                dHEPossession = (DHKeyExchange.DHEPossession)object42;
                break;
            }
            if (dHEPossession == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No expected DHE possessions for client key exchange");
            }
            SSLKeyExchange sSLKeyExchange = SSLKeyExchange.valueOf(serverHandshakeContext.negotiatedCipherSuite.keyExchange, serverHandshakeContext.negotiatedProtocol);
            if (sSLKeyExchange == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            object42 = new DHClientKeyExchangeMessage(serverHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming DH ClientKeyExchange handshake message", object42);
            }
            try {
                object3 = dHEPossession.publicKey.getParams();
                object2 = new DHPublicKeySpec(new BigInteger(1, ((DHClientKeyExchangeMessage)object42).y), ((DHParameterSpec)object3).getP(), ((DHParameterSpec)object3).getG());
                object = JsseJce.getKeyFactory("DiffieHellman");
                DHPublicKey dHPublicKey = (DHPublicKey)((KeyFactory)object).generatePublic((KeySpec)object2);
                if (!serverHandshakeContext.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), dHPublicKey)) {
                    throw new SSLHandshakeException("DHPublicKey does not comply to algorithm constraints");
                }
                SupportedGroupsExtension.NamedGroup namedGroup = SupportedGroupsExtension.NamedGroup.valueOf((DHParameterSpec)object3);
                serverHandshakeContext.handshakeCredentials.add(new DHKeyExchange.DHECredentials(dHPublicKey, namedGroup));
            }
            catch (IOException | GeneralSecurityException exception) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate DHPublicKey").initCause(exception);
            }
            object3 = sSLKeyExchange.createKeyDerivation(serverHandshakeContext);
            object2 = object3.deriveKey("MasterSecret", null);
            serverHandshakeContext.handshakeSession.setMasterSecret((SecretKey)object2);
            object = SSLTrafficKeyDerivation.valueOf(serverHandshakeContext.negotiatedProtocol);
            if (object == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)serverHandshakeContext.negotiatedProtocol));
            }
            serverHandshakeContext.handshakeKeyDerivation = ((SSLTrafficKeyDerivation)object).createKeyDerivation(serverHandshakeContext, (SecretKey)object2);
        }
    }

    private static final class DHClientKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private byte[] y;

        DHClientKeyExchangeMessage(HandshakeContext handshakeContext) throws IOException {
            super(handshakeContext);
            Object object2;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)handshakeContext;
            DHKeyExchange.DHEPossession dHEPossession = null;
            for (Object object2 : clientHandshakeContext.handshakePossessions) {
                if (!(object2 instanceof DHKeyExchange.DHEPossession)) continue;
                dHEPossession = (DHKeyExchange.DHEPossession)object2;
                break;
            }
            if (dHEPossession == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No DHE credentials negotiated for client key exchange");
            }
            DHPublicKey dHPublicKey = dHEPossession.publicKey;
            object2 = dHPublicKey.getParams();
            this.y = Utilities.toByteArray(dHPublicKey.getY());
        }

        DHClientKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)handshakeContext;
            if (byteBuffer.remaining() < 3) {
                throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid DH ClientKeyExchange message: insufficient data");
            }
            this.y = Record.getBytes16(byteBuffer);
            if (byteBuffer.hasRemaining()) {
                throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid DH ClientKeyExchange message: unknown extra data");
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CLIENT_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            return this.y.length + 2;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putBytes16(this.y);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"DH ClientKeyExchange\": '{'\n  \"parameters\": '{'\n    \"dh_Yc\": '{'\n{0}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            Object[] objectArray = new Object[]{Utilities.indent(hexDumpEncoder.encodeBuffer(this.y), "      ")};
            return messageFormat.format(objectArray);
        }
    }

    private static final class DHClientKeyExchangeProducer
    implements HandshakeProducer {
        private DHClientKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            Object object2;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            DHKeyExchange.DHECredentials dHECredentials = null;
            for (Object object2 : clientHandshakeContext.handshakeCredentials) {
                if (!(object2 instanceof DHKeyExchange.DHECredentials)) continue;
                dHECredentials = (DHKeyExchange.DHECredentials)object2;
                break;
            }
            if (dHECredentials == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No DHE credentials negotiated for client key exchange");
            }
            DHKeyExchange.DHEPossession dHEPossession = new DHKeyExchange.DHEPossession(dHECredentials, clientHandshakeContext.sslContext.getSecureRandom());
            clientHandshakeContext.handshakePossessions.add(dHEPossession);
            object2 = new DHClientKeyExchangeMessage(clientHandshakeContext);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced DH ClientKeyExchange handshake message", object2);
            }
            ((SSLHandshake.HandshakeMessage)object2).write(clientHandshakeContext.handshakeOutput);
            clientHandshakeContext.handshakeOutput.flush();
            SSLKeyExchange sSLKeyExchange = SSLKeyExchange.valueOf(clientHandshakeContext.negotiatedCipherSuite.keyExchange, clientHandshakeContext.negotiatedProtocol);
            if (sSLKeyExchange == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation sSLKeyDerivation = sSLKeyExchange.createKeyDerivation(clientHandshakeContext);
            SecretKey secretKey = sSLKeyDerivation.deriveKey("MasterSecret", null);
            clientHandshakeContext.handshakeSession.setMasterSecret(secretKey);
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(clientHandshakeContext.negotiatedProtocol);
            if (sSLTrafficKeyDerivation == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)clientHandshakeContext.negotiatedProtocol));
            }
            clientHandshakeContext.handshakeKeyDerivation = sSLTrafficKeyDerivation.createKeyDerivation(clientHandshakeContext, secretKey);
            return null;
        }
    }
}

