/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.crypto.spec.DHParameterSpec;
import javax.net.ssl.SSLProtocolException;
import sun.security.action.GetPropertyAction;
import sun.security.ssl.Alert;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.JsseJce;
import sun.security.ssl.PredefinedDHParameterSpecs;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLStringizer;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SunJSSE;
import sun.security.ssl.Utilities;

final class SupportedGroupsExtension {
    static final HandshakeProducer chNetworkProducer = new CHSupportedGroupsProducer();
    static final SSLExtension.ExtensionConsumer chOnLoadConsumer = new CHSupportedGroupsConsumer();
    static final SSLStringizer sgsStringizer = new SupportedGroupsStringizer();
    static final HandshakeProducer eeNetworkProducer = new EESupportedGroupsProducer();
    static final SSLExtension.ExtensionConsumer eeOnLoadConsumer = new EESupportedGroupsConsumer();

    SupportedGroupsExtension() {
    }

    private static final class CHSupportedGroupsConsumer
    implements SSLExtension.ExtensionConsumer {
        private CHSupportedGroupsConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            SupportedGroupsSpec supportedGroupsSpec;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_SUPPORTED_GROUPS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable supported_groups extension", new Object[0]);
                }
                return;
            }
            try {
                supportedGroupsSpec = new SupportedGroupsSpec(byteBuffer);
            }
            catch (IOException iOException) {
                throw serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
            }
            LinkedList<NamedGroup> linkedList = new LinkedList<NamedGroup>();
            for (int n : supportedGroupsSpec.namedGroupsIds) {
                NamedGroup namedGroup = NamedGroup.valueOf(n);
                if (namedGroup == null) continue;
                linkedList.add(namedGroup);
            }
            serverHandshakeContext.clientRequestedNamedGroups = linkedList;
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.CH_SUPPORTED_GROUPS, supportedGroupsSpec);
        }
    }

    private static final class CHSupportedGroupsProducer
    extends SupportedGroups
    implements HandshakeProducer {
        private CHSupportedGroupsProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_SUPPORTED_GROUPS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable supported_groups extension", new Object[0]);
                }
                return null;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(SupportedGroups.supportedNamedGroups.length);
            for (NamedGroup namedGroup : SupportedGroups.supportedNamedGroups) {
                if (!SupportedGroups.enableFFDHE && namedGroup.type == NamedGroupType.NAMED_GROUP_FFDHE) continue;
                if (namedGroup.isAvailable(clientHandshakeContext.activeProtocols) && namedGroup.isSupported(clientHandshakeContext.activeCipherSuites) && clientHandshakeContext.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), namedGroup.algorithm, (AlgorithmParameters)namedGroupParams.get((Object)namedGroup))) {
                    arrayList.add((Object)namedGroup);
                    continue;
                }
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                SSLLogger.fine("Ignore inactive or disabled named group: " + namedGroup.name, new Object[0]);
            }
            if (arrayList.isEmpty()) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("no available named group", new Object[0]);
                }
                return null;
            }
            int n = arrayList.size() << 1;
            byte[] byArray = new byte[n + 2];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Record.putInt16(byteBuffer, n);
            for (NamedGroup namedGroup : arrayList) {
                Record.putInt16(byteBuffer, namedGroup.id);
            }
            clientHandshakeContext.clientRequestedNamedGroups = Collections.unmodifiableList(arrayList);
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.CH_SUPPORTED_GROUPS, new SupportedGroupsSpec(arrayList));
            return byArray;
        }
    }

    private static final class EESupportedGroupsConsumer
    implements SSLExtension.ExtensionConsumer {
        private EESupportedGroupsConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            SupportedGroupsSpec supportedGroupsSpec;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.EE_SUPPORTED_GROUPS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable supported_groups extension", new Object[0]);
                }
                return;
            }
            try {
                supportedGroupsSpec = new SupportedGroupsSpec(byteBuffer);
            }
            catch (IOException iOException) {
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
            }
            ArrayList<NamedGroup> arrayList = new ArrayList<NamedGroup>(supportedGroupsSpec.namedGroupsIds.length);
            for (int n : supportedGroupsSpec.namedGroupsIds) {
                NamedGroup namedGroup = NamedGroup.valueOf(n);
                if (namedGroup == null) continue;
                arrayList.add(namedGroup);
            }
            clientHandshakeContext.conContext.serverRequestedNamedGroups = arrayList;
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.EE_SUPPORTED_GROUPS, supportedGroupsSpec);
        }
    }

    private static final class EESupportedGroupsProducer
    extends SupportedGroups
    implements HandshakeProducer {
        private EESupportedGroupsProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.EE_SUPPORTED_GROUPS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable supported_groups extension", new Object[0]);
                }
                return null;
            }
            ArrayList<NamedGroup> arrayList = new ArrayList<NamedGroup>(SupportedGroups.supportedNamedGroups.length);
            for (NamedGroup object2 : SupportedGroups.supportedNamedGroups) {
                if (!SupportedGroups.enableFFDHE && object2.type == NamedGroupType.NAMED_GROUP_FFDHE) continue;
                if (object2.isAvailable(serverHandshakeContext.activeProtocols) && object2.isSupported(serverHandshakeContext.activeCipherSuites) && serverHandshakeContext.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), object2.algorithm, (AlgorithmParameters)namedGroupParams.get((Object)object2))) {
                    arrayList.add(object2);
                    continue;
                }
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                SSLLogger.fine("Ignore inactive or disabled named group: " + object2.name, new Object[0]);
            }
            if (arrayList.isEmpty()) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("no available named group", new Object[0]);
                }
                return null;
            }
            int n = arrayList.size() << 1;
            byte[] byArray = new byte[n + 2];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Record.putInt16(byteBuffer, n);
            for (NamedGroup namedGroup : arrayList) {
                Record.putInt16(byteBuffer, namedGroup.id);
            }
            serverHandshakeContext.conContext.serverRequestedNamedGroups = Collections.unmodifiableList(arrayList);
            SupportedGroupsSpec supportedGroupsSpec = new SupportedGroupsSpec(arrayList);
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.EE_SUPPORTED_GROUPS, supportedGroupsSpec);
            return byArray;
        }
    }

    static enum NamedGroup {
        SECT163_K1(1, "sect163k1", "1.3.132.0.1", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECT163_R1(2, "sect163r1", "1.3.132.0.2", false, ProtocolVersion.PROTOCOLS_TO_12),
        SECT163_R2(3, "sect163r2", "1.3.132.0.15", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECT193_R1(4, "sect193r1", "1.3.132.0.24", false, ProtocolVersion.PROTOCOLS_TO_12),
        SECT193_R2(5, "sect193r2", "1.3.132.0.25", false, ProtocolVersion.PROTOCOLS_TO_12),
        SECT233_K1(6, "sect233k1", "1.3.132.0.26", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECT233_R1(7, "sect233r1", "1.3.132.0.27", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECT239_K1(8, "sect239k1", "1.3.132.0.3", false, ProtocolVersion.PROTOCOLS_TO_12),
        SECT283_K1(9, "sect283k1", "1.3.132.0.16", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECT283_R1(10, "sect283r1", "1.3.132.0.17", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECT409_K1(11, "sect409k1", "1.3.132.0.36", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECT409_R1(12, "sect409r1", "1.3.132.0.37", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECT571_K1(13, "sect571k1", "1.3.132.0.38", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECT571_R1(14, "sect571r1", "1.3.132.0.39", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECP160_K1(15, "secp160k1", "1.3.132.0.9", false, ProtocolVersion.PROTOCOLS_TO_12),
        SECP160_R1(16, "secp160r1", "1.3.132.0.8", false, ProtocolVersion.PROTOCOLS_TO_12),
        SECP160_R2(17, "secp160r2", "1.3.132.0.30", false, ProtocolVersion.PROTOCOLS_TO_12),
        SECP192_K1(18, "secp192k1", "1.3.132.0.31", false, ProtocolVersion.PROTOCOLS_TO_12),
        SECP192_R1(19, "secp192r1", "1.2.840.10045.3.1.1", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECP224_K1(20, "secp224k1", "1.3.132.0.32", false, ProtocolVersion.PROTOCOLS_TO_12),
        SECP224_R1(21, "secp224r1", "1.3.132.0.33", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECP256_K1(22, "secp256k1", "1.3.132.0.10", false, ProtocolVersion.PROTOCOLS_TO_12),
        SECP256_R1(23, "secp256r1", "1.2.840.10045.3.1.7", true, ProtocolVersion.PROTOCOLS_TO_13),
        SECP384_R1(24, "secp384r1", "1.3.132.0.34", true, ProtocolVersion.PROTOCOLS_TO_13),
        SECP521_R1(25, "secp521r1", "1.3.132.0.35", true, ProtocolVersion.PROTOCOLS_TO_13),
        X25519(29, "x25519", true, "x25519", ProtocolVersion.PROTOCOLS_TO_13),
        X448(30, "x448", true, "x448", ProtocolVersion.PROTOCOLS_TO_13),
        FFDHE_2048(256, "ffdhe2048", true, ProtocolVersion.PROTOCOLS_TO_13),
        FFDHE_3072(257, "ffdhe3072", true, ProtocolVersion.PROTOCOLS_TO_13),
        FFDHE_4096(258, "ffdhe4096", true, ProtocolVersion.PROTOCOLS_TO_13),
        FFDHE_6144(259, "ffdhe6144", true, ProtocolVersion.PROTOCOLS_TO_13),
        FFDHE_8192(260, "ffdhe8192", true, ProtocolVersion.PROTOCOLS_TO_13),
        ARBITRARY_PRIME(65281, "arbitrary_explicit_prime_curves", ProtocolVersion.PROTOCOLS_TO_12),
        ARBITRARY_CHAR2(65282, "arbitrary_explicit_char2_curves", ProtocolVersion.PROTOCOLS_TO_12);

        final int id;
        final NamedGroupType type;
        final String name;
        final String oid;
        final String algorithm;
        final boolean isFips;
        final ProtocolVersion[] supportedProtocols;
        final boolean isEcAvailable;

        private NamedGroup(int n2, String string2, String string3, boolean bl, ProtocolVersion[] protocolVersionArray) {
            this.id = n2;
            this.type = NamedGroupType.NAMED_GROUP_ECDHE;
            this.name = string2;
            this.oid = string3;
            this.algorithm = "EC";
            this.isFips = bl;
            this.supportedProtocols = protocolVersionArray;
            this.isEcAvailable = JsseJce.isEcAvailable();
        }

        private NamedGroup(int n2, String string2, boolean bl, String string3, ProtocolVersion[] protocolVersionArray) {
            this.id = n2;
            this.type = NamedGroupType.NAMED_GROUP_XDH;
            this.name = string2;
            this.oid = null;
            this.algorithm = string3;
            this.isFips = bl;
            this.supportedProtocols = protocolVersionArray;
            this.isEcAvailable = true;
        }

        private NamedGroup(int n2, String string2, boolean bl, ProtocolVersion[] protocolVersionArray) {
            this.id = n2;
            this.type = NamedGroupType.NAMED_GROUP_FFDHE;
            this.name = string2;
            this.oid = null;
            this.algorithm = "DiffieHellman";
            this.isFips = bl;
            this.supportedProtocols = protocolVersionArray;
            this.isEcAvailable = true;
        }

        private NamedGroup(int n2, String string2, ProtocolVersion[] protocolVersionArray) {
            this.id = n2;
            this.type = NamedGroupType.NAMED_GROUP_ARBITRARY;
            this.name = string2;
            this.oid = null;
            this.algorithm = "EC";
            this.isFips = false;
            this.supportedProtocols = protocolVersionArray;
            this.isEcAvailable = true;
        }

        static NamedGroup valueOf(int n) {
            for (NamedGroup namedGroup : NamedGroup.values()) {
                if (namedGroup.id != n) continue;
                return namedGroup;
            }
            return null;
        }

        static NamedGroup valueOf(ECParameterSpec eCParameterSpec) {
            String string = JsseJce.getNamedCurveOid(eCParameterSpec);
            if (string != null && !string.isEmpty()) {
                for (NamedGroup namedGroup : NamedGroup.values()) {
                    if (namedGroup.type != NamedGroupType.NAMED_GROUP_ECDHE || !string.equals(namedGroup.oid)) continue;
                    return namedGroup;
                }
            }
            return null;
        }

        static NamedGroup valueOf(DHParameterSpec dHParameterSpec) {
            for (Map.Entry<NamedGroup, AlgorithmParameters> entry : SupportedGroups.namedGroupParams.entrySet()) {
                NamedGroup namedGroup = entry.getKey();
                if (namedGroup.type != NamedGroupType.NAMED_GROUP_FFDHE) continue;
                DHParameterSpec dHParameterSpec2 = null;
                AlgorithmParameters algorithmParameters = entry.getValue();
                try {
                    dHParameterSpec2 = algorithmParameters.getParameterSpec(DHParameterSpec.class);
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    // empty catch block
                }
                if (dHParameterSpec2 == null || !dHParameterSpec2.getP().equals(dHParameterSpec.getP()) || !dHParameterSpec2.getG().equals(dHParameterSpec.getG())) continue;
                return namedGroup;
            }
            return null;
        }

        static NamedGroup nameOf(String string) {
            for (NamedGroup namedGroup : NamedGroup.values()) {
                if (!namedGroup.name.equals(string)) continue;
                return namedGroup;
            }
            return null;
        }

        static String nameOf(int n) {
            for (NamedGroup namedGroup : NamedGroup.values()) {
                if (namedGroup.id != n) continue;
                return namedGroup.name;
            }
            return "UNDEFINED-NAMED-GROUP(" + n + ")";
        }

        boolean isAvailable(List<ProtocolVersion> list) {
            if (this.isEcAvailable) {
                for (ProtocolVersion protocolVersion : this.supportedProtocols) {
                    if (!list.contains((Object)protocolVersion)) continue;
                    return true;
                }
            }
            return false;
        }

        boolean isAvailable(ProtocolVersion protocolVersion) {
            if (this.isEcAvailable) {
                for (ProtocolVersion protocolVersion2 : this.supportedProtocols) {
                    if (protocolVersion != protocolVersion2) continue;
                    return true;
                }
            }
            return false;
        }

        boolean isSupported(List<CipherSuite> list) {
            for (CipherSuite cipherSuite : list) {
                boolean bl = this.isAvailable(cipherSuite.supportedProtocols);
                if (!bl || cipherSuite.keyExchange != null && cipherSuite.keyExchange.groupType != this.type) continue;
                return true;
            }
            return false;
        }

        AlgorithmParameters getParameters() {
            return SupportedGroups.namedGroupParams.get((Object)this);
        }

        AlgorithmParameterSpec getParameterSpec() {
            if (this.type == NamedGroupType.NAMED_GROUP_ECDHE) {
                return SupportedGroups.getECGenParamSpec(this);
            }
            if (this.type == NamedGroupType.NAMED_GROUP_FFDHE) {
                return SupportedGroups.getDHParameterSpec(this);
            }
            return null;
        }
    }

    static enum NamedGroupType {
        NAMED_GROUP_ECDHE,
        NAMED_GROUP_FFDHE,
        NAMED_GROUP_XDH,
        NAMED_GROUP_ARBITRARY,
        NAMED_GROUP_NONE;


        boolean isSupported(List<CipherSuite> list) {
            for (CipherSuite cipherSuite : list) {
                if (cipherSuite.keyExchange != null && cipherSuite.keyExchange.groupType != this) continue;
                return true;
            }
            return false;
        }
    }

    static class SupportedGroups {
        static final boolean enableFFDHE;
        static final Map<NamedGroup, AlgorithmParameters> namedGroupParams;
        static final NamedGroup[] supportedNamedGroups;

        SupportedGroups() {
        }

        private static boolean isAvailableGroup(NamedGroup namedGroup) {
            AlgorithmParameters algorithmParameters = null;
            AlgorithmParameterSpec algorithmParameterSpec = null;
            if (namedGroup.type == NamedGroupType.NAMED_GROUP_ECDHE) {
                if (namedGroup.oid != null) {
                    try {
                        algorithmParameters = JsseJce.getAlgorithmParameters("EC");
                        algorithmParameterSpec = new ECGenParameterSpec(namedGroup.oid);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        return false;
                    }
                }
            } else if (namedGroup.type == NamedGroupType.NAMED_GROUP_FFDHE) {
                try {
                    algorithmParameters = JsseJce.getAlgorithmParameters("DiffieHellman");
                    algorithmParameterSpec = SupportedGroups.getFFDHEDHParameterSpec(namedGroup);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    return false;
                }
            }
            if (algorithmParameters != null && algorithmParameterSpec != null) {
                try {
                    algorithmParameters.init(algorithmParameterSpec);
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    return false;
                }
                namedGroupParams.put(namedGroup, algorithmParameters);
                return true;
            }
            return false;
        }

        private static DHParameterSpec getFFDHEDHParameterSpec(NamedGroup namedGroup) {
            DHParameterSpec dHParameterSpec = null;
            switch (namedGroup) {
                case FFDHE_2048: {
                    dHParameterSpec = PredefinedDHParameterSpecs.ffdheParams.get(2048);
                    break;
                }
                case FFDHE_3072: {
                    dHParameterSpec = PredefinedDHParameterSpecs.ffdheParams.get(3072);
                    break;
                }
                case FFDHE_4096: {
                    dHParameterSpec = PredefinedDHParameterSpecs.ffdheParams.get(4096);
                    break;
                }
                case FFDHE_6144: {
                    dHParameterSpec = PredefinedDHParameterSpecs.ffdheParams.get(6144);
                    break;
                }
                case FFDHE_8192: {
                    dHParameterSpec = PredefinedDHParameterSpecs.ffdheParams.get(8192);
                }
            }
            return dHParameterSpec;
        }

        private static DHParameterSpec getPredefinedDHParameterSpec(NamedGroup namedGroup) {
            DHParameterSpec dHParameterSpec = null;
            switch (namedGroup) {
                case FFDHE_2048: {
                    dHParameterSpec = PredefinedDHParameterSpecs.definedParams.get(2048);
                    break;
                }
                case FFDHE_3072: {
                    dHParameterSpec = PredefinedDHParameterSpecs.definedParams.get(3072);
                    break;
                }
                case FFDHE_4096: {
                    dHParameterSpec = PredefinedDHParameterSpecs.definedParams.get(4096);
                    break;
                }
                case FFDHE_6144: {
                    dHParameterSpec = PredefinedDHParameterSpecs.definedParams.get(6144);
                    break;
                }
                case FFDHE_8192: {
                    dHParameterSpec = PredefinedDHParameterSpecs.definedParams.get(8192);
                }
            }
            return dHParameterSpec;
        }

        static ECGenParameterSpec getECGenParamSpec(NamedGroup namedGroup) {
            if (namedGroup.type != NamedGroupType.NAMED_GROUP_ECDHE) {
                throw new RuntimeException("Not a named EC group: " + (Object)((Object)namedGroup));
            }
            AlgorithmParameters algorithmParameters = namedGroupParams.get((Object)namedGroup);
            if (algorithmParameters == null) {
                throw new RuntimeException("Not a supported EC named group: " + (Object)((Object)namedGroup));
            }
            try {
                return algorithmParameters.getParameterSpec(ECGenParameterSpec.class);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                return new ECGenParameterSpec(namedGroup.oid);
            }
        }

        static DHParameterSpec getDHParameterSpec(NamedGroup namedGroup) {
            if (namedGroup.type != NamedGroupType.NAMED_GROUP_FFDHE) {
                throw new RuntimeException("Not a named DH group: " + (Object)((Object)namedGroup));
            }
            AlgorithmParameters algorithmParameters = namedGroupParams.get((Object)namedGroup);
            if (algorithmParameters == null) {
                throw new RuntimeException("Not a supported DH named group: " + (Object)((Object)namedGroup));
            }
            try {
                return algorithmParameters.getParameterSpec(DHParameterSpec.class);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                return SupportedGroups.getPredefinedDHParameterSpec(namedGroup);
            }
        }

        static boolean isActivatable(AlgorithmConstraints algorithmConstraints, NamedGroupType namedGroupType) {
            boolean bl = false;
            for (NamedGroup namedGroup : supportedNamedGroups) {
                if (namedGroup.type != namedGroupType) continue;
                if (algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), namedGroup.algorithm, namedGroupParams.get((Object)namedGroup))) {
                    return true;
                }
                if (bl || namedGroupType != NamedGroupType.NAMED_GROUP_FFDHE) continue;
                bl = true;
            }
            return !bl && namedGroupType == NamedGroupType.NAMED_GROUP_FFDHE;
        }

        static boolean isActivatable(AlgorithmConstraints algorithmConstraints, NamedGroup namedGroup) {
            if (!SupportedGroups.isSupported(namedGroup)) {
                return false;
            }
            return algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), namedGroup.algorithm, namedGroupParams.get((Object)namedGroup));
        }

        static boolean isSupported(NamedGroup namedGroup) {
            for (NamedGroup namedGroup2 : supportedNamedGroups) {
                if (namedGroup.id != namedGroup2.id) continue;
                return true;
            }
            return false;
        }

        static NamedGroup getPreferredGroup(ProtocolVersion protocolVersion, AlgorithmConstraints algorithmConstraints, NamedGroupType namedGroupType, List<NamedGroup> list) {
            for (NamedGroup namedGroup : list) {
                if (namedGroup.type != namedGroupType || !namedGroup.isAvailable(protocolVersion) || !SupportedGroups.isSupported(namedGroup) || !algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), namedGroup.algorithm, namedGroupParams.get((Object)namedGroup))) continue;
                return namedGroup;
            }
            return null;
        }

        static NamedGroup getPreferredGroup(ProtocolVersion protocolVersion, AlgorithmConstraints algorithmConstraints, NamedGroupType namedGroupType) {
            for (NamedGroup namedGroup : supportedNamedGroups) {
                if (namedGroup.type != namedGroupType || !namedGroup.isAvailable(protocolVersion) || !algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), namedGroup.algorithm, namedGroupParams.get((Object)namedGroup))) continue;
                return namedGroup;
            }
            return null;
        }

        static {
            ArrayList<Object> arrayList;
            Object[] objectArray;
            enableFFDHE = Utilities.getBooleanProperty("jsse.enableFFDHE", true);
            namedGroupParams = new HashMap<NamedGroup, AlgorithmParameters>();
            boolean bl = SunJSSE.isFIPS();
            String string = GetPropertyAction.privilegedGetProperty("jdk.tls.namedGroups");
            if (string != null && !string.isEmpty() && string.length() > 1 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
                string = string.substring(1, string.length() - 1);
            }
            if (string != null && !string.isEmpty()) {
                objectArray = string.split(",");
                arrayList = new ArrayList<Object>(objectArray.length);
                for (String string2 : objectArray) {
                    NamedGroup namedGroup;
                    String string3 = string2.trim();
                    if (string3.isEmpty() || (namedGroup = NamedGroup.nameOf(string3)) == null || bl && !namedGroup.isFips || !SupportedGroups.isAvailableGroup(namedGroup)) continue;
                    arrayList.add((Object)namedGroup);
                }
                if (arrayList.isEmpty()) {
                    throw new IllegalArgumentException("System property jdk.tls.namedGroups(" + string + ") contains no supported named groups");
                }
            } else {
                objectArray = bl ? new NamedGroup[]{NamedGroup.SECP256_R1, NamedGroup.SECP384_R1, NamedGroup.SECP521_R1, NamedGroup.FFDHE_2048, NamedGroup.FFDHE_3072, NamedGroup.FFDHE_4096, NamedGroup.FFDHE_6144, NamedGroup.FFDHE_8192} : new NamedGroup[]{NamedGroup.SECP256_R1, NamedGroup.SECP384_R1, NamedGroup.SECP521_R1, NamedGroup.FFDHE_2048, NamedGroup.FFDHE_3072, NamedGroup.FFDHE_4096, NamedGroup.FFDHE_6144, NamedGroup.FFDHE_8192};
                arrayList = new ArrayList(objectArray.length);
                for (String string4 : objectArray) {
                    if (!SupportedGroups.isAvailableGroup((NamedGroup)((Object)string4))) continue;
                    arrayList.add(string4);
                }
                if (arrayList.isEmpty() && SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.warning("No default named groups", new Object[0]);
                }
            }
            supportedNamedGroups = new NamedGroup[arrayList.size()];
            int n = 0;
            for (NamedGroup namedGroup : arrayList) {
                SupportedGroups.supportedNamedGroups[n++] = namedGroup;
            }
        }
    }

    static final class SupportedGroupsSpec
    implements SSLExtension.SSLExtensionSpec {
        final int[] namedGroupsIds;

        private SupportedGroupsSpec(int[] nArray) {
            this.namedGroupsIds = nArray;
        }

        private SupportedGroupsSpec(List<NamedGroup> list) {
            this.namedGroupsIds = new int[list.size()];
            int n = 0;
            for (NamedGroup namedGroup : list) {
                this.namedGroupsIds[n++] = namedGroup.id;
            }
        }

        private SupportedGroupsSpec(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.remaining() < 2) {
                throw new SSLProtocolException("Invalid supported_groups extension: insufficient data");
            }
            byte[] byArray = Record.getBytes16(byteBuffer);
            if (byteBuffer.hasRemaining()) {
                throw new SSLProtocolException("Invalid supported_groups extension: unknown extra data");
            }
            if (byArray == null || byArray.length == 0 || byArray.length % 2 != 0) {
                throw new SSLProtocolException("Invalid supported_groups extension: incomplete data");
            }
            int[] nArray = new int[byArray.length / 2];
            int n = 0;
            int n2 = 0;
            while (n < byArray.length) {
                nArray[n2++] = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
            }
            this.namedGroupsIds = nArray;
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"versions\": '['{0}']'", Locale.ENGLISH);
            if (this.namedGroupsIds == null || this.namedGroupsIds.length == 0) {
                Object[] objectArray = new Object[]{"<no supported named group specified>"};
                return messageFormat.format(objectArray);
            }
            StringBuilder stringBuilder = new StringBuilder(512);
            boolean bl = true;
            for (int n : this.namedGroupsIds) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(NamedGroup.nameOf(n));
            }
            Object[] objectArray = new Object[]{stringBuilder.toString()};
            return messageFormat.format(objectArray);
        }
    }

    private static final class SupportedGroupsStringizer
    implements SSLStringizer {
        private SupportedGroupsStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new SupportedGroupsSpec(byteBuffer).toString();
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
    }
}

