/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.AccelerationCsvReader;
import com.nttdocomo.dojaemu.ktoolbar.AccelerationCsvRecord;
import com.nttdocomo.dojaemu.ktoolbar.AccelerationCsvWriter;
import com.nttdocomo.dojaemu.ktoolbar.AccelerationDataWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.ExportListener;
import com.nttdocomo.dojaemu.ktoolbar.ImExportDialog;
import com.nttdocomo.dojaemu.ktoolbar.ImportException;
import com.nttdocomo.dojaemu.ktoolbar.ImportListener;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import com.nttdocomo.dojaemu.ktoolbar.VerifyAccelerationData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class AccelerationEntryWindow
extends TabPanel
implements ImportListener,
ExportListener,
ListSelectionListener {
    private JTable accelerationTable;
    private List<AccelerationCsvRecord> listRecord = new ArrayList<AccelerationCsvRecord>();
    private JScrollPane scrollpane;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;
    private JButton upButton;
    private JButton downButton;
    private JButton exButton;
    private JList deviceIdList = new JList();
    private static final File ACCELERATION_DIR = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "location" + File.separator + "acceleration");

    AccelerationEntryWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        String[] stringArray = new String[]{Resource.getString("ACCELERATION_DEVICEID_0_NAME"), Resource.getString("ACCELERATION_DEVICEID_1_NAME")};
        this.deviceIdList.setListData(stringArray);
        this.deviceIdList.setSelectedIndex(0);
        this.deviceIdList.setSelectionMode(0);
        this.deviceIdList.setVisibleRowCount(stringArray.length);
        this.deviceIdList.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.deviceIdList);
        jScrollPane.getViewport().setView(this.deviceIdList);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jScrollPane);
        jPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getString("ACCELERATION_DEVICEID_NAME"), 0, 0));
        JPanel jPanel2 = new JPanel();
        this.addButton = new JButton(Resource.getString("ADD"));
        this.editButton = new JButton(Resource.getString("EDIT"));
        this.deleteButton = new JButton(Resource.getString("DELETE"));
        this.upButton = new JButton(Resource.getString("ACCELERATION_UP"));
        this.downButton = new JButton(Resource.getString("ACCELERATION_DOWN"));
        JButton jButton = new JButton(Resource.getString("COMMON_IMPORT"));
        this.exButton = new JButton(Resource.getString("COMMON_EXPORT"));
        this.addButton.setActionCommand("add");
        this.editButton.setActionCommand("edit");
        this.deleteButton.setActionCommand("delete");
        this.upButton.setActionCommand("up");
        this.downButton.setActionCommand("down");
        jButton.setActionCommand("importData");
        this.exButton.setActionCommand("exportData");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.addButton.addActionListener(actionDispatcher);
        this.editButton.addActionListener(actionDispatcher);
        this.deleteButton.addActionListener(actionDispatcher);
        this.upButton.addActionListener(actionDispatcher);
        this.downButton.addActionListener(actionDispatcher);
        jButton.addActionListener(actionDispatcher);
        this.exButton.addActionListener(actionDispatcher);
        jPanel2.add(this.addButton);
        jPanel2.add(this.editButton);
        jPanel2.add(this.deleteButton);
        jPanel2.add(this.upButton);
        jPanel2.add(this.downButton);
        jPanel2.add(new JLabel("  "));
        jPanel2.add(jButton);
        jPanel2.add(this.exButton);
        this.accelerationTable = this.createAccelerationTable();
        this.scrollpane = new JScrollPane(this.accelerationTable);
        this.add("North", jPanel);
        this.add("Center", this.scrollpane);
        this.add("South", jPanel2);
    }

    private JTable createAccelerationTable() {
        JTable jTable = null;
        String[] stringArray = new String[]{Resource.getString("ACC_X_AXIS"), Resource.getString("ACC_Y_AXIS"), Resource.getString("ACC_Z_AXIS"), Resource.getString("ACC_ROLL_ANGLE"), Resource.getString("ACC_PITCH_ANGLE"), Resource.getString("ACC_DIRECTION")};
        AccelerationTableModel accelerationTableModel = new AccelerationTableModel(stringArray, 0);
        this.readCsv();
        for (AccelerationCsvRecord accelerationCsvRecord : this.listRecord) {
            Vector<String> vector = new Vector<String>();
            vector.addElement(accelerationCsvRecord.getAccelerationX());
            vector.addElement(accelerationCsvRecord.getAccelerationY());
            vector.addElement(accelerationCsvRecord.getAccelerationZ());
            vector.addElement(accelerationCsvRecord.getRoll());
            vector.addElement(accelerationCsvRecord.getPitch());
            vector.addElement(accelerationCsvRecord.getScreenOrientation());
            accelerationTableModel.addRow(vector);
        }
        jTable = new JTable(accelerationTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.setDefaultRenderer(Object.class, new AccelerationTableCellRenderer());
        jTable.setSelectionMode(2);
        this.changeButtonEnabled();
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    AccelerationEntryWindow.this.edit();
                }
            }
        });
        jTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    AccelerationEntryWindow.this.edit();
                }
            }
        });
        return jTable;
    }

    void add() {
        AccelerationCsvRecord accelerationCsvRecord = new AccelerationCsvRecord();
        AccelerationDataWindow accelerationDataWindow = new AccelerationDataWindow(this.parent, accelerationCsvRecord);
        accelerationDataWindow.setLocation(this.parent.getShowLocation(accelerationDataWindow.getWidth(), accelerationDataWindow.getHeight(), this.tabwin));
        accelerationDataWindow.setVisible(true);
        if (!accelerationDataWindow.isCanceled()) {
            this.listRecord.add(accelerationCsvRecord);
            this.writeCsvAndUpdateTable();
        }
    }

    void edit() {
        int[] nArray = this.accelerationTable.getSelectedRows();
        if (this.accelerationTable.getSelectedRowCount() == 1) {
            AccelerationCsvRecord accelerationCsvRecord = this.listRecord.get(nArray[0]);
            AccelerationDataWindow accelerationDataWindow = new AccelerationDataWindow(this.parent, accelerationCsvRecord);
            accelerationDataWindow.setLocation(this.parent.getShowLocation(accelerationDataWindow.getWidth(), accelerationDataWindow.getHeight(), this.tabwin));
            accelerationDataWindow.setVisible(true);
            if (!accelerationDataWindow.isCanceled()) {
                this.writeCsvAndUpdateTable();
            }
        }
    }

    void delete() {
        int[] nArray = this.accelerationTable.getSelectedRows();
        if (this.accelerationTable.getSelectedRowCount() != 0) {
            JOptionPane jOptionPane = new JOptionPane(Resource.format("ACCELERATION_DELETE_WNG", String.valueOf(this.accelerationTable.getSelectedRowCount())), 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                for (int i = this.accelerationTable.getSelectedRowCount() - 1; i >= 0; --i) {
                    this.listRecord.remove(nArray[i]);
                }
                this.writeCsvAndUpdateTable();
            }
        }
    }

    void up() {
        int[] nArray = this.accelerationTable.getSelectedRows();
        if (this.accelerationTable.getSelectedRowCount() == 1) {
            int n = nArray[0];
            if (n == 0) {
                return;
            }
            AccelerationCsvRecord accelerationCsvRecord = this.listRecord.get(n);
            AccelerationCsvRecord accelerationCsvRecord2 = this.listRecord.get(n - 1);
            this.listRecord.set(n, accelerationCsvRecord2);
            this.listRecord.set(n - 1, accelerationCsvRecord);
            this.writeCsvAndUpdateTable();
            this.accelerationTable.setRowSelectionInterval(n - 1, n - 1);
        }
    }

    void down() {
        int[] nArray = this.accelerationTable.getSelectedRows();
        if (this.accelerationTable.getSelectedRowCount() == 1) {
            int n = nArray[0];
            if (n == this.listRecord.size() - 1) {
                return;
            }
            AccelerationCsvRecord accelerationCsvRecord = this.listRecord.get(n);
            AccelerationCsvRecord accelerationCsvRecord2 = this.listRecord.get(n + 1);
            this.listRecord.set(n, accelerationCsvRecord2);
            this.listRecord.set(n + 1, accelerationCsvRecord);
            this.writeCsvAndUpdateTable();
            this.accelerationTable.setRowSelectionInterval(n + 1, n + 1);
        }
    }

    @Override
    void cancel() {
    }

    @Override
    boolean set() {
        return true;
    }

    private String getFilePath() {
        return ACCELERATION_DIR.getPath() + File.separator + this.deviceIdList.getSelectedIndex() + ".dat";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCsv() {
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        AccelerationCsvReader accelerationCsvReader = null;
        try {
            AccelerationCsvRecord accelerationCsvRecord;
            fileReader = new FileReader(this.getFilePath());
            bufferedReader = new BufferedReader(fileReader);
            accelerationCsvReader = new AccelerationCsvReader(bufferedReader);
            this.listRecord = new ArrayList<AccelerationCsvRecord>();
            while ((accelerationCsvRecord = accelerationCsvReader.readRecord()) != null) {
                this.listRecord.add(accelerationCsvRecord);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.listRecord.clear();
            this.writeCsv();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                accelerationCsvReader.close();
                bufferedReader.close();
                fileReader.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCsv() {
        FileWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        AccelerationCsvWriter accelerationCsvWriter = null;
        try {
            fileWriter = new FileWriter(this.getFilePath());
            bufferedWriter = new BufferedWriter(fileWriter);
            accelerationCsvWriter = new AccelerationCsvWriter(bufferedWriter);
            for (AccelerationCsvRecord accelerationCsvRecord : this.listRecord) {
                accelerationCsvWriter.writeRecord(accelerationCsvRecord);
            }
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("WRITE_ERR", this.getFilePath()));
        }
        finally {
            try {
                accelerationCsvWriter.close();
                bufferedWriter.close();
                fileWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    private void createTable() {
        this.accelerationTable = this.createAccelerationTable();
        this.scrollpane = new JScrollPane(this.accelerationTable);
        this.add("Center", this.scrollpane);
    }

    private void updateTable() {
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.accelerationTable = null;
        this.createTable();
        this.setVisible(true);
    }

    private void writeCsvAndUpdateTable() {
        this.writeCsv();
        this.updateTable();
    }

    private void changeButtonEnabled() {
        if (this.listRecord != null && this.listRecord.size() > 0) {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            this.exButton.setEnabled(true);
            if (this.listRecord.size() > 1) {
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(true);
            } else {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
        } else {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.exButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    @Override
    public void check(String[] stringArray, int n) throws ImportException {
        VerifyAccelerationData.verify(stringArray);
    }

    @Override
    public int add(String[] stringArray, int n) throws ImportException {
        Object[] objectArray = VerifyAccelerationData.adjust(stringArray);
        AccelerationCsvRecord accelerationCsvRecord = new AccelerationCsvRecord();
        accelerationCsvRecord.setAccelerationX(objectArray[0]);
        accelerationCsvRecord.setAccelerationY(objectArray[1]);
        accelerationCsvRecord.setAccelerationZ(objectArray[2]);
        accelerationCsvRecord.setRoll(objectArray[3]);
        accelerationCsvRecord.setPitch(objectArray[4]);
        accelerationCsvRecord.setScreenOrientation(objectArray[5]);
        this.listRecord.add(accelerationCsvRecord);
        this.addRow(this.accelerationTable, objectArray);
        return this.listRecord.size() - 1;
    }

    public void addRow(final JTable jTable, final Object[] objectArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (jTable != null && AccelerationEntryWindow.this.accelerationTable != null && jTable.equals(AccelerationEntryWindow.this.accelerationTable)) {
                    DefaultTableModel defaultTableModel = (DefaultTableModel)jTable.getModel();
                    defaultTableModel.addRow(objectArray);
                }
            }
        });
    }

    @Override
    public int delete(int n) throws ImportException {
        int n2 = this.listRecord.size();
        while (this.listRecord.size() > n) {
            this.listRecord.remove(this.listRecord.size() - 1);
        }
        return n2 - n;
    }

    @Override
    public ArrayList get() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.accelerationTable.getModel();
        Vector<Vector> vector = defaultTableModel.getDataVector();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < vector.size(); ++i) {
            String string = "";
            Vector vector2 = vector.elementAt(i);
            String[] stringArray = vector2.toArray(new String[0]);
            for (int j = 0; j < stringArray.length; ++j) {
                string = string + stringArray[j] + (j < stringArray.length - 1 ? "," : "");
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    void importData() {
        ImExportDialog imExportDialog = new ImExportDialog(this.tabwin, this, 0);
        imExportDialog.open();
        this.writeCsvAndUpdateTable();
    }

    void exportData() {
        ImExportDialog imExportDialog = new ImExportDialog(this.tabwin, this, 1);
        imExportDialog.open();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.readCsv();
        this.updateTable();
        FocusEvent focusEvent = new FocusEvent(this.deviceIdList, 1004);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(focusEvent);
    }

    class AccelerationTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        AccelerationTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class AccelerationTableModel
    extends DefaultTableModel {
        AccelerationTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

