/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AppIconException;
import java.io.ByteArrayInputStream;

class AppIconCheck {
    private final int TRAILER = 59;
    private final int IMAGE_BLOCK = 44;
    private final int EXTENSION_INTRODUCER = 33;
    private final int PLAIN_TEXT_EXTENTION = 1;
    private final int GRAPHIC_CONTROL_EXTENTION = 249;
    private final int COMMENT_EXTENTION = 254;
    private final int APPLICATION_EXTENTION = 255;
    private final int FILE_TYPE_GIF = 0;
    private final int FILE_TYPE_JPEG = 1;
    private final int FILE_TYPE_PNG = 2;
    private final int FILE_TYPE_BMP = 3;
    private final int FILE_TYPE_UNKNOWN = -1;
    private final int[] REGULATION_SIZE = new int[]{24, 48, 96};
    public static final int REGULATION_FORMAT = 0;
    public static final int INVALID_FORMAT = -1;
    public static final int INVALID_SIGVER = -2;
    public static final int INVALID_SIZE = -3;
    public static final int INVALID_INTERLACE = -4;
    public static final int INVALID_ANIMATION = -5;
    public static final int UNDEFINED_ERROR = -99;
    private int nTh;

    public AppIconCheck(int n) {
        this.nTh = n;
    }

    private void checkGifHeader(ByteArrayInputStream byteArrayInputStream) throws Exception {
        int n = 0;
        byte[] byArray = new byte[6];
        byteArrayInputStream.read(byArray);
        String string = new String(byArray);
        if (!string.equals("GIF87a") && !string.equals("GIF89a")) {
            throw new AppIconException(2, "Invalid signature or version");
        }
        byteArrayInputStream.read(new byte[4]);
        byte by = (byte)byteArrayInputStream.read();
        if ((by & 0x80) != 0) {
            int n2 = (by & 7) + 1;
            n = (int)Math.pow(2.0, n2) * 3;
        }
        byteArrayInputStream.skip(2 + n);
    }

    private void checkGifHeader(ByteArrayInputStream byteArrayInputStream, int n) throws Exception {
        int n2 = 0;
        byte[] byArray = new byte[6];
        byteArrayInputStream.read(byArray);
        String string = new String(byArray);
        if (!string.equals("GIF87a") && !string.equals("GIF89a")) {
            throw new AppIconException(2, "Invalid signature or version");
        }
        byArray = null;
        byte[] byArray2 = new byte[4];
        byteArrayInputStream.read(byArray2);
        int n3 = (byArray2[1] << 8) + (byArray2[0] & 0xFF);
        int n4 = (byArray2[3] << 8) + (byArray2[2] & 0xFF);
        if (n != n3 || n != n4) {
            throw new AppIconException(3, "Invalid logical screen size");
        }
        byte by = (byte)byteArrayInputStream.read();
        if ((by & 0x80) != 0) {
            int n5 = (by & 7) + 1;
            n2 = (int)Math.pow(2.0, n5) * 3;
        }
        byteArrayInputStream.skip(2 + n2);
    }

    private void checkImageBlock(ByteArrayInputStream byteArrayInputStream) throws Exception {
        int n;
        int n2 = 0;
        byteArrayInputStream.skip(8L);
        byte by = (byte)((byte)byteArrayInputStream.read() & 0xFF);
        if ((by & 0x40) != 0) {
            throw new AppIconException(4, "Interlace image");
        }
        if ((by & 0x80) != 0) {
            n = (by & 7) + 1;
            n2 = (int)Math.pow(2.0, n) * 3;
        }
        byteArrayInputStream.skip(n2 + 1);
        while ((n = byteArrayInputStream.read()) != 0) {
            byteArrayInputStream.skip(n);
        }
    }

    private void checkPlaneText(ByteArrayInputStream byteArrayInputStream) throws Exception {
        int n;
        byteArrayInputStream.skip(byteArrayInputStream.read() & 0xFF);
        while ((n = byteArrayInputStream.read()) != 0) {
            byteArrayInputStream.skip(n);
        }
    }

    private void checkGraphicControl(ByteArrayInputStream byteArrayInputStream) throws Exception {
        byteArrayInputStream.skip(byteArrayInputStream.read() & 0xFF);
        if ((byteArrayInputStream.read() & 0xFF) != 0) {
            throw new AppIconException(1, "Invalid Block Terminator");
        }
    }

    private void checkComment(ByteArrayInputStream byteArrayInputStream) throws Exception {
        int n;
        while ((n = byteArrayInputStream.read()) != 0) {
            byteArrayInputStream.skip(n);
        }
    }

    private void checkApplication(ByteArrayInputStream byteArrayInputStream) throws Exception {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        byteArrayInputStream.skip(1L);
        byte[] byArray = new byte[11];
        byteArrayInputStream.read(byArray);
        String string = new String(byArray);
        if (string.equals("NETSCAPE2.0") || string.equals("ANIMEXTS1.0")) {
            bl = true;
        }
        while ((n = byteArrayInputStream.read()) != 0) {
            if (n == 3) {
                byte[] byArray2 = new byte[n];
                byteArrayInputStream.read(byArray2);
                if (byArray2[0] != 1) continue;
                bl2 = true;
                continue;
            }
            byteArrayInputStream.skip(n);
        }
        if (bl && bl2) {
            throw new AppIconException(5, "Animation GIF");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkGifFormat(byte[] byArray) {
        int n = 0;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.checkGifHeader(byteArrayInputStream);
            while (true) {
                int n2;
                if ((n2 = byteArrayInputStream.read()) == 59) {
                } else {
                    if (n2 == 44) {
                        this.checkImageBlock(byteArrayInputStream);
                        continue;
                    }
                    if (n2 == 33) {
                        int n3 = byteArrayInputStream.read();
                        if (n3 == 1) {
                            this.checkPlaneText(byteArrayInputStream);
                            continue;
                        }
                        if (n3 == 249) {
                            this.checkGraphicControl(byteArrayInputStream);
                            continue;
                        }
                        if (n3 == 254) {
                            this.checkComment(byteArrayInputStream);
                            continue;
                        }
                        if (n3 == 255) {
                            this.checkApplication(byteArrayInputStream);
                            continue;
                        }
                    }
                }
                break;
            }
        }
        catch (AppIconException appIconException) {
            n = appIconException.getType() * -1;
        }
        catch (Exception exception) {
            n = -99;
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkGifFormat(byte[] byArray, int n) {
        int n2 = 0;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.checkGifHeader(byteArrayInputStream, n);
            while (true) {
                int n3;
                if ((n3 = byteArrayInputStream.read()) == 59) {
                } else {
                    if (n3 == 44) {
                        this.checkImageBlock(byteArrayInputStream);
                        continue;
                    }
                    if (n3 == 33) {
                        int n4 = byteArrayInputStream.read();
                        if (n4 == 1) {
                            this.checkPlaneText(byteArrayInputStream);
                            continue;
                        }
                        if (n4 == 249) {
                            this.checkGraphicControl(byteArrayInputStream);
                            continue;
                        }
                        if (n4 == 254) {
                            this.checkComment(byteArrayInputStream);
                            continue;
                        }
                        if (n4 == 255) {
                            this.checkApplication(byteArrayInputStream);
                            continue;
                        }
                    }
                }
                break;
            }
        }
        catch (AppIconException appIconException) {
            n2 = appIconException.getType() * -1;
        }
        catch (Exception exception) {
            n2 = -99;
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return n2;
    }

    private void checkJpegFormat(byte[] byArray) throws Exception {
        int n = -1;
        if (byArray.length > 2 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 216) {
            for (int i = 2; i < byArray.length - 8; ++i) {
                int n2 = byArray[i] & 0xFF;
                int n3 = byArray[i + 1] & 0xFF;
                if (n2 != 255) continue;
                if (n3 == 192 || n3 == 193 || n3 == 194 || n3 == 195 || n3 == 197 || n3 == 198 || n3 == 199 || n3 == 201 || n3 == 202 || n3 == 203 || n3 == 205 || n3 == 206 || n3 == 207) {
                    n = 0;
                    break;
                }
                int n4 = (byArray[i + 2] << 8) + (byArray[i + 3] & 0xFF);
                i += n4 + 1;
            }
        }
        if (n == -1) {
            throw new AppIconException(1, "Invalid Format");
        }
    }

    private void checkJpegFormat(byte[] byArray, int n) throws Exception {
        int n2 = -1;
        if (byArray.length > 2 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 216) {
            for (int i = 2; i < byArray.length - 8; ++i) {
                int n3;
                int n4 = byArray[i] & 0xFF;
                int n5 = byArray[i + 1] & 0xFF;
                if (n4 != 255) continue;
                if (n5 == 192 || n5 == 193 || n5 == 194 || n5 == 195 || n5 == 197 || n5 == 198 || n5 == 199 || n5 == 201 || n5 == 202 || n5 == 203 || n5 == 205 || n5 == 206 || n5 == 207) {
                    n3 = (byArray[i + 7] << 8) + (byArray[i + 8] & 0xFF);
                    int n6 = (byArray[i + 5] << 8) + (byArray[i + 6] & 0xFF);
                    if (n != n3 || n != n6) {
                        throw new AppIconException(3, "Invalid logical screen size");
                    }
                    n2 = 0;
                    break;
                }
                n3 = (byArray[i + 2] << 8) + (byArray[i + 3] & 0xFF);
                i += n3 + 1;
            }
        }
        if (n2 == -1) {
            throw new AppIconException(1, "Invalid Format");
        }
    }

    private void checkPngFormat(byte[] byArray, int n) throws Exception {
        int n2 = 0;
        int n3 = 0;
        if (byArray.length >= 23) {
            n2 |= (byArray[16] & 0xFF) << 32;
            n2 |= (byArray[17] & 0xFF) << 16;
            n2 |= (byArray[18] & 0xFF) << 8;
            n2 |= byArray[19] & 0xFF;
            n3 |= (byArray[20] & 0xFF) << 32;
            n3 |= (byArray[21] & 0xFF) << 16;
            n3 |= (byArray[22] & 0xFF) << 8;
            n3 |= byArray[23] & 0xFF;
        }
        if (n2 != n || n3 != n) {
            throw new AppIconException(3, "Invalid logical screen size");
        }
    }

    private int checkFileType(byte[] byArray) throws Exception {
        int n = -1;
        String string = "";
        if (byArray.length >= 6) {
            string = new String(byArray, 0, 6);
        }
        if (string.equals("GIF87a") || string.equals("GIF89a")) {
            n = 0;
        } else if (byArray.length >= 2 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 216) {
            n = 1;
        } else if (byArray.length >= 16 && (byArray[0] & 0xFF) == 137 && (byArray[1] & 0xFF) == 80 && (byArray[2] & 0xFF) == 78 && (byArray[3] & 0xFF) == 71 && (byArray[4] & 0xFF) == 13 && (byArray[5] & 0xFF) == 10 && (byArray[6] & 0xFF) == 26 && (byArray[7] & 0xFF) == 10 && (byArray[11] & 0xFF) == 13 && (byArray[12] & 0xFF) == 73 && (byArray[13] & 0xFF) == 72 && (byArray[14] & 0xFF) == 68 && (byArray[15] & 0xFF) == 82) {
            n = 2;
        } else if (byArray.length >= 2 && (byArray[0] & 0xFF) == 66 && (byArray[1] & 0xFF) == 77) {
            n = 3;
        }
        return n;
    }

    public int checkFormat(String string, byte[] byArray) {
        int n = 0;
        try {
            switch (this.checkFileType(byArray)) {
                case 0: {
                    n = this.checkGifFormat(byArray);
                    if (string == "StartingAppImage" && n == -5) {
                        n = 0;
                    }
                    break;
                }
                case 1: {
                    this.checkJpegFormat(byArray);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (string == "StartingAppImage") break;
                }
                default: {
                    throw new AppIconException(2, "Invalid signature or version");
                }
            }
        }
        catch (AppIconException appIconException) {
            n = appIconException.getType() * -1;
        }
        catch (Exception exception) {
            n = -99;
        }
        return n;
    }

    public int checkFormat(byte[] byArray, int n) {
        int n2 = 0;
        try {
            switch (this.checkFileType(byArray)) {
                case 0: {
                    n2 = this.checkGifFormat(byArray, n);
                    break;
                }
                case 1: {
                    this.checkJpegFormat(byArray, n);
                    break;
                }
                case 2: {
                    this.checkPngFormat(byArray, n);
                    break;
                }
                default: {
                    throw new AppIconException(2, "Invalid signature or version");
                }
            }
        }
        catch (AppIconException appIconException) {
            n2 = appIconException.getType() * -1;
        }
        catch (Exception exception) {
            n2 = -99;
        }
        return n2;
    }
}

