/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.AppPropApplicationSetupTab;
import com.nttdocomo.dojaemu.ktoolbar.AppPropDeviceSetupTab;
import com.nttdocomo.dojaemu.ktoolbar.AppPropNativeDataSetupTab;
import com.nttdocomo.dojaemu.ktoolbar.AppPropTabPanel;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.Setting;
import com.nttdocomo.dojaemu.ktoolbar.TabEventListener;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class AppPropSetupWindow
extends AbstractWindow
implements TabEventListener,
ChangeListener {
    private Container cp;
    private JButton aplButton;
    private ActionDispatcher actionListener;
    private JTabbedPane tabbedPane;
    private Setting projectSetting;

    public AppPropSetupWindow(MainWindow mainWindow, Setting setting) {
        super(mainWindow, Resource.getString("LIMIT_WINDOW_TITLE"));
        boolean bl = false;
        this.parent = mainWindow;
        this.addWindowListener();
        if (setting != null) {
            this.projectSetting = setting;
        } else {
            this.projectSetting = new Setting();
            bl = true;
        }
        this.cp = this.getContentPane();
        this.cp.setLayout(new BorderLayout());
        this.actionListener = new ActionDispatcher(this);
        JButton jButton = new JButton(Resource.getString("SET"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        this.aplButton = new JButton(Resource.getString("SP_UPDATE"));
        jButton.setActionCommand("set");
        jButton2.setActionCommand("cancel");
        this.aplButton.setActionCommand("apply");
        jButton.addActionListener(this.actionListener);
        jButton2.addActionListener(this.actionListener);
        this.aplButton.addActionListener(this.actionListener);
        AppPropNativeDataSetupTab appPropNativeDataSetupTab = new AppPropNativeDataSetupTab(this, this.projectSetting, bl);
        AppPropApplicationSetupTab appPropApplicationSetupTab = new AppPropApplicationSetupTab(this, this.projectSetting, bl);
        AppPropDeviceSetupTab appPropDeviceSetupTab = new AppPropDeviceSetupTab(this, this.projectSetting, bl);
        appPropNativeDataSetupTab.setTabEventListener(this);
        appPropApplicationSetupTab.setTabEventListener(this);
        appPropDeviceSetupTab.setTabEventListener(this);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.addChangeListener(this);
        this.tabbedPane.addTab(Resource.getString("APP_SETTING_TAB_TITLE"), appPropApplicationSetupTab);
        this.tabbedPane.addTab(Resource.getString("NATIVE_SETTING_TAB_TITLE"), appPropNativeDataSetupTab);
        this.tabbedPane.addTab(Resource.getString("DEVICE_SETTING_TAB_TITLE"), appPropDeviceSetupTab);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(this.aplButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add("North", this.tabbedPane);
        jPanel2.add("Center", jPanel);
        this.cp.add("Center", jPanel2);
        this.pack();
        this.setResizable(false);
        this.aplButton.setEnabled(false);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.tabbedPane.getSelectedIndex();
    }

    @Override
    public void tabPanelEvent(TabPanel tabPanel, int n, int n2) {
        if (!this.aplButton.isEnabled()) {
            this.aplButton.setEnabled(true);
        }
        tabPanel.isChange = true;
    }

    void set() {
        if (this.update()) {
            this.parent.closeWindow(this);
        }
    }

    void cancel() {
        int n = this.tabbedPane.getSelectedIndex();
        ((TabPanel)this.tabbedPane.getSelectedComponent()).cancel();
        this.parent.closeWindow(this);
    }

    void apply() {
        if (this.update()) {
            this.aplButton.setEnabled(false);
        }
    }

    private boolean update() {
        TabPanel tabPanel;
        int n;
        int n2 = 0;
        for (n = 0; n < this.tabbedPane.getTabCount(); ++n) {
            tabPanel = (AppPropTabPanel)this.tabbedPane.getComponentAt(n);
            if (!((AppPropTabPanel)tabPanel).isChange || ((AppPropTabPanel)tabPanel).check()) continue;
            return false;
        }
        for (n = 0; n < this.tabbedPane.getTabCount(); ++n) {
            tabPanel = (TabPanel)this.tabbedPane.getComponentAt(n);
            if (!tabPanel.isChange) continue;
            if (!tabPanel.set()) {
                return false;
            }
            if (!tabPanel.isChange) continue;
            tabPanel.isChange = false;
        }
        File file = new File(this.parent.getProjectSettingPath(this.parent.getProjectName()));
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        n2 = this.parent.saveProjectSetting(this.projectSetting);
        if (n2 == 0) {
            System.out.println(Resource.getString("UPDATE_SETTING"));
        } else {
            System.out.println(Resource.format("WRITE_ERR", file.getPath()));
        }
        return true;
    }

    void selectTab(AppPropTabPanel appPropTabPanel) {
        if (appPropTabPanel != null) {
            try {
                this.tabbedPane.setSelectedComponent(appPropTabPanel);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

