/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.Const;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocumentLong;
import com.nttdocomo.dojaemu.ktoolbar.IniFileEntity;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComboBoxUI;

class AppSettingWindow
extends TabPanel
implements DocumentListener {
    private static final int MIN_HEAP_SIZE = 1000;
    private static final int MAX_HEAP_SIZE = 65535;
    private static final String[] TIME_ZONE = new String[]{"---------", "GMT-12:00", "GMT-11:00", "GMT-10:00", "GMT-09:30", "GMT-09:00", "GMT-08:30", "GMT-08:00", "GMT-07:00", "GMT-06:00", "GMT-05:00", "GMT-04:00", "GMT-03:30", "GMT-03:00", "GMT-02:00", "GMT-02:00", "GMT-01:00", "GMT 00:00", "GMT+01:00", "GMT+02:00", "GMT+03:00", "GMT+03:30", "GMT+04:00", "GMT+04:30", "GMT+05:00", "GMT+05:30", "GMT+06:00", "GMT+06:30", "GMT+07:00", "GMT+08:00", "GMT+09:00", "GMT+09:30", "GMT+10:00", "GMT+10:30", "GMT+11:00", "GMT+12:00", "GMT+12:45", "GMT+13:00", "GMT+14:00"};
    private JTextField heapSizeField;
    private JComboBox timezoneComboBox;
    private static final String FONTSIZE_FILE_INI = Const.PATH_LIB + "FontSize.ini";
    private static final String FONTSIZE_SECTION = "FONT_SIZE";
    private static final String FONTSIZE_KEY_MAX_SIZE = "MAX_SIZE";
    private JTextField maxFontSizeField;
    private static final int FONTSIZE_MAX_ENTRY = 3;
    private static final int FONTSIZE_MAX_LOWER = 60;
    private static final int FONTSIZE_MAX_UPPER = 128;
    private static final String STORAGEDEVICE_PATH = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "storagedevice";
    private JTextField storageSizeField;
    private static final int MAX_ENTRY = 13;
    private ButtonGroup radioButtonGroup;
    private JRadioButton byteButton;
    private JRadioButton kbyteButton;
    private JRadioButton mbyteButton;
    private JRadioButton gbyteButton;
    private static final String INTERNAL_STORAGEDEVICE_PATH = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "internalstoragedevice";
    private JTextField internalStorageSizeField;
    private ButtonGroup internalStorageRadioButtonGroup;
    private JRadioButton internalStorageByteButton;
    private JRadioButton internalStorageKByteButton;
    private JRadioButton internalStorageMByteButton;
    private JRadioButton internalStorageGByteButton;
    public static final int STORAGE_UNIT_B = 1;
    public static final int STORAGE_UNIT_KB = 2;
    public static final int STORAGE_UNIT_MB = 3;
    public static final int STORAGE_UNIT_GB = 4;
    private static final String STORAGE_MAX_BYTE = "1099511627776";
    private static final String STORAGE_MAX_KBYTE = "1073741824";
    private static final String STORAGE_MAX_MBYTE = "1048576";
    private static final String STORAGE_MAX_GBYTE = "1024";
    private static final String DEFAULT_STORAGE_CAPACITY = "2";
    private static final long UNIT_BYTE = 1024L;

    AppSettingWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        String string;
        int n;
        JLabel jLabel = new JLabel(Resource.getString("HEAP_SIZE"));
        JLabel jLabel2 = new JLabel(Resource.getString("HEAP_UNIT"));
        JLabel jLabel3 = new JLabel(Resource.getString("TIME_ZONE"));
        JLabel jLabel4 = new JLabel(Resource.getString("STORAGE_CAPACITY_FULL"));
        JLabel jLabel5 = new JLabel(Resource.getString("INTERNAL_STORAGE_CAPACITY_FULL"));
        this.heapSizeField = new JTextField(6);
        this.heapSizeField.setDocument(new HalfNumberDocument(6));
        this.heapSizeField.setText(String.valueOf(this.parent.getHeapMemorySize()));
        this.heapSizeField.getDocument().addDocumentListener(this);
        this.timezoneComboBox = new JComboBox();
        this.timezoneComboBox.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        for (n = 0; n < TIME_ZONE.length; ++n) {
            this.timezoneComboBox.addItem(TIME_ZONE[n]);
        }
        n = this.parent.getTimeZone();
        String string2 = string = n < 0 ? "GMT-" : "GMT+";
        if (n == 0) {
            string = "GMT 00:00";
        } else if (n == -1) {
            string = "---------";
        } else {
            if ((n *= n < 0 ? -1 : 1) / 60 < 10) {
                string = string + "0";
            }
            string = string + n / 60 + ":";
            if (n % 60 < 10) {
                string = string + "0";
            }
            string = string + n % 60;
        }
        for (int i = 0; i < TIME_ZONE.length; ++i) {
            if (!TIME_ZONE[i].equals(string)) continue;
            this.timezoneComboBox.setSelectedIndex(i);
        }
        this.timezoneComboBox.setActionCommand("selectTimeZone");
        JLabel jLabel6 = new JLabel(Resource.getString("SupportedFontSizes.common.caption.UsableRange"));
        JLabel jLabel7 = new JLabel(Resource.getString("SupportedFontSizes.common.caption.MinSize"));
        JLabel jLabel8 = new JLabel(Resource.getString("SupportedFontSizes.common.caption.FontUnit"));
        JLabel jLabel9 = new JLabel(Resource.getString("SupportedFontSizes.common.caption.Hyphen"));
        JLabel jLabel10 = new JLabel(Resource.getString("SupportedFontSizes.common.caption.FontUnit"));
        this.maxFontSizeField = new JTextField(3);
        this.maxFontSizeField.setDocument(new HalfNumberDocument(3));
        this.maxFontSizeField.getDocument().addDocumentListener(this);
        this.storageSizeField = new JTextField(13);
        this.storageSizeField.setDocument(new HalfNumberDocumentLong(13));
        this.storageSizeField.getDocument().addDocumentListener(this);
        this.radioButtonGroup = new ButtonGroup();
        this.byteButton = new JRadioButton(Resource.getString("STORAGE_UNIT_BYTE"));
        this.kbyteButton = new JRadioButton(Resource.getString("STORAGE_UNIT_KBYTE"));
        this.mbyteButton = new JRadioButton(Resource.getString("STORAGE_UNIT_MBYTE"));
        this.gbyteButton = new JRadioButton(Resource.getString("STORAGE_UNIT_GBYTE"));
        this.byteButton.setActionCommand("changeStorageSize");
        this.kbyteButton.setActionCommand("changeStorageSize");
        this.mbyteButton.setActionCommand("changeStorageSize");
        this.gbyteButton.setActionCommand("changeStorageSize");
        this.radioButtonGroup.add(this.byteButton);
        this.radioButtonGroup.add(this.kbyteButton);
        this.radioButtonGroup.add(this.mbyteButton);
        this.radioButtonGroup.add(this.gbyteButton);
        this.internalStorageSizeField = new JTextField(13);
        this.internalStorageSizeField.setDocument(new HalfNumberDocumentLong(13));
        this.internalStorageSizeField.getDocument().addDocumentListener(this);
        this.internalStorageRadioButtonGroup = new ButtonGroup();
        this.internalStorageByteButton = new JRadioButton(Resource.getString("INTERNAL_STORAGE_UNIT_BYTE"));
        this.internalStorageKByteButton = new JRadioButton(Resource.getString("INTERNAL_STORAGE_UNIT_KBYTE"));
        this.internalStorageMByteButton = new JRadioButton(Resource.getString("INTERNAL_STORAGE_UNIT_MBYTE"));
        this.internalStorageGByteButton = new JRadioButton(Resource.getString("INTERNAL_STORAGE_UNIT_GBYTE"));
        this.internalStorageByteButton.setActionCommand("changeInternalStorageSize");
        this.internalStorageKByteButton.setActionCommand("changeInternalStorageSize");
        this.internalStorageMByteButton.setActionCommand("changeInternalStorageSize");
        this.internalStorageGByteButton.setActionCommand("changeInternalStorageSize");
        this.internalStorageRadioButtonGroup.add(this.internalStorageByteButton);
        this.internalStorageRadioButtonGroup.add(this.internalStorageKByteButton);
        this.internalStorageRadioButtonGroup.add(this.internalStorageMByteButton);
        this.internalStorageRadioButtonGroup.add(this.internalStorageGByteButton);
        try {
            this.loadMaxFontSize();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.loadStorageInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.loadInternalStorageInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SET_HEAP_SIZE")));
        jPanel.add(jLabel);
        jPanel.add(this.heapSizeField);
        jPanel.add(jLabel2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SET_TIME_ZONE")));
        jPanel2.add(jLabel3);
        jPanel2.add(this.timezoneComboBox);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SupportedFontSizes.common.caption.Setting")));
        jPanel3.add(jLabel6);
        jPanel3.add(jLabel7);
        jPanel3.add(jLabel8);
        jPanel3.add(jLabel9);
        jPanel3.add(this.maxFontSizeField);
        jPanel3.add(jLabel10);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SET_STORAGE_CAPACITY")));
        jPanel4.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        jPanel4.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this.storageSizeField, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this.byteButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this.kbyteButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this.mbyteButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this.gbyteButton, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SET_INTERNAL_STORAGE_CAPACITY")));
        jPanel5.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.anchor = 10;
        jPanel5.add((Component)jLabel5, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.anchor = 17;
        jPanel5.add((Component)this.internalStorageSizeField, gridBagConstraints2);
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.anchor = 17;
        jPanel5.add((Component)this.internalStorageByteButton, gridBagConstraints2);
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = -1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.anchor = 17;
        jPanel5.add((Component)this.internalStorageKByteButton, gridBagConstraints2);
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = -1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.anchor = 17;
        jPanel5.add((Component)this.internalStorageMByteButton, gridBagConstraints2);
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = -1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.anchor = 17;
        jPanel5.add((Component)this.internalStorageGByteButton, gridBagConstraints2);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.add(jPanel);
        jPanel6.add(jPanel2);
        jPanel6.add(jPanel3);
        jPanel6.add(jPanel4);
        jPanel6.add(jPanel5);
        this.add("North", jPanel6);
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.timezoneComboBox.addActionListener(actionDispatcher);
        this.byteButton.addActionListener(actionDispatcher);
        this.kbyteButton.addActionListener(actionDispatcher);
        this.mbyteButton.addActionListener(actionDispatcher);
        this.gbyteButton.addActionListener(actionDispatcher);
        this.internalStorageByteButton.addActionListener(actionDispatcher);
        this.internalStorageKByteButton.addActionListener(actionDispatcher);
        this.internalStorageMByteButton.addActionListener(actionDispatcher);
        this.internalStorageGByteButton.addActionListener(actionDispatcher);
    }

    @Override
    boolean set() {
        int n;
        String string = this.heapSizeField.getText().trim();
        int n2 = 0;
        Object[] objectArray = new String[]{String.valueOf(1000), String.valueOf(65535)};
        boolean bl = true;
        if (string.length() == 0) {
            try {
                this.parent.showDialog(Resource.format("SPECIFIED_VAL_WNG", Resource.getString("HEAP_SIZE")), this.tabwin, 2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return false;
        }
        for (n = 0; n < string.length(); ++n) {
            if (Character.isDigit(string.charAt(n))) continue;
            this.parent.showDialog(Resource.format("HEAP_LIMIT_WNG", objectArray), this.tabwin, 2);
            return false;
        }
        n2 = Integer.parseInt(string);
        if (n2 < 1000 || n2 > 65535) {
            this.parent.showDialog(Resource.format("HEAP_LIMIT_WNG", objectArray), this.tabwin, 2);
            return false;
        }
        this.parent.setHeapMemorySize(n2);
        if ("---------".equals(TIME_ZONE[this.timezoneComboBox.getSelectedIndex()])) {
            this.parent.setTimeZone(-1);
        } else {
            n = TIME_ZONE[this.timezoneComboBox.getSelectedIndex()].substring(3, 4).equals("-") ? -1 : 1;
            int n3 = Integer.parseInt(TIME_ZONE[this.timezoneComboBox.getSelectedIndex()].substring(4, 6));
            int n4 = Integer.parseInt(TIME_ZONE[this.timezoneComboBox.getSelectedIndex()].substring(7, 9));
            this.parent.setTimeZone((n3 * 60 + n4) * n);
        }
        try {
            n = 60;
            try {
                n = Integer.parseInt(this.maxFontSizeField.getText());
            }
            catch (Exception exception) {
                this.parent.showDialog(Resource.getString("SupportedFontSizes.common.message.NoInput"), this.tabwin, 2);
                return false;
            }
            if (n < 60 || n > 128) {
                this.parent.showDialog(Resource.getString("SupportedFontSizes.common.message.Limit"), this.tabwin, 2);
                return false;
            }
            this.saveMaxFontSize(Integer.toString(n));
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l = this.checkStorageInfo();
        if (l < 0L) {
            return false;
        }
        long l2 = this.checkInternalStorageInfo();
        if (l2 < 0L) {
            return false;
        }
        if (!this.checkDiskFreeSpace(l, l2)) {
            return false;
        }
        if (!this.saveStorageInfo(l)) {
            return false;
        }
        return this.saveInternalStorageInfo(l2);
    }

    @Override
    void cancel() {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    public void selectTimeZone() {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    public void changeStorageSize() {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 2, 0);
        }
    }

    private void loadStorageInfo() {
        byte[] byArray = JAMManager.getStorageTotalSize();
        int n = JAMManager.getStorageTotalSizeUnit();
        if (byArray.length == 0) {
            this.storageSizeField.setText(DEFAULT_STORAGE_CAPACITY);
        } else {
            String string = new String(byArray);
            long l = Long.valueOf(string);
            for (int i = 1; i < n; ++i) {
                l /= 1024L;
            }
            this.storageSizeField.setText(String.valueOf(l));
        }
        if (n == 1) {
            this.byteButton.setSelected(true);
        } else if (n == 2) {
            this.kbyteButton.setSelected(true);
        } else if (n == 3) {
            this.mbyteButton.setSelected(true);
        } else if (n == 4) {
            this.gbyteButton.setSelected(true);
        } else {
            this.gbyteButton.setSelected(true);
        }
    }

    private long checkStorageInfo() {
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        Object[] objectArray = null;
        if (this.storageSizeField.getText() == null || this.storageSizeField.getText().equals("")) {
            objectArray = new String[]{Resource.getString("SET_STORAGE_CAPACITY"), Resource.getString("STORAGE_CAPACITY_NAME")};
            this.parent.showDialog(Resource.format("STORAGE_CAPACITY_NOINPUT_WNG", objectArray), this.tabwin, 2);
            return -1L;
        }
        l = Long.valueOf(this.storageSizeField.getText());
        objectArray = new String[3];
        if (this.byteButton.isSelected()) {
            n = 1;
            l2 = Long.valueOf(STORAGE_MAX_BYTE);
            objectArray[0] = Resource.getString("SET_STORAGE_CAPACITY");
            objectArray[1] = Resource.getString("STORAGE_UNIT_BYTE");
            objectArray[2] = STORAGE_MAX_BYTE;
        } else if (this.kbyteButton.isSelected()) {
            n = 2;
            l2 = Long.valueOf(STORAGE_MAX_KBYTE);
            objectArray[0] = Resource.getString("SET_STORAGE_CAPACITY");
            objectArray[1] = Resource.getString("STORAGE_UNIT_KBYTE");
            objectArray[2] = STORAGE_MAX_KBYTE;
        } else if (this.mbyteButton.isSelected()) {
            n = 3;
            l2 = Long.valueOf(STORAGE_MAX_MBYTE);
            objectArray[0] = Resource.getString("SET_STORAGE_CAPACITY");
            objectArray[1] = Resource.getString("STORAGE_UNIT_MBYTE");
            objectArray[2] = STORAGE_MAX_MBYTE;
        } else if (this.gbyteButton.isSelected()) {
            n = 4;
            l2 = Long.valueOf(STORAGE_MAX_GBYTE);
            objectArray[0] = Resource.getString("SET_STORAGE_CAPACITY");
            objectArray[1] = Resource.getString("STORAGE_UNIT_GBYTE");
            objectArray[2] = STORAGE_MAX_GBYTE;
        }
        if (l > l2) {
            this.parent.showDialog(Resource.format("STORAGE_CAPACITY_LIMIT_WNG", objectArray), this.tabwin, 2);
            return -1L;
        }
        for (int i = 1; i < n; ++i) {
            l *= 1024L;
        }
        return l;
    }

    private boolean saveStorageInfo(long l) {
        int n = 0;
        if (this.byteButton.isSelected()) {
            n = 1;
        } else if (this.kbyteButton.isSelected()) {
            n = 2;
        } else if (this.mbyteButton.isSelected()) {
            n = 3;
        } else if (this.gbyteButton.isSelected()) {
            n = 4;
        }
        String string = String.valueOf(l);
        string = string + "\u0000";
        byte[] byArray = string.getBytes();
        int n2 = JAMManager.setStorageTotalSize(byArray);
        int n3 = JAMManager.setStorageTotalSizeUnit(n);
        if (n2 != 0 || n3 != 0) {
            this.parent.showDialog(Resource.format("REGISTRY_ERR", ""), this.tabwin, 2);
            return false;
        }
        return true;
    }

    private long getFileSize(String string) {
        String[] stringArray = new File(string).list();
        long l = 0L;
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string + "/" + stringArray[i];
            boolean bl = false;
            try {
                bl = new File(string2).list() != null;
            }
            catch (SecurityException securityException) {
                System.out.println(securityException.toString());
            }
            if (bl) {
                l += this.getFileSize(string2);
                continue;
            }
            long l2 = new File(string2).length();
            l += l2;
        }
        return l;
    }

    public void changeInternalStorageSize() {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 2, 0);
        }
    }

    private void loadInternalStorageInfo() {
        byte[] byArray = JAMManager.getInternalStorageTotalSize();
        int n = JAMManager.getInternalStorageTotalSizeUnit();
        if (byArray.length == 0) {
            this.internalStorageSizeField.setText(DEFAULT_STORAGE_CAPACITY);
        } else {
            String string = new String(byArray);
            long l = Long.valueOf(string);
            for (int i = 1; i < n; ++i) {
                l /= 1024L;
            }
            this.internalStorageSizeField.setText(String.valueOf(l));
        }
        if (n == 1) {
            this.internalStorageByteButton.setSelected(true);
        } else if (n == 2) {
            this.internalStorageKByteButton.setSelected(true);
        } else if (n == 3) {
            this.internalStorageMByteButton.setSelected(true);
        } else if (n == 4) {
            this.internalStorageGByteButton.setSelected(true);
        } else {
            this.internalStorageGByteButton.setSelected(true);
        }
    }

    private boolean saveInternalStorageInfo(long l) {
        int n = 0;
        if (this.internalStorageByteButton.isSelected()) {
            n = 1;
        } else if (this.internalStorageKByteButton.isSelected()) {
            n = 2;
        } else if (this.internalStorageMByteButton.isSelected()) {
            n = 3;
        } else if (this.internalStorageGByteButton.isSelected()) {
            n = 4;
        }
        String string = String.valueOf(l);
        string = string + "\u0000";
        byte[] byArray = string.getBytes();
        int n2 = JAMManager.setInternalStorageTotalSize(byArray);
        int n3 = JAMManager.setInternalStorageTotalSizeUnit(n);
        if (n2 != 0 || n3 != 0) {
            this.parent.showDialog(Resource.format("REGISTRY_ERR", ""), this.tabwin, 2);
            return false;
        }
        return true;
    }

    private long checkInternalStorageInfo() {
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        Object[] objectArray = null;
        if (this.internalStorageSizeField.getText() == null || this.internalStorageSizeField.getText().equals("")) {
            objectArray = new String[]{Resource.getString("SET_INTERNAL_STORAGE_CAPACITY"), Resource.getString("INTERNAL_STORAGE_CAPACITY_NAME")};
            this.parent.showDialog(Resource.format("INTERNAL_STORAGE_CAPACITY_NOINPUT_WNG", objectArray), this.tabwin, 2);
            return -1L;
        }
        l = Long.valueOf(this.internalStorageSizeField.getText());
        objectArray = new String[3];
        if (this.internalStorageByteButton.isSelected()) {
            n = 1;
            l2 = Long.valueOf(STORAGE_MAX_BYTE);
            objectArray[0] = Resource.getString("SET_INTERNAL_STORAGE_CAPACITY");
            objectArray[1] = Resource.getString("INTERNAL_STORAGE_UNIT_BYTE");
            objectArray[2] = STORAGE_MAX_BYTE;
        } else if (this.internalStorageKByteButton.isSelected()) {
            n = 2;
            l2 = Long.valueOf(STORAGE_MAX_KBYTE);
            objectArray[0] = Resource.getString("SET_INTERNAL_STORAGE_CAPACITY");
            objectArray[1] = Resource.getString("INTERNAL_STORAGE_UNIT_KBYTE");
            objectArray[2] = STORAGE_MAX_KBYTE;
        } else if (this.internalStorageMByteButton.isSelected()) {
            n = 3;
            l2 = Long.valueOf(STORAGE_MAX_MBYTE);
            objectArray[0] = Resource.getString("SET_INTERNAL_STORAGE_CAPACITY");
            objectArray[1] = Resource.getString("INTERNAL_STORAGE_UNIT_MBYTE");
            objectArray[2] = STORAGE_MAX_MBYTE;
        } else if (this.internalStorageGByteButton.isSelected()) {
            n = 4;
            l2 = Long.valueOf(STORAGE_MAX_GBYTE);
            objectArray[0] = Resource.getString("SET_INTERNAL_STORAGE_CAPACITY");
            objectArray[1] = Resource.getString("INTERNAL_STORAGE_UNIT_GBYTE");
            objectArray[2] = STORAGE_MAX_GBYTE;
        }
        if (l > l2) {
            this.parent.showDialog(Resource.format("INTERNAL_STORAGE_CAPACITY_LIMIT_WNG", objectArray), this.tabwin, 2);
            return -1L;
        }
        for (int i = 1; i < n; ++i) {
            l *= 1024L;
        }
        return l;
    }

    private boolean checkDiskFreeSpace(long l, long l2) {
        long l3 = this.getFileSize(STORAGEDEVICE_PATH);
        long l4 = this.getFileSize(INTERNAL_STORAGEDEVICE_PATH);
        byte[] byArray = JAMManager.getDiskFreeSpaceSize();
        String string = new String(byArray);
        long l5 = Long.parseLong(string);
        long l6 = l5 + l3 + l4;
        if (l + l2 > l6) {
            this.parent.showDialog(Resource.format("INTERNAL_STORAGE_CAPACITY_OVERFLOW_WNG", ""), this.tabwin, 2);
            return false;
        }
        return true;
    }

    private void loadMaxFontSize() throws FileNotFoundException, IOException {
        String string;
        IniFileEntity iniFileEntity = new IniFileEntity(FONTSIZE_FILE_INI);
        try {
            int n;
            iniFileEntity.read();
            string = iniFileEntity.getSectionAttribute(FONTSIZE_SECTION, FONTSIZE_KEY_MAX_SIZE);
            if (string == null || string.equals("")) {
                string = Integer.toString(60);
            }
            if (string.length() != string.getBytes().length) {
                string = Integer.toString(60);
            }
            if ((n = Integer.parseInt(string)) < 60 || n > 128) {
                string = Integer.toString(60);
            }
        }
        catch (Exception exception) {
            string = Integer.toString(60);
        }
        this.maxFontSizeField.setText(string);
    }

    private void saveMaxFontSize(String string) throws FileNotFoundException, IOException {
        IniFileEntity iniFileEntity;
        IniFileEntity iniFileEntity2 = iniFileEntity = new IniFileEntity(FONTSIZE_FILE_INI);
        iniFileEntity2.getClass();
        IniFileEntity.IniSection iniSection = new IniFileEntity.IniSection(iniFileEntity2, FONTSIZE_SECTION);
        iniFileEntity.addSection(iniSection);
        iniFileEntity.setSectionAttribute(FONTSIZE_SECTION, FONTSIZE_KEY_MAX_SIZE, string);
        iniFileEntity.save();
    }

    class FontSizeListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        FontSizeListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }
}

