/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.BluetoothDeviceBean;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothDeviceDataBean;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class BluetoothBean {
    private static final String DELIM_HOST = ",";
    public static final int DEFAULT_MAX_CONNECTION = 3;
    private BluetoothDeviceDataBean ownBluetoothDeviceData;
    private List<BluetoothDeviceBean> bdbList = new ArrayList<BluetoothDeviceBean>();
    private List<BluetoothDeviceBean> deleteBdbList = new ArrayList<BluetoothDeviceBean>();
    private int maxConnection = 3;
    private List<String> hostList = new ArrayList<String>();

    public BluetoothBean() {
    }

    public BluetoothBean(BluetoothDeviceDataBean bluetoothDeviceDataBean, List<BluetoothDeviceBean> list, String string, String string2) {
        this.ownBluetoothDeviceData = bluetoothDeviceDataBean;
        this.bdbList = list;
        try {
            this.maxConnection = Integer.parseInt(string);
            if (this.maxConnection <= 0) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            this.maxConnection = 3;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, DELIM_HOST);
            while (stringTokenizer.hasMoreTokens() && this.hostList.size() < this.maxConnection) {
                String string3 = (String)stringTokenizer.nextElement();
                if ("".equals(string3) || !BluetoothBean.checkHost(string3)) continue;
                this.hostList.add(string3);
            }
            for (int i = this.hostList.size() - 1; i >= this.maxConnection; --i) {
                this.hostList.remove(i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean checkHost(String string) {
        if (string.getBytes().length > 255) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isLetterOrDigit(cArray[i]) || cArray[i] == '-' || cArray[i] == '.') continue;
            return false;
        }
        return true;
    }

    public List<BluetoothDeviceBean> getRemoteLaunch() {
        ArrayList<BluetoothDeviceBean> arrayList = new ArrayList<BluetoothDeviceBean>();
        for (int i = 0; i < this.bdbList.size(); ++i) {
            BluetoothDeviceBean bluetoothDeviceBean = this.bdbList.get(i);
            if (!bluetoothDeviceBean.isRemoteLaunch()) continue;
            arrayList.add(bluetoothDeviceBean);
        }
        return arrayList;
    }

    public String getHostListString() {
        String string = "";
        for (int i = 0; i < this.hostList.size(); ++i) {
            string = i == this.hostList.size() - 1 ? string + this.hostList.get(i) : string + this.hostList.get(i) + DELIM_HOST;
        }
        return string;
    }

    public BluetoothDeviceBean getDeviceAddressRepetition(String string) {
        for (BluetoothDeviceBean bluetoothDeviceBean : this.bdbList) {
            if (!bluetoothDeviceBean.getBluetoothAddress().equalsIgnoreCase(string)) continue;
            return bluetoothDeviceBean;
        }
        return null;
    }

    public boolean isDeviceAddressRepetition(String string) {
        for (BluetoothDeviceBean bluetoothDeviceBean : this.bdbList) {
            if (!bluetoothDeviceBean.getBluetoothAddress().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isDeviceAddressRepetitionSppOnly(String string) {
        for (BluetoothDeviceBean bluetoothDeviceBean : this.bdbList) {
            if (!bluetoothDeviceBean.getBluetoothAddress().equalsIgnoreCase(string)) continue;
            if (bluetoothDeviceBean.isSpp()) {
                return bluetoothDeviceBean.isHdp();
            }
            return true;
        }
        return false;
    }

    public List<BluetoothDeviceBean> getBdbList() {
        return this.bdbList;
    }

    public void setBdbList(List<BluetoothDeviceBean> list) {
        this.bdbList = list;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public void setMaxConnection(int n) {
        this.maxConnection = n;
    }

    public List<String> getHostList() {
        return this.hostList;
    }

    public void setHostList(List<String> list) {
        this.hostList = list;
    }

    public BluetoothDeviceDataBean getOwnBluetoothDeviceData() {
        return this.ownBluetoothDeviceData;
    }

    public void setOwnBluetoothDeviceData(BluetoothDeviceDataBean bluetoothDeviceDataBean) {
        this.ownBluetoothDeviceData = bluetoothDeviceDataBean;
    }

    public List<BluetoothDeviceBean> getDeleteBdbList() {
        return this.deleteBdbList;
    }

    public void addDeleteBdb(BluetoothDeviceBean bluetoothDeviceBean) {
        this.deleteBdbList.add(bluetoothDeviceBean);
    }
}

