/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher2;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothDeviceBean;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothHDPSetupWindow;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothManager;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothSettingWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import com.nttdocomo.dojaemu.ktoolbar.swing.JButtonUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.JTableUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.WidthBean;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class BluetoothHDPSettingWindow
extends TabPanel {
    private JTableUtil jtuBluetoothDevice;
    private JTable tableBluetoothDevice;
    private JScrollPane scrollPaneBluetoothDevice;
    private JButton buttonAdd;
    private JButton buttonEdit;
    private JButton buttonDelete;
    private List<BluetoothDeviceBean> bluetoothDeviceBeanList = null;
    private static final int COLUMN_WIDTH = 200;
    private static final int DIMENSION_WIDTH = 250;
    private static final int DIMENSION_HEIGHT = 100;
    private BluetoothSettingWindow bsw;
    private JPanel panelMain;
    private JPanel panelBluetoothDeviceSetting;

    BluetoothHDPSettingWindow(AbstractWindow abstractWindow, BluetoothSettingWindow bluetoothSettingWindow) {
        super(abstractWindow);
        this.bsw = bluetoothSettingWindow;
        this.setLayout(new BorderLayout());
        ActionDispatcher2 actionDispatcher2 = new ActionDispatcher2(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.buttonAdd = JButtonUtil.createBasicButton(Resource.getString("ADD"), "add", actionDispatcher2);
        jPanel.add(this.buttonAdd);
        jPanel.add(new JLabel(" "));
        this.buttonEdit = JButtonUtil.createBasicButton(Resource.getString("EDIT"), "edit", actionDispatcher2);
        jPanel.add(this.buttonEdit);
        jPanel.add(new JLabel(" "));
        this.buttonDelete = JButtonUtil.createBasicButton(Resource.getString("DELETE"), "delete", actionDispatcher2);
        jPanel.add(this.buttonDelete);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(new JLabel(" "));
        jPanel2.add(jPanel);
        jPanel2.add(new JLabel(" "));
        this.bluetoothDeviceBeanList = this.bsw.getBluetoothDeviceBean();
        this.createBluetoothDeviceTable();
        this.panelBluetoothDeviceSetting = new JPanel();
        this.panelBluetoothDeviceSetting.setLayout(new BorderLayout());
        this.panelBluetoothDeviceSetting.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("BluetoothHDP.common.caption.deviceSetting")));
        this.panelBluetoothDeviceSetting.add((Component)this.scrollPaneBluetoothDevice, "Center");
        this.panelBluetoothDeviceSetting.add((Component)jPanel2, "East");
        this.panelMain = new JPanel();
        this.panelMain.setLayout(new BoxLayout(this.panelMain, 1));
        this.panelMain.add(this.panelBluetoothDeviceSetting);
        this.add("North", this.panelMain);
    }

    private List<Vector<String>> convertAndFilterData(List<BluetoothDeviceBean> list) {
        ArrayList<Vector<String>> arrayList = new ArrayList<Vector<String>>();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).isHdp()) continue;
            Vector<String> vector = new Vector<String>();
            vector.addElement(list.get(i).getBluetoothDeviceData().getDeviceName());
            vector.addElement(list.get(i).getBluetoothDeviceData().getBluetoothAddress());
            arrayList.add(vector);
        }
        return arrayList;
    }

    private void createBluetoothDeviceTable() {
        String[] stringArray = new String[]{Resource.getString("Bluetooth.common.caption.deviceName"), Resource.getString("Bluetooth.common.caption.bluetoothAddress")};
        ArrayList<WidthBean> arrayList = new ArrayList<WidthBean>();
        arrayList.add(new WidthBean(200, 200));
        arrayList.add(new WidthBean(200, 200));
        this.jtuBluetoothDevice = new JTableUtil();
        this.tableBluetoothDevice = this.jtuBluetoothDevice.createBasicTable(stringArray, arrayList, 2, this.convertAndFilterData(this.bluetoothDeviceBeanList));
        this.scrollPaneBluetoothDevice = JTableUtil.createBasicScrollPane(this.tableBluetoothDevice, 250, 100);
        this.tableBluetoothDevice.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    BluetoothHDPSettingWindow.this.edit();
                }
            }
        });
        this.tableBluetoothDevice.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    BluetoothHDPSettingWindow.this.edit();
                }
            }
        });
    }

    private void updateBluetoothDeviceTable() {
        this.setVisible(false);
        this.panelBluetoothDeviceSetting.remove(this.scrollPaneBluetoothDevice);
        this.tableBluetoothDevice = this.jtuBluetoothDevice.updateBasicTable(this.convertAndFilterData(this.bluetoothDeviceBeanList));
        this.scrollPaneBluetoothDevice = JTableUtil.createBasicScrollPane(this.tableBluetoothDevice, 250, 100);
        this.panelBluetoothDeviceSetting.add("Center", this.scrollPaneBluetoothDevice);
        this.setVisible(true);
    }

    void add() {
        BluetoothHDPSetupWindow bluetoothHDPSetupWindow = new BluetoothHDPSetupWindow(this.parent, this.bsw);
        bluetoothHDPSetupWindow.setLocation(this.parent.getShowLocation(bluetoothHDPSetupWindow.getWidth(), bluetoothHDPSetupWindow.getHeight(), this.tabwin));
        bluetoothHDPSetupWindow.setVisible(true);
        if (!bluetoothHDPSetupWindow.isCanceled()) {
            if (!this.bsw.getBluetoothBean().isDeviceAddressRepetitionSppOnly(bluetoothHDPSetupWindow.getBluetoothDeviceBean().getBluetoothAddress())) {
                BluetoothDeviceBean bluetoothDeviceBean = this.bsw.getBluetoothBean().getDeviceAddressRepetition(bluetoothHDPSetupWindow.getBluetoothDeviceBean().getBluetoothAddress());
                this.bsw.getBluetoothBean().getBdbList().remove(bluetoothDeviceBean);
                if (bluetoothDeviceBean != null) {
                    bluetoothHDPSetupWindow.getBluetoothDeviceBean().setSpp(true);
                    bluetoothHDPSetupWindow.getBluetoothDeviceBean().setRegistered(bluetoothDeviceBean.isRegistered());
                    bluetoothHDPSetupWindow.getBluetoothDeviceBean().setLastSelected(bluetoothDeviceBean.getLastSelected());
                    bluetoothHDPSetupWindow.getBluetoothDeviceBean().setProjectName(bluetoothDeviceBean.getProjectName());
                }
            }
            this.bluetoothDeviceBeanList.add(bluetoothHDPSetupWindow.getBluetoothDeviceBean());
            this.updateBluetoothDeviceTable();
            if (this.listener != null) {
                this.listener.tabPanelEvent(this, 1, 0);
            }
        }
    }

    void edit() {
        int[] nArray = this.tableBluetoothDevice.getSelectedRows();
        if (this.tableBluetoothDevice.getSelectedRowCount() == 1) {
            int n = 0;
            int n2 = 0;
            BluetoothDeviceBean bluetoothDeviceBean = null;
            for (BluetoothDeviceBean bluetoothDeviceBean2 : this.bluetoothDeviceBeanList) {
                if (bluetoothDeviceBean2.isHdp()) {
                    if (n2 == nArray[0]) {
                        bluetoothDeviceBean = this.bluetoothDeviceBeanList.remove(n);
                        break;
                    }
                    ++n2;
                }
                ++n;
            }
            BluetoothHDPSetupWindow bluetoothHDPSetupWindow = new BluetoothHDPSetupWindow(this.parent, bluetoothDeviceBean, this.bsw);
            bluetoothHDPSetupWindow.setLocation(this.parent.getShowLocation(bluetoothHDPSetupWindow.getWidth(), bluetoothHDPSetupWindow.getHeight(), this.tabwin));
            bluetoothHDPSetupWindow.setVisible(true);
            if (!bluetoothHDPSetupWindow.isCanceled()) {
                this.bluetoothDeviceBeanList.add(n2, bluetoothHDPSetupWindow.getBluetoothDeviceBean());
                this.updateBluetoothDeviceTable();
                if (this.listener != null) {
                    this.listener.tabPanelEvent(this, 1, 0);
                }
            } else {
                this.bluetoothDeviceBeanList.add(n2, bluetoothDeviceBean);
            }
        }
    }

    public void delete() {
        int[] nArray = this.tableBluetoothDevice.getSelectedRows();
        if (this.tableBluetoothDevice.getSelectedRowCount() == 1) {
            int n = 0;
            int n2 = 0;
            BluetoothDeviceBean bluetoothDeviceBean = null;
            for (BluetoothDeviceBean object2 : this.bluetoothDeviceBeanList) {
                if (object2.isHdp()) {
                    if (n == nArray[0]) {
                        bluetoothDeviceBean = object2;
                        break;
                    }
                    ++n;
                }
                ++n2;
            }
            if (bluetoothDeviceBean.isRegistered()) {
                this.parent.showDialog(Resource.getString("BluetoothHDP.common.message.delete.error.registered"), this, 0);
                return;
            }
            JOptionPane jOptionPane = new JOptionPane(Resource.format("BluetoothHDP.common.message.delete.warn.bluetoothDevice", String.valueOf(this.tableBluetoothDevice.getSelectedRowCount())), 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                this.bsw.getBluetoothBean().addDeleteBdb(this.bluetoothDeviceBeanList.remove(n2));
                this.updateBluetoothDeviceTable();
                if (this.listener != null) {
                    this.listener.tabPanelEvent(this, 1, 0);
                }
            }
        }
    }

    @Override
    boolean set() {
        try {
            BluetoothManager.write(this.bsw.getBluetoothBean());
        }
        catch (Exception exception) {
            System.err.println(Resource.format("WRITE_ERR", exception.getMessage()));
            return false;
        }
        return true;
    }

    @Override
    void cancel() {
    }
}

