/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow2;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher2;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothDeviceBean;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothDeviceDataBean;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothMDEPBean;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothMDEPSetupWindow;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothSettingWindow;
import com.nttdocomo.dojaemu.ktoolbar.CheckUtil;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.bluetoothhdpsetupwindow.DevicePanel;
import com.nttdocomo.dojaemu.ktoolbar.bluetoothhdpsetupwindow.DevicePanelCaptionBean;
import com.nttdocomo.dojaemu.ktoolbar.swing.BasicAbstractWindowWindowListener;
import com.nttdocomo.dojaemu.ktoolbar.swing.EditWindowInterface;
import com.nttdocomo.dojaemu.ktoolbar.swing.JButtonUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.JComboBoxUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.JTableUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.JTextFieldUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.WidthBean;
import com.nttdocomo.dojaemu.ktoolbar.swing.document.HalfLetterAndNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.swing.document.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.swing.document.HexDocument;
import com.nttdocomo.dojaemu.ktoolbar.swing.document.LimitedHexDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class BluetoothHDPSetupWindow
extends AbstractWindow2
implements EditWindowInterface {
    private List<BluetoothMDEPBean> bluetoothMDEPBeanList = null;
    private static final int COLUMN_WIDTH = 150;
    private List<String> labelList = new ArrayList<String>();
    private DevicePanel panelBuluetoothDevice = null;
    private JTableUtil jtu;
    private JButton buttonAdd;
    private JButton buttonEdit;
    private JButton buttonDelete;
    private MainWindow parent = null;
    private JTable tableMDEPRegisterList;
    private JScrollPane scrollPaneMDEPRegisterList;
    private JButton buttonSet;
    private JButton buttonCancel;
    private BluetoothDeviceBean bluetoothDeviceBean = null;
    private static final int DIMENSION_WIDTH = 150;
    private static final int DIMENSION_HEIGHT = 150;
    private JPanel panelMdep;
    private BluetoothSettingWindow bsw;

    public BluetoothHDPSetupWindow(MainWindow mainWindow, BluetoothSettingWindow bluetoothSettingWindow) {
        this(mainWindow, new BluetoothDeviceBean(), bluetoothSettingWindow);
    }

    public BluetoothHDPSetupWindow(MainWindow mainWindow, BluetoothDeviceBean bluetoothDeviceBean, BluetoothSettingWindow bluetoothSettingWindow) {
        super(mainWindow, Resource.getString("BluetoothHDP.common.caption.setupWindow"));
        this.bsw = bluetoothSettingWindow;
        this.parent = mainWindow;
        this.addWindowListener(new BasicAbstractWindowWindowListener(mainWindow, this){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                BluetoothHDPSetupWindow.this.cancel();
            }
        });
        this.setResizable(false);
        this.bluetoothDeviceBean = bluetoothDeviceBean;
        this.bluetoothMDEPBeanList = new ArrayList<BluetoothMDEPBean>(this.bluetoothDeviceBean.getBluetoothDeviceData().getBluetoothMDEPBeanList());
        ActionDispatcher2 actionDispatcher2 = new ActionDispatcher2(this);
        this.labelList.add(Resource.getString("Bluetooth.common.caption.cod.mobile"));
        this.labelList.add(Resource.getString("Bluetooth.common.caption.cod.pc"));
        this.labelList.add(Resource.getString("Bluetooth.common.caption.cod.bloodPressureMonitor"));
        this.labelList.add(Resource.getString("Bluetooth.common.caption.cod.bodyThermometer"));
        DevicePanelCaptionBean devicePanelCaptionBean = new DevicePanelCaptionBean();
        devicePanelCaptionBean.setDeviceName(Resource.getString("Bluetooth.common.caption.deviceName"));
        devicePanelCaptionBean.setDeviceAddress(Resource.getString("Bluetooth.common.caption.bluetoothAddress"));
        devicePanelCaptionBean.setCod(Resource.getString("Bluetooth.common.caption.cod"));
        devicePanelCaptionBean.setSpecData(Resource.getString("Bluetooth.common.caption.specData"));
        devicePanelCaptionBean.setLocalName(Resource.getString("Bluetooth.common.caption.localName"));
        devicePanelCaptionBean.setUuid(Resource.getString("Bluetooth.common.caption.uuid"));
        this.panelBuluetoothDevice = new DevicePanel(devicePanelCaptionBean);
        JTextFieldUtil.settingBasicTextField(this.panelBuluetoothDevice.getTxtDeviceName(), 20, new HalfLetterAndNumberDocument(32));
        JTextFieldUtil.settingBasicTextField(this.panelBuluetoothDevice.getTxtDeviceAddress1(), 2, new LimitedHexDocument(2));
        JTextFieldUtil.settingBasicTextField(this.panelBuluetoothDevice.getTxtDeviceAddress2(), 2, new LimitedHexDocument(2));
        JTextFieldUtil.settingBasicTextField(this.panelBuluetoothDevice.getTxtDeviceAddress3(), 2, new LimitedHexDocument(2));
        JTextFieldUtil.settingBasicTextField(this.panelBuluetoothDevice.getTxtDeviceAddress4(), 2, new LimitedHexDocument(2));
        JTextFieldUtil.settingBasicTextField(this.panelBuluetoothDevice.getTxtDeviceAddress5(), 2, new LimitedHexDocument(2));
        JTextFieldUtil.settingBasicTextField(this.panelBuluetoothDevice.getTxtDeviceAddress6(), 2, new LimitedHexDocument(2));
        JTextFieldUtil.settingBasicTextField(this.panelBuluetoothDevice.getTxtSpecData(), 20, new HexDocument());
        JTextFieldUtil.settingBasicTextField(this.panelBuluetoothDevice.getTxtUuid(), 4, new HalfNumberDocument(4));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.buttonAdd = JButtonUtil.createBasicButton(Resource.getString("ADD"), "add", actionDispatcher2);
        jPanel.add(this.buttonAdd);
        this.buttonEdit = JButtonUtil.createBasicButton(Resource.getString("EDIT"), "edit", actionDispatcher2);
        jPanel.add(this.buttonEdit);
        this.buttonDelete = JButtonUtil.createBasicButton(Resource.getString("DELETE"), "delete", actionDispatcher2);
        jPanel.add(this.buttonDelete);
        this.createMDEPRegisterListTable();
        this.panelMdep = new JPanel();
        this.panelMdep.setLayout(new BorderLayout());
        this.panelMdep.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("BluetoothHDP.common.caption.mdepRegisterList")));
        this.panelMdep.add((Component)this.scrollPaneMDEPRegisterList, "Center");
        this.panelMdep.add((Component)jPanel, "East");
        JPanel jPanel2 = new JPanel();
        this.buttonSet = JButtonUtil.createBasicButton(Resource.getString("SET"), "set", actionDispatcher2);
        jPanel2.add(this.buttonSet);
        this.buttonCancel = JButtonUtil.createBasicButton(Resource.getString("CANCEL"), "cancel", actionDispatcher2);
        jPanel2.add(this.buttonCancel);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(this.panelBuluetoothDevice);
        container.add(this.panelMdep);
        container.add(jPanel2);
        this.pack();
        BluetoothDeviceDataBean bluetoothDeviceDataBean = this.bluetoothDeviceBean.getBluetoothDeviceData();
        if (bluetoothDeviceDataBean != null) {
            this.panelBuluetoothDevice.getTxtDeviceName().setText(bluetoothDeviceDataBean.getDeviceName());
            this.panelBuluetoothDevice.getTxtDeviceAddress1().setText(bluetoothDeviceDataBean.getBluetoothAddress1());
            this.panelBuluetoothDevice.getTxtDeviceAddress2().setText(bluetoothDeviceDataBean.getBluetoothAddress2());
            this.panelBuluetoothDevice.getTxtDeviceAddress3().setText(bluetoothDeviceDataBean.getBluetoothAddress3());
            this.panelBuluetoothDevice.getTxtDeviceAddress4().setText(bluetoothDeviceDataBean.getBluetoothAddress4());
            this.panelBuluetoothDevice.getTxtDeviceAddress5().setText(bluetoothDeviceDataBean.getBluetoothAddress5());
            this.panelBuluetoothDevice.getTxtDeviceAddress6().setText(bluetoothDeviceDataBean.getBluetoothAddress6());
            JComboBox jComboBox = this.panelBuluetoothDevice.getComboCod();
            JComboBoxUtil.settingBasicComboBox(jComboBox, this.labelList, "deviceTypeChanged", actionDispatcher2);
            jComboBox.setSelectedIndex(bluetoothDeviceDataBean.getDeviceTypeComboboxIndex());
            this.panelBuluetoothDevice.getTxtSpecData().setText(bluetoothDeviceDataBean.getSpecData());
            this.panelBuluetoothDevice.getTxtLocalName().setText(bluetoothDeviceDataBean.getLocalname());
            this.panelBuluetoothDevice.getTxtUuid().setText(bluetoothDeviceDataBean.getUuid());
        }
    }

    private List<Vector<String>> convertData(List<BluetoothMDEPBean> list) {
        ArrayList<Vector<String>> arrayList = new ArrayList<Vector<String>>();
        for (int i = 0; i < list.size(); ++i) {
            Vector<String> vector = new Vector<String>();
            vector.addElement(Integer.toString(list.get(i).getMdepId()));
            vector.addElement(BluetoothHDPSetupWindow.getTypeString(list.get(i).getType()));
            vector.addElement(BluetoothHDPSetupWindow.getRoleString(list.get(i).getRole()));
            arrayList.add(vector);
        }
        return arrayList;
    }

    private void createMDEPRegisterListTable() {
        String[] stringArray = new String[]{Resource.getString("BluetoothHDP.common.caption.id"), Resource.getString("BluetoothHDP.common.caption.type"), Resource.getString("BluetoothHDP.common.caption.role")};
        ArrayList<WidthBean> arrayList = new ArrayList<WidthBean>();
        arrayList.add(new WidthBean(150, 150));
        arrayList.add(new WidthBean(150, 150));
        arrayList.add(new WidthBean(150, 150));
        this.jtu = new JTableUtil();
        this.tableMDEPRegisterList = this.jtu.createBasicTable(stringArray, arrayList, 0, this.convertData(this.bluetoothMDEPBeanList));
        this.scrollPaneMDEPRegisterList = JTableUtil.createBasicScrollPane(this.tableMDEPRegisterList, 150, 150);
        this.tableMDEPRegisterList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    BluetoothHDPSetupWindow.this.edit();
                }
            }
        });
        this.tableMDEPRegisterList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    BluetoothHDPSetupWindow.this.edit();
                }
            }
        });
    }

    private void updateMDEPRegisterListTable() {
        this.setVisible(false);
        this.panelMdep.remove(this.scrollPaneMDEPRegisterList);
        this.tableMDEPRegisterList = this.jtu.updateBasicTable(this.convertData(this.bluetoothMDEPBeanList));
        this.scrollPaneMDEPRegisterList = JTableUtil.createBasicScrollPane(this.tableMDEPRegisterList, 150, 150);
        this.panelMdep.add("Center", this.scrollPaneMDEPRegisterList);
        this.setVisible(true);
    }

    private static String getTypeString(int n) {
        String string = "";
        string = n == 8 ? Resource.getString("Bluetooth.common.caption.cod.bodyThermometer") : Resource.getString("Bluetooth.common.caption.cod.bloodPressureMonitor");
        return string;
    }

    private static String getRoleString(int n) {
        String string = "";
        string = n == 1 ? Resource.getString("BluetoothHDP.common.caption.sink") : Resource.getString("BluetoothHDP.common.caption.source");
        return string;
    }

    void add() {
        BluetoothMDEPSetupWindow bluetoothMDEPSetupWindow = new BluetoothMDEPSetupWindow(this.parent, this.bluetoothMDEPBeanList);
        bluetoothMDEPSetupWindow.setLocation(this.parent.getShowLocation(bluetoothMDEPSetupWindow.getWidth(), bluetoothMDEPSetupWindow.getHeight(), this));
        bluetoothMDEPSetupWindow.setVisible(true);
        if (!bluetoothMDEPSetupWindow.isCanceled()) {
            this.bluetoothMDEPBeanList.add(bluetoothMDEPSetupWindow.getBluetoothMDEPBean());
            this.updateMDEPRegisterListTable();
        }
    }

    void edit() {
        int[] nArray = this.tableMDEPRegisterList.getSelectedRows();
        if (this.tableMDEPRegisterList.getSelectedRowCount() == 1) {
            BluetoothMDEPBean bluetoothMDEPBean = this.bluetoothMDEPBeanList.remove(nArray[0]);
            BluetoothMDEPSetupWindow bluetoothMDEPSetupWindow = new BluetoothMDEPSetupWindow(this.parent, bluetoothMDEPBean, this.bluetoothMDEPBeanList);
            bluetoothMDEPSetupWindow.setLocation(this.parent.getShowLocation(bluetoothMDEPSetupWindow.getWidth(), bluetoothMDEPSetupWindow.getHeight(), this));
            bluetoothMDEPSetupWindow.setVisible(true);
            if (!bluetoothMDEPSetupWindow.isCanceled()) {
                this.bluetoothMDEPBeanList.add(nArray[0], bluetoothMDEPSetupWindow.getBluetoothMDEPBean());
                this.updateMDEPRegisterListTable();
            } else {
                this.bluetoothMDEPBeanList.add(nArray[0], bluetoothMDEPBean);
            }
        }
    }

    public void delete() {
        int[] nArray = this.tableMDEPRegisterList.getSelectedRows();
        if (this.tableMDEPRegisterList.getSelectedRowCount() == 1) {
            JOptionPane jOptionPane = new JOptionPane(Resource.format("BluetoothHDP.common.message.delete.warn.mdep", String.valueOf(this.tableMDEPRegisterList.getSelectedRowCount())), 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                this.bluetoothDeviceBean.getBluetoothDeviceData().addDeleteMdepBean(this.bluetoothMDEPBeanList.remove(nArray[0]));
                this.updateMDEPRegisterListTable();
            }
        }
    }

    @Override
    public void checkInput() throws Exception {
        if ("".equals(this.panelBuluetoothDevice.getTxtDeviceName().getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.deviceName")));
        }
        if ("".equals(this.panelBuluetoothDevice.getTxtDeviceAddress1().getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if ("".equals(this.panelBuluetoothDevice.getTxtDeviceAddress2().getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if ("".equals(this.panelBuluetoothDevice.getTxtDeviceAddress3().getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if ("".equals(this.panelBuluetoothDevice.getTxtDeviceAddress4().getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if ("".equals(this.panelBuluetoothDevice.getTxtDeviceAddress5().getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if ("".equals(this.panelBuluetoothDevice.getTxtDeviceAddress6().getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if ("".equals(this.panelBuluetoothDevice.getTxtSpecData().getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.specData")));
        }
        if ("".equals(this.panelBuluetoothDevice.getTxtLocalName().getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.localName")));
        }
        if ("".equals(this.panelBuluetoothDevice.getTxtUuid().getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.uuid")));
        }
    }

    @Override
    public void checkFormat() throws Exception {
        if (this.panelBuluetoothDevice.getTxtDeviceName().getText().getBytes().length > 32) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.deviceName")));
        }
        if (this.panelBuluetoothDevice.getTxtDeviceAddress1().getText().getBytes().length != 2) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        try {
            Integer.parseInt(this.panelBuluetoothDevice.getTxtDeviceAddress1().getText(), 16);
        }
        catch (Exception exception) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if (this.panelBuluetoothDevice.getTxtDeviceAddress2().getText().getBytes().length != 2) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        try {
            Integer.parseInt(this.panelBuluetoothDevice.getTxtDeviceAddress2().getText(), 16);
        }
        catch (Exception exception) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if (this.panelBuluetoothDevice.getTxtDeviceAddress3().getText().getBytes().length != 2) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        try {
            Integer.parseInt(this.panelBuluetoothDevice.getTxtDeviceAddress3().getText(), 16);
        }
        catch (Exception exception) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if (this.panelBuluetoothDevice.getTxtDeviceAddress4().getText().getBytes().length != 2) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        try {
            Integer.parseInt(this.panelBuluetoothDevice.getTxtDeviceAddress4().getText(), 16);
        }
        catch (Exception exception) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if (this.panelBuluetoothDevice.getTxtDeviceAddress5().getText().getBytes().length != 2) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        try {
            Integer.parseInt(this.panelBuluetoothDevice.getTxtDeviceAddress5().getText(), 16);
        }
        catch (Exception exception) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if (this.panelBuluetoothDevice.getTxtDeviceAddress6().getText().getBytes().length != 2) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        try {
            Integer.parseInt(this.panelBuluetoothDevice.getTxtDeviceAddress6().getText(), 16);
        }
        catch (Exception exception) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        try {
            if (!CheckUtil.checkHex(this.panelBuluetoothDevice.getTxtSpecData().getText())) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.specData")));
        }
        if (this.panelBuluetoothDevice.getTxtUuid().getText().getBytes().length > 4) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.uuid")));
        }
        try {
            Integer.parseInt(this.panelBuluetoothDevice.getTxtUuid().getText(), 10);
        }
        catch (Exception exception) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.uuid")));
        }
    }

    void set() {
        try {
            this.checkInput();
            this.checkFormat();
            if (this.bluetoothMDEPBeanList.size() <= 0) {
                this.parent.showDialog(Resource.getString("BluetoothHDP.common.message.setting.error.noMdep"), this, 0);
                return;
            }
            BluetoothDeviceDataBean bluetoothDeviceDataBean = new BluetoothDeviceDataBean();
            bluetoothDeviceDataBean.setBluetoothAddress(this.panelBuluetoothDevice.getTxtDeviceAddress1().getText(), this.panelBuluetoothDevice.getTxtDeviceAddress2().getText(), this.panelBuluetoothDevice.getTxtDeviceAddress3().getText(), this.panelBuluetoothDevice.getTxtDeviceAddress4().getText(), this.panelBuluetoothDevice.getTxtDeviceAddress5().getText(), this.panelBuluetoothDevice.getTxtDeviceAddress6().getText());
            String string = bluetoothDeviceDataBean.getBluetoothAddress();
            if (!string.equals(this.bluetoothDeviceBean.getBluetoothDeviceData().getOriginalBluetoothAddress()) && this.bsw.getBluetoothBean().isDeviceAddressRepetitionSppOnly(string)) {
                this.parent.showDialog(Resource.getString("BluetoothHDP.common.message.setting.error.deviceAddressRepetition"), this, 0);
                return;
            }
            BluetoothDeviceDataBean bluetoothDeviceDataBean2 = this.bluetoothDeviceBean.getBluetoothDeviceData();
            bluetoothDeviceDataBean2.setDeviceName(this.panelBuluetoothDevice.getTxtDeviceName().getText());
            bluetoothDeviceDataBean2.setBluetoothAddress(this.panelBuluetoothDevice.getTxtDeviceAddress1().getText(), this.panelBuluetoothDevice.getTxtDeviceAddress2().getText(), this.panelBuluetoothDevice.getTxtDeviceAddress3().getText(), this.panelBuluetoothDevice.getTxtDeviceAddress4().getText(), this.panelBuluetoothDevice.getTxtDeviceAddress5().getText(), this.panelBuluetoothDevice.getTxtDeviceAddress6().getText());
            bluetoothDeviceDataBean2.setDeviceTypeComboboxIndex(this.panelBuluetoothDevice.getComboCod().getSelectedIndex());
            bluetoothDeviceDataBean2.setSpecData(this.panelBuluetoothDevice.getTxtSpecData().getText());
            bluetoothDeviceDataBean2.setLocalname(this.panelBuluetoothDevice.getTxtLocalName().getText());
            bluetoothDeviceDataBean2.setUuid(this.panelBuluetoothDevice.getTxtUuid().getText());
            bluetoothDeviceDataBean2.setBluetoothMDEPBeanList(this.bluetoothMDEPBeanList);
            this.bluetoothDeviceBean.setHdp(true);
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            this.parent.showDialog(exception.getMessage(), this, 2);
        }
    }

    void cancel() {
        this.bluetoothDeviceBean = null;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public boolean isCanceled() {
        return this.bluetoothDeviceBean == null;
    }

    public BluetoothDeviceBean getBluetoothDeviceBean() {
        return this.bluetoothDeviceBean;
    }

    void deviceTypeChanged() {
    }
}

