/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow2;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher2;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothBean;
import com.nttdocomo.dojaemu.ktoolbar.HostInfoDocument;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.swing.BasicAbstractWindowWindowListener;
import com.nttdocomo.dojaemu.ktoolbar.swing.EditWindowInterface;
import com.nttdocomo.dojaemu.ktoolbar.swing.JButtonUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.JTextFieldUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BluetoothHostSetupWindow
extends AbstractWindow2
implements EditWindowInterface {
    private static final int SIZE_TEXTFIELD = 15;
    private MainWindow parent = null;
    private JTextField txtHost;
    private JButton buttonSet;
    private JButton buttonCancel;
    private String host = null;
    private static final int WIDTH = 200;
    private static final int HEIGHT = 100;

    BluetoothHostSetupWindow(MainWindow mainWindow, String string) {
        super(mainWindow, Resource.getString("Bluetooth.common.caption.scanDeviceData"));
        this.parent = mainWindow;
        this.setResizable(false);
        this.addWindowListener(new BasicAbstractWindowWindowListener(mainWindow, this){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                BluetoothHostSetupWindow.this.cancel();
            }
        });
        this.host = string;
        ActionDispatcher2 actionDispatcher2 = new ActionDispatcher2(this);
        JLabel jLabel = new JLabel(Resource.getString("Bluetooth.common.caption.scanDevice"));
        this.txtHost = JTextFieldUtil.createBasicTextField(15, new HostInfoDocument(255));
        JPanel jPanel = new JPanel();
        this.buttonSet = JButtonUtil.createBasicButton(Resource.getString("SET"), "set", actionDispatcher2);
        this.buttonCancel = JButtonUtil.createBasicButton(Resource.getString("CANCEL"), "cancel", actionDispatcher2);
        jPanel.add(this.buttonSet);
        jPanel.add(this.buttonCancel);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        jPanel2.add(jLabel);
        jPanel2.add(this.txtHost);
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(this.buttonSet);
        jPanel.add(this.buttonCancel);
        container.add("Center", jPanel2);
        container.add("South", jPanel);
        this.setSize(200, 100);
        this.pack();
        this.txtHost.setText(string);
    }

    @Override
    public void checkInput() throws Exception {
        if ("".equals(this.txtHost.getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.scanDevice")));
        }
    }

    @Override
    public void checkFormat() throws Exception {
        if (!BluetoothBean.checkHost(this.txtHost.getText())) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.scanDevice")));
        }
    }

    void set() {
        try {
            this.checkInput();
            this.checkFormat();
            this.host = this.txtHost.getText();
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            this.parent.showDialog(exception.getMessage(), this, 2);
        }
    }

    void cancel() {
        this.host = null;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public boolean isCanceled() {
        return this.host == null;
    }

    public String getHost() {
        return this.host;
    }
}

