/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow2;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher2;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothMDEPBean;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothManager;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.swing.BasicAbstractWindowWindowListener;
import com.nttdocomo.dojaemu.ktoolbar.swing.EditWindowInterface;
import com.nttdocomo.dojaemu.ktoolbar.swing.JButtonUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.JTextFieldUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.document.HalfNumberDocument;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.ComboBoxUI;

public class BluetoothMDEPSetupWindow
extends AbstractWindow2
implements EditWindowInterface {
    private static final Dimension SIZE_COMBOBOX = new Dimension(140, 20);
    private static final int SIZE_TEXTFIELD = 15;
    private static final int MAXBYTES_MDEP_ID = 3;
    private static final GridLayout GRID_LAYOUT = new GridLayout(3, 1);
    private MainWindow parent = null;
    private JTextField txtID;
    private JComboBox comboType;
    public static final String[] TYPE_ITEMS = new String[]{Resource.getString("Bluetooth.common.caption.cod.bloodPressureMonitor"), Resource.getString("Bluetooth.common.caption.cod.bodyThermometer")};
    private JComboBox comboRole;
    public static final String[] ROLE_ITEMS = new String[]{Resource.getString("BluetoothHDP.common.caption.source"), Resource.getString("BluetoothHDP.common.caption.sink")};
    private JButton buttonSet;
    private JButton buttonCancel;
    private BluetoothMDEPBean bluetoothMDEPBean = null;
    private List<BluetoothMDEPBean> bluetoothMDEPBeanList = null;

    public BluetoothMDEPSetupWindow(MainWindow mainWindow, List<BluetoothMDEPBean> list) {
        this(mainWindow, new BluetoothMDEPBean(-1), list);
    }

    public BluetoothMDEPSetupWindow(MainWindow mainWindow, BluetoothMDEPBean bluetoothMDEPBean, List<BluetoothMDEPBean> list) {
        super(mainWindow, Resource.getString("BluetoothHDP.common.caption.mdepSetupWindow"));
        this.parent = mainWindow;
        this.setResizable(false);
        this.addWindowListener(new BasicAbstractWindowWindowListener(mainWindow, this){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                BluetoothMDEPSetupWindow.this.cancel();
            }
        });
        this.bluetoothMDEPBean = bluetoothMDEPBean;
        this.bluetoothMDEPBeanList = list;
        ActionDispatcher2 actionDispatcher2 = new ActionDispatcher2(this);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        JPanel jPanel7 = new JPanel(GRID_LAYOUT);
        JPanel jPanel8 = new JPanel(GRID_LAYOUT);
        JPanel jPanel9 = new JPanel();
        JLabel jLabel = new JLabel(Resource.getString("BluetoothHDP.common.caption.id"));
        JLabel jLabel2 = new JLabel(Resource.getString("BluetoothHDP.common.caption.type"));
        JLabel jLabel3 = new JLabel(Resource.getString("BluetoothHDP.common.caption.role"));
        this.txtID = JTextFieldUtil.createBasicTextField(15, new HalfNumberDocument(3));
        this.comboType = new JComboBox<String>(TYPE_ITEMS);
        this.comboType.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        this.comboType.setPreferredSize(SIZE_COMBOBOX);
        this.comboRole = new JComboBox<String>(ROLE_ITEMS);
        this.comboRole.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        this.comboRole.setPreferredSize(SIZE_COMBOBOX);
        jPanel9.setLayout(new BoxLayout(jPanel9, 0));
        jPanel.add(jLabel);
        jPanel2.add(jLabel2);
        jPanel3.add(jLabel3);
        jPanel4.add(this.txtID);
        jPanel5.add(this.comboType);
        jPanel6.add(this.comboRole);
        jPanel7.add(jPanel);
        jPanel7.add(jPanel2);
        jPanel7.add(jPanel3);
        jPanel8.add(jPanel4);
        jPanel8.add(jPanel5);
        jPanel8.add(jPanel6);
        jPanel9.add(jPanel7);
        jPanel9.add(jPanel8);
        JPanel jPanel10 = new JPanel();
        this.buttonSet = JButtonUtil.createBasicButton(Resource.getString("SET"), "set", actionDispatcher2);
        this.buttonCancel = JButtonUtil.createBasicButton(Resource.getString("CANCEL"), "cancel", actionDispatcher2);
        jPanel10.add(this.buttonSet);
        jPanel10.add(this.buttonCancel);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(jPanel9);
        container.add(jPanel10);
        this.pack();
        if (this.bluetoothMDEPBean.getMdepId() != -1) {
            this.txtID.setText(Integer.toString(this.bluetoothMDEPBean.getMdepId()));
        }
        this.comboType.setSelectedIndex(this.bluetoothMDEPBean.getTypeComboboxIndex());
        if (this.bluetoothMDEPBean.getRole() == 0) {
            this.comboRole.setSelectedIndex(0);
        } else {
            this.comboRole.setSelectedIndex(1);
        }
    }

    @Override
    public void checkInput() throws Exception {
        if ("".equals(this.txtID.getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("BluetoothHDP.common.caption.id")));
        }
    }

    @Override
    public void checkFormat() throws Exception {
        try {
            int n = Integer.parseInt(this.txtID.getText());
            if (0 > n || n > 255) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("BluetoothHDP.common.caption.id")));
        }
    }

    void set() {
        int n = this.bluetoothMDEPBean.getMdepId();
        try {
            this.checkInput();
            this.checkFormat();
            this.bluetoothMDEPBean.setMdepId(Integer.parseInt(this.txtID.getText()));
            try {
                if ((this.bluetoothMDEPBean.isMdepidChanged() || this.bluetoothMDEPBean.getOrignalMdepId() == -1) && this.bluetoothMDEPBeanList.size() >= 1) {
                    BluetoothManager.checkRepetitionMdepId(this.bluetoothMDEPBeanList, this.bluetoothMDEPBean.getMdepId());
                }
            }
            catch (Exception exception) {
                throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("BluetoothHDP.common.caption.id")));
            }
            this.bluetoothMDEPBean.setTypeComboboxIndex(this.comboType.getSelectedIndex());
            this.bluetoothMDEPBean.setRole(this.comboRole.getSelectedIndex());
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            this.bluetoothMDEPBean.setMdepId(n);
            this.parent.showDialog(exception.getMessage(), this, 2);
        }
    }

    void cancel() {
        this.bluetoothMDEPBean = null;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public boolean isCanceled() {
        return this.bluetoothMDEPBean == null;
    }

    public BluetoothMDEPBean getBluetoothMDEPBean() {
        return this.bluetoothMDEPBean;
    }
}

